/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.nautilus.NautilusAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.AbstractMountInventoryMenu;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public abstract class AbstractNautilus
extends EntityTameableAnimal
implements HasCustomInventoryScreen,
IJumpable {
    public static final int cz = 500;
    public static final int cA = 3;
    public static final int cB = 16;
    public static final int cC = 32;
    public static final int cD = 8;
    private static final int cG = 60;
    private static final int cH = 40;
    private static final double cI = 0.9;
    private static final float cJ = 0.011f;
    private static final float cK = 0.0325f;
    private static final float cL = 0.02f;
    private static final DataWatcherObject<Boolean> cM = DataWatcher.a(AbstractNautilus.class, DataWatcherRegistry.k);
    private static final int cN = 40;
    private static final int cO = 5;
    private static final float cP = 1.2f;
    private static final float cQ = 0.5f;
    private int cR = 0;
    protected float cE;
    public InventorySubcontainer cF;
    private static final double cU = 0.8;
    private static final double cV = 1.1;
    private static final double cW = 0.25;
    private static final double cX = 2.0;
    private static final float cY = 0.15f;
    private static final float cZ = 1.0f;

    protected AbstractNautilus(EntityTypes<? extends AbstractNautilus> type, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, level);
        this.cp = new SmoothSwimmingMoveControl(this, 85, 10, 0.011f, 0.0f, true);
        this.co = new SmoothSwimmingLookControl(this, 10);
        this.a(PathType.j, 0.0f);
        this.hj();
    }

    @Override
    public boolean j(ItemStack stack) {
        return !this.p() && !this.e_() ? stack.a(TagsItem.bk) : stack.a(TagsItem.bj);
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(TagsItem.bi)) {
            player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.sl)));
        } else {
            super.a(player, hand, stack);
        }
    }

    public static AttributeProvider.Builder hd() {
        return EntityAnimal.gW().a(GenericAttributes.u, 15.0).a(GenericAttributes.x, 1.0).a(GenericAttributes.d, 3.0).a(GenericAttributes.r, 0.3f);
    }

    @Override
    public boolean db() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    public static boolean c(EntityTypes<? extends AbstractNautilus> type, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        int seaLevel = level.V();
        int i2 = seaLevel - 25;
        seaLevel = level.getMinecraftWorld().paperConfig().entities.spawning.wateranimalSpawnHeight.maximum.or(seaLevel - 5);
        i2 = level.getMinecraftWorld().paperConfig().entities.spawning.wateranimalSpawnHeight.minimum.or(i2);
        return pos.v() >= i2 && pos.v() <= seaLevel && level.b_(pos.e()).a(TagsFluid.a) && level.a_(pos.d()).a(Blocks.J);
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h && slot != EnumItemSlot.g ? super.e(slot) : this.cb() && !this.e_() && this.p();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.g || slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected boolean s(Entity passenger) {
        return !this.cr();
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityLiving entityLiving;
        Entity entity;
        if (this.al() && (entity = this.do()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            entityLiving = player;
        } else {
            entityLiving = super.dl();
        }
        return entityLiving;
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        float f2 = player.bN;
        float f1 = 0.0f;
        float f22 = 0.0f;
        if (player.bP != 0.0f) {
            float cos = MathHelper.b((double)(player.ee() * ((float)Math.PI / 180)));
            float f3 = -MathHelper.a((double)(player.ee() * ((float)Math.PI / 180)));
            if (player.bP < 0.0f) {
                cos *= -0.5f;
                f3 *= -0.5f;
            }
            f22 = f3;
            f1 = cos;
        }
        return new Vec3D(f2, f22, f1);
    }

    protected Vec2F k(EntityLiving entity) {
        return new Vec2F(entity.ee() * 0.5f, entity.ec());
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.k(player);
        float yRot = this.ec();
        float f2 = MathHelper.f(riddenRotation.k - yRot);
        float f1 = 0.5f;
        this.a(yRot += f2 * 0.5f, riddenRotation.j);
        this.bC = this.bE = yRot;
        this.ab = this.bE;
        if (this.dv()) {
            if (this.cE > 0.0f && !this.fS()) {
                this.a(this.cE, player);
            }
            this.cE = 0.0f;
        }
    }

    @Override
    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        float speed = this.fM();
        this.a(speed, travelVector);
        this.a(EnumMoveType.a, this.dN());
        this.k(this.dN().c(0.9));
    }

    @Override
    protected float f(EntityHuman player) {
        return this.by() ? 0.0325f * (float)this.i(GenericAttributes.x) : 0.02f * (float)this.i(GenericAttributes.x);
    }

    protected void i(EntityHuman player) {
        if (!this.ao().B_()) {
            player.o(this);
            if (!this.cr()) {
                this.gE();
            }
        }
    }

    private int hn() {
        return !this.e_() && this.a(EnumItemSlot.h).f() ? 32 : 16;
    }

    protected void he() {
        if (!this.S_() && !this.cr() && this.p()) {
            int nautilusRestrictionRadius = this.hn();
            if (!this.gF() || !this.gC().a(this.dK(), (double)(nautilusRestrictionRadius + 8)) || nautilusRestrictionRadius != this.gD()) {
                this.a(this.dK(), nautilusRestrictionRadius);
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        this.he();
        super.a(level);
    }

    private void c(World level) {
        Entity entity = this.do();
        if (entity instanceof EntityHuman) {
            boolean flag;
            EntityHuman player = (EntityHuman)entity;
            boolean hasEffect = player.d(MobEffects.N);
            boolean bl = flag = level.au() % 40L == 0L;
            if (!hasEffect || flag) {
                player.addEffect(new MobEffect(MobEffects.N, 60, 0, true, true, true), EntityPotionEffectEvent.Cause.NAUTILUS);
            }
        }
    }

    private void ho() {
        double len = this.dN().g();
        double d2 = MathHelper.a(len * 2.0, (double)0.15f, 1.0);
        if ((double)this.as.i() < d2) {
            float yRot = this.ec();
            float f2 = MathHelper.a(this.ee(), -10.0f, 10.0f);
            Vec3D vec3 = this.c(f2, yRot);
            double d1 = this.as.j() * 0.8 * (1.0 + len);
            double d22 = ((double)this.as.i() - 0.5) * d1;
            double d3 = ((double)this.as.i() - 0.5) * d1;
            double d4 = ((double)this.as.i() - 0.5) * d1;
            this.ao().a(Particles.d, this.dP() - vec3.g * 1.1, this.dR() - vec3.h + 0.25, this.dV() - vec3.i * 1.1, d22, d3, d4);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.ao().B_()) {
            this.c(this.ao());
        }
        if (this.hf() && this.cR < 35) {
            this.A(false);
        }
        if (this.cR > 0) {
            --this.cR;
            if (this.cR == 0) {
                this.b(this.hh());
            }
        }
        if (this.by()) {
            this.ho();
        }
    }

    @Override
    public boolean a() {
        return this.al();
    }

    @Override
    public void a(int jumpPower) {
        if (this.al() && this.cR <= 0) {
            this.cE = this.e_(jumpPower);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cM, false);
    }

    public boolean hf() {
        return this.az.a(cM);
    }

    public void A(boolean dash) {
        this.az.a(cM, dash);
    }

    protected void a(float playerJumpPendingScale, EntityHuman player) {
        this.l(player.cj().c((double)((this.by() ? 1.2f : 0.5f) * playerJumpPendingScale) * this.i(GenericAttributes.x) * (double)this.bi()));
        this.cR = 40;
        this.A(true);
        this.aF = true;
    }

    @Override
    public void b(int jumpPower) {
        this.b(this.hg());
        this.c(GameEvent.u);
        this.A(true);
    }

    @Override
    public int c() {
        return this.cR;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (!this.ay && cM.equals(key)) {
            this.cR = this.cR == 0 ? 40 : this.cR;
        }
        super.a(key);
    }

    @Override
    public void b() {
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    protected @Nullable SoundEffect hg() {
        return null;
    }

    protected @Nullable SoundEffect hh() {
        return null;
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        this.gz();
        return super.a(player, hand);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (this.e_()) {
            return super.b(player, hand);
        }
        if (this.p() && player.gA()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        if (!itemInHand.f()) {
            if (!this.ao().B_() && !this.p() && this.j(itemInHand)) {
                this.a(player, hand, itemInHand);
                this.j(player);
                return EnumInteractionResult.b;
            }
            if (this.j(itemInHand) && this.eZ() < this.fq()) {
                FoodInfo foodProperties = itemInHand.a(DataComponents.y);
                this.heal(foodProperties != null ? (float)(2 * foodProperties.a()) : 1.0f, EntityRegainHealthEvent.RegainReason.EATING);
                this.a(player, hand, itemInHand);
                this.gX();
                return EnumInteractionResult.a;
            }
            EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
            if (interactionResult.a()) {
                return interactionResult;
            }
        }
        if (this.p() && !player.gA() && !this.j(itemInHand)) {
            this.i(player);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    private void j(EntityHuman player) {
        if (this.as.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.g(player);
            this.cr.n();
            this.ao().a((Entity)this, (byte)7);
        } else {
            this.ao().a((Entity)this, (byte)6);
        }
        this.gX();
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            NautilusAi.a(level, this, livingEntity);
        }
        return flag;
    }

    @Override
    public boolean b(MobEffect effectInstance) {
        return effectInstance.c() != MobEffects.s && super.b(effectInstance);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        NautilusAi.a(this, random);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        if (slot == EnumItemSlot.h && this.bC()) {
            return SoundEffects.Hv;
        }
        return slot == EnumItemSlot.h ? SoundEffects.Hw : super.a(slot, stack, equippable);
    }

    public final int hi() {
        return AbstractMountInventoryMenu.e(this.hk());
    }

    protected void hj() {
        InventorySubcontainer simpleContainer = this.cF;
        this.cF = new InventorySubcontainer(this.hi(), (InventoryHolder)((org.bukkit.entity.AbstractNautilus)this.getBukkitEntity()));
        if (simpleContainer != null) {
            int min = Math.min(simpleContainer.b(), this.cF.b());
            for (int i2 = 0; i2 < min; ++i2) {
                ItemStack item = simpleContainer.a(i2);
                if (item.f()) continue;
                this.cF.a(i2, item.v());
            }
        }
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.ao().B_() && (!this.cr() || this.z(player)) && this.p()) {
            player.a(this, (IInventory)this.cF);
        }
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        int i2 = slot - 500;
        return i2 >= 0 && i2 < this.cF.b() ? this.cF.a_(i2) : super.a_(slot);
    }

    public boolean a(IInventory oldInventory) {
        return this.cF != oldInventory;
    }

    public int hk() {
        return 0;
    }

    protected boolean hl() {
        return this.do() instanceof EntityInsentient;
    }

    protected boolean hm() {
        return this.ev().a(MemoryModuleType.am) || this.ev().a(MemoryModuleType.p);
    }
}

