/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.panda;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.mojang.serialization.Codec;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityPanda
extends EntityAnimal {
    private static final DataWatcherObject<Integer> cx = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cz = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cA = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cB = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> cC = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> cD = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    static final PathfinderTargetCondition cE = PathfinderTargetCondition.b().a(8.0);
    private static final EntitySize cF = EntityTypes.aU.n().a(0.5f).a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, 0.40625f, 0.0f));
    private static final int cG = 2;
    private static final int cH = 4;
    private static final int cI = 8;
    private static final int cJ = 16;
    private static final int cK = 5;
    public static final int cv = 32;
    private static final int cL = 32;
    boolean cM;
    boolean cN;
    public int cw;
    private Vec3D cO;
    private float cP;
    private float cQ;
    private float cR;
    private float cU;
    private float cV;
    private float cW;
    g cX;

    public EntityPanda(EntityTypes<? extends EntityPanda> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cp = new h(this);
        if (!this.e_()) {
            this.b_(true);
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.gn();
    }

    public int p() {
        return this.az.a(cx);
    }

    public void s(int unhappyCounter) {
        this.az.a(cx, unhappyCounter);
    }

    public boolean gP() {
        return this.v(2);
    }

    public boolean gQ() {
        return this.v(8);
    }

    public void x(boolean sitting) {
        if (!new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(8, sitting);
    }

    public boolean gR() {
        return this.v(16);
    }

    public void y(boolean onBack) {
        this.d(16, onBack);
    }

    public boolean gS() {
        return this.az.a(cA) > 0;
    }

    public void z(boolean eating) {
        this.az.a(cA, eating ? 1 : 0);
    }

    public int ho() {
        return this.az.a(cA);
    }

    public void u(int eatCounter) {
        this.az.a(cA, eatCounter);
    }

    public void A(boolean sneezing) {
        this.d(2, sneezing);
        if (!sneezing) {
            this.t(0);
        }
    }

    public int gT() {
        return this.az.a(cz);
    }

    public void t(int sneezeCounter) {
        this.az.a(cz, sneezeCounter);
    }

    public Gene gU() {
        return Gene.a(this.az.a(cB).byteValue());
    }

    public void a(Gene pandaType) {
        if (pandaType.a() > 6) {
            pandaType = Gene.a(this.as);
        }
        this.az.a(cB, (byte)pandaType.a());
    }

    public Gene gV() {
        return Gene.a(this.az.a(cC).byteValue());
    }

    public void b(Gene pandaType) {
        if (pandaType.a() > 6) {
            pandaType = Gene.a(this.as);
        }
        this.az.a(cC, (byte)pandaType.a());
    }

    public boolean hd() {
        return this.v(4);
    }

    public void B(boolean rolling) {
        this.d(4, rolling);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cx, 0);
        builder.a(cz, 0);
        builder.a(cB, (byte)0);
        builder.a(cC, (byte)0);
        builder.a(cD, (byte)0);
        builder.a(cA, 0);
    }

    private boolean v(int flag) {
        return (this.az.a(cD) & flag) != 0;
    }

    private void d(int flagId, boolean value) {
        byte b2 = this.az.a(cD);
        if (value) {
            this.az.a(cD, (byte)(b2 | flagId));
        } else {
            this.az.a(cD, (byte)(b2 & ~flagId));
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("MainGene", Gene.h, this.gU());
        output.a("HiddenGene", Gene.h, this.gV());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("MainGene", Gene.h).orElse(Gene.a));
        this.b(input.a("HiddenGene", Gene.h).orElse(Gene.a));
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        EntityPanda panda = EntityTypes.aU.a(level, EntitySpawnReason.e);
        if (panda != null) {
            if (partner instanceof EntityPanda) {
                EntityPanda panda1 = (EntityPanda)partner;
                panda.a(this, panda1);
            }
            panda.hm();
        }
        return panda;
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(2, new i(this, 2.0));
        this.cs.a(2, new d(this, 1.0));
        this.cs.a(3, new b(this, (double)1.2f, true));
        this.cs.a(4, new PathfinderGoalTempt(this, 1.0, stack -> stack.a(TagsItem.aY), false));
        this.cs.a(6, new c<EntityHuman>(this, EntityHuman.class, 8.0f, 2.0, 2.0));
        this.cs.a(6, new c<EntityMonster>(this, EntityMonster.class, 4.0f, 2.0, 2.0));
        this.cs.a(7, new k());
        this.cs.a(8, new f(this));
        this.cs.a(8, new l(this));
        this.cX = new g(this, EntityHuman.class, 6.0f);
        this.cs.a(9, this.cX);
        this.cs.a(10, new PathfinderGoalRandomLookaround(this));
        this.cs.a(12, new j(this));
        this.cs.a(13, new PathfinderGoalFollowParent(this, 1.25));
        this.cs.a(14, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ct.a(1, new e(this, new Class[0]).a(new Class[0]));
    }

    public static AttributeProvider.Builder he() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.15f).a(GenericAttributes.d, 6.0);
    }

    public Gene hf() {
        return Gene.a(this.gU(), this.gV());
    }

    public boolean hg() {
        return this.hf() == Gene.b;
    }

    public boolean hh() {
        return this.hf() == Gene.c;
    }

    public boolean hi() {
        return this.hf() == Gene.d;
    }

    public boolean hj() {
        return this.hf() == Gene.e;
    }

    public boolean hk() {
        return this.hf() == Gene.f;
    }

    @Override
    public boolean gI() {
        return this.hf() == Gene.g;
    }

    @Override
    public boolean aj_() {
        return false;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (!this.gI()) {
            this.cN = true;
        }
        return super.c(level, target);
    }

    @Override
    public void fN() {
        this.a(SoundEffects.vh, 1.0f, 1.0f);
    }

    @Override
    public void g() {
        EntityLiving target;
        super.g();
        if (this.hh()) {
            if (this.ao().an() && !this.by()) {
                this.x(true);
                this.z(false);
            } else if (!this.gS()) {
                this.x(false);
            }
        }
        if ((target = this.ag_()) == null) {
            this.cM = false;
            this.cN = false;
        }
        if (this.p() > 0) {
            if (target != null) {
                this.a((Entity)target, 90.0f, 90.0f);
            }
            if (this.p() == 29 || this.p() == 14) {
                this.a(SoundEffects.vd, 1.0f, 1.0f);
            }
            this.s(this.p() - 1);
        }
        if (this.gP()) {
            this.t(this.gT() + 1);
            if (this.gT() > 20) {
                this.A(false);
                this.hv();
            } else if (this.gT() == 1) {
                this.a(SoundEffects.uX, 1.0f, 1.0f);
            }
        }
        if (this.hd()) {
            this.hu();
        } else {
            this.cw = 0;
        }
        if (this.gQ()) {
            this.w(0.0f);
        }
        this.hr();
        this.hp();
        this.hs();
        this.ht();
    }

    public boolean hl() {
        return this.hh() && this.ao().an();
    }

    private void hp() {
        if (!this.gS() && this.gQ() && !this.hl() && !this.a(EnumItemSlot.a).f() && this.as.a(80) == 1) {
            this.z(true);
        } else if (this.a(EnumItemSlot.a).f() || !this.gQ()) {
            this.z(false);
        }
        if (this.gS()) {
            this.hq();
            if (!this.ao().B_() && this.ho() > 80 && this.as.a(20) == 1) {
                if (this.ho() > 100 && this.a(EnumItemSlot.a).a(TagsItem.aZ)) {
                    if (!this.ao().B_()) {
                        this.a(EnumItemSlot.a, ItemStack.l);
                        this.c(GameEvent.m);
                    }
                    this.x(false);
                }
                this.z(false);
                return;
            }
            this.u(this.ho() + 1);
        }
    }

    private void hq() {
        if (this.ho() % 5 == 0) {
            this.a(SoundEffects.vb, 0.5f + 0.5f * (float)this.as.a(2), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
            for (int i2 = 0; i2 < 6; ++i2) {
                Vec3D vec3 = new Vec3D(((double)this.as.i() - 0.5) * 0.1, (double)this.as.i() * 0.1 + 0.1, ((double)this.as.i() - 0.5) * 0.1);
                vec3 = vec3.a(-this.ee() * ((float)Math.PI / 180));
                vec3 = vec3.b(-this.ec() * ((float)Math.PI / 180));
                double d2 = (double)(-this.as.i()) * 0.6 - 0.3;
                Vec3D vec31 = new Vec3D(((double)this.as.i() - 0.5) * 0.8, d2, 1.0 + ((double)this.as.i() - 0.5) * 0.4);
                vec31 = vec31.b(-this.bC * ((float)Math.PI / 180));
                vec31 = vec31.b(this.dP(), this.dT() + 1.0, this.dV());
                this.ao().a(new ParticleParamItem(Particles.V, this.a(EnumItemSlot.a)), vec31.g, vec31.h, vec31.i, vec3.g, vec3.h + 0.05, vec3.i);
            }
        }
    }

    private void hr() {
        this.cQ = this.cP;
        this.cP = this.gQ() ? Math.min(1.0f, this.cP + 0.15f) : Math.max(0.0f, this.cP - 0.19f);
    }

    private void hs() {
        this.cU = this.cR;
        this.cR = this.gR() ? Math.min(1.0f, this.cR + 0.15f) : Math.max(0.0f, this.cR - 0.19f);
    }

    private void ht() {
        this.cW = this.cV;
        this.cV = this.hd() ? Math.min(1.0f, this.cV + 0.15f) : Math.max(0.0f, this.cV - 0.19f);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cQ, this.cP);
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.cU, this.cR);
    }

    public float N(float partialTick) {
        return MathHelper.h(partialTick, this.cW, this.cV);
    }

    private void hu() {
        ++this.cw;
        if (this.cw > 32) {
            this.B(false);
        } else if (!this.ao().B_()) {
            Vec3D deltaMovement = this.dN();
            if (this.cw == 1) {
                float f2 = this.ec() * ((float)Math.PI / 180);
                float f1 = this.e_() ? 0.1f : 0.2f;
                this.cO = new Vec3D(deltaMovement.g + (double)(-MathHelper.a((double)f2) * f1), 0.0, deltaMovement.i + (double)(MathHelper.b((double)f2) * f1));
                this.k(this.cO.b(0.0, 0.27, 0.0));
            } else if ((float)this.cw != 7.0f && (float)this.cw != 15.0f && (float)this.cw != 23.0f) {
                this.m(this.cO.g, deltaMovement.h, this.cO.i);
            } else {
                this.m(0.0, this.aV() ? 0.27 : deltaMovement.h, 0.0);
            }
        }
    }

    private void hv() {
        WorldServer serverLevel;
        Vec3D deltaMovement = this.dN();
        World level = this.ao();
        level.a(Particles.ak, this.dP() - (double)(this.dF() + 1.0f) * 0.5 * (double)MathHelper.a((double)(this.bC * ((float)Math.PI / 180))), this.dT() - (double)0.1f, this.dV() + (double)(this.dF() + 1.0f) * 0.5 * (double)MathHelper.b((double)(this.bC * ((float)Math.PI / 180))), deltaMovement.g, 0.0, deltaMovement.i);
        this.a(SoundEffects.uY, 1.0f, 1.0f);
        for (EntityPanda panda : level.a(EntityPanda.class, this.dj().g(10.0))) {
            if (panda.e_() || !panda.aV() || panda.by() || !panda.hn()) continue;
            if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                panda.u();
                continue;
            }
            this.t(false);
        }
        World world = this.ao();
        if (world instanceof WorldServer && (serverLevel = (WorldServer)world).U().a(GameRules.D).booleanValue()) {
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aH, this::a);
            this.forceDrops = false;
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !this.a(EnumItemSlot.a).f() || !EntityPanda.b(entity)).isCancelled()) {
            this.a(entity);
            ItemStack item = entity.e();
            this.a(EnumItemSlot.a, item);
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.N());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        this.x(false);
        return super.a(level, damageSource, amount);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        this.a(Gene.a(random));
        this.b(Gene.a(random));
        this.hm();
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public void a(EntityPanda father, @Nullable EntityPanda mother) {
        if (mother == null) {
            if (this.as.h()) {
                this.a(father.hw());
                this.b(Gene.a(this.as));
            } else {
                this.a(Gene.a(this.as));
                this.b(father.hw());
            }
        } else if (this.as.h()) {
            this.a(father.hw());
            this.b(mother.hw());
        } else {
            this.a(mother.hw());
            this.b(father.hw());
        }
        if (this.as.a(32) == 0) {
            this.a(Gene.a(this.as));
        }
        if (this.as.a(32) == 0) {
            this.b(Gene.a(this.as));
        }
    }

    private Gene hw() {
        return this.as.h() ? this.gU() : this.gV();
    }

    public void hm() {
        if (this.hk()) {
            this.h(GenericAttributes.u).a(10.0);
        }
        if (this.hg()) {
            this.h(GenericAttributes.x).a(0.07f);
        }
    }

    void hx() {
        if (!this.by()) {
            this.I(0.0f);
            this.N().n();
            this.x(true);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block7: {
            block9: {
                WorldServer serverLevel;
                ItemStack itemInHand;
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                itemInHand = player.b(hand);
                                if (this.hl()) {
                                    return EnumInteractionResult.e;
                                }
                                if (this.gR()) {
                                    this.y(false);
                                    return EnumInteractionResult.a;
                                }
                                if (!this.j(itemInHand)) break block7;
                                if (this.ag_() != null) {
                                    this.cM = true;
                                }
                                if (!this.e_()) break block8;
                                this.a(player, hand, itemInHand);
                                this.a((int)((float)(-this.Z_() / 20) * 0.1f), true);
                                break block9;
                            }
                            if (this.ao().B_() || this.Z_() != 0 || !this.gY()) break block10;
                            ItemStack breedCopy = itemInHand.v();
                            this.a(player, hand, itemInHand);
                            this.setInLove(player, breedCopy);
                            break block9;
                        }
                        World world = this.ao();
                        if (!(world instanceof WorldServer)) break block11;
                        serverLevel = (WorldServer)world;
                        if (!this.gQ() && !this.by()) break block12;
                    }
                    return EnumInteractionResult.e;
                }
                this.hx();
                this.z(true);
                ItemStack itemBySlot = this.a(EnumItemSlot.a);
                if (!itemBySlot.f() && !player.gv()) {
                    this.forceDrops = true;
                    this.a(serverLevel, itemBySlot);
                    this.forceDrops = false;
                }
                this.a(EnumItemSlot.a, new ItemStack(itemInHand.h(), 1));
                this.a(player, hand, itemInHand);
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public @Nullable SoundEffect W() {
        if (this.gI()) {
            return SoundEffects.ve;
        }
        return this.hh() ? SoundEffects.vf : SoundEffects.uZ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.vc, 0.15f, 1.0f);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aY);
    }

    @Override
    public @Nullable SoundEffect fd() {
        return SoundEffects.va;
    }

    @Override
    public @Nullable SoundEffect h(DamageSource damageSource) {
        return SoundEffects.vg;
    }

    public boolean hn() {
        return !this.gR() && !this.hl() && !this.gS() && !this.hd() && !this.gQ();
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cF : super.b(pose);
    }

    private static boolean b(EntityItem itemEntity) {
        return itemEntity.e().a(TagsItem.aZ) && itemEntity.cb() && !itemEntity.n();
    }

    static class h
    extends ControllerMove {
        private final EntityPanda l;

        public h(EntityPanda mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.l.hn()) {
                super.a();
            }
        }
    }

    public static final class Gene
    extends Enum<Gene>
    implements INamable {
        public static final /* enum */ Gene a = new Gene(0, "normal", false);
        public static final /* enum */ Gene b = new Gene(1, "lazy", false);
        public static final /* enum */ Gene c = new Gene(2, "worried", false);
        public static final /* enum */ Gene d = new Gene(3, "playful", false);
        public static final /* enum */ Gene e = new Gene(4, "brown", true);
        public static final /* enum */ Gene f = new Gene(5, "weak", true);
        public static final /* enum */ Gene g = new Gene(6, "aggressive", false);
        public static final Codec<Gene> h;
        private static final IntFunction<Gene> i;
        private static final int j = 6;
        private final int k;
        private final String l;
        private final boolean m;
        private static final /* synthetic */ Gene[] n;

        public static Gene[] values() {
            return (Gene[])n.clone();
        }

        public static Gene valueOf(String name) {
            return Enum.valueOf(Gene.class, name);
        }

        private Gene(int id, String name, boolean isRecessive) {
            this.k = id;
            this.l = name;
            this.m = isRecessive;
        }

        public int a() {
            return this.k;
        }

        @Override
        public String c() {
            return this.l;
        }

        public boolean b() {
            return this.m;
        }

        static Gene a(Gene mainGene, Gene hiddenGene) {
            if (mainGene.b()) {
                return mainGene == hiddenGene ? mainGene : a;
            }
            return mainGene;
        }

        public static Gene a(int id) {
            return i.apply(id);
        }

        public static Gene a(RandomSource random) {
            int randomInt = random.a(16);
            if (randomInt == 0) {
                return b;
            }
            if (randomInt == 1) {
                return c;
            }
            if (randomInt == 2) {
                return d;
            }
            if (randomInt == 4) {
                return g;
            }
            if (randomInt < 9) {
                return f;
            }
            return randomInt < 11 ? e : a;
        }

        private static /* synthetic */ Gene[] d() {
            return new Gene[]{a, b, c, d, e, f, g};
        }

        static {
            n = Gene.d();
            h = INamable.a(Gene::values);
            i = ByIdMap.a(Gene::a, Gene.values(), ByIdMap.a.a);
        }
    }

    static class i
    extends PathfinderGoalPanic {
        private final EntityPanda a;

        public i(EntityPanda panda, double speedModifier) {
            super((EntityCreature)panda, speedModifier, DamageTypeTags.G);
            this.a = panda;
        }

        @Override
        public boolean c() {
            if (this.a.gQ()) {
                this.a.N().n();
                return false;
            }
            return super.c();
        }
    }

    static class d
    extends PathfinderGoalBreed {
        private final EntityPanda d;
        private int e;

        public d(EntityPanda panda, double speedModifier) {
            super(panda, speedModifier);
            this.d = panda;
        }

        @Override
        public boolean b() {
            if (!super.b() || this.d.p() != 0) {
                return false;
            }
            if (!this.h()) {
                if (this.e <= this.d.at) {
                    this.d.s(32);
                    this.e = this.d.at + 600;
                    if (this.d.dy()) {
                        EntityHuman nearestPlayer = this.b.a(cE, this.d);
                        this.d.cX.a(nearestPlayer);
                    }
                }
                return false;
            }
            return true;
        }

        private boolean h() {
            BlockPosition blockPos = this.d.dK();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int i1 = 0; i1 < 8; ++i1) {
                    int i22 = 0;
                    while (i22 <= i1) {
                        int i3;
                        int n2 = i3 = i22 < i1 && i22 > -i1 ? i1 : 0;
                        while (i3 <= i1) {
                            mutableBlockPos.a(blockPos, i22, i2, i3);
                            if (this.b.a_(mutableBlockPos).a(Blocks.nW)) {
                                return true;
                            }
                            i3 = i3 > 0 ? -i3 : 1 - i3;
                        }
                        i22 = i22 > 0 ? -i22 : 1 - i22;
                    }
                }
            }
            return false;
        }
    }

    static class b
    extends PathfinderGoalMeleeAttack {
        private final EntityPanda b;

        public b(EntityPanda panda, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(panda, speedModifier, followingTargetEvenIfNotSeen);
            this.b = panda;
        }

        @Override
        public boolean b() {
            return this.b.hn() && super.b();
        }
    }

    static class c<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityPanda i;

        public c(EntityPanda panda, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(panda, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.f);
            this.i = panda;
        }

        @Override
        public boolean b() {
            return this.i.hh() && this.i.hn() && super.b();
        }
    }

    class k
    extends PathfinderGoal {
        private int b;

        public k() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return this.b <= EntityPanda.this.at && !EntityPanda.this.e_() && !EntityPanda.this.by() && EntityPanda.this.hn() && EntityPanda.this.p() <= 0 && (!EntityPanda.this.a(EnumItemSlot.a).f() || !EntityPanda.this.ao().a(EntityItem.class, EntityPanda.this.dj().c(6.0, 6.0, 6.0), EntityPanda::b).isEmpty());
        }

        @Override
        public boolean c() {
            return !EntityPanda.this.by() && (EntityPanda.this.hg() || EntityPanda.this.as.a(k.b(600)) != 1) && EntityPanda.this.as.a(k.b(2000)) != 1;
        }

        @Override
        public void a() {
            if (!EntityPanda.this.gQ() && !EntityPanda.this.a(EnumItemSlot.a).f()) {
                EntityPanda.this.hx();
            }
        }

        @Override
        public void d() {
            if (EntityPanda.this.a(EnumItemSlot.a).f()) {
                List<EntityItem> entitiesOfClass = EntityPanda.this.ao().a(EntityItem.class, EntityPanda.this.dj().c(8.0, 8.0, 8.0), EntityPanda::b);
                if (!entitiesOfClass.isEmpty()) {
                    EntityPanda.this.N().a((Entity)entitiesOfClass.getFirst(), (double)1.2f);
                }
            } else {
                EntityPanda.this.hx();
            }
            this.b = 0;
        }

        @Override
        public void e() {
            ItemStack itemBySlot = EntityPanda.this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                EntityPanda.this.forceDrops = true;
                EntityPanda.this.a(k.a(EntityPanda.this.ao()), itemBySlot);
                EntityPanda.this.forceDrops = false;
                EntityPanda.this.a(EnumItemSlot.a, ItemStack.l);
                int i2 = EntityPanda.this.hg() ? EntityPanda.this.as.a(50) + 10 : EntityPanda.this.as.a(150) + 10;
                this.b = EntityPanda.this.at + i2 * 20;
            }
            EntityPanda.this.x(false);
        }
    }

    static class f
    extends PathfinderGoal {
        private final EntityPanda a;
        private int b;

        public f(EntityPanda panda) {
            this.a = panda;
        }

        @Override
        public boolean b() {
            return this.b < this.a.at && this.a.hg() && this.a.hn() && this.a.as.a(net.minecraft.world.entity.animal.panda.EntityPanda$f.b(400)) == 1;
        }

        @Override
        public boolean c() {
            return !this.a.by() && (this.a.hg() || this.a.as.a(net.minecraft.world.entity.animal.panda.EntityPanda$f.b(600)) != 1) && this.a.as.a(net.minecraft.world.entity.animal.panda.EntityPanda$f.b(2000)) != 1;
        }

        @Override
        public void d() {
            this.a.y(true);
            this.b = 0;
        }

        @Override
        public void e() {
            this.a.y(false);
            this.b = this.a.at + 200;
        }
    }

    static class l
    extends PathfinderGoal {
        private final EntityPanda a;

        public l(EntityPanda panda) {
            this.a = panda;
        }

        @Override
        public boolean b() {
            return this.a.e_() && this.a.hn() && (this.a.hk() && this.a.as.a(l.b(500)) == 1 || this.a.as.a(l.b(6000)) == 1);
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            this.a.A(true);
        }
    }

    static class g
    extends PathfinderGoalLookAtPlayer {
        private final EntityPanda h;

        public g(EntityPanda panda, Class<? extends EntityLiving> lookAtType, float lookDistance) {
            super(panda, lookAtType, lookDistance);
            this.h = panda;
        }

        public void a(EntityLiving lookAt) {
            this.c = lookAt;
        }

        @Override
        public boolean c() {
            return this.c != null && super.c();
        }

        @Override
        public boolean b() {
            if (this.b.ep().i() >= this.e) {
                return false;
            }
            if (this.c == null) {
                WorldServer serverLevel = g.a(this.b);
                this.c = this.f == EntityHuman.class ? serverLevel.a(this.g, this.b, this.b.dP(), this.b.dT(), this.b.dV()) : serverLevel.a(this.b.ao().a(this.f, this.b.dj().c(this.d, 3.0, this.d), entity -> true), this.g, this.b, this.b.dP(), this.b.dT(), this.b.dV());
            }
            return this.h.hn() && this.c != null;
        }

        @Override
        public void a() {
            if (this.c != null) {
                super.a();
            }
        }
    }

    static class j
    extends PathfinderGoal {
        private final EntityPanda a;

        public j(EntityPanda panda) {
            this.a = panda;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            if ((this.a.e_() || this.a.hi()) && this.a.aV()) {
                if (!this.a.hn()) {
                    return false;
                }
                float f2 = this.a.ec() * ((float)Math.PI / 180);
                float f1 = -MathHelper.a((double)f2);
                float cos = MathHelper.b((double)f2);
                int i2 = (double)Math.abs(f1) > 0.5 ? MathHelper.m(f1) : 0;
                int i1 = (double)Math.abs(cos) > 0.5 ? MathHelper.m(cos) : 0;
                return this.a.ao().a_(this.a.dK().b(i2, -1, i1)).l() || this.a.hi() && this.a.as.a(j.b(60)) == 1 || this.a.as.a(j.b(500)) == 1;
            }
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            this.a.B(true);
        }

        @Override
        public boolean W_() {
            return false;
        }
    }

    static class e
    extends PathfinderGoalHurtByTarget {
        private final EntityPanda a;

        public e(EntityPanda panda, Class<?> ... toIgnoreDamage) {
            super(panda, toIgnoreDamage);
            this.a = panda;
        }

        @Override
        public boolean c() {
            if (!this.a.cM && !this.a.cN) {
                return super.c();
            }
            this.a.g((EntityLiving)null);
            return false;
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPanda && mob.gI()) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY);
            }
        }
    }
}

