/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.parrot;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.parrot.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> cD = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> cE = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient mob) {
            return mob != null && cF.containsKey(mob.ay());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> cF = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put(EntityTypes.q, SoundEffects.vr);
        map.put(EntityTypes.s, SoundEffects.vs);
        map.put(EntityTypes.t, SoundEffects.vt);
        map.put(EntityTypes.w, SoundEffects.vu);
        map.put(EntityTypes.y, SoundEffects.vS);
        map.put(EntityTypes.H, SoundEffects.vv);
        map.put(EntityTypes.I, SoundEffects.vw);
        map.put(EntityTypes.O, SoundEffects.vx);
        map.put(EntityTypes.Q, SoundEffects.vy);
        map.put(EntityTypes.T, SoundEffects.vz);
        map.put(EntityTypes.S, SoundEffects.vA);
        map.put(EntityTypes.W, SoundEffects.vB);
        map.put(EntityTypes.ah, SoundEffects.vC);
        map.put(EntityTypes.ai, SoundEffects.tA);
        map.put(EntityTypes.an, SoundEffects.vD);
        map.put(EntityTypes.ao, SoundEffects.vE);
        map.put(EntityTypes.ar, SoundEffects.vF);
        map.put(EntityTypes.as, SoundEffects.vG);
        map.put(EntityTypes.aE, SoundEffects.vH);
        map.put(EntityTypes.aV, SoundEffects.vJ);
        map.put(EntityTypes.aX, SoundEffects.vI);
        map.put(EntityTypes.aZ, SoundEffects.vK);
        map.put(EntityTypes.ba, SoundEffects.vL);
        map.put(EntityTypes.bb, SoundEffects.vM);
        map.put(EntityTypes.bh, SoundEffects.vN);
        map.put(EntityTypes.bk, SoundEffects.vO);
        map.put(EntityTypes.bm, SoundEffects.vP);
        map.put(EntityTypes.bn, SoundEffects.vQ);
        map.put(EntityTypes.bp, SoundEffects.vR);
        map.put(EntityTypes.bw, SoundEffects.vS);
        map.put(EntityTypes.bA, SoundEffects.vT);
        map.put(EntityTypes.bK, SoundEffects.vU);
        map.put(EntityTypes.bM, SoundEffects.vV);
        map.put(EntityTypes.bO, SoundEffects.vW);
        map.put(EntityTypes.bQ, SoundEffects.vX);
        map.put(EntityTypes.bR, SoundEffects.vY);
        map.put(EntityTypes.bS, SoundEffects.vZ);
        map.put(EntityTypes.bV, SoundEffects.wa);
        map.put(EntityTypes.bW, SoundEffects.wb);
        map.put(EntityTypes.bX, SoundEffects.wc);
        map.put(EntityTypes.bY, SoundEffects.wd);
        map.put(EntityTypes.bZ, SoundEffects.we);
    });
    public float cz;
    public float cA;
    public float cB;
    public float cC;
    private float cG = 1.0f;
    private float cH = 1.0f;
    private boolean cI;
    private @Nullable BlockPosition cJ;

    public EntityParrot(EntityTypes<? extends EntityParrot> type, World level) {
        super((EntityTypes<? extends EntityPerchable>)type, level);
        this.cp = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(SystemUtils.a(Variant.values(), level.G_()));
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected void D() {
        this.cs.a(0, new EntityTameableAnimal.a(1.25));
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(2, new PathfinderGoalSit(this));
        this.cs.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.cs.a(2, new a(this, 1.0));
        this.cs.a(3, new PathfinderGoalPerch(this));
        this.cs.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder hd() {
        return EntityAnimal.gW().a(GenericAttributes.u, 6.0).a(GenericAttributes.n, 0.4f).a(GenericAttributes.x, 0.2f).a(GenericAttributes.d, 3.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.e(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    public void d_() {
        if (this.cJ == null || !this.cJ.a(this.dI(), 3.46) || !this.ao().a_(this.cJ).a(Blocks.ew)) {
            this.cI = false;
            this.cJ = null;
        }
        if (this.ao().y.a(400) == 0) {
            EntityParrot.a(this.ao(), this);
        }
        super.d_();
        this.hh();
    }

    @Override
    public void a(BlockPosition pos, boolean isPartying) {
        this.cJ = pos;
        this.cI = isPartying;
    }

    public boolean he() {
        return this.cI;
    }

    private void hh() {
        this.cC = this.cz;
        this.cB = this.cA;
        this.cA += (float)(!this.aV() && !this.cq() ? 4 : -1) * 0.3f;
        this.cA = MathHelper.a(this.cA, 0.0f, 1.0f);
        if (!this.aV() && this.cG < 1.0f) {
            this.cG = 1.0f;
        }
        this.cG *= 0.9f;
        Vec3D deltaMovement = this.dN();
        if (!this.aV() && deltaMovement.h < 0.0) {
            this.k(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.cz += this.cG * 2.0f;
    }

    public static boolean a(World level, Entity parrot) {
        if (parrot.cb() && !parrot.bq() && level.y.a(2) == 0) {
            EntityInsentient mob;
            List<EntityInsentient> entitiesOfClass = level.a(EntityInsentient.class, parrot.dj().g(20.0), cE);
            if (!entitiesOfClass.isEmpty() && !(mob = entitiesOfClass.get(level.y.a(entitiesOfClass.size()))).bq()) {
                SoundEffect imitatedSound = EntityParrot.b(mob.ay());
                level.a(null, parrot.dP(), parrot.dR(), parrot.dV(), imitatedSound, parrot.dB(), 0.7f, EntityParrot.a(level.y));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!this.p() && itemInHand.a(TagsItem.bf)) {
            this.a(player, hand, itemInHand);
            if (!this.bq()) {
                this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.vo, this.dB(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
            }
            if (!this.ao().B_()) {
                if (this.as.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.g(player);
                    this.ao().a((Entity)this, (byte)7);
                } else {
                    this.ao().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemInHand.a(TagsItem.bg)) {
            if (!this.d() && this.p() && this.j(player)) {
                if (!this.ao().B_()) {
                    this.z(!this.gR());
                }
                return EnumInteractionResult.a;
            }
            return super.b(player, hand);
        }
        this.a(player, hand, itemInHand);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (player.ha() || !this.cU()) {
            this.a(this.en().a(player), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean j(ItemStack stack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cq) && EntityParrot.a(level, pos);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return null;
    }

    @Override
    public @Nullable SoundEffect W() {
        return EntityParrot.a(this.ao(), this.ao().y);
    }

    public static SoundEffect a(World level, RandomSource random) {
        if (level.av() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cF.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.vm;
    }

    private static SoundEffect b(EntityTypes<?> type) {
        return cF.getOrDefault(type, SoundEffects.vm);
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.vq;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.vn;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.wf, 0.15f, 1.0f);
    }

    @Override
    protected boolean bp() {
        return this.am > this.cH;
    }

    @Override
    protected void bo() {
        this.a(SoundEffects.vp, 0.15f, 1.0f);
        this.cH = this.am + this.cA / 2.0f;
    }

    @Override
    public float fD() {
        return EntityParrot.a(this.as);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void F(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.F(entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.z(false);
        return true;
    }

    public Variant hf() {
        return Variant.a(this.az.a(cD));
    }

    public void a(Variant variant) {
        this.az.a(cD, variant.k);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aI ? EntityParrot.c(component, this.hf()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aI);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aI) {
            this.a(EntityParrot.c(DataComponents.aI, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cD, Variant.f.k);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Variant", Variant.h, this.hf());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean d() {
        return !this.aV();
    }

    @Override
    protected boolean gV() {
        return true;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.5f * this.dk(), this.dF() * 0.4f);
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "red_blue");
        public static final /* enum */ Variant b = new Variant(1, "blue");
        public static final /* enum */ Variant c = new Variant(2, "green");
        public static final /* enum */ Variant d = new Variant(3, "yellow_blue");
        public static final /* enum */ Variant e = new Variant(4, "gray");
        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;
        private static final /* synthetic */ Variant[] m;

        public static Variant[] values() {
            return (Variant[])m.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.k = id;
            this.l = name;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int id) {
            return j.apply(id);
        }

        @Override
        public String c() {
            return this.l;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            m = Variant.b();
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            h = Codec.INT.xmap(j::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speedModifier) {
            super(mob, speedModifier);
        }

        @Override
        protected @Nullable Vec3D h() {
            Vec3D vec3 = null;
            if (this.b.by()) {
                vec3 = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.ep().i() >= this.j) {
                vec3 = this.k();
            }
            return vec3 == null ? super.h() : vec3;
        }

        private @Nullable Vec3D k() {
            BlockPosition blockPos = this.b.dK();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos1 : BlockPosition.b(MathHelper.c(this.b.dP() - 3.0), MathHelper.c(this.b.dR() - 6.0), MathHelper.c(this.b.dV() - 3.0), MathHelper.c(this.b.dP() + 3.0), MathHelper.c(this.b.dR() + 6.0), MathHelper.c(this.b.dV() + 3.0))) {
                IBlockData blockState;
                boolean flag;
                if (blockPos.equals(blockPos1) || !(flag = (blockState = this.b.ao().a_(mutableBlockPos1.a((BaseBlockPosition)blockPos1, EnumDirection.a))).b() instanceof BlockLeaves || blockState.a(TagsBlock.E)) || !this.b.ao().A(blockPos1) || !this.b.ao().A(mutableBlockPos.a((BaseBlockPosition)blockPos1, EnumDirection.b))) continue;
                return Vec3D.c(blockPos1);
            }
            return null;
        }
    }
}

