/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.pig;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.animal.pig.PigVariants;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityPig
extends EntityAnimal
implements ISteerable {
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<PigVariant>> cw = DataWatcher.a(EntityPig.class, DataWatcherRegistry.C);
    public final SaddleStorage cx;

    public EntityPig(EntityTypes<? extends EntityPig> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cx = new SaddleStorage(this.az, cv);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 1.25));
        this.cs.a(3, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(Items.pn), false));
        this.cs.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(TagsItem.ba), false));
        this.cs.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.cs.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 10.0).a(GenericAttributes.x, 0.25);
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityHuman player;
        Entity entity;
        return this.al() && (entity = this.do()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.pn) ? player : super.dl();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cv.equals(key) && this.ao().B_()) {
            this.cx.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, 0);
        builder.a(cw, VariantUtils.a(this.eo(), PigVariants.d));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        VariantUtils.a(output, this.gP());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.bo).ifPresent(this::b);
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.wm;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.wo;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.wn;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.wq, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.j(player.b(hand));
        if (!isFood && this.al() && !this.cr() && !player.gA()) {
            if (!this.ao().B_()) {
                player.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return this.a(itemInHand, EnumItemSlot.h) ? itemInHand.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        return interactionResult;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.cb() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.wp : super.a(slot, stack, equippable);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.av() != EnumDifficulty.a) {
            EntityPigZombie zombifiedPiglin = this.convertTo(EntityTypes.ca, ConversionParams.a(this, false, true), (T mob) -> {
                mob.a(this.ep(), level.c(this.dK()));
                mob.gz();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, lightning, zombifiedPiglin).isCancelled()) {
                return;
            }
            level.addFreshEntity(zombifiedPiglin, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (zombifiedPiglin == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        this.a(player.ec(), player.ee() * 0.5f);
        this.bC = this.bE = this.ec();
        this.ab = this.bE;
        this.cx.b();
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman player) {
        return (float)(this.i(GenericAttributes.x) * 0.225 * (double)this.cx.c());
    }

    @Override
    public boolean a() {
        return this.cx.a(this.ep());
    }

    public @Nullable EntityPig b(WorldServer level, EntityAgeable partner) {
        EntityPig pig = EntityTypes.aY.a(level, EntitySpawnReason.e);
        if (pig != null && partner instanceof EntityPig) {
            EntityPig pig1 = (EntityPig)partner;
            pig.b(this.as.h() ? this.gP() : pig1.gP());
        }
        return pig;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ba);
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    public void b(Holder<PigVariant> variant) {
        this.az.a(cw, variant);
    }

    public Holder<PigVariant> gP() {
        return this.az.a(cw);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aO ? EntityPig.c(component, this.gP()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aO);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aO) {
            this.b(EntityPig.c(DataComponents.aO, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        VariantUtils.a(SpawnContext.a(level, this.dK()), Registries.bo).ifPresent(this::b);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }
}

