/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.polarbear;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float cw = 6.0f;
    private float cx;
    private float cz;
    private int cA;
    private static final UniformInt cB = TimeRange.a(20, 39);
    private long cC;
    private @Nullable EntityReference<EntityLiving> cD;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bc.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return false;
    }

    @Override
    protected void D() {
        super.D();
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new c());
        this.cs.a(1, new PathfinderGoalPanic((EntityCreature)this, 2.0, mob -> mob.e_() ? DamageTypeTags.F : DamageTypeTags.G));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.cs.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new b());
        this.ct.a(2, new a());
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ct.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.ct.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 30.0).a(GenericAttributes.o, 20.0).a(GenericAttributes.x, 0.25).a(GenericAttributes.d, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        Holder<BiomeBase> biome = level.z(pos);
        return !biome.a(BiomeTags.al) ? EntityPolarBear.b(entityType, level, spawnReason, pos, random) : EntityPolarBear.a(level, pos) && level.a_(pos.e()).a(TagsBlock.cr);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(this.ao(), input);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        this.b_(output);
    }

    @Override
    public void c() {
        this.a(cB.a(this.as));
    }

    @Override
    public void b(long absoluteTime) {
        this.cC = absoluteTime;
    }

    @Override
    public long a() {
        return this.cC;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> target) {
        this.cD = target;
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cD;
    }

    @Override
    public SoundEffect W() {
        return this.e_() ? SoundEffects.xj : SoundEffects.xi;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.xl;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.xk;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.xm, 0.15f, 1.0f);
    }

    protected void gP() {
        if (this.cA <= 0) {
            this.b(SoundEffects.xn);
            this.cA = 40;
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, false);
    }

    @Override
    public void g() {
        super.g();
        if (this.ao().B_()) {
            if (this.cz != this.cx) {
                this.j_();
            }
            this.cx = this.cz;
            this.cz = this.gQ() ? MathHelper.a(this.cz + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.cz - 1.0f, 0.0f, 6.0f);
        }
        if (this.cA > 0) {
            --this.cA;
        }
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
    }

    @Override
    public EntitySize b(EntityPose pose) {
        if (this.cz > 0.0f) {
            float f2 = this.cz / 6.0f;
            float f1 = 1.0f + f2;
            return super.b(pose).a(1.0f, f1);
        }
        return super.b(pose);
    }

    public boolean gQ() {
        return this.az.a(cv);
    }

    public void x(boolean standing) {
        this.az.a(cv, standing);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cx, this.cz) / 6.0f;
    }

    @Override
    protected float fI() {
        return 0.98f;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.polarbear.EntityPolarBear$c.a(this.a), (Entity)target);
                EntityPolarBear.this.x(false);
            } else if (this.a.g((Entity)target) < (double)((target.dF() + 3.0f) * (target.dF() + 3.0f))) {
                if (this.i()) {
                    EntityPolarBear.this.x(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.x(true);
                    EntityPolarBear.this.gP();
                }
            } else {
                this.h();
                EntityPolarBear.this.x(false);
            }
        }

        @Override
        public void e() {
            EntityPolarBear.this.x(false);
            super.e();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        public void d() {
            super.d();
            if (EntityPolarBear.this.e_()) {
                this.h();
                this.e();
            }
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.e_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        public boolean b() {
            if (EntityPolarBear.this.e_()) {
                return false;
            }
            if (super.b()) {
                for (EntityPolarBear polarBear : EntityPolarBear.this.ao().a(EntityPolarBear.class, EntityPolarBear.this.dj().c(8.0, 4.0, 8.0))) {
                    if (!polarBear.e_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

