/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.rabbit;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class EntityRabbit
extends EntityAnimal {
    public static final double cv = 0.6;
    public static final double cw = 0.8;
    public static final double cx = 1.0;
    public static final double cz = 2.2;
    public static final double cA = 1.4;
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(EntityRabbit.class, DataWatcherRegistry.b);
    private static final int cC = 0;
    private static final MinecraftKey cD = MinecraftKey.b("killer_bunny");
    private static final int cE = 3;
    private static final int cF = 5;
    private static final MinecraftKey cG = MinecraftKey.b("evil");
    private static final int cH = 8;
    private static final int cI = 40;
    private int cJ;
    private int cK;
    private boolean cL;
    private int cM;
    public int cN = 0;

    public EntityRabbit(EntityTypes<? extends EntityRabbit> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cq = new ControllerJumpRabbit(this);
        this.cp = new ControllerMoveRabbit(this);
    }

    @Override
    public void D() {
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.ao()));
        this.cs.a(1, new PathfinderGoalRabbitPanic(this, 2.2));
        this.cs.a(2, new PathfinderGoalBreed(this, 0.8));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.0, stack -> stack.a(TagsItem.bb), false));
        this.cs.a(4, new PathfinderGoalRabbitAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 2.2, 2.2));
        this.cs.a(4, new PathfinderGoalRabbitAvoidTarget<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.cs.a(4, new PathfinderGoalRabbitAvoidTarget<EntityMonster>(this, EntityMonster.class, 4.0f, 2.2, 2.2));
        this.cs.a(5, new PathfinderGoalEatCarrots(this));
        this.cs.a(6, new PathfinderGoalRandomStrollLand(this, 0.6));
        this.cs.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
    }

    @Override
    protected float fF() {
        PathEntity path;
        float f2 = 0.3f;
        if (this.cp.c() <= 0.6) {
            f2 = 0.2f;
        }
        if ((path = this.cr.j()) != null && !path.c()) {
            Vec3D nextEntityPos = path.a(this);
            if (nextEntityPos.h > this.dR() + 0.5) {
                f2 = 0.5f;
            }
        }
        if (this.ad || this.bM && this.cp.e() > this.dR() + 0.5) {
            f2 = 0.5f;
        }
        return super.A(f2 / 0.42f);
    }

    @Override
    public void u() {
        double d2;
        super.u();
        double speedModifier = this.cp.c();
        if (speedModifier > 0.0 && (d2 = this.dN().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
        if (!this.ao().B_()) {
            this.ao().a((Entity)this, (byte)1);
        }
    }

    public float L(float partialTick) {
        return this.cK == 0 ? 0.0f : ((float)this.cJ + partialTick) / (float)this.cK;
    }

    public void k(double speedModifier) {
        this.N().a(speedModifier);
        this.cp.a(this.cp.d(), this.cp.e(), this.cp.f(), speedModifier);
    }

    @Override
    public void t(boolean jumping) {
        super.t(jumping);
        if (jumping) {
            this.a(this.gQ(), this.fC(), ((this.as.i() - this.as.i()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void p() {
        this.t(true);
        this.cK = 10;
        this.cJ = 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cB, Variant.h.m);
    }

    @Override
    public void a(WorldServer level) {
        if (this.cM > 0) {
            --this.cM;
        }
        if (this.cN > 0) {
            this.cN -= this.as.a(3);
            if (this.cN < 0) {
                this.cN = 0;
            }
        }
        if (this.aV()) {
            ControllerJumpRabbit rabbitJumpControl;
            EntityLiving target;
            if (!this.cL) {
                this.t(false);
                this.gV();
            }
            if (this.gR() == Variant.g && this.cM == 0 && (target = this.ag_()) != null && this.g((Entity)target) < 16.0) {
                this.c(target.dP(), target.dV());
                this.cp.a(target.dP(), target.dR(), target.dV(), this.cp.c());
                this.p();
                this.cL = true;
            }
            if (!(rabbitJumpControl = (ControllerJumpRabbit)this.cq).c()) {
                if (this.cp.b() && this.cM == 0) {
                    PathEntity path = this.cr.j();
                    Vec3D vec3 = new Vec3D(this.cp.d(), this.cp.e(), this.cp.f());
                    if (path != null && !path.c()) {
                        vec3 = path.a(this);
                    }
                    this.c(vec3.g, vec3.i);
                    this.p();
                }
            } else if (!rabbitJumpControl.d()) {
                this.gS();
            }
        }
        this.cL = this.aV();
    }

    @Override
    public boolean bL() {
        return false;
    }

    private void c(double x2, double z2) {
        this.v((float)(MathHelper.d(z2 - this.dV(), x2 - this.dP()) * 180.0 / 3.1415927410125732) - 90.0f);
    }

    private void gS() {
        ((ControllerJumpRabbit)this.cq).a(true);
    }

    private void gT() {
        ((ControllerJumpRabbit)this.cq).a(false);
    }

    private void gU() {
        this.cM = this.cp.c() < 2.2 ? 10 : 1;
    }

    private void gV() {
        this.gU();
        this.gT();
    }

    @Override
    public void d_() {
        super.d_();
        if (this.cJ != this.cK) {
            ++this.cJ;
        } else if (this.cK != 0) {
            this.cJ = 0;
            this.cK = 0;
            this.t(false);
        }
    }

    public static AttributeProvider.Builder gP() {
        return EntityAnimal.gW().a(GenericAttributes.u, 3.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.d, 3.0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("RabbitType", Variant.j, this.gR());
        output.a("MoreCarrotTicks", this.cN);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("RabbitType", Variant.j).orElse(Variant.h));
        this.cN = input.a("MoreCarrotTicks", 0);
    }

    protected SoundEffect gQ() {
        return SoundEffects.xM;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.xI;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.xL;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.xK;
    }

    @Override
    public void fN() {
        if (this.gR() == Variant.g) {
            this.a(SoundEffects.xJ, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
        }
    }

    @Override
    public SoundCategory dB() {
        return this.gR() == Variant.g ? SoundCategory.f : SoundCategory.g;
    }

    /*
     * Unable to fully structure code
     */
    public @Nullable EntityRabbit b(WorldServer level, EntityAgeable partner) {
        block2: {
            block3: {
                rabbit = EntityTypes.bg.a(level, EntitySpawnReason.e);
                if (rabbit == null) break block2;
                randomRabbitVariant = EntityRabbit.a((GeneratorAccess)level, this.dK());
                if (this.as.a(20) == 0) break block3;
                if (!(partner instanceof EntityRabbit)) ** GOTO lbl-1000
                rabbit1 = (EntityRabbit)partner;
                if (this.as.h()) {
                    randomRabbitVariant = rabbit1.gR();
                } else lbl-1000:
                // 2 sources

                {
                    randomRabbitVariant = this.gR();
                }
            }
            rabbit.a(randomRabbitVariant);
        }
        return rabbit;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.bb);
    }

    public Variant gR() {
        return Variant.a(this.az.a(cB));
    }

    public void a(Variant variant) {
        if (variant == Variant.g) {
            this.h(GenericAttributes.b).a(8.0);
            this.cs.a(4, new PathfinderGoalMeleeAttack(this, 1.4, true));
            this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
            this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
            this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityWolf>((EntityInsentient)this, EntityWolf.class, true));
            this.h(GenericAttributes.d).a(new AttributeModifier(cG, 5.0, AttributeModifier.Operation.a));
            if (!this.i_()) {
                this.b(IChatBaseComponent.c(SystemUtils.a("entity", cD)));
            }
        } else {
            this.h(GenericAttributes.d).c(cG);
        }
        this.az.a(cB, variant.m);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aN ? EntityRabbit.c(component, this.gR()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aN);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aN) {
            this.a(EntityRabbit.c(DataComponents.aN, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Variant randomRabbitVariant = EntityRabbit.a(level, this.dK());
        if (spawnGroupData instanceof GroupDataRabbit) {
            randomRabbitVariant = ((GroupDataRabbit)spawnGroupData).a;
        } else {
            spawnGroupData = new GroupDataRabbit(randomRabbitVariant);
        }
        this.a(randomRabbitVariant);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private static Variant a(GeneratorAccess level, BlockPosition pos) {
        Holder<BiomeBase> biome = level.z(pos);
        int randomInt = level.G_().a(100);
        if (biome.a(BiomeTags.ai)) {
            return randomInt < 80 ? Variant.b : Variant.d;
        }
        if (biome.a(BiomeTags.ah)) {
            return Variant.e;
        }
        return randomInt < 50 ? Variant.a : (randomInt < 90 ? Variant.f : Variant.c);
    }

    public static boolean c(EntityTypes<EntityRabbit> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cs) && EntityRabbit.a(level, pos);
    }

    boolean hd() {
        return this.cN <= 0;
    }

    @Override
    public void b(byte id) {
        if (id == 1) {
            this.bM();
            this.cK = 10;
            this.cJ = 0;
        } else {
            super.b(id);
        }
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    public static class ControllerJumpRabbit
    extends ControllerJump {
        private final EntityRabbit b;
        private boolean c;

        public ControllerJumpRabbit(EntityRabbit mob) {
            super(mob);
            this.b = mob;
        }

        public boolean c() {
            return this.a;
        }

        public boolean d() {
            return this.c;
        }

        public void a(boolean canJump) {
            this.c = canJump;
        }

        @Override
        public void b() {
            if (this.a) {
                this.b.p();
                this.a = false;
            }
        }
    }

    static class ControllerMoveRabbit
    extends ControllerMove {
        private final EntityRabbit l;
        private double m;

        public ControllerMoveRabbit(EntityRabbit mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.l.aV() && !this.l.bM && !((ControllerJumpRabbit)this.l.cq).c()) {
                this.l.k(0.0);
            } else if (this.b() || this.k == ControllerMove.Operation.d) {
                this.l.k(this.m);
            }
            super.a();
        }

        @Override
        public void a(double x2, double y2, double z2, double speedModifier) {
            if (this.l.by()) {
                speedModifier = 1.5;
            }
            super.a(x2, y2, z2, speedModifier);
            if (speedModifier > 0.0) {
                this.m = speedModifier;
            }
        }
    }

    static class PathfinderGoalRabbitPanic
    extends PathfinderGoalPanic {
        private final EntityRabbit a;

        public PathfinderGoalRabbitPanic(EntityRabbit rabbit, double speedModifier) {
            super(rabbit, speedModifier);
            this.a = rabbit;
        }

        @Override
        public void a() {
            super.a();
            this.a.k(this.d);
        }
    }

    static class PathfinderGoalRabbitAvoidTarget<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityRabbit i;

        public PathfinderGoalRabbitAvoidTarget(EntityRabbit rabbit, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(rabbit, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier);
            this.i = rabbit;
        }

        @Override
        public boolean b() {
            return this.i.gR() != Variant.g && super.b();
        }
    }

    static class PathfinderGoalEatCarrots
    extends PathfinderGoalGotoTarget {
        private final EntityRabbit g;
        private boolean h;
        private boolean i;

        public PathfinderGoalEatCarrots(EntityRabbit rabbit) {
            super(rabbit, 0.7f, 16);
            this.g = rabbit;
        }

        @Override
        public boolean b() {
            if (this.c <= 0) {
                if (!PathfinderGoalEatCarrots.a(this.g).U().a(GameRules.F).booleanValue()) {
                    return false;
                }
                this.i = false;
                this.h = this.g.hd();
            }
            return super.b();
        }

        @Override
        public boolean c() {
            return this.i && super.c();
        }

        @Override
        public void a() {
            super.a();
            this.g.J().a((double)this.e.u() + 0.5, this.e.v() + 1, (double)this.e.w() + 0.5, 10.0f, this.g.ac());
            if (this.m()) {
                World level = this.g.ao();
                BlockPosition blockPos = this.e.d();
                IBlockData blockState = level.a_(blockPos);
                Block block = blockState.b();
                if (this.i && block instanceof BlockCarrots) {
                    int ageValue = blockState.c(BlockCrops.f);
                    if (ageValue == 0) {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.g, blockPos, blockState.y().g())) {
                            return;
                        }
                        level.a(blockPos, Blocks.a.m(), 2);
                        level.a(blockPos, true, this.g);
                    } else {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.g, blockPos, (IBlockData)blockState.b(BlockCrops.f, ageValue - 1))) {
                            return;
                        }
                        level.a(blockPos, (IBlockData)blockState.b(BlockCrops.f, ageValue - 1), 2);
                        level.a(GameEvent.c, blockPos, GameEvent.a.a(this.g));
                        level.c(2001, blockPos, Block.j(blockState));
                    }
                    this.g.cN = 40;
                }
                this.i = false;
                this.c = 10;
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            IBlockData blockState = level.a_(pos);
            if (blockState.a(Blocks.cZ) && this.h && !this.i && (blockState = level.a_(pos.d())).b() instanceof BlockCarrots && ((BlockCarrots)blockState.b()).i(blockState)) {
                this.i = true;
                return true;
            }
            return false;
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "brown");
        public static final /* enum */ Variant b = new Variant(1, "white");
        public static final /* enum */ Variant c = new Variant(2, "black");
        public static final /* enum */ Variant d = new Variant(3, "white_splotched");
        public static final /* enum */ Variant e = new Variant(4, "gold");
        public static final /* enum */ Variant f = new Variant(5, "salt");
        public static final /* enum */ Variant g = new Variant(99, "evil");
        public static final Variant h;
        private static final IntFunction<Variant> l;
        public static final Codec<Variant> i;
        @Deprecated
        public static final Codec<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> k;
        final int m;
        private final String n;
        private static final /* synthetic */ Variant[] o;

        public static Variant[] values() {
            return (Variant[])o.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.m = id;
            this.n = name;
        }

        @Override
        public String c() {
            return this.n;
        }

        public int a() {
            return this.m;
        }

        public static Variant a(int id) {
            return l.apply(id);
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e, f, g};
        }

        static {
            o = Variant.b();
            h = a;
            l = ByIdMap.a(Variant::a, Variant.values(), h);
            i = INamable.a(Variant::values);
            j = Codec.INT.xmap(l::apply, Variant::a);
            k = ByteBufCodecs.a(l, Variant::a);
        }
    }

    public static class GroupDataRabbit
    extends EntityAgeable.a {
        public final Variant a;

        public GroupDataRabbit(Variant variant) {
            super(1.0f);
            this.a = variant;
        }
    }
}

