/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sheep.SheepColorSpawnRules;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Sheep;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.jspecify.annotations.Nullable;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int cv = 40;
    private static final DataWatcherObject<Byte> cw = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final EnumColor cx = EnumColor.a;
    private static final boolean cz = false;
    private int cA;
    private PathfinderGoalEatTile cB;

    public EntitySheep(EntityTypes<? extends EntitySheep> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
    }

    @Override
    protected void D() {
        this.cB = new PathfinderGoalEatTile(this);
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 1.25));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.1, stack -> stack.a(TagsItem.aG), false));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.cs.a(5, this.cB);
        this.cs.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aG);
    }

    @Override
    protected void a(WorldServer level) {
        this.cA = this.cB.h();
        super.a(level);
    }

    @Override
    public void d_() {
        if (this.ao().B_()) {
            this.cA = Math.max(0, this.cA - 1);
        }
        super.d_();
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 8.0).a(GenericAttributes.x, 0.23f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cw, (byte)0);
    }

    @Override
    public void b(byte id) {
        if (id == 10) {
            this.cA = 40;
        } else {
            super.b(id);
        }
    }

    public float L(float partialTick) {
        if (this.cA <= 0) {
            return 0.0f;
        }
        if (this.cA >= 4 && this.cA <= 36) {
            return 1.0f;
        }
        return this.cA < 4 ? ((float)this.cA - partialTick) / 4.0f : -((float)(this.cA - 40) - partialTick) / 4.0f;
    }

    public float M(float partialTick) {
        if (this.cA > 4 && this.cA <= 36) {
            float f2 = ((float)(this.cA - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a((double)(f2 * 28.7f));
        }
        return this.cA > 0 ? 0.62831855f : this.k(partialTick) * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.tZ)) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.a()) {
                    List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                    PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                    if (event != null) {
                        if (event.isCancelled()) {
                            return EnumInteractionResult.e;
                        }
                        drops = CraftItemStack.asNMSCopy(event.getDrops());
                    }
                    this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                    this.a(GameEvent.M, (Entity)player);
                    itemInHand.a(1, (EntityLiving)player, hand.a());
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(level, LootTables.bb, shears, (arg_0, arg_1) -> EntitySheep.lambda$generateDefaultDrops$1((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.zw, source, 1.0f, 1.0f);
        drops.forEach(itemStack -> {
            this.forceDrops = true;
            EntityItem itemEntity = this.a(level, (ItemStack)itemStack, 1.0f);
            this.forceDrops = false;
            if (itemEntity != null) {
                itemEntity.k(itemEntity.dN().b((this.as.i() - this.as.i()) * 0.1f, this.as.i() * 0.05f, (this.as.i() - this.as.i()) * 0.1f));
            }
        });
        this.x(true);
    }

    @Override
    public boolean a() {
        return this.cb() && !this.gQ() && !this.e_();
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Sheared", this.gQ());
        output.a("Color", EnumColor.s, this.gP());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("Sheared", false));
        this.a(input.a("Color", EnumColor.s).orElse(cx));
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.zt;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.zv;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.zu;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.zx, 0.15f, 1.0f);
    }

    public EnumColor gP() {
        return EnumColor.a(this.az.a(cw) & 0xF);
    }

    public void a(EnumColor color) {
        byte b2 = this.az.a(cw);
        this.az.a(cw, (byte)(b2 & 0xF0 | color.a() & 0xF));
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aZ ? EntitySheep.c(component, this.gP()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aZ);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aZ) {
            this.a(EntitySheep.c(DataComponents.aZ, value));
            return true;
        }
        return super.b(component, value);
    }

    public boolean gQ() {
        return (this.az.a(cw) & 0x10) != 0;
    }

    public void x(boolean sheared) {
        byte b2 = this.az.a(cw);
        if (sheared) {
            this.az.a(cw, (byte)(b2 | 0x10));
        } else {
            this.az.a(cw, (byte)(b2 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(WorldAccess level, BlockPosition pos) {
        Holder<BiomeBase> biome = level.z(pos);
        return SheepColorSpawnRules.a(biome, level.G_());
    }

    public @Nullable EntitySheep b(WorldServer level, EntityAgeable partner) {
        EntitySheep sheep = EntityTypes.bj.a(level, EntitySpawnReason.e);
        if (sheep != null) {
            EnumColor color = this.gP();
            EnumColor color1 = ((EntitySheep)partner).gP();
            sheep.a(EnumColor.a(level, color, color1));
        }
        return sheep;
    }

    @Override
    public void R() {
        if (!new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity()).callEvent()) {
            return;
        }
        super.R();
        this.x(false);
        if (this.e_()) {
            this.c_(60);
        }
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(EntitySheep.a(level, this.dK()));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$1(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.N(); ++i2) {
            drops.add(stack.c(1));
        }
    }
}

