/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int cB = 1700;
    private static final int cC = 6000;
    private static final int cD = 30;
    private static final int cE = 120;
    private static final int cF = 48000;
    private static final float cG = 0.4f;
    private static final EntitySize cH = EntitySize.b(EntityTypes.br.l(), EntityTypes.br.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> cI = DataWatcher.a(Sniffer.class, DataWatcherRegistry.G);
    private static final DataWatcherObject<Integer> cJ = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState cv = new AnimationState();
    public final AnimationState cw = new AnimationState();
    public final AnimationState cx = new AnimationState();
    public final AnimationState cz = new AnimationState();
    public final AnimationState cA = new AnimationState();

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.1f).a(GenericAttributes.u, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> type, World level) {
        super(type, level);
        this.N().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cI, State.a);
        builder.a(cJ, 0);
    }

    @Override
    public void G() {
        super.G();
        if (this.cp() || this.by()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void H() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.he() == State.f ? cH.a(this.eE()) : super.b(pose);
    }

    public boolean gP() {
        return this.he() == State.e;
    }

    public boolean gQ() {
        return this.ca.c(MemoryModuleType.S).orElse(false);
    }

    public boolean gR() {
        return !this.gQ() && !this.gM() && !this.by() && !this.hb() && this.aV() && !this.cq() && !this.S_();
    }

    public boolean gS() {
        return this.he() == State.f || this.he() == State.e;
    }

    private BlockPosition gV() {
        Vec3D headPosition = this.hd();
        return BlockPosition.a(headPosition.a(), this.dR() + (double)0.2f, headPosition.c());
    }

    private Vec3D hd() {
        return this.dI().e(this.cm().c(2.25));
    }

    @Override
    public boolean z() {
        return true;
    }

    @Override
    public Vec3D[] A() {
        return Leashable.a(this, -0.01, 0.63, 0.38, 1.15);
    }

    public State he() {
        return this.az.a(cI);
    }

    private Sniffer b(State state) {
        this.az.a(cI, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cI.equals(key)) {
            State state = this.he();
            this.hf();
            switch (state.ordinal()) {
                case 1: {
                    this.cv.b(this.at);
                    break;
                }
                case 2: {
                    this.cw.b(this.at);
                    break;
                }
                case 3: {
                    this.cx.b(this.at);
                }
                default: {
                    break;
                }
                case 5: {
                    this.cz.b(this.at);
                    break;
                }
                case 6: {
                    this.cA.b(this.at);
                }
            }
            this.j_();
        }
        super.a(key);
    }

    private void hf() {
        this.cz.a();
        this.cx.a();
        this.cA.a();
        this.cv.a();
        this.cw.a();
    }

    public Sniffer a(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.BO, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).hg();
                break;
            }
            case 3: {
                this.a(SoundEffects.BK, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).hh();
                break;
            }
            case 6: {
                this.a(SoundEffects.BN, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer hg() {
        this.a(SoundEffects.BJ, 1.0f, this.e_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer hh() {
        this.az.a(cJ, this.at + 120);
        this.ao().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer x(boolean storeExploredPosition) {
        if (storeExploredPosition) {
            this.i(this.bg());
        }
        return this;
    }

    public Optional<BlockPosition> gT() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockPos -> this.ao().w().a((BlockPosition)blockPos)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gU() {
        return !this.gM() && !this.gQ() && !this.e_() && !this.by() && this.aV() && !this.cq() && this.h(this.gV().e());
    }

    private boolean h(BlockPosition pos) {
        return this.ao().a_(pos).a(TagsBlock.cJ) && this.hj().noneMatch(globalPos -> GlobalPos.a(this.ao().aq(), pos).equals(globalPos)) && Optional.ofNullable(this.N().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void hi() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.az.a(cJ) == this.at) {
                BlockPosition headBlock = this.gV();
                this.a(serverLevel, LootTables.aG, (WorldServer serverLevel1, ItemStack itemStack) -> {
                    EntityItem itemEntity = new EntityItem(this.ao(), headBlock.u(), headBlock.v(), headBlock.w(), (ItemStack)itemStack);
                    itemEntity.i();
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    serverLevel1.b(itemEntity);
                });
                this.a(SoundEffects.BI, 1.0f, 1.0f);
            }
        }
    }

    private Sniffer a(AnimationState animationState) {
        boolean flag;
        boolean bl = flag = animationState.a((float)this.at) > 1700L && animationState.a((float)this.at) < 6000L;
        if (flag) {
            BlockPosition headBlock = this.gV();
            IBlockData blockState = this.ao().a_(headBlock.e());
            if (blockState.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3 = Vec3D.b(headBlock).b(0.0, -0.65f, 0.0);
                    this.ao().a(new ParticleParamBlock(Particles.b, blockState), vec3.g, vec3.h, vec3.i, 0.0, 0.0, 0.0);
                }
                if (this.at % 10 == 0) {
                    this.ao().a(this.dP(), this.dR(), this.dV(), blockState.A().f(), this.dB(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.at % 10 == 0) {
            this.ao().a(GameEvent.u, this.gV(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition pos) {
        List list = this.hj().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.ao().aq(), pos));
        this.ev().a(MemoryModuleType.bb, list);
        return this;
    }

    public Stream<GlobalPos> hj() {
        return this.ev().c(MemoryModuleType.bb).stream().flatMap(Collection::stream);
    }

    @Override
    public void u() {
        double d2;
        super.u();
        double speedModifier = this.cp.c();
        if (speedModifier > 0.0 && (d2 = this.dN().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer level, EntityAnimal partner) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, partner);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemStack = new ItemStack(Items.lj);
        EntityItem itemEntity = new EntityItem(level, this.dI().a(), this.dI().b(), this.dI().c(), itemStack);
        itemEntity.i();
        this.finalizeSpawnChildFromBreeding(level, partner, null, result.getExperience());
        if (this.spawnAtLocation(level, itemEntity) != null) {
            this.a(SoundEffects.BP, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void g() {
        switch (this.he().ordinal()) {
            case 4: {
                this.hk();
                break;
            }
            case 5: {
                this.a(this.cz).hi();
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        boolean isFood = this.j(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gX();
        }
        return interactionResult;
    }

    @Override
    protected void gX() {
        this.ao().a(null, this, SoundEffects.BE, SoundCategory.g, 1.0f, MathHelper.b(this.ao().y, 0.8f, 1.2f));
    }

    private void hk() {
        if (this.ao().B_() && this.at % 20 == 0) {
            this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.BL, this.dB(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.BD, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect W() {
        return Set.of(State.f, State.e).contains((Object)this.he()) ? null : SoundEffects.BF;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.BG;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.BH;
    }

    @Override
    public int ae() {
        return 50;
    }

    @Override
    public void a_(boolean baby) {
        this.d_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.br.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        if (!(otherAnimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)otherAnimal;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.he()) && set.contains((Object)sniffer.he()) && super.a(otherAnimal);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aB);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<Sniffer> ev() {
        return super.ev();
    }

    protected BehaviorController.b<Sniffer> ew() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("snifferBrain");
        this.ev().a(level, this);
        profilerFiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State a = new State(0);
        public static final /* enum */ State b = new State(1);
        public static final /* enum */ State c = new State(2);
        public static final /* enum */ State d = new State(3);
        public static final /* enum */ State e = new State(4);
        public static final /* enum */ State f = new State(5);
        public static final /* enum */ State g = new State(6);
        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;
        private static final /* synthetic */ State[] k;

        public static State[] values() {
            return (State[])k.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(int id) {
            this.j = id;
        }

        public int a() {
            return this.j;
        }

        private static /* synthetic */ State[] b() {
            return new State[]{a, b, c, d, e, f, g};
        }

        static {
            k = State.b();
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

