/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.squid;

import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntitySquid
extends AgeableWaterCreature {
    public float cv;
    public float cw;
    public float cx;
    public float cy;
    public float cz;
    public float cA;
    public float cB;
    public float cC;
    private float cD;
    private float cE;
    private float cF;
    Vec3D cG = Vec3D.c;

    public EntitySquid(EntityTypes<? extends EntitySquid> type, World level) {
        super((EntityTypes<? extends AgeableWaterCreature>)type, level);
        this.cE = 1.0f / (this.as.i() + 1.0f) * 0.2f;
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalSquid(this));
        this.cs.a(1, new a());
    }

    public static AttributeProvider.Builder gR() {
        return EntityInsentient.E().a(GenericAttributes.u, 10.0);
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.Cr;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.Ct;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Cs;
    }

    protected SoundEffect gP() {
        return SoundEffects.Cu;
    }

    @Override
    public boolean aj_() {
        return true;
    }

    @Override
    public float fC() {
        return 0.4f;
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.c;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bz.a(level, EntitySpawnReason.e);
    }

    @Override
    protected double bs() {
        return 0.08;
    }

    @Override
    public void d_() {
        super.d_();
        this.cw = this.cv;
        this.cy = this.cx;
        this.cA = this.cz;
        this.cC = this.cB;
        this.cz += this.cE;
        if ((double)this.cz > Math.PI * 2) {
            if (this.ao().B_()) {
                this.cz = (float)Math.PI * 2;
            } else {
                this.cz -= (float)Math.PI * 2;
                if (this.as.a(10) == 0) {
                    this.cE = 1.0f / (this.as.i() + 1.0f) * 0.2f;
                }
                this.ao().a((Entity)this, (byte)19);
            }
        }
        if (this.by()) {
            if (this.cz < (float)Math.PI) {
                float f2 = this.cz / (float)Math.PI;
                this.cB = MathHelper.a((double)(f2 * f2 * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f2 > 0.75) {
                    if (this.dv()) {
                        this.k(this.cG);
                    }
                    this.cF = 1.0f;
                } else {
                    this.cF *= 0.8f;
                }
            } else {
                this.cB = 0.0f;
                if (this.dv()) {
                    this.k(this.dN().c(0.9));
                }
                this.cF *= 0.99f;
            }
            Vec3D deltaMovement = this.dN();
            double d2 = deltaMovement.i();
            this.bC += (-((float)MathHelper.d(deltaMovement.g, deltaMovement.i)) * 57.295776f - this.bC) * 0.1f;
            this.v(this.bC);
            this.cx += (float)Math.PI * this.cF * 1.5f;
            this.cv += (-((float)MathHelper.d(d2, deltaMovement.h)) * 57.295776f - this.cv) * 0.1f;
        } else {
            this.cB = MathHelper.c(MathHelper.a((double)this.cz)) * (float)Math.PI * 0.25f;
            if (!this.ao().B_()) {
                double d1 = this.dN().h;
                d1 = this.d(MobEffects.y) ? 0.05 * (double)(this.e(MobEffects.y).e() + 1) : (d1 -= this.bt());
                this.m(0.0, d1 * (double)0.98f, 0.0);
            }
            this.cv += (-90.0f - this.cv) * 0.02f;
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (super.a(level, damageSource, amount) && this.eK() != null) {
            this.gQ();
            return true;
        }
        return false;
    }

    private Vec3D o(Vec3D vector) {
        Vec3D vec3 = vector.a(this.cw * ((float)Math.PI / 180));
        return vec3.b(-this.bD * ((float)Math.PI / 180));
    }

    private void gQ() {
        this.b(this.gP());
        Vec3D vec3 = this.o(new Vec3D(0.0, -1.0, 0.0)).b(this.dP(), this.dR(), this.dV());
        for (int i2 = 0; i2 < 30; ++i2) {
            Vec3D vec31 = this.o(new Vec3D((double)this.as.i() * 0.6 - 0.3, -1.0, (double)this.as.i() * 0.6 - 0.3));
            float f2 = this.e_() ? 0.1f : 0.3f;
            Vec3D vec32 = vec31.c((double)(f2 + this.as.i() * 2.0f));
            ((WorldServer)this.ao()).a(this.p(), vec3.g, vec3.h + 0.5, vec3.i, 0, vec32.g, vec32.h, vec32.i, (double)0.1f);
        }
    }

    protected ParticleParam p() {
        return Particles.am;
    }

    @Override
    public void m(Vec3D travelVector) {
        this.a(EnumMoveType.a, this.dN());
    }

    @Override
    public void b(byte id) {
        if (id == 19) {
            this.cz = 0.0f;
        } else {
            super.b(id);
        }
    }

    public boolean gS() {
        return this.cG.h() > (double)1.0E-5f;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        GroupDataEntity spawnGroupData1 = Objects.requireNonNullElseGet(spawnGroupData, () -> new EntityAgeable.a(0.05f));
        return super.a(level, difficulty, spawnReason, spawnGroupData1);
    }

    static class PathfinderGoalSquid
    extends PathfinderGoal {
        private final EntitySquid a;

        public PathfinderGoalSquid(EntitySquid squid) {
            this.a = squid;
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public void a() {
            int noActionTime = this.a.eP();
            if (noActionTime > 100) {
                this.a.cG = Vec3D.c;
            } else if (this.a.ep().a(PathfinderGoalSquid.b(50)) == 0 || !this.a.au || !this.a.gS()) {
                float f2 = this.a.ep().i() * ((float)Math.PI * 2);
                this.a.cG = new Vec3D(MathHelper.b((double)f2) * 0.2f, -0.1f + this.a.ep().i() * 0.2f, MathHelper.a((double)f2) * 0.2f);
            }
        }
    }

    class a
    extends PathfinderGoal {
        private static final float b = 3.0f;
        private static final float c = 5.0f;
        private static final float d = 10.0f;
        private int e;

        a() {
        }

        @Override
        public boolean b() {
            EntityLiving lastHurtByMob = EntitySquid.this.eK();
            return EntitySquid.this.by() && lastHurtByMob != null && EntitySquid.this.g((Entity)lastHurtByMob) < 100.0;
        }

        @Override
        public void d() {
            this.e = 0;
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ++this.e;
            EntityLiving lastHurtByMob = EntitySquid.this.eK();
            if (lastHurtByMob != null) {
                Vec3D vec3 = new Vec3D(EntitySquid.this.dP() - lastHurtByMob.dP(), EntitySquid.this.dR() - lastHurtByMob.dR(), EntitySquid.this.dV() - lastHurtByMob.dV());
                IBlockData blockState = EntitySquid.this.ao().a_(BlockPosition.a(EntitySquid.this.dP() + vec3.g, EntitySquid.this.dR() + vec3.h, EntitySquid.this.dV() + vec3.i));
                Fluid fluidState = EntitySquid.this.ao().b_(BlockPosition.a(EntitySquid.this.dP() + vec3.g, EntitySquid.this.dR() + vec3.h, EntitySquid.this.dV() + vec3.i));
                if (fluidState.a(TagsFluid.a) || blockState.l()) {
                    double len = vec3.g();
                    if (len > 0.0) {
                        vec3.d();
                        double d2 = 3.0;
                        if (len > 5.0) {
                            d2 -= (len - 5.0) / 5.0;
                        }
                        if (d2 > 0.0) {
                            vec3 = vec3.c(d2);
                        }
                    }
                    if (blockState.l()) {
                        vec3 = vec3.a(0.0, vec3.h, 0.0);
                    }
                    EntitySquid.this.cG = new Vec3D(vec3.g / 20.0, vec3.h / 20.0, vec3.i / 20.0);
                }
                if (this.e % 10 == 5) {
                    EntitySquid.this.ao().a(Particles.d, EntitySquid.this.dP(), EntitySquid.this.dR(), EntitySquid.this.dV(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

