/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.turtle;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;
import org.jspecify.annotations.Nullable;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<Boolean> cw = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final float cz = 0.3f;
    private static final EntitySize cA = EntityTypes.bJ.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bJ.m(), -0.25f)).a(0.3f);
    private static final boolean cB = false;
    int cC;
    public static final PathfinderTargetCondition.a cv = (entity, level) -> entity.e_() && !entity.by();
    public BlockPosition cD = BlockPosition.c;
    @Nullable BlockPosition cE;
    public boolean cF;

    public EntityTurtle(EntityTypes<? extends EntityTurtle> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.cp = new e(this);
    }

    public void h(BlockPosition homePos) {
        this.cD = homePos;
    }

    public boolean p() {
        return this.az.a(cw);
    }

    public void x(boolean hasEgg) {
        this.az.a(cw, hasEgg);
    }

    public boolean gP() {
        return this.az.a(cx);
    }

    void y(boolean isLayingEgg) {
        this.cC = isLayingEgg ? 1 : 0;
        this.az.a(cx, isLayingEgg);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cw, false);
        builder.a(cx, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("home_pos", BlockPosition.a, this.cD);
        output.a("has_egg", this.p());
    }

    @Override
    protected void a(ValueInput input) {
        this.h(input.a("home_pos", BlockPosition.a).orElse(this.dK()));
        super.a(input);
        this.x(input.a("has_egg", false));
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.h(this.dK());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<EntityTurtle> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < level.V() + 4 && BlockTurtleEgg.a(level, pos) && EntityTurtle.a(level, pos);
    }

    @Override
    protected void D() {
        this.cs.a(0, new f(this, 1.2));
        this.cs.a(1, new a(this, 1.0));
        this.cs.a(1, new d(this, 1.0));
        this.cs.a(2, new PathfinderGoalTempt(this, 1.1, itemStack -> itemStack.a(TagsItem.be), false));
        this.cs.a(3, new c(this, 1.0));
        this.cs.a(4, new b(this, 1.0));
        this.cs.a(7, new i(this, 1.0));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder gQ() {
        return EntityAnimal.gW().a(GenericAttributes.u, 30.0).a(GenericAttributes.x, 0.25).a(GenericAttributes.D, 1.0);
    }

    @Override
    public boolean db() {
        return false;
    }

    @Override
    public int S() {
        return 200;
    }

    @Override
    public @Nullable SoundEffect W() {
        return !this.by() && this.aV() && !this.e_() ? SoundEffects.Dx : super.W();
    }

    @Override
    protected void g(float volume) {
        super.g(volume * 1.5f);
    }

    @Override
    public SoundEffect bk() {
        return SoundEffects.DI;
    }

    @Override
    public @Nullable SoundEffect h(DamageSource damageSource) {
        return this.e_() ? SoundEffects.DE : SoundEffects.DD;
    }

    @Override
    public @Nullable SoundEffect fd() {
        return this.e_() ? SoundEffects.Dz : SoundEffects.Dy;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        SoundEffect soundEvent = this.e_() ? SoundEffects.DH : SoundEffects.DG;
        this.a(soundEvent, 0.15f, 1.0f);
    }

    @Override
    public boolean gY() {
        return super.gY() && !this.p();
    }

    @Override
    protected float bj() {
        return this.al + 0.15f;
    }

    @Override
    public float eE() {
        return this.e_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new g(this, level);
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bJ.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.be);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (!this.cF && level.b_(pos).a(TagsFluid.a)) {
            return 10.0f;
        }
        return BlockTurtleEgg.a(level, pos) ? 10.0f : level.C(pos);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.cb() && this.gP() && this.cC >= 1 && this.cC % 5 == 0) {
            BlockPosition blockPos = this.dK();
            if (BlockTurtleEgg.a(this.ao(), blockPos)) {
                this.ao().c(2001, blockPos, Block.j(this.ao().a_(blockPos.e())));
                this.c(GameEvent.u);
            }
        }
    }

    @Override
    protected void h() {
        WorldServer serverLevel;
        World world;
        super.h();
        if (!this.e_() && (world = this.ao()) instanceof WorldServer && (serverLevel = (WorldServer)world).U().a(GameRules.D).booleanValue()) {
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aK, this::a);
            this.forceDrops = false;
        }
    }

    @Override
    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        this.a(0.1f, travelVector);
        this.a(EnumMoveType.a, this.dN());
        this.k(this.dN().c(0.9));
        if (!(this.ag_() != null || this.cF && this.cD.a(this.dI(), 20.0))) {
            this.k(this.dN().b(0.0, -0.005, 0.0));
        }
    }

    @Override
    public boolean aj_() {
        return false;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        this.a(level, this.en().c().eventEntityDamager(lightning), Float.MAX_VALUE);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cA : super.b(pose);
    }

    static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle mob) {
            super(mob);
            this.l = mob;
        }

        private void h() {
            if (this.l.by()) {
                this.l.k(this.l.dN().b(0.0, 0.005, 0.0));
                if (!this.l.cD.a(this.l.dI(), 16.0)) {
                    this.l.C(Math.max(this.l.fM() / 2.0f, 0.08f));
                }
                if (this.l.e_()) {
                    this.l.C(Math.max(this.l.fM() / 3.0f, 0.06f));
                }
            } else if (this.l.aV()) {
                this.l.C(Math.max(this.l.fM() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.h();
            if (this.k == ControllerMove.Operation.b && !this.l.N().l()) {
                double d2;
                double d1;
                double d3 = this.e - this.l.dP();
                double squareRoot = Math.sqrt(d3 * d3 + (d1 = this.f - this.l.dR()) * d1 + (d2 = this.g - this.l.dV()) * d2);
                if (squareRoot < (double)1.0E-5f) {
                    this.d.C(0.0f);
                } else {
                    d1 /= squareRoot;
                    float f2 = (float)(MathHelper.d(d2, d3) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.l.v(this.b(this.l.ec(), f2, 90.0f));
                    this.l.bC = this.l.ec();
                    float f1 = (float)(this.h * this.l.i(GenericAttributes.x));
                    this.l.C(MathHelper.h(0.125f, this.l.fM(), f1));
                    this.l.k(this.l.dN().b(0.0, (double)this.l.fM() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.C(0.0f);
            }
        }
    }

    static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
        }

        @Override
        public boolean b() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockPos = this.a(this.c.ao(), this.c, 7);
            if (blockPos != null) {
                this.e = blockPos.u();
                this.f = blockPos.v();
                this.g = blockPos.w();
                return true;
            }
            return this.i();
        }
    }

    static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
            this.d = turtle;
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.p();
        }

        @Override
        protected void g() {
            EntityFertilizeEggEvent event;
            EntityPlayer loveCause = this.a.ha();
            if (loveCause == null && this.c.ha() != null) {
                loveCause = this.c.ha();
            }
            if ((event = CraftEventFactory.callEntityFertilizeEggEvent(this.a, this.c)).isCancelled()) {
                return;
            }
            if (loveCause != null) {
                loveCause.a(StatisticList.R);
                CriterionTriggers.p.a(loveCause, this.a, this.c, null);
            }
            this.d.x(true);
            this.a.d_(6000);
            this.c.d_(6000);
            this.a.hc();
            this.c.hc();
            RandomSource random = this.a.ep();
            if (net.minecraft.world.entity.animal.turtle.EntityTurtle$a.a(this.b).U().a(GameRules.D).booleanValue() && event.getExperience() > 0) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dI(), Vec3D.c, event.getExperience(), ExperienceOrb.SpawnReason.BREED, loveCause, this.d));
            }
        }
    }

    static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier, 16);
            this.g = turtle;
        }

        @Override
        public boolean b() {
            return this.g.p() && this.g.cD.a(this.g.dI(), 9.0) && super.b();
        }

        @Override
        public boolean c() {
            return super.c() && this.g.p() && this.g.cD.a(this.g.dI(), 9.0);
        }

        @Override
        public void a() {
            super.a();
            BlockPosition blockPos = this.g.dK();
            if (!this.g.by() && this.m()) {
                if (this.g.cC < 1) {
                    this.g.y(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)this.e, this.g.ao())).callEvent());
                } else if (this.g.cC > this.a(200)) {
                    int eggCount = this.g.as.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)this.e.d(), this.g.ao()), eggCount);
                    if (layEggEvent.callEvent() && CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.d(), (IBlockData)Blocks.nb.m().b(BlockTurtleEgg.c, layEggEvent.getEggCount()))) {
                        World level = this.g.ao();
                        level.a(null, blockPos, SoundEffects.DF, SoundCategory.e, 0.3f, 0.9f + level.y.i() * 0.2f);
                        BlockPosition blockPos1 = this.e.d();
                        IBlockData blockState = (IBlockData)Blocks.nb.m().b(BlockTurtleEgg.c, layEggEvent.getEggCount());
                        level.a(blockPos1, blockState, 3);
                        level.a(GameEvent.i, blockPos1, GameEvent.a.a(this.g, blockState));
                    }
                    this.g.x(false);
                    this.g.y(false);
                    this.g.r(600);
                }
                if (this.g.gP()) {
                    ++this.g.cC;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.A(pos.d()) && BlockTurtleEgg.b(level, pos);
        }
    }

    static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speedModifier) {
            super(turtle, turtle.e_() ? 2.0 : speedModifier, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean c() {
            return !this.h.by() && this.d <= 1200 && this.a(this.h.ao(), this.e);
        }

        @Override
        public boolean b() {
            return this.h.e_() && !this.h.by() ? super.b() : !this.h.cF && !this.h.by() && !this.h.p() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.J);
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.e_() && (this.a.p() || this.a.ep().a(net.minecraft.world.entity.animal.turtle.EntityTurtle$b.b(700)) == 0 && !this.a.cD.a(this.a.dI(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.a.cF = true;
            this.c = false;
            this.d = 0;
        }

        @Override
        public void e() {
            this.a.cF = false;
        }

        @Override
        public boolean c() {
            return !this.a.cD.a(this.a.dI(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void a() {
            BlockPosition blockPos = this.a.cD;
            boolean flag = blockPos.a(this.a.dI(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.N().l()) {
                Vec3D vec3 = Vec3D.c(blockPos);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null && !flag && !this.a.ao().a_(BlockPosition.a(posTowards)).a(Blocks.J)) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3, 1.5707963705062866);
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.N().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }
    }

    static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.cF && !this.a.p() && this.a.by();
        }

        @Override
        public void d() {
            int i2 = 512;
            int i1 = 4;
            RandomSource randomSource = this.a.as;
            int i22 = randomSource.a(1025) - 512;
            int i3 = randomSource.a(9) - 4;
            int i4 = randomSource.a(1025) - 512;
            if ((double)i3 + this.a.dR() > (double)(this.a.ao().V() - 1)) {
                i3 = 0;
            }
            this.a.cE = BlockPosition.a((double)i22 + this.a.dP(), (double)i3 + this.a.dR(), (double)i4 + this.a.dV());
            this.c = false;
        }

        @Override
        public void a() {
            if (this.a.cE == null) {
                this.c = true;
            } else if (this.a.N().l()) {
                Vec3D vec3 = Vec3D.c(this.a.cE);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null) {
                    int floor = MathHelper.c(posTowards.g);
                    int floor1 = MathHelper.c(posTowards.i);
                    int i2 = 34;
                    if (!this.a.ao().b(floor - 34, floor1 - 34, floor + 34, floor1 + 34)) {
                        posTowards = null;
                    }
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.N().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }

        @Override
        public boolean c() {
            return !this.a.N().l() && !this.c && !this.a.cF && !this.a.hb() && !this.a.p();
        }

        @Override
        public void e() {
            this.a.cE = null;
            super.e();
        }
    }

    static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speedModifier, int interval) {
            super(turtle, speedModifier, interval);
            this.i = turtle;
        }

        @Override
        public boolean b() {
            return !this.b.by() && !this.i.cF && !this.i.p() && super.b();
        }
    }

    static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle turtle, World level) {
            super(turtle, level);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean a(BlockPosition pos) {
            block3: {
                block2: {
                    EntityInsentient entityInsentient = this.a;
                    if (!(entityInsentient instanceof EntityTurtle)) break block2;
                    EntityTurtle turtle = (EntityTurtle)entityInsentient;
                    if (turtle.cE != null) break block3;
                }
                if (this.b.a_(pos.e()).l()) return false;
                return true;
            }
            boolean bl = this.b.a_(pos).a(Blocks.J);
            return bl;
        }
    }
}

