/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cC = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Long> cD = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Holder<WolfVariant>> cE = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> cF = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.A);
    public static final PathfinderTargetCondition.a cz = (entity, level) -> {
        EntityTypes<?> type = entity.ay();
        return type == EntityTypes.bj || type == EntityTypes.bg || type == EntityTypes.ae;
    };
    private static final float cG = 8.0f;
    private static final float cH = 40.0f;
    private static final float cI = 0.125f;
    public static final float cA = 0.62831855f;
    private static final EnumColor cJ = EnumColor.o;
    private float cK;
    private float cL;
    public boolean cM;
    private boolean cN;
    private float cO;
    private float cP;
    private static final UniformInt cQ = TimeRange.a(20, 39);
    private @Nullable EntityReference<EntityLiving> cR;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, level);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.cs.a(2, new PathfinderGoalSit(this));
        this.cs.a(3, new a<EntityLlama>(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.cs.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cs.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cs.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.cs.a(7, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(10, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.ct.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.ct.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.ct.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ct.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, cz));
        this.ct.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.cv));
        this.ct.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.ct.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey hd() {
        WolfVariant wolfVariant = this.hi().a();
        if (this.p()) {
            return wolfVariant.b().b().b();
        }
        return this.ab_() ? wolfVariant.b().c().b() : wolfVariant.b().a().b();
    }

    public Holder<WolfVariant> hi() {
        return this.az.a(cE);
    }

    public void b(Holder<WolfVariant> variant) {
        this.az.a(cE, variant);
    }

    public Holder<WolfSoundVariant> hj() {
        return this.az.a(cF);
    }

    public void k(Holder<WolfSoundVariant> soundVariant) {
        this.az.a(cF, soundVariant);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.aD) {
            return EntityWolf.c(component, this.hi());
        }
        if (component == DataComponents.aE) {
            return EntityWolf.c(component, this.hj());
        }
        return component == DataComponents.aF ? EntityWolf.c(component, this.hg()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aD);
        this.a(componentGetter, DataComponents.aE);
        this.a(componentGetter, DataComponents.aF);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aD) {
            this.b(EntityWolf.c(DataComponents.aD, value));
            return true;
        }
        if (component == DataComponents.aE) {
            this.k(EntityWolf.c(DataComponents.aE, value));
            return true;
        }
        if (component == DataComponents.aF) {
            this.a(EntityWolf.c(DataComponents.aF, value));
            return true;
        }
        return super.b(component, value);
    }

    public static AttributeProvider.Builder he() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.3f).a(GenericAttributes.u, 8.0).a(GenericAttributes.d, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistry<WolfSoundVariant> registry = this.eo().f(Registries.bC);
        builder.a(cE, VariantUtils.a(this.eo(), WolfVariants.j));
        builder.a(cF, (Holder)registry.a(WolfSoundVariants.a).or(registry::a).orElseThrow());
        builder.a(cB, false);
        builder.a(cC, cJ.a());
        builder.a(cD, -1L);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Gg, 0.15f, 1.0f);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("CollarColor", EnumColor.s, this.hg());
        VariantUtils.a(output, this.hi());
        this.b_(output);
        this.hj().e().ifPresent(resourceKey -> output.a("sound_variant", ResourceKey.a(Registries.bC), resourceKey));
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.bB).ifPresent(this::b);
        this.a(input.a("CollarColor", EnumColor.s).orElse(cJ));
        this.a(this.ao(), input);
        input.a("sound_variant", ResourceKey.a(Registries.bC)).flatMap(resourceKey -> this.eo().f(Registries.bC).a((ResourceKey)resourceKey)).ifPresent(this::k);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData instanceof b) {
            b wolfPackData = (b)spawnGroupData;
            this.b(wolfPackData.a);
        } else {
            Optional optional = VariantUtils.a(SpawnContext.a(level, this.dK()), Registries.bB);
            if (optional.isPresent()) {
                this.b(optional.get());
                spawnGroupData = new b(optional.get());
            }
        }
        this.k(WolfSoundVariants.a(this.eo(), level.G_()));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public SoundEffect W() {
        if (this.ab_()) {
            return this.hj().a().c().a();
        }
        if (this.as.a(3) == 0) {
            return this.p() && this.eZ() < 20.0f ? this.hj().a().f().a() : this.hj().a().e().a();
        }
        return this.hj().a().a().a();
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.i(damageSource) ? SoundEffects.Gd : this.hj().a().d().a();
    }

    @Override
    public SoundEffect fd() {
        return this.hj().a().b().a();
    }

    @Override
    public float fC() {
        return 0.4f;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.ao().B_() && this.cM && !this.cN && !this.gL() && this.aV()) {
            this.cN = true;
            this.cO = 0.0f;
            this.cP = 0.0f;
            this.ao().a((Entity)this, (byte)8);
        }
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.cb()) {
            this.cL = this.cK;
            this.cK = this.hh() ? (this.cK += (1.0f - this.cK) * 0.4f) : (this.cK += (0.0f - this.cK) * 0.4f);
            if (this.bA()) {
                this.cM = true;
                if (this.cN && !this.ao().B_()) {
                    this.ao().a((Entity)this, (byte)56);
                    this.hk();
                }
            } else if ((this.cM || this.cN) && this.cN) {
                if (this.cO == 0.0f) {
                    this.a(SoundEffects.Gf, this.fC(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.u);
                }
                this.cP = this.cO;
                this.cO += 0.05f;
                if (this.cP >= 2.0f) {
                    this.cM = false;
                    this.cN = false;
                    this.cP = 0.0f;
                    this.cO = 0.0f;
                }
                if (this.cO > 0.4f) {
                    float f2 = (float)this.dR();
                    int i2 = (int)(MathHelper.a((double)((this.cO - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3D deltaMovement = this.dN();
                    for (int i1 = 0; i1 < i2; ++i1) {
                        float f1 = (this.as.i() * 2.0f - 1.0f) * this.dF() * 0.5f;
                        float f22 = (this.as.i() * 2.0f - 1.0f) * this.dF() * 0.5f;
                        this.ao().a(Particles.aq, this.dP() + (double)f1, (double)(f2 + 0.8f), this.dV() + (double)f22, deltaMovement.g, deltaMovement.h, deltaMovement.i);
                    }
                }
            }
        }
    }

    private void hk() {
        this.cN = false;
        this.cO = 0.0f;
        this.cP = 0.0f;
    }

    @Override
    public void a(DamageSource damageSource) {
        this.cM = false;
        this.cN = false;
        this.cP = 0.0f;
        this.cO = 0.0f;
        super.a(damageSource);
    }

    public float L(float partialTick) {
        return !this.cM ? 1.0f : Math.min(0.75f + MathHelper.h(partialTick, this.cP, this.cO) / 2.0f * 0.25f, 1.0f);
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.cP, this.cO);
    }

    public float N(float partialTick) {
        return MathHelper.h(partialTick, this.cL, this.cK) * 0.15f * (float)Math.PI;
    }

    @Override
    public int ac() {
        return this.gQ() ? 20 : super.ac();
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.z(false);
        return true;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.i(damageSource)) {
            return super.actuallyHurt(level, damageSource, amount, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack bodyArmorItem = this.ak();
        int damageValue = bodyArmorItem.o();
        int maxDamage = bodyArmorItem.p();
        bodyArmorItem.a(MathHelper.d(amount), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(damageValue, maxDamage) != Crackiness.b.a(this.ak())) {
            this.a(SoundEffects.Gc);
            level.a(new ParticleParamItem(Particles.V, Items.pR.m()), this.dP(), this.dR() + 1.0, this.dV(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return true;
    }

    private boolean i(DamageSource damageSource) {
        return this.ak().a(Items.pS) && !damageSource.a(DamageTypeTags.C);
    }

    @Override
    protected void gP() {
        if (this.p()) {
            this.h(GenericAttributes.u).a(40.0);
            this.x(this.fq());
        } else {
            this.h(GenericAttributes.u).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    protected boolean b_(EntityHuman player) {
        return this.j(player);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block14: {
            ItemStack itemInHand;
            block11: {
                ItemDye dyeItem;
                block13: {
                    block12: {
                        itemInHand = player.b(hand);
                        Item item = itemInHand.h();
                        if (!this.p()) break block11;
                        if (this.j(itemInHand) && this.eZ() < this.fq()) {
                            this.a(player, hand, itemInHand);
                            FoodInfo foodProperties = itemInHand.a(DataComponents.y);
                            float f2 = foodProperties != null ? (float)foodProperties.a() : 1.0f;
                            this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                            return EnumInteractionResult.a;
                        }
                        if (!(item instanceof ItemDye)) break block12;
                        dyeItem = (ItemDye)item;
                        if (this.j(player)) break block13;
                    }
                    if (this.a(itemInHand, EnumItemSlot.g) && !this.am() && this.j(player) && !this.e_()) {
                        this.i(itemInHand.c(1));
                        itemInHand.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    if (this.gQ() && this.am() && this.j(player) && this.ak().n() && this.ak().c(itemInHand)) {
                        itemInHand.h(1);
                        this.a(SoundEffects.Ge);
                        ItemStack bodyArmorItem = this.ak();
                        int i2 = (int)((float)bodyArmorItem.p() * 0.125f);
                        bodyArmorItem.b(Math.max(0, bodyArmorItem.o() - i2));
                        return EnumInteractionResult.a;
                    }
                    EnumInteractionResult interactionResult = super.b(player, hand);
                    if (!interactionResult.a() && this.j(player)) {
                        this.z(!this.gR());
                        this.bM = false;
                        this.cr.n();
                        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
                        return EnumInteractionResult.a.b();
                    }
                    return interactionResult;
                }
                EnumColor dyeColor = dyeItem.a();
                if (dyeColor != this.hg()) {
                    EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)player.getBukkitEntity());
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    dyeColor = EnumColor.a(event.getColor().getWoolData());
                    this.a(dyeColor);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                break block14;
            }
            if (!this.ao().B_() && itemInHand.a(Items.tD) && !this.ab_()) {
                itemInHand.a(1, (EntityLiving)player);
                this.i(player);
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    private void i(EntityHuman player) {
        if (this.as.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.g(player);
            this.cr.n();
            this.g((EntityLiving)null);
            this.z(true);
            this.ao().a((Entity)this, (byte)7);
        } else {
            this.ao().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 8) {
            this.cN = true;
            this.cO = 0.0f;
            this.cP = 0.0f;
        } else if (id == 56) {
            this.hk();
        } else {
            super.b(id);
        }
    }

    public float hf() {
        if (this.ab_()) {
            return 1.5393804f;
        }
        if (this.p()) {
            float maxHealth = this.fq();
            float f2 = (maxHealth - this.eZ()) / maxHealth;
            return (0.55f - f2 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aH);
    }

    @Override
    public int aj() {
        return 8;
    }

    @Override
    public long a() {
        return this.az.a(cD);
    }

    @Override
    public void b(long absoluteTime) {
        this.az.a(cD, absoluteTime);
    }

    @Override
    public void c() {
        this.a(cQ.a(this.as));
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cR;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> target) {
        this.cR = target;
    }

    public EnumColor hg() {
        return EnumColor.a(this.az.a(cC));
    }

    public void a(EnumColor color) {
        this.az.a(cC, color.a());
    }

    public @Nullable EntityWolf b(WorldServer level, EntityAgeable partner) {
        EntityWolf wolf = EntityTypes.bU.a(level, EntitySpawnReason.e);
        if (wolf != null && partner instanceof EntityWolf) {
            EntityWolf wolf1 = (EntityWolf)partner;
            if (this.as.h()) {
                wolf.b(this.hi());
            } else {
                wolf.b(wolf1.hi());
            }
            if (this.p()) {
                wolf.b(this.ae_());
                wolf.a(true, true);
                EnumColor collarColor = this.hg();
                EnumColor collarColor1 = wolf1.hg();
                wolf.a(EnumColor.a(level, collarColor, collarColor1));
            }
            wolf.k(WolfSoundVariants.a(this.eo(), this.as));
        }
        return wolf;
    }

    public void A(boolean isInterested) {
        this.az.a(cB, isInterested);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityWolf wolf;
        return otherAnimal != this && this.p() && otherAnimal instanceof EntityWolf && (wolf = (EntityWolf)otherAnimal).p() && !wolf.gQ() && this.hb() && wolf.hb();
    }

    public boolean hh() {
        return this.az.a(cB);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (target instanceof EntityCreeper) return false;
        if (target instanceof EntityGhast) return false;
        if (target instanceof EntityArmorStand) {
            return false;
        }
        if (target instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)target;
            if (!wolf.p()) return true;
            if (wolf.U_() == owner) return false;
            return true;
        }
        if (target instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)target;
            if (owner instanceof EntityHuman) {
                EntityHuman player1 = (EntityHuman)owner;
                if (!player1.a(player)) return false;
            }
        }
        if (target instanceof EntityHorseAbstract) {
            EntityHorseAbstract abstractHorse = (EntityHorseAbstract)target;
            if (abstractHorse.hn()) return false;
        }
        if (!(target instanceof EntityTameableAnimal)) return true;
        EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)target;
        if (tamableAnimal.p()) return false;
        return true;
    }

    @Override
    public boolean aj_() {
        return !this.ab_();
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cu) && EntityWolf.a(level, pos);
    }

    class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf wolf, Class<T> avoidClass, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
            super(wolf, avoidClass, maxDistance, walkSpeedModifier, sprintSpeedModifier);
            this.j = wolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama && !this.j.p() && this.a((EntityLlama)this.b);
        }

        private boolean a(EntityLlama llama) {
            return llama.gT() >= EntityWolf.this.as.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.g((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> type) {
            super(false);
            this.a = type;
        }
    }
}

