/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cx = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cy = PathfinderTargetCondition.a().a(64.0);
    private static final int cz = 200;
    private static final int cA = 400;
    private static final float cB = 0.25f;
    private static final String cC = "DragonDeathTime";
    private static final String cD = "DragonPhase";
    private static final int cE = 0;
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] cF;
    public final EntityComplexPart c;
    private final EntityComplexPart cG;
    private final EntityComplexPart cH;
    private final EntityComplexPart cI;
    private final EntityComplexPart cJ;
    private final EntityComplexPart cK;
    private final EntityComplexPart cL;
    private final EntityComplexPart cM;
    public float d;
    public float e;
    public boolean f;
    public int cu = 0;
    public float cv;
    public @Nullable EntityEnderCrystal cw;
    private @Nullable EnderDragonBattle cN;
    private BlockPosition cO = BlockPosition.c;
    private final DragonControllerManager cP;
    private int cQ = 100;
    private float cR;
    private final PathPoint[] cU = new PathPoint[24];
    private final int[] cV = new int[24];
    private final Path cW = new Path();
    private final Explosion explosionSource;
    private @Nullable BlockPosition podium;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.T, level);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cG = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cH = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cI = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cJ = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cK = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cL = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cM = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cF = new EntityComplexPart[]{this.c, this.cG, this.cH, this.cI, this.cJ, this.cK, this.cL, this.cM};
        this.x(this.fq());
        this.ar = true;
        this.cP = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(level.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle dragonFight) {
        this.cN = dragonFight;
    }

    public void c(BlockPosition fightOrigin) {
        this.cO = fightOrigin;
    }

    public BlockPosition k() {
        return this.cO;
    }

    public static AttributeProvider.Builder p() {
        return EntityInsentient.E().a(GenericAttributes.u, 200.0).a(GenericAttributes.j, 16.0);
    }

    public BlockPosition getPodium() {
        if (this.podium == null) {
            return WorldGenEndTrophy.a(this.k());
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPosition blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean bp() {
        float cos = MathHelper.b((double)(this.e * ((float)Math.PI * 2)));
        float cos1 = MathHelper.b((double)(this.d * ((float)Math.PI * 2)));
        return cos1 <= -0.3f && cos >= -0.3f;
    }

    @Override
    public void bo() {
        if (this.ao().B_() && !this.bq()) {
            this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.jL, this.dB(), 5.0f, 0.8f + this.as.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, DragonControllerPhase.k.b());
    }

    @Override
    public void d_() {
        WorldServer serverLevel;
        EnderDragonBattle dragonFight;
        World world;
        this.bd();
        if (this.ao().B_()) {
            this.x(this.eZ());
            if (!this.bq() && !this.cP.a().a() && --this.cQ < 0) {
                this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.jM, this.dB(), 2.5f, 0.8f + this.as.i() * 0.3f, false);
                this.cQ = 200 + this.as.a(200);
            }
        }
        if (this.cN == null && (world = this.ao()) instanceof WorldServer && (dragonFight = (serverLevel = (WorldServer)world).K()) != null && this.cY().equals(dragonFight.i())) {
            this.cN = dragonFight;
        }
        this.d = this.e;
        if (this.fa()) {
            float f2 = (this.as.i() - 0.5f) * 8.0f;
            float f1 = (this.as.i() - 0.5f) * 4.0f;
            float f22 = (this.as.i() - 0.5f) * 8.0f;
            this.ao().a(Particles.x, this.dP() + (double)f2, this.dR() + 2.0 + (double)f1, this.dV() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gQ();
            Vec3D deltaMovement = this.dN();
            float f1 = 0.2f / ((float)deltaMovement.i() * 10.0f + 1.0f);
            this.e = this.cP.a().a() ? (this.e += 0.1f) : (this.f ? (this.e += f1 * 0.5f) : (this.e += (f1 *= (float)Math.pow(2.0, deltaMovement.h))));
            this.v(MathHelper.f(this.ec()));
            if (this.gG()) {
                this.e = 0.5f;
            } else {
                float f4;
                float f3;
                this.b.a(this.dR(), this.ec());
                World world2 = this.ao();
                if (world2 instanceof WorldServer) {
                    Vec3D flyTargetLocation;
                    WorldServer serverLevel1 = (WorldServer)world2;
                    IDragonController currentPhase = this.cP.a();
                    currentPhase.a(serverLevel1);
                    if (this.cP.a() != currentPhase) {
                        currentPhase = this.cP.a();
                        currentPhase.a(serverLevel1);
                    }
                    if ((flyTargetLocation = currentPhase.f()) != null && currentPhase.h() != DragonControllerPhase.k) {
                        double d2 = flyTargetLocation.g - this.dP();
                        double d1 = flyTargetLocation.h - this.dR();
                        double d22 = flyTargetLocation.i - this.dV();
                        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
                        float flySpeed = currentPhase.e();
                        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
                        if (squareRoot > 0.0) {
                            d1 = MathHelper.a(d1 / squareRoot, (double)(-flySpeed), (double)flySpeed);
                        }
                        this.k(this.dN().b(0.0, d1 * 0.01, 0.0));
                        this.v(MathHelper.f(this.ec()));
                        Vec3D vec3 = flyTargetLocation.a(this.dP(), this.dR(), this.dV()).d();
                        Vec3D vec31 = new Vec3D(MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), this.dN().h, -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)))).d();
                        float max = Math.max(((float)vec31.b(vec3) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d2) > (double)1.0E-5f || Math.abs(d22) > (double)1.0E-5f) {
                            f3 = MathHelper.a(MathHelper.f(180.0f - (float)MathHelper.d(d2, d22) * 57.295776f - this.ec()), -50.0f, 50.0f);
                            this.cv *= 0.8f;
                            this.cv += f3 * currentPhase.g();
                            this.v(this.ec() + this.cv * 0.1f);
                        }
                        f3 = (float)(2.0 / (d3 + 1.0));
                        f4 = 0.06f;
                        this.a(0.06f * (max * f3 + (1.0f - f3)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.f) {
                            this.a(EnumMoveType.a, this.dN().c((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dN());
                        }
                        Vec3D vec32 = this.dN().d();
                        double d4 = 0.8 + 0.15 * (vec32.b(vec31) + 1.0) / 2.0;
                        this.k(this.dN().d(d4, 0.91f, d4));
                    }
                } else {
                    this.bQ.e();
                    this.cP.a().b();
                }
                if (!this.ao().B_()) {
                    this.aW();
                }
                this.bC = this.ec();
                Vec3D[] vec3s = new Vec3D[this.cF.length];
                for (int i2 = 0; i2 < this.cF.length; ++i2) {
                    vec3s[i2] = new Vec3D(this.cF[i2].dP(), this.cF[i2].dR(), this.cF[i2].dV());
                }
                float f5 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * ((float)Math.PI / 180);
                float cos = MathHelper.b((double)f5);
                float sin = MathHelper.a((double)f5);
                float f6 = this.ec() * ((float)Math.PI / 180);
                float sin1 = MathHelper.a((double)f6);
                float cos1 = MathHelper.b((double)f6);
                this.a(this.cH, (double)(sin1 * 0.5f), 0.0, (double)(-cos1 * 0.5f));
                this.a(this.cL, (double)(cos1 * 4.5f), 2.0, (double)(sin1 * 4.5f));
                this.a(this.cM, (double)(cos1 * -4.5f), 2.0, (double)(sin1 * -4.5f));
                World world3 = this.ao();
                if (world3 instanceof WorldServer) {
                    WorldServer serverLevel2 = (WorldServer)world3;
                    if (this.bu == 0) {
                        this.a(serverLevel2, serverLevel2.a((Entity)this, this.cL.dj().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(serverLevel2, serverLevel2.a((Entity)this, this.cM.dj().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(serverLevel2, serverLevel2.a((Entity)this, this.c.dj().g(1.0), IEntitySelector.e));
                        this.b(serverLevel2, serverLevel2.a((Entity)this, this.cG.dj().g(1.0), IEntitySelector.e));
                    }
                }
                float sin2 = MathHelper.a((double)(this.ec() * ((float)Math.PI / 180) - this.cv * 0.01f));
                float cos2 = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180) - this.cv * 0.01f));
                float headYOffset = this.gP();
                this.a(this.c, (double)(sin2 * 6.5f * cos), (double)(headYOffset + sin * 6.5f), (double)(-cos2 * 6.5f * cos));
                this.a(this.cG, (double)(sin2 * 5.5f * cos), (double)(headYOffset + sin * 5.5f), (double)(-cos2 * 5.5f * cos));
                DragonFlightHistory.a sample = this.b.a(5);
                for (int i1 = 0; i1 < 3; ++i1) {
                    EntityComplexPart enderDragonPart = null;
                    if (i1 == 0) {
                        enderDragonPart = this.cI;
                    }
                    if (i1 == 1) {
                        enderDragonPart = this.cJ;
                    }
                    if (i1 == 2) {
                        enderDragonPart = this.cK;
                    }
                    DragonFlightHistory.a sample1 = this.b.a(12 + i1 * 2);
                    float f7 = this.ec() * ((float)Math.PI / 180) + this.k((double)(sample1.b() - sample.b())) * ((float)Math.PI / 180);
                    float sin3 = MathHelper.a((double)f7);
                    float maxx = MathHelper.b((double)f7);
                    f3 = 1.5f;
                    f4 = (float)(i1 + 1) * 2.0f;
                    this.a(enderDragonPart, (double)(-(sin1 * 1.5f + sin3 * f4) * cos), sample1.a() - sample.a() - (double)((f4 + 1.5f) * sin) + 1.5, (double)((cos1 * 1.5f + maxx * f4) * cos));
                }
                World world4 = this.ao();
                if (world4 instanceof WorldServer) {
                    WorldServer serverLevel3 = (WorldServer)world4;
                    this.f = this.a(serverLevel3, this.c.dj()) | this.a(serverLevel3, this.cG.dj()) | this.a(serverLevel3, this.cH.dj());
                    if (this.cN != null) {
                        this.cN.b(this);
                    }
                }
                for (int i1 = 0; i1 < this.cF.length; ++i1) {
                    this.cF[i1].Y = vec3s[i1].g;
                    this.cF[i1].Z = vec3s[i1].h;
                    this.cF[i1].aa = vec3s[i1].i;
                    this.cF[i1].ao = vec3s[i1].g;
                    this.cF[i1].ap = vec3s[i1].h;
                    this.cF[i1].aq = vec3s[i1].i;
                }
            }
        }
    }

    private void a(EntityComplexPart part, double offsetX, double offsetY, double offsetZ) {
        part.a_(this.dP() + offsetX, this.dR() + offsetY, this.dV() + offsetZ);
    }

    private float gP() {
        if (this.cP.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a sample = this.b.a(5);
        DragonFlightHistory.a sample1 = this.b.a(0);
        return (float)(sample.a() - sample1.a());
    }

    private void gQ() {
        if (this.cw != null) {
            EntityRegainHealthEvent event;
            if (this.cw.eh()) {
                this.cw = null;
            } else if (this.at % 10 == 0 && this.eZ() < this.fq() && (event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL)).callEvent()) {
                this.x((float)((double)this.eZ() + event.getAmount()));
            }
        }
        if (this.as.a(10) == 0) {
            List<EntityEnderCrystal> entitiesOfClass = this.ao().a(EntityEnderCrystal.class, this.dj().g(32.0));
            EntityEnderCrystal endCrystal = null;
            double d2 = Double.MAX_VALUE;
            for (EntityEnderCrystal endCrystal1 : entitiesOfClass) {
                double d1 = endCrystal1.g(this);
                if (!(d1 < d2)) continue;
                d2 = d1;
                endCrystal = endCrystal1;
            }
            this.cw = endCrystal;
        }
    }

    private void a(WorldServer level, List<Entity> targets) {
        double d2 = (this.cH.dj().a + this.cH.dj().d) / 2.0;
        double d1 = (this.cH.dj().c + this.cH.dj().f) / 2.0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving livingEntity = (EntityLiving)entity;
            double d22 = entity.dP() - d2;
            double d3 = entity.dV() - d1;
            double max = Math.max(d22 * d22 + d3 * d3, 0.1);
            entity.push(d22 / max * 4.0, 0.2f, d3 / max * 4.0, this);
            if (this.cP.a().a() || livingEntity.eM() >= entity.at - 2) continue;
            DamageSource damageSource = this.en().b(this);
            entity.a(level, damageSource, 5.0f);
            EnchantmentManager.a(level, entity, damageSource);
        }
    }

    private void b(WorldServer level, List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damageSource = this.en().b(this);
            entity.a(level, damageSource, 10.0f);
            EnchantmentManager.a(level, entity, damageSource);
        }
    }

    private float k(double angle) {
        return (float)MathHelper.g(angle);
    }

    private boolean a(WorldServer level, AxisAlignedBB box) {
        int floor = MathHelper.c(box.a);
        int floor1 = MathHelper.c(box.b);
        int floor2 = MathHelper.c(box.c);
        int floor3 = MathHelper.c(box.d);
        int floor4 = MathHelper.c(box.e);
        int floor5 = MathHelper.c(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int i2 = floor; i2 <= floor3; ++i2) {
            for (int i1 = floor1; i1 <= floor4; ++i1) {
                for (int i22 = floor2; i22 <= floor5; ++i22) {
                    BlockPosition blockPos = new BlockPosition(i2, i1, i22);
                    IBlockData blockState = level.a_(blockPos);
                    if (blockState.l() || blockState.a(TagsBlock.aR)) continue;
                    if (level.U().a(GameRules.F).booleanValue() && !blockState.a(TagsBlock.aQ)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(level, blockPos));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.ao().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                CraftBlock tntBlock;
                Material blockType = block.getType();
                if (blockType.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition pos = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity blockEntity = craftBlock.getNMS().x() ? this.ao().c_(pos) : null;
                    LootParams.a builder = new LootParams.a((WorldServer)this.ao()).a(LootContextParameters.h, Vec3D.b(pos)).a(LootContextParameters.k, ItemStack.l).a(LootContextParameters.l, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.j, blockEntity);
                    craftBlock.getNMS().a(builder).forEach(stack -> Block.a(this.ao(), pos, stack));
                    craftBlock.getNMS().a((WorldServer)this.ao(), pos, ItemStack.l, false);
                }
                if (!new TNTPrimeEvent((org.bukkit.block.Block)(tntBlock = CraftBlock.at(this.ao(), pos)), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.c().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a((WorldServer)this.ao(), pos, this.explosionSource);
                this.ao().a(pos, false);
            }
        }
        if (flag1) {
            BlockPosition blockPos1 = new BlockPosition(floor + this.as.a(floor3 - floor + 1), floor1 + this.as.a(floor4 - floor1 + 1), floor2 + this.as.a(floor5 - floor2 + 1));
            level.c(2008, blockPos1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer level, EntityComplexPart part, DamageSource damageSource, float amount) {
        if (this.cP.a().h() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cP.a().a(damageSource, amount);
        if (part != this.c) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (damageSource.d() instanceof EntityHuman || damageSource.a(DamageTypeTags.y)) {
            float health = this.eZ();
            this.d(level, damageSource, amount);
            if (this.fa() && !this.cP.a().a()) {
                this.x(1.0f);
                this.cP.a(DragonControllerPhase.j);
            }
            if (this.cP.a().a()) {
                this.cR = this.cR + health - this.eZ();
                if (this.cR > 0.25f * this.fq()) {
                    this.cR = 0.0f;
                    this.cP.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return this.a(level, this.cH, damageSource, amount);
    }

    protected void d(WorldServer level, DamageSource damageSource, float amount) {
        super.a(level, damageSource, amount);
    }

    @Override
    public void c(WorldServer level) {
        this.silentDeath = true;
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.en().y());
        if (deathEvent.isCancelled()) {
            this.silentDeath = false;
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
        if (this.cN != null) {
            this.cN.b(this);
            this.cN.a(this);
        }
    }

    @Override
    protected void eH() {
        World world;
        if (this.cN != null) {
            this.cN.b(this);
        }
        ++this.cu;
        if (this.cu >= 180 && this.cu <= 200) {
            float f2 = (this.as.i() - 0.5f) * 8.0f;
            float f1 = (this.as.i() - 0.5f) * 4.0f;
            float f22 = (this.as.i() - 0.5f) * 8.0f;
            this.ao().a(Particles.w, this.dP() + (double)f2, this.dR() + 2.0 + (double)f1, this.dV() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i2 = this.expToDrop;
        World f22 = this.ao();
        if (f22 instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)f22;
            if (this.cu > 150 && this.cu % 5 == 0) {
                EntityExperienceOrb.awardWithDirection(serverLevel, this.dI(), Vec3D.c, MathHelper.b((float)i2 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, EntityReference.a(this.bH, this.ao(), EntityHuman.class), this);
            }
            if (this.cu == 1 && !this.bq()) {
                int viewDistance = serverLevel.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : serverLevel.getPlayersForGlobalSoundGamerule()) {
                    double deltaX = this.dP() - player.dP();
                    double deltaZ = this.dV() - player.dV();
                    double distanceSquared = MathHelper.n(deltaX) + MathHelper.n(deltaZ);
                    double soundRadiusSquared = serverLevel.getGlobalSoundRangeSquared(config -> config.dragonDeathSoundRadius);
                    if (!serverLevel.U().a(GameRules.q).booleanValue() && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)MathHelper.i(viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dP() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dV() + deltaZ / deltaLength * (double)viewDistance;
                        player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dR(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dP(), (int)this.dR(), (int)this.dV()), 0, true));
                }
            }
        }
        Vec3D vec3 = new Vec3D(0.0, 0.1f, 0.0);
        this.a(EnumMoveType.a, vec3);
        for (EntityComplexPart enderDragonPart : this.cF) {
            enderDragonPart.bP();
            enderDragonPart.b(enderDragonPart.dI().e(vec3));
        }
        if (this.cu == 200 && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel1 = (WorldServer)world;
            EntityExperienceOrb.awardWithDirection(serverLevel1, this.dI(), Vec3D.c, MathHelper.b((float)i2 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, EntityReference.a(this.bH, this.ao(), EntityHuman.class), this);
            if (this.cN != null) {
                this.cN.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            this.c(GameEvent.p);
        }
    }

    public int gL() {
        if (this.cU[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int floor1;
                int floor;
                int i1 = 5;
                if (i2 < 12) {
                    floor = MathHelper.b(60.0f * MathHelper.b((double)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2))));
                    floor1 = MathHelper.b(60.0f * MathHelper.a((double)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2))));
                } else if (i2 < 20) {
                    int i22 = i2 - 12;
                    floor = MathHelper.b(40.0f * MathHelper.b((double)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i22))));
                    floor1 = MathHelper.b(40.0f * MathHelper.a((double)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i22))));
                    i1 += 10;
                } else {
                    int var7 = i2 - 20;
                    floor = MathHelper.b(20.0f * MathHelper.b((double)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var7))));
                    floor1 = MathHelper.b(20.0f * MathHelper.a((double)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var7))));
                }
                int max = Math.max(73, this.ao().a(HeightMap.Type.f, new BlockPosition(floor, 0, floor1)).v() + i1);
                this.cU[i2] = new PathPoint(floor, max, floor1);
            }
            this.cV[0] = 6146;
            this.cV[1] = 8197;
            this.cV[2] = 8202;
            this.cV[3] = 16404;
            this.cV[4] = 32808;
            this.cV[5] = 32848;
            this.cV[6] = 65696;
            this.cV[7] = 131392;
            this.cV[8] = 131712;
            this.cV[9] = 263424;
            this.cV[10] = 526848;
            this.cV[11] = 525313;
            this.cV[12] = 1581057;
            this.cV[13] = 3166214;
            this.cV[14] = 2138120;
            this.cV[15] = 6373424;
            this.cV[16] = 4358208;
            this.cV[17] = 12910976;
            this.cV[18] = 9044480;
            this.cV[19] = 9706496;
            this.cV[20] = 15216640;
            this.cV[21] = 0xD0E000;
            this.cV[22] = 11763712;
            this.cV[23] = 0x7E0000;
        }
        return this.p(this.dP(), this.dR(), this.dV());
    }

    public int p(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint node = new PathPoint(MathHelper.c(x2), MathHelper.c(y2), MathHelper.c(z2));
        int i1 = 0;
        if (this.cN == null || this.cN.e() == 0) {
            i1 = 12;
        }
        for (int i22 = i1; i22 < 24; ++i22) {
            float f1;
            if (this.cU[i22] == null || !((f1 = this.cU[i22].c(node)) < f2)) continue;
            f2 = f1;
            i2 = i22;
        }
        return i2;
    }

    public @Nullable PathEntity a(int startIndex, int finishIndex, @Nullable PathPoint andThen) {
        PathPoint node;
        for (int i2 = 0; i2 < 24; ++i2) {
            node = this.cU[i2];
            node.i = false;
            node.g = 0.0f;
            node.e = 0.0f;
            node.f = 0.0f;
            node.h = null;
            node.d = -1;
        }
        PathPoint node1 = this.cU[startIndex];
        node = this.cU[finishIndex];
        node1.e = 0.0f;
        node1.g = node1.f = node1.a(node);
        this.cW.a();
        this.cW.a(node1);
        PathPoint node2 = node1;
        int i1 = 0;
        if (this.cN == null || this.cN.e() == 0) {
            i1 = 12;
        }
        while (!this.cW.e()) {
            PathPoint node3 = this.cW.c();
            if (node3.equals(node)) {
                if (andThen != null) {
                    andThen.h = node;
                    node = andThen;
                }
                return this.a(node1, node);
            }
            if (node3.a(node) < node2.a(node)) {
                node2 = node3;
            }
            node3.i = true;
            int i2 = 0;
            for (int i3 = 0; i3 < 24; ++i3) {
                if (this.cU[i3] != node3) continue;
                i2 = i3;
                break;
            }
            for (int i3x = i1; i3x < 24; ++i3x) {
                if ((this.cV[i2] & 1 << i3x) <= 0) continue;
                PathPoint node4 = this.cU[i3x];
                if (node4.i) continue;
                float f2 = node3.e + node3.a(node4);
                if (node4.c() && !(f2 < node4.e)) continue;
                node4.h = node3;
                node4.e = f2;
                node4.f = node4.a(node);
                if (node4.c()) {
                    this.cW.a(node4, node4.e + node4.f);
                    continue;
                }
                node4.g = node4.e + node4.f;
                this.cW.a(node4);
            }
        }
        if (node2 == node1) {
            return null;
        }
        cx.debug("Failed to find path from {} to {}", (Object)startIndex, (Object)finishIndex);
        if (andThen != null) {
            andThen.h = node2;
            node2 = andThen;
        }
        return this.a(node1, node2);
    }

    private PathEntity a(PathPoint start, PathPoint finish) {
        ArrayList list = Lists.newArrayList();
        PathPoint node = finish;
        list.add(0, finish);
        while (node.h != null) {
            node = node.h;
            list.add(0, node);
        }
        return new PathEntity(list, new BlockPosition(finish.a, finish.b, finish.c), true);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(cD, this.cP.a().h().b());
        output.a(cC, this.cu);
        output.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        input.e(cD).ifPresent(integer -> this.cP.a(DragonControllerPhase.a(integer)));
        this.cu = input.a(cC, 0);
        this.expToDrop = input.a("Bukkit.expToDrop", 0);
    }

    @Override
    public void dW() {
    }

    public EntityComplexPart[] gM() {
        return this.cF;
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.jI;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.jN;
    }

    @Override
    public float fC() {
        return 5.0f;
    }

    public Vec3D L(float partialTick) {
        Vec3D viewVector;
        IDragonController currentPhase = this.cP.a();
        DragonControllerPhase<? extends IDragonController> phase = currentPhase.h();
        if (phase == DragonControllerPhase.d || phase == DragonControllerPhase.e) {
            BlockPosition heightmapPos = this.ao().a(HeightMap.Type.f, this.getPodium());
            float max = Math.max((float)Math.sqrt(heightmapPos.b(this.dI())) / 4.0f, 1.0f);
            float f2 = 6.0f / max;
            float xRot = this.ee();
            float f1 = 1.5f;
            this.w(-f2 * 1.5f * 5.0f);
            viewVector = this.h(partialTick);
            this.w(xRot);
        } else if (currentPhase.a()) {
            float xRot1 = this.ee();
            float max = 1.5f;
            this.w(-45.0f);
            viewVector = this.h(partialTick);
            this.w(xRot1);
        } else {
            viewVector = this.h(partialTick);
        }
        return viewVector;
    }

    public void a(WorldServer level, EntityEnderCrystal crystal, BlockPosition pos, DamageSource damageSource) {
        EntityHuman player;
        Entity entity = damageSource.d();
        EntityHuman player1 = entity instanceof EntityHuman ? (player = (EntityHuman)entity) : level.a(cy, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (crystal == this.cw) {
            this.a(level, this.c, this.en().d(crystal, player1), 10.0f);
        }
        this.cP.a().a(crystal, pos, damageSource, player1);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key) && this.ao().B_()) {
            this.cP.a(DragonControllerPhase.a(this.aD().a(a)));
        }
        super.a(key);
    }

    public DragonControllerManager gN() {
        return this.cP;
    }

    public @Nullable EnderDragonBattle gO() {
        return this.cN;
    }

    @Override
    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        EntityComplexPart[] subEntities = this.gM();
        for (int i2 = 0; i2 < subEntities.length; ++i2) {
            subEntities[i2].e(i2 + packet.b() + 1);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.eS();
    }

    @Override
    protected float c(float scale) {
        return 1.0f;
    }

    @Override
    public int getExpReward(WorldServer level, Entity entity) {
        boolean flag = level.U().a(GameRules.D);
        int i2 = 500;
        if (this.cN != null && !this.cN.f()) {
            i2 = 12000;
        }
        return flag ? i2 : 0;
    }
}

