/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jspecify.annotations.Nullable;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> d = ImmutableList.of(a, b, c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int f = 220;
    private static final int cv = 0;
    private final float[] cw = new float[2];
    private final float[] cx = new float[2];
    private final float[] cy = new float[2];
    private final float[] cz = new float[2];
    private final int[] cA = new int[2];
    private final int[] cB = new int[2];
    private int cC;
    private boolean canPortal = false;
    public final BossBattleServer cD = (BossBattleServer)new BossBattleServer(this.R_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final PathfinderTargetCondition.a cE = (entity, level) -> !entity.ay().a(TagsEntity.z) && entity.gm();
    private static final PathfinderTargetCondition cF = PathfinderTargetCondition.a().a(20.0).a(cE);

    public EntityWither(EntityTypes<? extends EntityWither> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cp = new ControllerMoveFlying(this, 10, false);
        this.x(this.fq());
        this.cn = 50;
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.e(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    protected void D() {
        this.cs.a(0, new a());
        this.cs.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.cs.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cE));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, 0);
        builder.a(b, 0);
        builder.a(c, 0);
        builder.a(e, 0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Invul", this.gR());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("Invul", 0));
        if (this.i_()) {
            this.cD.a(this.R_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.cD.a(this.R_());
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.FR;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.FU;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.FT;
    }

    @Override
    public void d_() {
        int i2;
        Entity entity;
        Vec3D vec3 = this.dN().d(1.0, 0.6, 1.0);
        if (!this.ao().B_() && this.b(0) > 0 && (entity = this.ao().a(this.b(0))) != null) {
            double d2 = vec3.h;
            if (this.dR() < entity.dR() || !this.gS() && this.dR() < entity.dR() + 5.0) {
                d2 = Math.max(0.0, d2);
                d2 += 0.3 - d2 * (double)0.6f;
            }
            vec3 = new Vec3D(vec3.g, d2, vec3.i);
            Vec3D vec31 = new Vec3D(entity.dP() - this.dP(), 0.0, entity.dV() - this.dV());
            if (vec31.j() > 9.0) {
                Vec3D vec32 = vec31.d();
                vec3 = vec3.b(vec32.g * 0.3 - vec3.g * 0.6, 0.0, vec32.i * 0.3 - vec3.i * 0.6);
            }
        }
        this.k(vec3);
        if (vec3.j() > 0.05) {
            this.v((float)MathHelper.d(vec3.i, vec3.g) * 57.295776f - 90.0f);
        }
        super.d_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.cz[i2] = this.cx[i2];
            this.cy[i2] = this.cw[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int alternativeTarget = this.b(i2 + 1);
            Entity entity1 = null;
            if (alternativeTarget > 0) {
                entity1 = this.ao().a(alternativeTarget);
            }
            if (entity1 != null) {
                double headX = this.d(i2 + 1);
                double headY = this.r(i2 + 1);
                double headZ = this.s(i2 + 1);
                double d1 = entity1.dP() - headX;
                double d2 = entity1.dT() - headY;
                double d3 = entity1.dV() - headZ;
                double squareRoot = Math.sqrt(d1 * d1 + d3 * d3);
                float f2 = (float)(MathHelper.d(d3, d1) * 180.0 / 3.1415927410125732) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
                this.cw[i2] = this.a(this.cw[i2], f1, 40.0f);
                this.cx[i2] = this.a(this.cx[i2], f2, 10.0f);
                continue;
            }
            this.cx[i2] = this.a(this.cx[i2], this.bC, 10.0f);
        }
        boolean isPowered = this.gS();
        for (int alternativeTargetx = 0; alternativeTargetx < 3; ++alternativeTargetx) {
            double headX1 = this.d(alternativeTargetx);
            double headY1 = this.r(alternativeTargetx);
            double headZ1 = this.s(alternativeTargetx);
            float f2 = 0.3f * this.eF();
            this.ao().a(Particles.ai, headX1 + this.as.k() * (double)f2, headY1 + this.as.k() * (double)f2, headZ1 + this.as.k() * (double)f2, 0.0, 0.0, 0.0);
            if (!isPowered || this.ao().y.a(4) != 0) continue;
            this.ao().a(ColorParticleOption.a(Particles.v, 0.7f, 0.7f, 0.5f), headX1 + this.as.k() * (double)f2, headY1 + this.as.k() * (double)f2, headZ1 + this.as.k() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.gR() > 0) {
            float f3 = 3.3f * this.eF();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.ao().a(ColorParticleOption.a(Particles.v, 0.7f, 0.7f, 0.9f), this.dP() + this.as.k(), this.dR() + (double)(this.as.i() * f3), this.dV() + this.as.k(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        if (this.gR() > 0) {
            int i2 = this.gR() - 1;
            this.cD.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    level.a((Entity)this, this.dP(), this.dT(), this.dV(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.bq()) {
                    int viewDistance = level.getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : level.getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.dP() - player.dP();
                        double deltaZ = this.dV() - player.dV();
                        double distanceSquared = MathHelper.n(deltaX) + MathHelper.n(deltaZ);
                        double soundRadiusSquared = level.getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!level.U().a(GameRules.q).booleanValue() && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)MathHelper.i(viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dP() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dV() + deltaZ / deltaLength * (double)viewDistance;
                            player.g.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dR(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.g.b(new PacketPlayOutWorldEvent(1023, this.dK(), 0, true));
                    }
                }
            }
            this.a(i2);
            if (this.at % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int alternativeTarget;
            super.a(level);
            for (int ix = 1; ix < 3; ++ix) {
                EntityLiving livingEntity1;
                if (this.at < this.cA[ix - 1]) continue;
                this.cA[ix - 1] = this.at + 10 + this.as.a(10);
                if (level.av() == EnumDifficulty.c || level.av() == EnumDifficulty.d) {
                    int n2 = ix - 1;
                    int n3 = this.cB[n2];
                    this.cB[n2] = n3 + 1;
                    if (n3 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double randomDouble = MathHelper.a(this.as, this.dP() - 10.0, this.dP() + 10.0);
                        double randomDouble1 = MathHelper.a(this.as, this.dR() - 5.0, this.dR() + 5.0);
                        double randomDouble2 = MathHelper.a(this.as, this.dV() - 10.0, this.dV() + 10.0);
                        this.a(ix + 1, randomDouble, randomDouble1, randomDouble2, true);
                        this.cB[ix - 1] = 0;
                    }
                }
                if ((alternativeTarget = this.b(ix)) > 0) {
                    EntityLiving livingEntity = (EntityLiving)level.a(alternativeTarget);
                    if (livingEntity != null && this.c(livingEntity) && !(this.g((Entity)livingEntity) > 900.0) && this.G(livingEntity)) {
                        this.a(ix + 1, livingEntity);
                        this.cA[ix - 1] = this.at + 40 + this.as.a(20);
                        this.cB[ix - 1] = 0;
                        continue;
                    }
                    this.a(ix, 0);
                    continue;
                }
                List<EntityLiving> nearbyEntities = level.a(EntityLiving.class, cF, this, this.dj().c(20.0, 8.0, 20.0));
                if (nearbyEntities.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, livingEntity1 = nearbyEntities.get(this.as.a(nearbyEntities.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(ix, livingEntity1.aA());
            }
            if (this.ag_() != null) {
                this.a(0, this.ag_().aA());
            } else {
                this.a(0, 0);
            }
            if (this.cC > 0) {
                --this.cC;
                if (this.cC == 0 && level.U().a(GameRules.F).booleanValue()) {
                    boolean flag = false;
                    alternativeTarget = MathHelper.b(this.dF() / 2.0f + 1.0f);
                    int floor = MathHelper.b(this.dG());
                    for (BlockPosition blockPos : BlockPosition.b(this.dO() - alternativeTarget, this.dQ(), this.dU() - alternativeTarget, this.dO() + alternativeTarget, this.dQ() + floor, this.dU() + alternativeTarget)) {
                        IBlockData blockState = level.a_(blockPos);
                        if (!EntityWither.c(blockState) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.y().g())) continue;
                        flag = level.a(blockPos, true, this) || flag;
                    }
                    if (flag) {
                        level.a(null, 1022, this.dK(), 0);
                    }
                }
            }
            if (this.at % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cD.a(this.eZ() / this.fq());
        }
    }

    public static boolean c(IBlockData state) {
        return !state.l() && !state.a(TagsBlock.aS);
    }

    public void k() {
        this.a(220);
        this.cD.a(0.0f);
        this.x(this.fq() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.cD.a(player);
    }

    @Override
    public void e(EntityPlayer player) {
        super.e(player);
        this.cD.b(player);
    }

    private double d(int head) {
        if (head <= 0) {
            return this.dP();
        }
        float f2 = (this.bC + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float cos = MathHelper.b((double)f2);
        return this.dP() + (double)cos * 1.3 * (double)this.eF();
    }

    private double r(int head) {
        float f2 = head <= 0 ? 3.0f : 2.2f;
        return this.dR() + (double)(f2 * this.eF());
    }

    private double s(int head) {
        if (head <= 0) {
            return this.dV();
        }
        float f2 = (this.bC + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float sin = MathHelper.a((double)f2);
        return this.dV() + (double)sin * 1.3 * (double)this.eF();
    }

    private float a(float angle, float targetAngle, float max) {
        float f2 = MathHelper.f(targetAngle - angle);
        if (f2 > max) {
            f2 = max;
        }
        if (f2 < -max) {
            f2 = -max;
        }
        return angle + f2;
    }

    private void a(int head, EntityLiving target) {
        this.a(head, target.dP(), target.dR() + (double)target.dk() * 0.5, target.dV(), head == 0 && this.as.i() < 0.001f);
    }

    private void a(int head, double x2, double y2, double z2, boolean isDangerous) {
        if (!this.bq()) {
            this.ao().a(null, 1024, this.dK(), 0);
        }
        double headX = this.d(head);
        double headY = this.r(head);
        double headZ = this.s(head);
        double d2 = x2 - headX;
        double d1 = y2 - headY;
        double d22 = z2 - headZ;
        Vec3D vec3 = new Vec3D(d2, d1, d22);
        EntityWitherSkull witherSkull = new EntityWitherSkull(this.ao(), this, vec3.d());
        witherSkull.d(this);
        if (isDangerous) {
            witherSkull.b(true);
        }
        witherSkull.a_(headX, headY, headZ);
        this.ao().b(witherSkull);
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.a(0, target);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.t) || damageSource.d() instanceof EntityWither) {
            return false;
        }
        if (this.gR() > 0 && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        if (this.gS() && ((directEntity = damageSource.c()) instanceof EntityArrow || directEntity instanceof WindCharge)) {
            return false;
        }
        directEntity = damageSource.d();
        if (directEntity != null && directEntity.ay().a(TagsEntity.z)) {
            return false;
        }
        if (this.cC <= 0) {
            this.cC = 20;
        }
        for (int i2 = 0; i2 < this.cB.length; ++i2) {
            this.cB[i2] = this.cB[i2] + 3;
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        EntityItem itemEntity = this.spawnAtLocation(level, new ItemStack(Items.wE), Vec3D.c, EntityItem::r);
        if (itemEntity != null) {
            itemEntity.r();
        }
    }

    @Override
    public void dW() {
        if (this.ao().av() == EnumDifficulty.a && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bK = 0;
        }
    }

    @Override
    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return false;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gW().a(GenericAttributes.u, 300.0).a(GenericAttributes.x, 0.6f).a(GenericAttributes.n, 0.6f).a(GenericAttributes.o, 40.0).a(GenericAttributes.b, 4.0);
    }

    public float[] gP() {
        return this.cx;
    }

    public float[] gQ() {
        return this.cw;
    }

    public int gR() {
        return this.az.a(e);
    }

    public void a(int invulnerableTicks) {
        this.az.a(e, invulnerableTicks);
    }

    public int b(int head) {
        return this.az.a(d.get(head));
    }

    public void a(int targetOffset, int newId) {
        this.az.a(d.get(targetOffset), newId);
    }

    public boolean gS() {
        return this.eZ() <= this.fq() / 2.0f;
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return this.canPortal;
    }

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    @Override
    public boolean b(MobEffect effectInstance) {
        return (!effectInstance.a(MobEffects.t) || !this.ao().paperConfig().entities.mobEffects.immuneToWitherEffect.wither) && super.b(effectInstance);
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityWither.this.gR() > 0;
        }
    }
}

