/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

public class EntityArmorStand
extends EntityLiving {
    public static final int a = 5;
    private static final boolean cd = true;
    public static final Vector3f b = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f c = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f d = new Vector3f(-10.0f, 0.0f, -10.0f);
    public static final Vector3f e = new Vector3f(-15.0f, 0.0f, 10.0f);
    public static final Vector3f f = new Vector3f(-1.0f, 0.0f, -1.0f);
    public static final Vector3f g = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize ce = EntitySize.c(0.0f, 0.0f);
    private static final EntitySize cf = EntityTypes.h.n().a(0.5f).b(0.9875f);
    private static final double cg = 0.1;
    private static final double ch = 0.9;
    private static final double ci = 0.4;
    private static final double cj = 1.6;
    public static final int h = 8;
    public static final int i = 16;
    public static final int j = 1;
    public static final int k = 4;
    public static final int l = 8;
    public static final int m = 16;
    public static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> o = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> p = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> q = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> r = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> s = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> t = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    private static final Predicate<Entity> ck = entity -> {
        EntityMinecartAbstract abstractMinecart;
        return entity instanceof EntityMinecartAbstract && (abstractMinecart = (EntityMinecartAbstract)entity).z();
    };
    private static final boolean cl = false;
    private static final int cm = 0;
    private static final boolean cn = false;
    private static final boolean co = false;
    private static final boolean cp = false;
    private static final boolean cq = false;
    private boolean cr = false;
    public long cc;
    public int cs = 0;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World level) {
        super((EntityTypes<? extends EntityLiving>)type, level);
        if (level != null) {
            this.canTick = level.paperConfig().entities.armorStands.tick;
        }
    }

    public EntityArmorStand(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.h, level);
        this.a_(x2, y2, z2);
    }

    public static AttributeProvider.Builder k() {
        return EntityArmorStand.ex().a(GenericAttributes.D, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.ec();
    }

    @Override
    public void j_() {
        double x2 = this.dP();
        double y2 = this.dR();
        double z2 = this.dV();
        super.j_();
        this.a_(x2, y2, z2);
    }

    private boolean C() {
        return !this.r() && !this.br();
    }

    @Override
    public boolean dy() {
        return super.dy() && this.C();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(n, (byte)0);
        builder.a(o, b);
        builder.a(p, c);
        builder.a(q, d);
        builder.a(r, e);
        builder.a(s, f);
        builder.a(t, g);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g && slot != EnumItemSlot.h && !this.g(slot);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, boolean silent) {
        super.setItemSlot(slot, stack, silent);
        this.noTickEquipmentDirty = true;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Invisible", this.cG());
        output.a("Small", this.m());
        output.a("ShowArms", this.n());
        output.a("DisabledSlots", this.cs);
        output.a("NoBasePlate", !this.p());
        if (this.r()) {
            output.a("Marker", this.r());
        }
        output.a("Pose", net.minecraft.world.entity.decoration.EntityArmorStand$a.b, this.B());
        if (this.canTickSetByAPI) {
            output.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.l(input.a("Invisible", false));
        this.u(input.a("Small", false));
        this.a(input.a("ShowArms", false));
        this.cs = input.a("DisabledSlots", 0);
        this.b(input.a("NoBasePlate", false));
        this.v(input.a("Marker", false));
        this.ar = !this.C();
        input.a("Pose", net.minecraft.world.entity.decoration.EntityArmorStand$a.b).ifPresent(this::a);
        if (input.e("Paper.CanTickOverride").isPresent()) {
            this.canTick = input.a("Paper.CanTickOverride", true);
            this.canTickSetByAPI = true;
        }
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void F(Entity entity) {
    }

    @Override
    protected void q() {
        if (!this.ao().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        for (Entity entity : this.ao().a(EntityMinecartAbstract.class, this.dj(), ck)) {
            if (!(this.g(entity) <= 0.2)) continue;
            entity.h(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemInHand = player.b(hand);
        if (this.r() || itemInHand.a(Items.xa)) {
            return EnumInteractionResult.e;
        }
        if (player.au()) {
            return EnumInteractionResult.a;
        }
        if (player.ao().B_()) {
            return EnumInteractionResult.b;
        }
        EnumItemSlot equipmentSlotForItem = this.f(itemInHand);
        if (itemInHand.f()) {
            EnumItemSlot equipmentSlot;
            EnumItemSlot clickedSlot = this.a(vec);
            EnumItemSlot enumItemSlot = equipmentSlot = this.g(clickedSlot) ? equipmentSlotForItem : clickedSlot;
            if (this.d(equipmentSlot) && this.a(player, equipmentSlot, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        } else {
            if (this.g(equipmentSlotForItem)) {
                return EnumInteractionResult.d;
            }
            if (equipmentSlotForItem.a() == EnumItemSlot.Function.a && !this.n()) {
                return EnumInteractionResult.d;
            }
            if (this.a(player, equipmentSlotForItem, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        }
        return EnumInteractionResult.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot a(Vec3D vector) {
        EnumItemSlot equipmentSlot = EnumItemSlot.a;
        boolean isSmall = this.m();
        double d2 = vector.h / (double)(this.eF() * this.eE());
        EnumItemSlot equipmentSlot1 = EnumItemSlot.c;
        if (d2 >= 0.1) {
            double d3 = isSmall ? 0.8 : 0.45;
            if (d2 < 0.1 + d3 && this.d(equipmentSlot1)) {
                return EnumItemSlot.c;
            }
        }
        double d4 = isSmall ? 0.3 : 0.0;
        if (d2 >= 0.9 + d4) {
            double d5 = isSmall ? 1.0 : 0.7;
            if (d2 < 0.9 + d5 && this.d(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d2 >= 0.4) {
            double d6 = isSmall ? 1.0 : 0.8;
            if (d2 < 0.4 + d6 && this.d(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d2 >= 1.6 && this.d(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.d(EnumItemSlot.a)) return equipmentSlot;
        if (!this.d(EnumItemSlot.b)) return equipmentSlot;
        return EnumItemSlot.b;
    }

    public boolean g(EnumItemSlot slot) {
        return (this.cs & 1 << slot.b(0)) != 0 || slot.a() == EnumItemSlot.Function.a && !this.n();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && (this.cs & 1 << slot.b(8)) != 0) {
            return false;
        }
        if (itemBySlot.f() && (this.cs & 1 << slot.b(16)) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemBySlot);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.ao().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.gv() && itemBySlot.f() && !stack.f()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (stack.f() || stack.N() <= 1) {
            this.a(slot, stack);
            player.a(hand, itemBySlot);
            return true;
        }
        if (!itemBySlot.f()) {
            return false;
        }
        this.a(slot, stack.a(1));
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.eh()) {
            return false;
        }
        if (!level.U().a(GameRules.F).booleanValue() && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.d)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
                return false;
            }
            this.kill(level, damageSource);
            return false;
        }
        if (this.a(level, damageSource) || this.r()) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.l)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cr)) {
                return false;
            }
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.u)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cr)) {
                return false;
            }
            if (this.cp()) {
                this.d(level, damageSource, 0.15f);
            } else {
                this.e(5.0f);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.v) && this.eZ() > 0.5f) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cr)) {
                return false;
            }
            this.d(level, damageSource, 4.0f);
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cr)) {
            return false;
        }
        boolean isCanBreakArmorStand = damageSource.a(DamageTypeTags.B);
        boolean isAlwaysKillsArmorStands = damageSource.a(DamageTypeTags.A);
        if (!isCanBreakArmorStand && !isAlwaysKillsArmorStands) {
            return false;
        }
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (!player.gL().e) {
                return false;
            }
        }
        if (damageSource.h()) {
            this.E();
            this.D();
            this.kill(level, damageSource);
            return true;
        }
        long gameTime = level.au();
        if (gameTime - this.cc > 5L && !isAlwaysKillsArmorStands) {
            level.a((Entity)this, (byte)32);
            this.a(GameEvent.o, damageSource.d());
            this.cc = gameTime;
        } else {
            EntityDeathEvent event = this.brokenByPlayer(level, damageSource);
            this.D();
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        }
        return true;
    }

    @Override
    public void b(byte id) {
        if (id == 32) {
            if (this.ao().B_()) {
                this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.aF, this.dB(), 0.3f, 1.0f, false);
                this.cc = this.ao().au();
            }
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.dj().a() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    @Override
    private void D() {
        if (this.ao() instanceof WorldServer) {
            ((WorldServer)this.ao()).a(new ParticleParamBlock(Particles.b, Blocks.n.m()), this.dP(), this.f(0.6666666666666666), this.dV(), 10, (double)(this.dF() / 4.0f), (double)(this.dG() / 4.0f), (double)(this.dF() / 4.0f), 0.05);
        }
    }

    private void d(WorldServer level, DamageSource damageSource, float damageAmount) {
        float health = this.eZ();
        if ((health -= damageAmount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        } else {
            this.x(health);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(WorldServer level, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(Items.wS);
        itemStack.b(DataComponents.h, this.as());
        this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.ao(), this.dK(), stack)));
        return this.brokenByAnything(level, damageSource);
    }

    private EntityDeathEvent brokenByAnything(WorldServer level, DamageSource damageSource) {
        this.E();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            net.minecraft.world.item.ItemStack itemStack = this.cb.a(equipmentSlot);
            if (itemStack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.ao(), this.dK().d(), stack)));
        }
        EntityDeathEvent event = this.dropAllDeathLoot(level, damageSource);
        if (!event.isCancelled()) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                this.cb.a(equipmentSlot, net.minecraft.world.item.ItemStack.l);
            }
        }
        return event;
    }

    private void E() {
        this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.aD, this.dB(), 1.0f, 1.0f);
    }

    @Override
    protected void D(float yBodyRot) {
        this.bD = this.ab;
        this.bC = this.ec();
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.C()) {
            super.m(travelVector);
        }
    }

    @Override
    public void s(float offset) {
        this.bD = this.ab = offset;
        this.bF = this.bE = offset;
    }

    @Override
    public void r(float rotation) {
        this.bD = this.ab = rotation;
        this.bF = this.bE = rotation;
    }

    @Override
    protected void M() {
        this.l(this.cr);
    }

    @Override
    public void l(boolean invisible) {
        this.cr = invisible;
        super.l(invisible);
    }

    @Override
    public boolean e_() {
        return this.m();
    }

    @Override
    public void g() {
        if (!this.canTick) {
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.K();
            }
            return;
        }
        super.g();
    }

    @Override
    public void c(WorldServer level) {
        this.kill(level, null);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource) {
        this.kill(level, damageSource, true);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.en().y() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || this.cG();
    }

    @Override
    public EnumPistonReaction n_() {
        return this.r() ? EnumPistonReaction.d : super.n_();
    }

    @Override
    public boolean m_() {
        return this.r();
    }

    public void u(boolean small) {
        this.az.a(n, this.a(this.az.a(n), 1, small));
    }

    public boolean m() {
        return (this.az.a(n) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.az.a(n, this.a(this.az.a(n), 4, showArms));
    }

    public boolean n() {
        return (this.az.a(n) & 4) != 0;
    }

    public void b(boolean noBasePlate) {
        this.az.a(n, this.a(this.az.a(n), 8, noBasePlate));
    }

    public boolean p() {
        return (this.az.a(n) & 8) == 0;
    }

    public void v(boolean marker) {
        this.az.a(n, this.a(this.az.a(n), 16, marker));
    }

    public boolean r() {
        return (this.az.a(n) & 0x10) != 0;
    }

    private byte a(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void a(Vector3f headPose) {
        this.az.a(o, headPose);
    }

    public void b(Vector3f bodyPose) {
        this.az.a(p, bodyPose);
    }

    public void c(Vector3f leftArmPose) {
        this.az.a(q, leftArmPose);
    }

    public void d(Vector3f rightArmPose) {
        this.az.a(r, rightArmPose);
    }

    public void e(Vector3f leftLegPose) {
        this.az.a(s, leftLegPose);
    }

    public void f(Vector3f rightLegPose) {
        this.az.a(t, rightLegPose);
    }

    public Vector3f s() {
        return this.az.a(o);
    }

    public Vector3f v() {
        return this.az.a(p);
    }

    public Vector3f w() {
        return this.az.a(q);
    }

    public Vector3f x() {
        return this.az.a(r);
    }

    public Vector3f z() {
        return this.az.a(s);
    }

    public Vector3f A() {
        return this.az.a(t);
    }

    @Override
    public boolean bX() {
        return super.bX() && !this.r();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean w(Entity entity) {
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (this.ao().a((Entity)player, this.dK())) return false;
        return true;
    }

    @Override
    public EnumMainHand at() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a fj() {
        return new EntityLiving.a(SoundEffects.aE, SoundEffects.aE);
    }

    @Override
    public @Nullable SoundEffect h(DamageSource damageSource) {
        return SoundEffects.aF;
    }

    @Override
    public @Nullable SoundEffect fd() {
        return SoundEffects.aD;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
    }

    @Override
    public boolean gl() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (n.equals(key)) {
            this.j_();
            this.W = !this.r();
        }
        super.a(key);
    }

    @Override
    public boolean gm() {
        return false;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.w(this.r());
    }

    private EntitySize w(boolean isMarker) {
        if (isMarker) {
            return ce;
        }
        return this.e_() ? cf : this.ay().n();
    }

    @Override
    public Vec3D o(float partialTick) {
        if (this.r()) {
            AxisAlignedBB aabb = this.w(false).a(this.dI());
            BlockPosition blockPos = this.dK();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockPos1 : BlockPosition.c(BlockPosition.a(aabb.a, aabb.b, aabb.c), BlockPosition.a(aabb.d, aabb.e, aabb.f))) {
                int max = Math.max(this.ao().a(EnumSkyBlock.b, blockPos1), this.ao().a(EnumSkyBlock.a, blockPos1));
                if (max == 15) {
                    return Vec3D.b(blockPos1);
                }
                if (max <= i2) continue;
                i2 = max;
                blockPos = blockPos1.j();
            }
            return Vec3D.b(blockPos);
        }
        return super.o(partialTick);
    }

    @Override
    public net.minecraft.world.item.ItemStack dZ() {
        return new net.minecraft.world.item.ItemStack(Items.wS);
    }

    @Override
    public boolean eT() {
        return !this.cG() && !this.r();
    }

    public void a(a armorStandPose) {
        this.a(armorStandPose.a());
        this.b(armorStandPose.b());
        this.c(armorStandPose.c());
        this.d(armorStandPose.d());
        this.e(armorStandPose.e());
        this.f(armorStandPose.f());
    }

    public a B() {
        return new a(this.s(), this.v(), this.w(), this.x(), this.z(), this.A());
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }

    public static final class a
    extends Record {
        private final Vector3f c;
        private final Vector3f d;
        private final Vector3f e;
        private final Vector3f f;
        private final Vector3f g;
        private final Vector3f h;
        public static final a a = new a(b, c, d, e, f, g);
        public static final Codec<a> b = RecordCodecBuilder.create(instance -> instance.group((App)Vector3f.a.optionalFieldOf("Head", (Object)b).forGetter(a::a), (App)Vector3f.a.optionalFieldOf("Body", (Object)c).forGetter(a::b), (App)Vector3f.a.optionalFieldOf("LeftArm", (Object)d).forGetter(a::c), (App)Vector3f.a.optionalFieldOf("RightArm", (Object)e).forGetter(a::d), (App)Vector3f.a.optionalFieldOf("LeftLeg", (Object)f).forGetter(a::e), (App)Vector3f.a.optionalFieldOf("RightLeg", (Object)g).forGetter(a::f)).apply((Applicative)instance, a::new));

        public a(Vector3f head, Vector3f body, Vector3f leftArm, Vector3f rightArm, Vector3f leftLeg, Vector3f rightLeg) {
            this.c = head;
            this.d = body;
            this.e = leftArm;
            this.f = rightArm;
            this.g = leftLeg;
            this.h = rightLeg;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "head;body;leftArm;rightArm;leftLeg;rightLeg", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "head;body;leftArm;rightArm;leftLeg;rightLeg", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "head;body;leftArm;rightArm;leftLeg;rightLeg", "c", "d", "e", "f", "g", "h"}, this, o2);
        }

        public Vector3f a() {
            return this.c;
        }

        public Vector3f b() {
            return this.d;
        }

        public Vector3f c() {
            return this.e;
        }

        public Vector3f d() {
            return this.f;
        }

        public Vector3f e() {
            return this.g;
        }

        public Vector3f f() {
            return this.h;
        }
    }
}

