/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.jspecify.annotations.Nullable;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> d = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int b = 8;
    private static final float e = 0.0625f;
    private static final float f = 0.75f;
    private static final float g = 0.75f;
    private static final byte h = 0;
    private static final float i = 1.0f;
    private static final boolean j = false;
    private static final boolean k = false;
    public float l = 1.0f;
    public boolean m = false;
    public @Nullable MapId cachedMapId;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World level) {
        super((EntityTypes<? extends EntityHanging>)type, level);
        this.l(false);
    }

    public EntityItemFrame(World level, BlockPosition pos, EnumDirection facingDirection) {
        this(EntityTypes.ax, level, pos, facingDirection);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World level, BlockPosition pos, EnumDirection direction) {
        super((EntityTypes<? extends EntityHanging>)type, level, pos);
        this.b(direction);
        this.l(false);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, ItemStack.l);
        builder.a(d, 0);
    }

    @Override
    public void b(EnumDirection facingDirection) {
        Objects.requireNonNull(facingDirection);
        super.a(facingDirection);
        if (facingDirection.o().d()) {
            this.w(0.0f);
            this.v(facingDirection.e() * 90);
        } else {
            this.w(-90 * facingDirection.f().a());
            this.v(0.0f);
        }
        this.ac = this.ee();
        this.ab = this.ec();
        this.e();
    }

    @Override
    protected final void e() {
        super.e();
        this.e(this.dP(), this.dR(), this.dV());
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection direction) {
        return this.a(pos, direction, this.x());
    }

    @Override
    protected AxisAlignedBB u() {
        return this.a(this.a, this.dg(), false);
    }

    private AxisAlignedBB a(BlockPosition pos, EnumDirection direction, boolean hasFramedMap) {
        return EntityItemFrame.createBoundingBoxStatic(pos, direction, hasFramedMap);
    }

    public static AxisAlignedBB createBoundingBoxStatic(BlockPosition pos, EnumDirection direction, boolean hasFramedMap) {
        float f2 = 0.46875f;
        Vec3D vec3 = Vec3D.b(pos).a(direction, -0.46875);
        float f1 = hasFramedMap ? 1.0f : 0.75f;
        float f22 = hasFramedMap ? 1.0f : 0.75f;
        EnumDirection.EnumAxis axis = direction.o();
        double d2 = axis == EnumDirection.EnumAxis.a ? 0.0625 : (double)f1;
        double d1 = axis == EnumDirection.EnumAxis.b ? 0.0625 : (double)f22;
        double d22 = axis == EnumDirection.EnumAxis.c ? 0.0625 : (double)f1;
        return AxisAlignedBB.a(vec3, d2, d1, d22);
    }

    @Override
    public boolean f() {
        if (this.m) {
            return true;
        }
        if (this.b(this.u())) {
            return false;
        }
        IBlockData blockState = this.ao().a_(this.a.a(this.dg().g()));
        return (blockState.e() || this.dg().o().d() && BlockDiodeAbstract.n(blockState)) && this.a(true);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (!this.m) {
            super.a(type, movement);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.m) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    public void c(WorldServer level) {
        this.d(this.w());
        super.c(level);
    }

    private boolean a(DamageSource damageSource) {
        return !damageSource.a(DamageTypeTags.l) && !this.w().f();
    }

    private static boolean e(DamageSource damageSource) {
        return damageSource.a(DamageTypeTags.d) || damageSource.h();
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return (!this.m || EntityItemFrame.e(damageSource)) && !this.d(damageSource);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.m) {
            if (this.d(damageSource)) {
                return false;
            }
            if (this.a(damageSource)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false) || this.eh()) {
                    return true;
                }
                Entity entity = damageSource.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.w().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return true;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.a(level, damageSource.d(), false);
                this.a(GameEvent.c, damageSource.d());
                this.a(this.k(), 1.0f, 1.0f);
                return true;
            }
            return super.a(level, damageSource, amount);
        }
        return EntityItemFrame.e(damageSource) && super.a(level, damageSource, amount);
    }

    public SoundEffect k() {
        return SoundEffects.pD;
    }

    @Override
    public boolean a(double distance) {
        double d2 = 16.0;
        return distance < (d2 *= 64.0 * EntityItemFrame.dc()) * d2;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        this.a(this.m(), 1.0f, 1.0f);
        this.a(level, entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect m() {
        return SoundEffects.pB;
    }

    @Override
    public void v() {
        this.a(this.n(), 1.0f, 1.0f);
    }

    public SoundEffect n() {
        return SoundEffects.pC;
    }

    private void a(WorldServer level, @Nullable Entity entity, boolean dropItem) {
        if (!this.m) {
            EntityHuman player;
            ItemStack item = this.w();
            this.b(ItemStack.l);
            if (!level.U().a(GameRules.k).booleanValue()) {
                if (entity == null) {
                    this.d(item);
                }
            } else if (entity instanceof EntityHuman && (player = (EntityHuman)entity).gv()) {
                this.d(item);
            } else {
                if (dropItem) {
                    this.a(level, this.r());
                }
                if (!item.f()) {
                    item = item.v();
                    this.d(item);
                    if (this.as.i() < this.l) {
                        this.a(level, item);
                    }
                }
            }
        }
    }

    private void d(ItemStack stack) {
        WorldMap savedData;
        MapId framedMapId = this.a(stack);
        if (framedMapId != null && (savedData = ItemWorldMap.a(framedMapId, this.ao())) != null) {
            savedData.a(this.a, this.aA());
        }
        stack.a((Entity)null);
    }

    public ItemStack w() {
        return this.aD().a(c);
    }

    @Override
    public @Nullable EntityItem a(WorldServer serverLevel, ItemStack stack) {
        return this.a(serverLevel, stack, this.dg() == EnumDirection.a ? -0.6f : 0.0f);
    }

    public @Nullable MapId a(ItemStack stack) {
        return stack.a(DataComponents.T);
    }

    public boolean x() {
        return this.w().c(DataComponents.T);
    }

    public void b(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean updateNeighbours) {
        this.setItem(stack, updateNeighbours, true);
    }

    public void setItem(ItemStack stack, boolean updateNeighbours, boolean playSound) {
        if (!stack.f()) {
            stack = stack.c(1);
        }
        this.e(stack);
        this.aD().a(c, stack);
        if (!stack.f() && updateNeighbours && playSound) {
            this.a(this.p(), 1.0f, 1.0f);
        }
        if (updateNeighbours && this.a != null) {
            this.ao().b(this.a, Blocks.a);
        }
    }

    public SoundEffect p() {
        return SoundEffects.pA;
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::w, this::b) : super.a_(slot);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (key.equals(c)) {
            this.e(this.w());
        }
    }

    private void e(ItemStack item) {
        this.cachedMapId = item.a().a(DataComponents.T);
        if (!item.f() && item.I() != this) {
            item.a(this);
        }
        this.e();
    }

    public int y() {
        return this.aD().a(d);
    }

    public void a(int rotation) {
        this.a(rotation, true);
    }

    private void a(int rotation, boolean updateNeighbours) {
        this.aD().a(d, rotation % 8);
        if (updateNeighbours && this.a != null) {
            this.ao().b(this.a, Blocks.a);
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        ItemStack item = this.w();
        if (!item.f()) {
            output.a("Item", ItemStack.b, item);
        }
        output.a("ItemRotation", (byte)this.y());
        output.a("ItemDropChance", this.l);
        output.a("Facing", EnumDirection.k, this.dg());
        output.a("Invisible", this.cG());
        output.a("Fixed", this.m);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        ItemStack itemStack = input.a("Item", ItemStack.b).orElse(ItemStack.l);
        ItemStack item = this.w();
        if (!item.f() && !ItemStack.a(itemStack, item)) {
            this.d(item);
        }
        this.a(itemStack, false);
        this.a(input.a("ItemRotation", (byte)0), false);
        this.l = input.a("ItemDropChance", 1.0f);
        this.b(input.a("Facing", EnumDirection.k).orElse(EnumDirection.a));
        this.l(input.a("Invisible", false));
        this.m = input.a("Fixed", false);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemInHand = player.b(hand);
        boolean flag = !this.w().f();
        boolean bl = flag1 = !itemInHand.f();
        if (this.m) {
            return EnumInteractionResult.e;
        }
        if (!player.ao().B_()) {
            if (!flag) {
                if (flag1 && !this.eh()) {
                    WorldMap savedData = ItemWorldMap.b(itemInHand, this.ao());
                    if (savedData != null && savedData.a(256)) {
                        return EnumInteractionResult.d;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemInHand.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    this.b(ItemStack.fromBukkitCopy(event.getItemStack()));
                    this.a(GameEvent.c, (Entity)player);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.e;
            }
            PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.w().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
            if (!event.callEvent()) {
                return EnumInteractionResult.d;
            }
            this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
            this.a(this.q(), 1.0f, 1.0f);
            this.a(this.y() + 1);
            this.a(GameEvent.c, (Entity)player);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(!flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    public SoundEffect q() {
        return SoundEffects.pE;
    }

    public int z() {
        return this.w().f() ? 0 : this.y() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.dg().d(), this.i());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.b(EnumDirection.a(packet.n()));
    }

    @Override
    public ItemStack dZ() {
        ItemStack item = this.w();
        return item.f() ? this.r() : item.v();
    }

    protected ItemStack r() {
        return new ItemStack(Items.wo);
    }

    @Override
    public float ed() {
        EnumDirection direction = this.dg();
        int i2 = direction.o().b() ? 90 * direction.f().a() : 0;
        return MathHelper.b(180 + direction.e() * 90 + this.y() * 45 + i2);
    }
}

