/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.jspecify.annotations.Nullable;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float d = 0.1f;
    public static final float a = 0.2125f;
    private static final int e = 6000;
    private static final int f = Short.MAX_VALUE;
    private static final int g = Short.MIN_VALUE;
    private static final int h = 5;
    private static final short i = 0;
    private static final short j = 0;
    public int k = 0;
    public int l = 0;
    public int m = 5;
    public @Nullable EntityReference<Entity> n;
    public @Nullable UUID o;
    public final float b = this.as.i() * (float)Math.PI * 2.0f;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> type, World level) {
        super(type, level);
        if (GlobalConfiguration.get().misc.sendFullPosForItemEntities) {
            this.c(true);
        }
        this.v(this.as.i() * 360.0f);
    }

    public EntityItem(World level, double posX, double posY, double posZ, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.av, level);
        this.a_(posX, posY, posZ);
        this.m(this.as.j() * 0.2 - 0.1, 0.2, this.as.j() * 0.2 - 0.1);
        this.a(stack);
    }

    public EntityItem(World level, double posX, double posY, double posZ, ItemStack stack, double deltaX, double deltaY, double deltaZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.av, level);
        this.a_(posX, posY, posZ);
        this.m(deltaX, deltaY, deltaZ);
        this.a(stack);
    }

    @Override
    public boolean bw() {
        return this.e().a(TagsItem.V);
    }

    @Override
    public @Nullable Entity p() {
        return EntityReference.a(this.n, this.ao());
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            this.n = itemEntity.n;
        }
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(c, ItemStack.l);
    }

    @Override
    protected double bs() {
        return 0.04;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.l > 0 && this.l != Short.MAX_VALUE) {
            --this.l;
        }
        if (this.k != Short.MIN_VALUE) {
            ++this.k;
        }
        if (!this.ao().B_() && this.k >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.k = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void g() {
        if (this.e().f()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d2;
            int i2;
            super.g();
            if (this.l > 0 && this.l != Short.MAX_VALUE) {
                --this.l;
            }
            this.Y = this.dP();
            this.Z = this.dR();
            this.aa = this.dV();
            Vec3D deltaMovement = this.dN();
            if (this.by() && this.b(TagsFluid.a) > (double)0.1f) {
                this.u();
            } else if (this.bN() && this.b(TagsFluid.b) > (double)0.1f) {
                this.v();
            } else {
                this.bu();
            }
            if (this.ao().B_()) {
                this.ar = false;
            } else {
                boolean bl = this.ar = !this.ao().a((Entity)this, this.dj().h(1.0E-7));
                if (this.ar) {
                    this.k(this.dP(), (this.dj().b + this.dj().e) / 2.0, this.dV());
                }
            }
            if (!this.aV() || this.dN().j() > (double)1.0E-5f || (this.at + this.aA()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dN());
                this.aW();
                float f2 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f2 = 1.0f;
                } else if (this.aV()) {
                    f2 = this.ao().a_(this.bf()).b().g() * 0.98f;
                }
                this.k(this.dN().d(f2, 0.98, f2));
                if (this.aV()) {
                    Vec3D deltaMovement1 = this.dN();
                    if (deltaMovement1.h < 0.0) {
                        this.k(deltaMovement1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.c(this.Y) != MathHelper.c(this.dP()) || MathHelper.c(this.Z) != MathHelper.c(this.dR()) || MathHelper.c(this.aa) != MathHelper.c(this.dV());
            int n2 = i2 = flag ? 2 : 40;
            if (this.at % i2 == 0 && !this.ao().B_() && this.x()) {
                this.w();
            }
            if (this.k != Short.MIN_VALUE) {
                ++this.k;
            }
            this.aF |= this.bG();
            if (!this.ao().B_() && (d2 = this.dN().d(deltaMovement).h()) > 0.01) {
                this.aF = true;
            }
            if (!this.ao().B_() && this.k >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.k = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public BlockPosition bf() {
        return this.f(0.999999f);
    }

    private void u() {
        this.i((double)0.99f);
    }

    private void v() {
        this.i((double)0.95f);
    }

    private void i(double multiplier) {
        Vec3D deltaMovement = this.dN();
        this.m(deltaMovement.g * multiplier, deltaMovement.h + (double)(deltaMovement.h < (double)0.06f ? 5.0E-4f : 0.0f), deltaMovement.i * multiplier);
    }

    private void w() {
        if (this.x()) {
            double radius = this.ao().spigotConfig.itemMerge;
            for (EntityItem itemEntity : this.ao().a(EntityItem.class, this.dj().c(radius, this.ao().paperConfig().entities.behavior.onlyMergeItemsHorizontally ? 0.0 : radius - 0.5, radius), (? super T neighbour) -> neighbour != this && neighbour.x())) {
                if (!itemEntity.x() || this.ao().paperConfig().fixes.fixItemsMergingThroughWalls && this.ao().clipDirect(this.dI(), itemEntity.dI(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(itemEntity);
                if (!this.eh()) continue;
                break;
            }
        }
    }

    private boolean x() {
        ItemStack item = this.e();
        return this.cb() && this.l != Short.MAX_VALUE && this.k != Short.MIN_VALUE && this.k < this.despawnRate && item.N() < item.k();
    }

    private void a(EntityItem itemEntity) {
        ItemStack item = this.e();
        ItemStack item1 = itemEntity.e();
        if (Objects.equals(this.o, itemEntity.o) && EntityItem.a(item, item1)) {
            if (item1.N() < item.N()) {
                EntityItem.a(this, item, itemEntity, item1);
            } else {
                EntityItem.a(itemEntity, item1, this, item);
            }
        }
    }

    public static boolean a(ItemStack destinationStack, ItemStack originStack) {
        return originStack.N() + destinationStack.N() <= originStack.k() && ItemStack.c(destinationStack, originStack);
    }

    public static ItemStack a(ItemStack destinationStack, ItemStack originStack, int amount) {
        int min = Math.min(Math.min(destinationStack.k(), amount) - destinationStack.N(), originStack.N());
        ItemStack itemStack = destinationStack.c(destinationStack.N() + min);
        originStack.h(min);
        return itemStack;
    }

    private static void a(EntityItem destinationEntity, ItemStack destinationStack, ItemStack originStack) {
        ItemStack itemStack = EntityItem.a(destinationStack, originStack, 64);
        destinationEntity.a(itemStack);
    }

    private static void a(EntityItem destinationEntity, ItemStack destinationStack, EntityItem originEntity, ItemStack originStack) {
        if (!CraftEventFactory.callItemMergeEvent(originEntity, destinationEntity)) {
            return;
        }
        EntityItem.a(destinationEntity, destinationStack, originStack);
        destinationEntity.l = Math.max(destinationEntity.l, originEntity.l);
        destinationEntity.k = Math.min(destinationEntity.k, originEntity.k);
        if (originStack.f()) {
            originEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean bx() {
        return !this.e().a(this.en().a()) || super.bx();
    }

    @Override
    protected boolean aR() {
        return this.m <= 0 || this.at % 10 == 0;
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource) && this.e().a(damageSource);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        if (!level.U().a(GameRules.F).booleanValue() && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.e().a(damageSource)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
            return false;
        }
        this.bT();
        this.m = (int)((float)this.m - amount);
        this.a(GameEvent.o, damageSource.d());
        if (this.m <= 0) {
            this.e().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || super.a(explosion);
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("Health", (short)this.m);
        output.a("Age", (short)this.k);
        output.a("PickupDelay", (short)this.l);
        EntityReference.a(this.n, output, "Thrower");
        output.b("Owner", UUIDUtil.a, this.o);
        if (!this.e().f()) {
            output.a("Item", ItemStack.b, this.e());
        }
        if (this.frictionState != TriState.NOT_SET) {
            output.a("Paper.FrictionState", this.frictionState.toString());
        }
    }

    @Override
    protected void a(ValueInput input) {
        this.m = input.a("Health", (short)5);
        this.k = input.a("Age", (short)0);
        this.l = input.a("PickupDelay", (short)0);
        this.o = input.a("Owner", UUIDUtil.a).orElse(null);
        this.n = EntityReference.a(input, "Thrower");
        this.a(input.a("Item", ItemStack.b).orElse(ItemStack.l));
        input.g("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
        if (this.e().f()) {
            this.discard(null);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.ao().B_()) {
            ItemStack item = this.e();
            Item item1 = item.h();
            int count = item.N();
            int canHold = entity.gK().canHold(item);
            int remaining = count - canHold;
            boolean flyAtPlayer = false;
            if (this.l <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        entity.a((Entity)this, count);
                    }
                    return;
                }
            }
            if (this.l <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                item.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    item.e(count);
                    if (flyAtPlayer) {
                        entity.a((Entity)this, count);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.ao().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    item.e(count);
                    return;
                }
                ItemStack current = this.e();
                if (!item.equals(current)) {
                    item = current;
                } else {
                    item.e(canHold + remaining);
                }
                this.l = 0;
            } else if (this.l == 0) {
                this.l = -1;
            }
            if (this.l == 0 && (this.o == null || this.o.equals(entity.cY())) && entity.gK().g(item)) {
                if (flyAtPlayer) {
                    entity.a((Entity)this, count);
                }
                if (item.f()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    item.e(count);
                }
                entity.a(StatisticList.e.b(item1), count);
                entity.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ap() {
        IChatBaseComponent customName = this.as();
        return customName != null ? customName : this.e().A();
    }

    @Override
    public boolean cT() {
        return false;
    }

    @Override
    public @Nullable Entity b(TeleportTransition teleportTransition) {
        Entity entity = super.b(teleportTransition);
        if (!this.ao().B_() && entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            itemEntity.w();
        }
        return entity;
    }

    public ItemStack e() {
        return this.aD().a(c);
    }

    public void a(ItemStack stack) {
        this.aD().a(c, stack);
        this.despawnRate = this.ao().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.ao().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.h(), this.ao().spigotConfig.itemDespawnRate) : this.ao().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (c.equals(key)) {
            this.e().a((Entity)this);
        }
    }

    public void b(@Nullable UUID target) {
        this.o = target;
    }

    public void b(Entity thrower) {
        this.n = EntityReference.a(thrower);
    }

    public int f() {
        return this.k;
    }

    public void i() {
        this.l = 10;
    }

    public void k() {
        this.l = 0;
    }

    public void m() {
        this.l = Short.MAX_VALUE;
    }

    public void a(int pickupDelay) {
        this.l = pickupDelay;
    }

    public boolean n() {
        return this.l > 0;
    }

    public void q() {
        this.k = Short.MIN_VALUE;
    }

    public void r() {
        this.k = -6000;
    }

    public void s() {
        this.m();
        this.k = this.despawnRate - 1;
    }

    public static float f(float age, float bobOffset) {
        return age / 20.0f + bobOffset;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.i;
    }

    @Override
    public float ed() {
        return 180.0f - EntityItem.f((float)this.f() + 0.5f, this.b) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::e, this::a) : super.a_(slot);
    }
}

