/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.animal.feline.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jspecify.annotations.Nullable;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final boolean d = false;
    private static final boolean e = false;
    private static final short f = 30;
    private static final byte cv = 3;
    private int cw;
    public int cx;
    public int cy = 30;
    public int cz = 3;
    public boolean cA;
    public @Nullable Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(2, new PathfinderGoalSwell(this));
        this.cs.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.cs.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.cs.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(6, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.x, 0.25);
    }

    @Override
    public int cW() {
        return this.ag_() == null ? this.y(0.0f) : this.y(this.eZ() - 1.0f);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.cx += (int)(fallDistance * 1.5);
        if (this.cx > this.cy - 5) {
            this.cx = this.cy - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, -1);
        builder.a(b, false);
        builder.a(c, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("powered", this.p());
        output.a("Fuse", (short)this.cy);
        output.a("ExplosionRadius", (byte)this.cz);
        output.a("ignited", this.gQ());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(b, input.a("powered", false));
        this.cy = input.a("Fuse", (short)30);
        this.cz = input.a("ExplosionRadius", (byte)3);
        if (input.a("ignited", false)) {
            this.az.a(c, true);
        }
    }

    @Override
    public void g() {
        if (this.cb()) {
            int swellDir;
            this.cw = this.cx;
            if (this.gQ()) {
                this.a(1);
            }
            if ((swellDir = this.gP()) > 0 && this.cx == 0) {
                this.a(SoundEffects.hI, 1.0f, 0.5f);
                this.c(GameEvent.I);
            }
            this.cx += swellDir;
            if (this.cx < 0) {
                this.cx = 0;
            }
            if (this.cx >= this.cy) {
                this.cx = this.cy;
                this.gS();
            }
        }
        super.g();
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTargetEvent.TargetReason reason) {
        if (!(target instanceof Goat)) {
            return super.setTarget(target, reason);
        }
        return false;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.hH;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.hG;
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        if (this.e(level) && this.p() && !this.cA) {
            entity.a(level, damageSource, false, LootTables.bd, (ItemStack itemStack) -> {
                entity.a(level, (ItemStack)itemStack);
                this.cA = true;
            });
        }
        return super.a(level, entity, damageSource);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        return true;
    }

    public boolean p() {
        return this.az.a(b);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cw, this.cx) / (float)(this.cy - 2);
    }

    public int gP() {
        return this.az.a(a);
    }

    public void a(int state) {
        this.az.a(a, state);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        super.a(level, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.az.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.az.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(TagsItem.bP)) {
            SoundEffect soundEvent = itemInHand.a(Items.wi) ? SoundEffects.kx : SoundEffects.kN;
            this.ao().a((Entity)player, this.dP(), this.dR(), this.dV(), soundEvent, this.dB(), 1.0f, this.as.i() * 0.4f + 0.8f);
            if (!this.ao().B_()) {
                this.entityIgniter = player;
                this.gR();
                if (itemInHand.p() == 0) {
                    itemInHand.h(1);
                } else {
                    itemInHand.a(1, (EntityLiving)player, hand.a());
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void gS() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            float f2 = this.p() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.cz * f2, false);
            if (!event.isCancelled()) {
                this.bJ = true;
                serverLevel.a((Entity)this, this.dP(), this.dR(), this.dV(), event.getRadius(), event.getFire(), World.a.c);
                this.gT();
                this.a(serverLevel, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.cx = 0;
                this.az.a(c, false);
            }
        }
    }

    private void gT() {
        Collection<MobEffect> activeEffects = this.eW();
        if (!activeEffects.isEmpty() && !this.ao().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.ao(), this.dP(), this.dR(), this.dV());
            areaEffectCloud.a(this);
            areaEffectCloud.a(2.5f);
            areaEffectCloud.c(-0.5f);
            areaEffectCloud.d(10);
            areaEffectCloud.a(300);
            areaEffectCloud.b(0.25f);
            areaEffectCloud.d(-areaEffectCloud.c() / (float)areaEffectCloud.h());
            for (MobEffect mobEffectInstance : activeEffects) {
                areaEffectCloud.a(new MobEffect(mobEffectInstance));
            }
            this.ao().addFreshEntity(areaEffectCloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.gQ() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.az.a(c, event.isIgnited());
        }
    }

    public boolean gQ() {
        return this.az.a(c);
    }

    public void gR() {
        this.setIgnited(true);
    }
}

