/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.jspecify.annotations.Nullable;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey d = MinecraftKey.b("attacking");
    private static final AttributeModifier e = new AttributeModifier(d, 0.15f, AttributeModifier.Operation.a);
    private static final int f = 400;
    private static final int cv = 600;
    private static final DataWatcherObject<Optional<IBlockData>> cw = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cy = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int cz = Integer.MIN_VALUE;
    private int cA;
    private static final UniformInt cB = TimeRange.a(20, 39);
    private long cC;
    private @Nullable EntityReference<EntityLiving> cD;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new a(this));
        this.cs.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cs.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.cs.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.cs.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.ct.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.ct.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 40.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.d, 7.0).a(GenericAttributes.o, 64.0).a(GenericAttributes.D, 1.0);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTargetEvent.TargetReason reason) {
        if (!super.setTarget(target, reason)) {
            return false;
        }
        target = this.ag_();
        AttributeModifiable attribute = this.h(GenericAttributes.x);
        if (target == null) {
            this.cA = 0;
            this.az.a(cx, false);
            this.az.a(cy, false);
            attribute.c(d);
        } else {
            this.cA = this.at;
            this.az.a(cx, true);
            if (!attribute.b(d)) {
                attribute.b(e);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cw, Optional.empty());
        builder.a(cx, false);
        builder.a(cy, false);
    }

    @Override
    public void c() {
        this.a(cB.a(this.as));
    }

    @Override
    public void b(long absoluteTime) {
        this.cC = absoluteTime;
    }

    @Override
    public long a() {
        return this.cC;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> target) {
        this.cD = target;
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cD;
    }

    public void p() {
        if (this.at >= this.cz + 400) {
            this.cz = this.at;
            if (!this.bq()) {
                this.ao().a(this.dP(), this.dT(), this.dV(), SoundEffects.jV, this.dB(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cx.equals(key) && this.gS() && this.ao().B_()) {
            this.p();
        }
        super.a(key);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        IBlockData carriedBlock = this.gQ();
        if (carriedBlock != null) {
            output.a("carriedBlockState", IBlockData.a, carriedBlock);
        }
        this.b_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c((IBlockData)input.a("carriedBlockState", IBlockData.a).filter(blockState -> !blockState.l()).orElse(null));
        this.a(this.ao(), input);
    }

    boolean g(EntityHuman player) {
        boolean shouldAttack = this.isBeingStaredBy0(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    boolean isBeingStaredBy0(EntityHuman player) {
        return EntityLiving.bo.test(player) && this.a(player, 0.025, true, false, this.dT());
    }

    @Override
    public void d_() {
        if (this.ao().B_()) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.ao().a(Particles.ag, this.e(0.5), this.dS() - 0.25, this.h(0.5), (this.as.j() - 0.5) * 2.0, -this.as.j(), (this.as.j() - 0.5) * 2.0);
            }
        }
        this.bM = false;
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
        super.d_();
    }

    @Override
    public boolean fR() {
        return true;
    }

    @Override
    protected void a(WorldServer level) {
        float lightLevelDependentMagicValue;
        if (level.ag() && this.at >= this.cA + 600 && (lightLevelDependentMagicValue = this.bO()) > 0.5f && level.k(this.dK()) && this.as.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.g((EntityLiving)null);
            this.gP();
        }
        super.a(level);
    }

    public boolean gP() {
        if (!this.ao().B_() && this.cb()) {
            double d2 = this.dP() + (this.as.j() - 0.5) * 64.0;
            double d1 = this.dR() + (double)(this.as.a(64) - 32);
            double d22 = this.dV() + (this.as.j() - 0.5) * 64.0;
            return this.p(d2, d1, d22);
        }
        return false;
    }

    public boolean H(Entity target) {
        Vec3D vec3 = new Vec3D(this.dP() - target.dP(), this.f(0.5) - target.dT(), this.dV() - target.dV());
        vec3 = vec3.d();
        double d2 = 16.0;
        double d1 = this.dP() + (this.as.j() - 0.5) * 8.0 - vec3.g * 16.0;
        double d22 = this.dR() + (double)(this.as.a(16) - 8) - vec3.h * 16.0;
        double d3 = this.dV() + (this.as.j() - 0.5) * 8.0 - vec3.i * 16.0;
        return this.p(d1, d22, d3);
    }

    private boolean p(double x2, double y2, double z2) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        while (mutableBlockPos.v() > this.ao().K_() && !this.ao().a_(mutableBlockPos).d()) {
            mutableBlockPos.c(EnumDirection.a);
        }
        IBlockData blockState = this.ao().a_(mutableBlockPos);
        boolean flag = blockState.d();
        boolean isWater = blockState.y().a(TagsFluid.a);
        if (flag && !isWater) {
            Vec3D vec3 = this.dI();
            boolean flag1 = this.b(x2, y2, z2, true);
            if (flag1) {
                this.ao().a(GameEvent.R, vec3, GameEvent.a.a(this));
                if (!this.bq()) {
                    this.ao().a(null, this.Y, this.Z, this.aa, SoundEffects.jW, this.dB(), 1.0f, 1.0f);
                    this.a(SoundEffects.jW, 1.0f, 1.0f);
                }
            }
            return flag1;
        }
        return false;
    }

    @Override
    public SoundEffect W() {
        return this.gR() ? SoundEffects.jU : SoundEffects.jR;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.jT;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.jS;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        IBlockData carriedBlock = this.gQ();
        if (carriedBlock != null) {
            ItemStack itemStack = new ItemStack(Items.qP);
            EnchantmentManager.a(itemStack, level.J_(), VanillaEnchantmentProviders.g, level.c(this.dK()), this.ep());
            LootParams.a builder = new LootParams.a((WorldServer)this.ao()).a(LootContextParameters.h, this.dI()).a(LootContextParameters.k, itemStack).b(LootContextParameters.a, this);
            for (ItemStack itemStack1 : carriedBlock.a(builder)) {
                this.a(level, itemStack1);
            }
        }
    }

    public void c(@Nullable IBlockData state) {
        this.az.a(cw, Optional.ofNullable(state));
    }

    public @Nullable IBlockData gQ() {
        return this.az.a(cw).orElse(null);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag;
        EntityPotion abstractThrownPotion;
        EntityPotion abstractThrownPotion1;
        if (this.a(level, damageSource)) {
            return false;
        }
        Entity entity = damageSource.c();
        EntityPotion entityPotion = abstractThrownPotion1 = entity instanceof EntityPotion ? (abstractThrownPotion = (EntityPotion)entity) : null;
        if (!damageSource.a(DamageTypeTags.j) && abstractThrownPotion1 == null) {
            boolean flag2 = super.a(level, damageSource, amount);
            if (!(damageSource.d() instanceof EntityLiving) && this.as.a(10) != 0 && this.tryEscape(damageSource.a(DamageTypeTags.n) ? EndermanEscapeEvent.Reason.DROWN : EndermanEscapeEvent.Reason.CRITICAL_HIT)) {
                this.gP();
            }
            return flag2;
        }
        boolean bl = flag = abstractThrownPotion1 != null && this.a(level, damageSource, abstractThrownPotion1, amount);
        if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!this.gP()) continue;
                return true;
            }
        }
        return flag;
    }

    private boolean a(WorldServer level, DamageSource damageSource, EntityPotion potion, float damageAmount) {
        ItemStack item = potion.e();
        PotionContents potionContents = item.a(DataComponents.Y, PotionContents.a);
        return potionContents.a(Potions.a) && super.a(level, damageSource, damageAmount);
    }

    public boolean gR() {
        return this.az.a(cx);
    }

    public boolean gS() {
        return this.az.a(cy);
    }

    public void gT() {
        this.az.a(cy, true);
    }

    public void setCreepy(boolean creepy) {
        this.az.a(cx, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.az.a(cy, hasBeenStaredAt);
    }

    @Override
    public boolean ab() {
        return super.ab() || this.gQ() != null;
    }

    static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        private @Nullable EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.ag_();
            EntityLiving entityLiving = this.b;
            if (entityLiving instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entityLiving;
                double d2 = this.b.g(this.a);
                return !(d2 > 256.0) && this.a.g(player);
            }
            return false;
        }

        @Override
        public void d() {
            this.a.N().n();
        }

        @Override
        public void a() {
            this.a.J().a(this.b.dP(), this.b.dT(), this.b.dV());
        }
    }

    static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            return this.a.gQ() != null && PathfinderGoalEndermanPlaceBlock.a(this.a).U().a(GameRules.F) != false && this.a.ep().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0;
        }

        @Override
        public void a() {
            int floor2;
            int floor1;
            int floor;
            BlockPosition blockPos;
            RandomSource random = this.a.ep();
            World level = this.a.ao();
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos = new BlockPosition(floor = MathHelper.c(this.a.dP() - 1.0 + random.j() * 2.0), floor1 = MathHelper.c(this.a.dR() + random.j() * 2.0), floor2 = MathHelper.c(this.a.dV() - 1.0 + random.j() * 2.0)));
            if (blockState == null) {
                return;
            }
            BlockPosition blockPos1 = blockPos.e();
            IBlockData blockState1 = level.a_(blockPos1);
            IBlockData carriedBlock = this.a.gQ();
            if (carriedBlock != null && this.a(level, blockPos, carriedBlock = Block.b(carriedBlock, (GeneratorAccess)this.a.ao(), blockPos), blockState, blockState1, blockPos1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos, carriedBlock)) {
                level.a(blockPos, carriedBlock, 3);
                level.a(GameEvent.i, blockPos, GameEvent.a.a(this.a, carriedBlock));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World level, BlockPosition destinationPos, IBlockData carriedState, IBlockData destinationState, IBlockData belowDestinationState, BlockPosition belowDestinationPos) {
            return destinationState.l() && !belowDestinationState.l() && !belowDestinationState.a(Blocks.I) && belowDestinationState.m(level, belowDestinationPos) && carriedState.a((IWorldReader)level, destinationPos) && level.a_(this.a, AxisAlignedBB.a(Vec3D.a(destinationPos))).isEmpty();
        }
    }

    static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            return this.a.gQ() == null && PathfinderGoalEndermanPickupBlock.a(this.a).U().a(GameRules.F) != false && this.a.ep().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0;
        }

        @Override
        public void a() {
            int floor2;
            int floor1;
            int floor;
            BlockPosition blockPos;
            RandomSource random = this.a.ep();
            World level = this.a.ao();
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos = new BlockPosition(floor = MathHelper.c(this.a.dP() - 2.0 + random.j() * 4.0), floor1 = MathHelper.c(this.a.dR() + random.j() * 3.0), floor2 = MathHelper.c(this.a.dV() - 2.0 + random.j() * 4.0)));
            if (blockState == null) {
                return;
            }
            Vec3D vec3 = new Vec3D((double)this.a.dO() + 0.5, (double)floor1 + 0.5, (double)this.a.dU() + 0.5);
            Vec3D vec31 = new Vec3D((double)floor + 0.5, (double)floor1 + 0.5, (double)floor2 + 0.5);
            MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(vec3, vec31, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = blockHitResult.b().equals(blockPos);
            if (blockState.a(TagsBlock.aB) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos, blockState.y().g())) {
                level.a(blockPos, false);
                level.a(GameEvent.f, blockPos, GameEvent.a.a(this.a, blockState));
                this.a.c(blockState.b().m());
            }
        }
    }

    static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        private @Nullable EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final PathfinderTargetCondition.a o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable PathfinderTargetCondition.a selector) {
            super(enderman, EntityHuman.class, 10, false, false, selector);
            this.i = enderman;
            this.o = (entity, level) -> (enderman.g((EntityHuman)entity) || enderman.a(entity, level)) && !enderman.B(entity);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = PathfinderGoalPlayerWhoLookedAtTarget.a(this.i).a(this.m.a(this.l()), this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gT();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j, PathfinderGoalPlayerWhoLookedAtTarget.a(this.i))) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.B(this.c)) {
                    return false;
                }
                if (this.n.a(PathfinderGoalPlayerWhoLookedAtTarget.a(this.i), this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.ag_() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.cq()) {
                    if (this.i.g((EntityHuman)this.c)) {
                        if (this.c.g(this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.gP();
                        }
                        this.l = 0;
                    } else if (this.c.g(this.i) > 256.0 && this.l++ >= this.a(30) && this.i.H(this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

