/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityGhast
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private static final byte b = 1;
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)type, level);
        this.cn = 5;
        this.cp = new ControllerGhast(this, false, () -> false);
    }

    @Override
    protected void D() {
        this.cs.a(5, new PathfinderGoalGhastIdleMove(this));
        this.cs.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.cs.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> Math.abs(entity.dR() - this.dR()) <= 4.0));
    }

    public boolean k() {
        return this.az.a(a);
    }

    public void x(boolean charging) {
        this.az.a(a, charging);
    }

    public int p() {
        return this.c;
    }

    public void setExplosionPower(int explosionPower) {
        this.c = explosionPower;
    }

    private static boolean i(DamageSource damageSource) {
        return damageSource.c() instanceof EntityLargeFireball && damageSource.d() instanceof EntityHuman;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.cU() && !damageSource.a(DamageTypeTags.d) || !EntityGhast.i(damageSource) && super.a(level, damageSource);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean fl() {
        return false;
    }

    @Override
    public void m(Vec3D travelVector) {
        this.a(travelVector, 0.02f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (EntityGhast.i(damageSource)) {
            super.a(level, damageSource, 1000.0f);
            return true;
        }
        return !this.a(level, damageSource) && super.a(level, damageSource, amount);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    public static AttributeProvider.Builder gL() {
        return EntityInsentient.E().a(GenericAttributes.u, 10.0).a(GenericAttributes.o, 100.0).a(GenericAttributes.j, 8.0).a(GenericAttributes.n, 0.06);
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.lY;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.ma;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.lZ;
    }

    @Override
    public float fC() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.av() != EnumDifficulty.a && random.a(20) == 0 && EntityGhast.a(entityType, level, spawnReason, pos, random);
    }

    @Override
    public int aj() {
        return 1;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("ExplosionPower", (byte)this.c);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c = input.a("ExplosionPower", (byte)1);
    }

    @Override
    public boolean dY() {
        return true;
    }

    @Override
    public double x() {
        return 10.0;
    }

    @Override
    public double w() {
        return 16.0;
    }

    public static void a(EntityInsentient mob) {
        if (mob.ag_() == null) {
            Vec3D deltaMovement = mob.dN();
            mob.v(-((float)MathHelper.d(deltaMovement.g, deltaMovement.i)) * 57.295776f);
            mob.bC = mob.ec();
        } else {
            EntityLiving target = mob.ag_();
            double d2 = 64.0;
            if (target.g(mob) < 4096.0) {
                double d1 = target.dP() - mob.dP();
                double d22 = target.dV() - mob.dV();
                mob.v(-((float)MathHelper.d(d1, d22)) * 57.295776f);
                mob.bC = mob.ec();
            }
        }
    }

    public static class ControllerGhast
    extends ControllerMove {
        private final EntityInsentient l;
        private int m;
        private final boolean n;
        private final BooleanSupplier o;

        public ControllerGhast(EntityInsentient mob, boolean careful, BooleanSupplier shouldBeStopped) {
            super(mob);
            this.l = mob;
            this.n = careful;
            this.o = shouldBeStopped;
        }

        @Override
        public void a() {
            if (this.o.getAsBoolean()) {
                this.k = ControllerMove.Operation.a;
                this.l.X();
            }
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m = this.m + this.l.ep().a(5) + 2;
                Vec3D vec3 = new Vec3D(this.e - this.l.dP(), this.f - this.l.dR(), this.g - this.l.dV());
                if (this.a(vec3)) {
                    this.l.k(this.l.dN().e(vec3.d().c(this.l.i(GenericAttributes.n) * 5.0 / 3.0)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D delta) {
            AxisAlignedBB boundingBox = this.l.dj();
            AxisAlignedBB aabb = boundingBox.c(delta);
            if (this.n) {
                for (BlockPosition blockPos : BlockPosition.a(aabb.g(1.0))) {
                    if (this.a(this.l.ao(), null, null, blockPos, false, false)) continue;
                    return false;
                }
            }
            boolean isInWater = this.l.by();
            boolean isInLava = this.l.bN();
            Vec3D vec3 = this.l.dI();
            Vec3D vec31 = vec3.e(delta);
            return IBlockAccess.a(vec3, vec31, aabb, (pos, index) -> boundingBox.b(pos) || this.a(this.l.ao(), vec3, vec31, pos, isInWater, isInLava));
        }

        private boolean a(IBlockAccess level, @Nullable Vec3D from, @Nullable Vec3D to, BlockPosition pos, boolean isInLava, boolean isInWater) {
            boolean flag1;
            boolean flag;
            IBlockData blockState = level.a_(pos);
            if (blockState.l()) {
                return true;
            }
            boolean bl = flag = from != null && to != null;
            boolean bl2 = flag ? !this.l.a(from, to, blockState.g(level, pos).a(new Vec3D(pos)).e()) : (flag1 = blockState.g(level, pos).c());
            if (!this.n) {
                return flag1;
            }
            if (blockState.a(TagsBlock.bD)) {
                return false;
            }
            Fluid fluidState = level.b_(pos);
            if (!(fluidState.c() || flag && !this.l.a(fluidState, pos, from, to))) {
                if (fluidState.a(TagsFluid.a)) {
                    return isInLava;
                }
                if (fluidState.a(TagsFluid.b)) {
                    return isInWater;
                }
            }
            return flag1;
        }
    }

    public static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private static final int a = 64;
        private final EntityInsentient b;
        private final int c;

        public PathfinderGoalGhastIdleMove(EntityInsentient ghast) {
            this(ghast, 0);
        }

        public PathfinderGoalGhastIdleMove(EntityInsentient ghast, int distanceToBlocks) {
            this.b = ghast;
            this.c = distanceToBlocks;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            double d2;
            double d1;
            ControllerMove moveControl = this.b.K();
            if (!moveControl.b()) {
                return true;
            }
            double d3 = moveControl.d() - this.b.dP();
            double d32 = d3 * d3 + (d1 = moveControl.e() - this.b.dR()) * d1 + (d2 = moveControl.f() - this.b.dV()) * d2;
            return d32 < 1.0 || d32 > 3600.0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            Vec3D suitableFlyToPosition = PathfinderGoalGhastIdleMove.a(this.b, this.c);
            this.b.K().a(suitableFlyToPosition.a(), suitableFlyToPosition.b(), suitableFlyToPosition.c(), 1.0);
        }

        public static Vec3D a(EntityInsentient mob, int distanceToBlocks) {
            BlockPosition blockPos;
            int height;
            World level = mob.ao();
            RandomSource random = mob.ep();
            Vec3D vec3 = mob.dI();
            Vec3D vec31 = null;
            for (int i2 = 0; i2 < 64; ++i2) {
                vec31 = PathfinderGoalGhastIdleMove.a(mob, vec3, random);
                if (vec31 == null || !PathfinderGoalGhastIdleMove.a(level, vec31, distanceToBlocks)) continue;
                return vec31;
            }
            if (vec31 == null) {
                vec31 = PathfinderGoalGhastIdleMove.a(vec3, random);
            }
            if ((height = level.a(HeightMap.Type.e, (blockPos = BlockPosition.a(vec31)).u(), blockPos.w())) < blockPos.v() && height > level.K_()) {
                vec31 = new Vec3D(vec31.a(), mob.dR() - Math.abs(mob.dR() - vec31.b()), vec31.c());
            }
            return vec31;
        }

        private static boolean a(World level, Vec3D pos, int distanceToBlocks) {
            if (distanceToBlocks <= 0) {
                return true;
            }
            BlockPosition blockPos = BlockPosition.a(pos);
            if (!level.a_(blockPos).l()) {
                return false;
            }
            for (EnumDirection direction : EnumDirection.values()) {
                for (int i2 = 1; i2 < distanceToBlocks; ++i2) {
                    BlockPosition blockPos1 = blockPos.a(direction, i2);
                    if (level.a_(blockPos1).l()) continue;
                    return true;
                }
            }
            return false;
        }

        private static Vec3D a(Vec3D pos, RandomSource random) {
            double d2 = pos.a() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = pos.b() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            double d22 = pos.c() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            return new Vec3D(d2, d1, d22);
        }

        private static @Nullable Vec3D a(EntityInsentient mob, Vec3D pos, RandomSource random) {
            Vec3D vec3 = PathfinderGoalGhastIdleMove.a(pos, random);
            return mob.gF() && !mob.a(vec3) ? null : vec3;
        }
    }

    public static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityInsentient a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityInsentient ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            EntityGhast.a(this.a);
        }
    }

    static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast ghast) {
            this.b = ghast;
        }

        @Override
        public boolean b() {
            return this.b.ag_() != null;
        }

        @Override
        public void d() {
            this.a = 0;
        }

        @Override
        public void e() {
            this.b.x(false);
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.b.ag_();
            if (target != null) {
                double d2 = 64.0;
                if (target.g(this.b) < 4096.0 && this.b.G(target)) {
                    World level = this.b.ao();
                    ++this.a;
                    if (this.a == 10 && !this.b.bq()) {
                        level.a(null, 1015, this.b.dK(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D viewVector = this.b.h(1.0f);
                        double d22 = target.dP() - (this.b.dP() + viewVector.g * 4.0);
                        double d3 = target.f(0.5) - (0.5 + this.b.f(0.5));
                        double d4 = target.dV() - (this.b.dV() + viewVector.i * 4.0);
                        Vec3D vec3 = new Vec3D(d22, d3, d4);
                        if (!this.b.bq()) {
                            level.a(null, 1016, this.b.dK(), 0);
                        }
                        EntityLargeFireball largeFireball = new EntityLargeFireball(level, (EntityLiving)this.b, vec3.d(), this.b.p());
                        largeFireball.f = this.b.p();
                        largeFireball.bukkitYield = largeFireball.f;
                        largeFireball.a_(this.b.dP() + viewVector.g * 4.0, this.b.f(0.5) + 0.5, largeFireball.dV() + viewVector.i * 4.0);
                        level.b(largeFireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.x(this.a > 10);
            }
        }
    }
}

