/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.squid.EntitySquid;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityGuardian
extends EntityMonster {
    protected static final int b = 80;
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.b);
    private float e;
    private float f;
    private float cv;
    private float cw;
    private float cx;
    private @Nullable EntityLiving cy;
    private int cz;
    private boolean cA;
    public @Nullable PathfinderGoalRandomStroll c;
    public PathfinderGoalGuardianAttack guardianAttackGoal;

    public EntityGuardian(EntityTypes<? extends EntityGuardian> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cn = 10;
        this.a(PathType.j, 0.0f);
        this.cp = new ControllerMoveGuardian(this);
        this.f = this.e = this.as.i();
    }

    @Override
    protected void D() {
        PathfinderGoalMoveTowardsRestriction moveTowardsRestrictionGoal = new PathfinderGoalMoveTowardsRestriction(this, 1.0);
        this.c = new PathfinderGoalRandomStroll(this, 1.0, 80);
        this.guardianAttackGoal = new PathfinderGoalGuardianAttack(this);
        this.cs.a(4, this.guardianAttackGoal);
        this.cs.a(5, moveTowardsRestrictionGoal);
        this.cs.a(7, this.c);
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityGuardian.class, 12.0f, 0.01f));
        this.cs.a(9, new PathfinderGoalRandomLookaround(this));
        this.c.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        moveTowardsRestrictionGoal.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, true, false, new EntitySelectorGuardianTargetHumanSquid(this)));
    }

    public static AttributeProvider.Builder gQ() {
        return EntityMonster.gW().a(GenericAttributes.d, 6.0).a(GenericAttributes.x, 0.5).a(GenericAttributes.u, 30.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(d, 0);
    }

    public boolean gR() {
        return this.az.a(a);
    }

    void x(boolean moving) {
        this.az.a(a, moving);
    }

    public int p() {
        return 80;
    }

    public void a(int activeAttackTargetId) {
        this.az.a(d, activeAttackTargetId);
    }

    public boolean gS() {
        return this.az.a(d) != 0;
    }

    public @Nullable EntityLiving gT() {
        if (!this.gS()) {
            return null;
        }
        if (this.ao().B_()) {
            if (this.cy != null) {
                return this.cy;
            }
            Entity entity = this.ao().a(this.az.a(d));
            if (entity instanceof EntityLiving) {
                this.cy = (EntityLiving)entity;
                return this.cy;
            }
            return null;
        }
        return this.ag_();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (d.equals(key)) {
            this.cz = 0;
            this.cy = null;
        }
    }

    @Override
    public int S() {
        return 160;
    }

    @Override
    public SoundEffect W() {
        return this.by() ? SoundEffects.ng : SoundEffects.nh;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.by() ? SoundEffects.nm : SoundEffects.nn;
    }

    @Override
    public SoundEffect fd() {
        return this.by() ? SoundEffects.nj : SoundEffects.nk;
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.c;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.b_(pos).a(TagsFluid.a) ? 10.0f + level.C(pos) : super.a(pos, level);
    }

    @Override
    public void d_() {
        if (this.cb()) {
            if (this.ao().B_()) {
                Vec3D deltaMovement;
                this.f = this.e;
                if (!this.by()) {
                    this.cv = 2.0f;
                    deltaMovement = this.dN();
                    if (deltaMovement.h > 0.0 && this.cA && !this.bq()) {
                        this.ao().a(this.dP(), this.dR(), this.dV(), this.gP(), this.dB(), 1.0f, 1.0f, false);
                    }
                    this.cA = deltaMovement.h < 0.0 && this.ao().a(this.dK().e(), this);
                } else {
                    this.cv = this.gR() ? (this.cv < 0.5f ? 4.0f : (this.cv += (0.5f - this.cv) * 0.1f)) : (this.cv += (0.125f - this.cv) * 0.2f);
                }
                this.e += this.cv;
                this.cx = this.cw;
                this.cw = !this.by() ? this.as.i() : (this.gR() ? (this.cw += (0.0f - this.cw) * 0.25f) : (this.cw += (1.0f - this.cw) * 0.06f));
                if (this.gR() && this.by()) {
                    deltaMovement = this.h(0.0f);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        this.ao().a(Particles.d, this.e(0.5) - deltaMovement.g * 1.5, this.dS() - deltaMovement.h * 1.5, this.h(0.5) - deltaMovement.i * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.gS()) {
                    EntityLiving activeAttackTarget;
                    if (this.cz < this.p()) {
                        ++this.cz;
                    }
                    if ((activeAttackTarget = this.gT()) != null) {
                        this.J().a(activeAttackTarget, 90.0f, 90.0f);
                        this.J().a();
                        double d2 = this.N(0.0f);
                        double d1 = activeAttackTarget.dP() - this.dP();
                        double d22 = activeAttackTarget.f(0.5) - this.dT();
                        double d3 = activeAttackTarget.dV() - this.dV();
                        double squareRoot = Math.sqrt(d1 * d1 + d22 * d22 + d3 * d3);
                        d1 /= squareRoot;
                        d22 /= squareRoot;
                        d3 /= squareRoot;
                        double randomDouble = this.as.j();
                        while (randomDouble < squareRoot) {
                            this.ao().a(Particles.d, this.dP() + d1 * (randomDouble += 1.8 - d2 + this.as.j() * (1.7 - d2)), this.dT() + d22 * randomDouble, this.dV() + d3 * randomDouble, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.by()) {
                this.j(300);
            } else if (this.aV()) {
                this.k(this.dN().b((this.as.i() * 2.0f - 1.0f) * 0.4f, 0.5, (this.as.i() * 2.0f - 1.0f) * 0.4f));
                this.v(this.as.i() * 360.0f);
                this.e(false);
                this.aF = true;
            }
            if (this.gS()) {
                this.v(this.bE);
            }
        }
        super.d_();
    }

    protected SoundEffect gP() {
        return SoundEffects.nl;
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.f, this.e);
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.cx, this.cw);
    }

    public float N(float partialTick) {
        return ((float)this.cz + partialTick) / (float)this.p();
    }

    public float gU() {
        return this.cz;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    public static boolean b(EntityTypes<? extends EntityGuardian> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !(random.a(20) != 0 && level.B(pos) || level.av() == EnumDifficulty.a || !EntitySpawnReason.a(spawnReason) && !level.b_(pos).a(TagsFluid.a) || !level.b_(pos.e()).a(TagsFluid.a));
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        if (!this.gR() && !damageSource.a(DamageTypeTags.w) && !damageSource.a(DamageTypes.Q) && (entity = damageSource.c()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.a(level, this.en().d(this), 2.0f);
        }
        if (this.c != null) {
            this.c.i();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int ac() {
        return 180;
    }

    @Override
    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        this.a(0.1f, travelVector);
        this.a(EnumMoveType.a, this.dN());
        this.k(this.dN().c(0.9));
        if (!this.gR() && this.ag_() == null) {
            this.k(this.dN().b(0.0, -0.005, 0.0));
        }
    }

    static class ControllerMoveGuardian
    extends ControllerMove {
        private final EntityGuardian l;

        public ControllerMoveGuardian(EntityGuardian mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !this.l.N().l()) {
                Vec3D vec3 = new Vec3D(this.e - this.l.dP(), this.f - this.l.dR(), this.g - this.l.dV());
                double len = vec3.g();
                double d2 = vec3.g / len;
                double d1 = vec3.h / len;
                double d22 = vec3.i / len;
                float f2 = (float)(MathHelper.d(vec3.i, vec3.g) * 180.0 / 3.1415927410125732) - 90.0f;
                this.l.v(this.b(this.l.ec(), f2, 90.0f));
                this.l.bC = this.l.ec();
                float f1 = (float)(this.h * this.l.i(GenericAttributes.x));
                float f22 = MathHelper.h(0.125f, this.l.fM(), f1);
                this.l.C(f22);
                double d3 = Math.sin((double)(this.l.at + this.l.aA()) * 0.5) * 0.05;
                double cos = Math.cos(this.l.ec() * ((float)Math.PI / 180));
                double sin = Math.sin(this.l.ec() * ((float)Math.PI / 180));
                double d4 = Math.sin((double)(this.l.at + this.l.aA()) * 0.75) * 0.05;
                this.l.k(this.l.dN().b(d3 * cos, d4 * (sin + cos) * 0.25 + (double)f22 * d1 * 0.1, d3 * sin));
                ControllerLook lookControl = this.l.J();
                double d5 = this.l.dP() + d2 * 2.0;
                double d6 = this.l.dT() + d1 / len;
                double d7 = this.l.dV() + d22 * 2.0;
                double wantedX = lookControl.e();
                double wantedY = lookControl.f();
                double wantedZ = lookControl.g();
                if (!lookControl.d()) {
                    wantedX = d5;
                    wantedY = d6;
                    wantedZ = d7;
                }
                this.l.J().a(MathHelper.d(0.125, wantedX, d5), MathHelper.d(0.125, wantedY, d6), MathHelper.d(0.125, wantedZ, d7), 10.0f, 40.0f);
                this.l.x(true);
            } else {
                this.l.C(0.0f);
                this.l.x(false);
            }
        }
    }

    public static class PathfinderGoalGuardianAttack
    extends PathfinderGoal {
        private final EntityGuardian a;
        public int b;
        private final boolean c;

        public PathfinderGoalGuardianAttack(EntityGuardian guardian) {
            this.a = guardian;
            this.c = guardian instanceof EntityGuardianElder;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.ag_();
            return target != null && target.cb();
        }

        @Override
        public boolean c() {
            return super.c() && (this.c || this.a.ag_() != null && this.a.g((Entity)this.a.ag_()) > 9.0);
        }

        @Override
        public void d() {
            this.b = -10;
            this.a.N().n();
            EntityLiving target = this.a.ag_();
            if (target != null) {
                this.a.J().a(target, 90.0f, 90.0f);
            }
            this.a.aF = true;
        }

        @Override
        public void e() {
            this.a.a(0);
            this.a.g((EntityLiving)null);
            this.a.c.i();
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.a.ag_();
            if (target != null) {
                this.a.N().n();
                this.a.J().a(target, 90.0f, 90.0f);
                if (!this.a.G(target)) {
                    this.a.g((EntityLiving)null);
                } else {
                    ++this.b;
                    if (this.b == 0) {
                        this.a.a(target.aA());
                        if (!this.a.bq()) {
                            this.a.ao().a((Entity)this.a, (byte)21);
                        }
                    } else if (this.b >= this.a.p()) {
                        float f2 = 1.0f;
                        if (this.a.ao().av() == EnumDifficulty.d) {
                            f2 += 2.0f;
                        }
                        if (this.c) {
                            f2 += 2.0f;
                        }
                        WorldServer serverLevel = PathfinderGoalGuardianAttack.a(this.a);
                        target.a(serverLevel, this.a.en().c((Entity)this.a, (Entity)this.a), f2);
                        this.a.c(serverLevel, (Entity)target);
                        this.a.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    static class EntitySelectorGuardianTargetHumanSquid
    implements PathfinderTargetCondition.a {
        private final EntityGuardian a;

        public EntitySelectorGuardianTargetHumanSquid(EntityGuardian guardian) {
            this.a = guardian;
        }

        @Override
        public boolean test(@Nullable EntityLiving entity, WorldServer level) {
            return (entity instanceof EntityHuman || entity instanceof EntitySquid || entity instanceof Axolotl) && entity.g(this.a) > 9.0;
        }
    }
}

