/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.gamerules.GameRules;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    protected EntityMonster(EntityTypes<? extends EntityMonster> type, World level) {
        super((EntityTypes<? extends EntityCreature>)type, level);
        this.cn = 5;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    public void d_() {
        this.fv();
        this.gV();
        super.d_();
    }

    protected void gV() {
        float lightLevelDependentMagicValue = this.bO();
        if (lightLevelDependentMagicValue > 0.5f) {
            this.bK += 2;
        }
    }

    @Override
    public SoundEffect bk() {
        return SoundEffects.oX;
    }

    @Override
    public SoundEffect bl() {
        return SoundEffects.oW;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.oU;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.oT;
    }

    @Override
    public EntityLiving.a fj() {
        return new EntityLiving.a(SoundEffects.oV, SoundEffects.oS);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return -level.C(pos);
    }

    public static boolean a(WorldAccess level, BlockPosition pos, RandomSource random) {
        if (level.a(EnumSkyBlock.a, pos) > random.a(32)) {
            return false;
        }
        DimensionManager dimensionType = level.F_();
        int i2 = level.a().paperConfig().entities.spawning.monsterSpawnMaxLightLevel.or(dimensionType.b());
        if (i2 < 15 && level.a(EnumSkyBlock.b, pos) > i2) {
            return false;
        }
        int i1 = level.a().an() ? level.c(pos, 10) : level.G(pos);
        return i1 <= dimensionType.a().a(random);
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.av() != EnumDifficulty.a && (EntitySpawnReason.b(spawnReason) || EntityMonster.a(level, pos, random)) && EntityMonster.a(entityType, level, spawnReason, pos, random);
    }

    public static boolean c(EntityTypes<? extends EntityMonster> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.av() != EnumDifficulty.a && EntityMonster.a(entityType, level, spawnReason, pos, random);
    }

    public static boolean b(EntityTypes<? extends EntityInsentient> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return EntityMonster.a(entityType, level, spawnReason, pos, random) && (EntitySpawnReason.a(spawnReason) || level.k(pos));
    }

    public static AttributeProvider.Builder gW() {
        return EntityInsentient.E().a(GenericAttributes.d);
    }

    @Override
    public boolean eI() {
        return true;
    }

    @Override
    protected boolean e(WorldServer level) {
        return level.U().a(GameRules.D);
    }

    public boolean a(WorldServer level, EntityHuman player) {
        return true;
    }

    @Override
    public ItemStack d(ItemStack shootable) {
        if (shootable.h() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).c();
            ItemStack heldProjectile = ItemProjectileWeapon.a(this, supportedHeldProjectiles);
            return heldProjectile.f() ? new ItemStack(Items.pX) : heldProjectile;
        }
        return ItemStack.l;
    }
}

