/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.illager.EntityIllagerAbstract;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.Nullable;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> !(entity instanceof EntityRavager) && entity.cb();
    private static final Predicate<Entity> f = entity -> e.test((Entity)entity) && !entity.ay().equals(EntityTypes.h);
    private static final Predicate<EntityLiving> cv = livingEntity -> !(livingEntity instanceof EntityRavager) && livingEntity.cb() && livingEntity.dv();
    private static final double cw = 0.3;
    private static final double cx = 0.35;
    private static final int cy = 8356754;
    private static final float cz = 0.57254905f;
    private static final float cA = 0.5137255f;
    private static final float cB = 0.49803922f;
    public static final int a = 10;
    public static final int b = 40;
    private static final int cC = 0;
    private static final int cD = 0;
    private static final int cE = 0;
    public int cF = 0;
    public int cG = 0;
    public int cH = 0;

    public EntityRavager(EntityTypes<? extends EntityRavager> type, World level) {
        super((EntityTypes<? extends EntityRaider>)type, level);
        this.cn = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void D() {
        super.D();
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ct.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, (entity, level) -> !entity.e_()));
        this.ct.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void V() {
        boolean flag = !(this.dl() instanceof EntityInsentient) || this.dl().ay().a(TagsEntity.c);
        boolean flag1 = !(this.dz() instanceof AbstractBoat);
        this.cs.a(PathfinderGoal.Type.a, flag);
        this.cs.a(PathfinderGoal.Type.c, flag && flag1);
        this.cs.a(PathfinderGoal.Type.b, flag);
        this.cs.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder gP() {
        return EntityMonster.gW().a(GenericAttributes.u, 100.0).a(GenericAttributes.x, 0.3).a(GenericAttributes.r, 0.75).a(GenericAttributes.d, 12.0).a(GenericAttributes.e, 1.5).a(GenericAttributes.o, 32.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("AttackTick", this.cF);
        output.a("StunTick", this.cG);
        output.a("RoarTick", this.cH);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cF = input.a("AttackTick", 0);
        this.cG = input.a("StunTick", 0);
        this.cH = input.a("RoarTick", 0);
    }

    @Override
    public SoundEffect gX() {
        return SoundEffects.xQ;
    }

    @Override
    public int ae() {
        return 45;
    }

    @Override
    public void d_() {
        super.d_();
        if (this.cb()) {
            if (this.fE()) {
                this.h(GenericAttributes.x).a(0.0);
            } else {
                double d2 = this.ag_() != null ? 0.35 : 0.3;
                double baseValue = this.h(GenericAttributes.x).b();
                this.h(GenericAttributes.x).a(MathHelper.d(0.1, baseValue, d2));
            }
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.ad && serverLevel.U().a(GameRules.F).booleanValue()) {
                    boolean flag = false;
                    AxisAlignedBB aabb = this.dj().g(0.2);
                    for (BlockPosition blockPos : BlockPosition.b(MathHelper.c(aabb.a), MathHelper.c(aabb.b), MathHelper.c(aabb.c), MathHelper.c(aabb.d), MathHelper.c(aabb.e), MathHelper.c(aabb.f))) {
                        IBlockData blockState = serverLevel.a_(blockPos);
                        Block block = blockState.b();
                        if (!(block instanceof BlockLeaves) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.y().g())) continue;
                        flag = serverLevel.a(blockPos, true, this) || flag;
                    }
                    if (!flag && this.aV()) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.u();
                        } else {
                            this.t(false);
                        }
                    }
                }
            }
            if (this.cH > 0) {
                --this.cH;
                if (this.cH == 10) {
                    this.hc();
                }
            }
            if (this.cF > 0) {
                --this.cF;
            }
            if (this.cG > 0) {
                --this.cG;
                this.hb();
                if (this.cG == 0) {
                    this.a(SoundEffects.xV, 1.0f, 1.0f);
                    this.cH = 20;
                }
            }
        }
    }

    private void hb() {
        if (this.as.a(6) == 0) {
            double d2 = this.dP() - (double)this.dF() * Math.sin(this.bC * ((float)Math.PI / 180)) + (this.as.j() * 0.6 - 0.3);
            double d1 = this.dR() + (double)this.dG() - 0.3;
            double d22 = this.dV() + (double)this.dF() * Math.cos(this.bC * ((float)Math.PI / 180)) + (this.as.j() * 0.6 - 0.3);
            this.ao().a(ColorParticleOption.a(Particles.v, 0.49803922f, 0.5137255f, 0.57254905f), d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean fE() {
        return super.fE() || this.cF > 0 || this.cG > 0 || this.cH > 0;
    }

    @Override
    public boolean G(Entity entity) {
        return this.cG <= 0 && this.cH <= 0 && super.G(entity);
    }

    @Override
    protected void d(EntityLiving entity) {
        if (this.cH == 0) {
            if (this.as.j() < 0.5) {
                this.cG = 40;
                this.a(SoundEffects.xU, 1.0f, 1.0f);
                this.ao().a((Entity)this, (byte)39);
                entity.h(this);
            } else {
                this.H(entity);
            }
            entity.ah = true;
        }
    }

    private void hc() {
        World world;
        if (this.cb() && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Predicate<Entity> predicate = serverLevel.U().a(GameRules.F) != false ? e : f;
            for (EntityLiving entityLiving : this.ao().a(EntityLiving.class, this.dj().g(4.0), predicate)) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(serverLevel, this.en().b(this), 6.0f);
                }
                if (entityLiving instanceof EntityHuman) continue;
                this.H(entityLiving);
            }
            this.c(GameEvent.u);
            serverLevel.a((Entity)this, (byte)69);
        }
    }

    private void hl() {
        for (EntityLiving livingEntity : this.ao().a(EntityLiving.class, this.dj().g(4.0), cv)) {
            this.H(livingEntity);
        }
    }

    private void H(Entity entity) {
        double d2 = entity.dP() - this.dP();
        double d1 = entity.dV() - this.dV();
        double max = Math.max(d2 * d2 + d1 * d1, 0.001);
        entity.push(d2 / max * 4.0, 0.2, d1 / max * 4.0, this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cF = 10;
            this.a(SoundEffects.xP, 1.0f, 1.0f);
        } else if (id == 39) {
            this.cG = 40;
        } else if (id == 69) {
            this.hm();
            this.hl();
        }
        super.b(id);
    }

    private void hm() {
        Vec3D center = this.dj().f();
        for (int i2 = 0; i2 < 40; ++i2) {
            double d2 = this.as.k() * 0.2;
            double d1 = this.as.k() * 0.2;
            double d22 = this.as.k() * 0.2;
            this.ao().a(Particles.af, center.g, center.h, center.i, d2, d1, d22);
        }
    }

    public int gY() {
        return this.cF;
    }

    public int gZ() {
        return this.cG;
    }

    public int ha() {
        return this.cH;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        this.cF = 10;
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.xP, 1.0f, 1.0f);
        return super.c(level, target);
    }

    @Override
    public @Nullable SoundEffect W() {
        return SoundEffects.xO;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.xS;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.xR;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.xT, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader level) {
        return !level.d(this.dj());
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
    }

    @Override
    public boolean k() {
        return false;
    }

    @Override
    protected AxisAlignedBB j(double horizontalExpansion) {
        AxisAlignedBB aabb = super.j(horizontalExpansion);
        return aabb.f(0.05, 0.0, 0.05);
    }
}

