/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class EntityShulker
extends EntityGolem
implements IMonster {
    private static final MinecraftKey d = MinecraftKey.b("covered");
    private static final AttributeModifier e = new AttributeModifier(d, 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> a = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.q);
    protected static final DataWatcherObject<Byte> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int f = 6;
    private static final byte cv = 16;
    private static final byte cw = 16;
    private static final int cx = 8;
    private static final int cy = 8;
    private static final int cz = 5;
    private static final float cA = 0.05f;
    private static final byte cB = 0;
    private static final EnumDirection cC = EnumDirection.a;
    static final Vector3f cD = SystemUtils.a(() -> {
        BaseBlockPosition unitVec3i = EnumDirection.d.q();
        return new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
    });
    private static final float cE = 3.0f;
    private float cF;
    private float cG;
    private @Nullable BlockPosition cH;
    private int cI;
    private static final float cJ = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> type, World level) {
        super((EntityTypes<? extends EntityGolem>)type, level);
        this.cn = 5;
        this.co = new d(this);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.cs.a(4, new a());
        this.cs.a(7, new f());
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.ct.a(2, new e(this));
        this.ct.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.zS;
    }

    @Override
    public void T() {
        if (!this.gV()) {
            super.T();
        }
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.zY;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.gV() ? SoundEffects.Aa : SoundEffects.zZ;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, cC);
        builder.a(b, (byte)0);
        builder.a(c, (byte)16);
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.u, 30.0);
    }

    @Override
    protected EntityAIBodyControl I() {
        return new b(this);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("AttachFace", EnumDirection.k).orElse(cC));
        this.az.a(b, input.a("Peek", (byte)0));
        this.az.a(c, input.a("Color", (byte)16));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("AttachFace", EnumDirection.k, this.gP());
        output.a("Peek", this.az.a(b));
        output.a("Color", this.az.a(c));
    }

    @Override
    public void g() {
        super.g();
        if (!(this.ao().B_() || this.cq() || this.a(this.dK(), this.gP()))) {
            this.gS();
        }
        if (this.gT()) {
            this.gU();
        }
        if (this.ao().B_()) {
            if (this.cI > 0) {
                --this.cI;
            } else {
                this.cH = null;
            }
        }
    }

    private void gS() {
        EnumDirection direction = this.h(this.dK());
        if (direction != null) {
            this.a(direction);
        } else {
            this.p();
        }
    }

    @Override
    protected AxisAlignedBB c(Vec3D position) {
        float physicalPeek = EntityShulker.N(this.cG);
        EnumDirection opposite = this.gP().g();
        return EntityShulker.a(this.eF(), opposite, physicalPeek, position);
    }

    private static float N(float peek) {
        return 0.5f - MathHelper.a((double)((0.5f + peek) * (float)Math.PI)) * 0.5f;
    }

    private boolean gT() {
        this.cF = this.cG;
        float f2 = (float)this.gX() * 0.01f;
        if (this.cG == f2) {
            return false;
        }
        this.cG = this.cG > f2 ? MathHelper.a(this.cG - 0.05f, f2, 1.0f) : MathHelper.a(this.cG + 0.05f, 0.0f, f2);
        return true;
    }

    private void gU() {
        this.aH();
        float physicalPeek = EntityShulker.N(this.cG);
        float physicalPeek1 = EntityShulker.N(this.cF);
        EnumDirection opposite = this.gP().g();
        float f2 = (physicalPeek - physicalPeek1) * this.eF();
        if (!(f2 <= 0.0f)) {
            for (Entity entity : this.ao().a((Entity)this, EntityShulker.a(this.eF(), opposite, physicalPeek1, physicalPeek, this.dI()), IEntitySelector.f.and(entity1 -> !entity1.A(this)))) {
                if (entity instanceof EntityShulker || entity.ar) continue;
                entity.a(EnumMoveType.e, new Vec3D(f2 * (float)opposite.j(), f2 * (float)opposite.k(), f2 * (float)opposite.l()));
            }
        }
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float peek, Vec3D position) {
        return EntityShulker.a(scale, expansionDirection, -1.0f, peek, position);
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float currentPeek, float oldPeek, Vec3D position) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-scale) * 0.5, 0.0, (double)(-scale) * 0.5, (double)scale * 0.5, scale, (double)scale * 0.5);
        double d2 = Math.max(currentPeek, oldPeek);
        double d1 = Math.min(currentPeek, oldPeek);
        AxisAlignedBB aabb1 = aabb.b((double)expansionDirection.j() * d2 * (double)scale, (double)expansionDirection.k() * d2 * (double)scale, (double)expansionDirection.l() * d2 * (double)scale).a((double)(-expansionDirection.j()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.k()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.l()) * (1.0 + d1) * (double)scale);
        return aabb1.d(position.g, position.h, position.i);
    }

    @Override
    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        if (this.ao().B_()) {
            this.cH = null;
            this.cI = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force, triggerEvents);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        if (this.ao().B_()) {
            this.cH = this.dK();
        }
        this.bD = 0.0f;
        this.bC = 0.0f;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.v(0.0f);
        this.bE = this.ec();
        this.bP();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (type == EnumMoveType.d) {
            this.p();
        } else {
            super.a(type, movement);
        }
    }

    @Override
    public Vec3D dN() {
        return Vec3D.c;
    }

    @Override
    public void k(Vec3D deltaMovement) {
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        BlockPosition blockPos1;
        BlockPosition blockPos = this.dK();
        if (this.cq()) {
            super.a_(x2, y2, z2);
        } else {
            super.a_((double)MathHelper.c(x2) + 0.5, MathHelper.c(y2 + 0.5), (double)MathHelper.c(z2) + 0.5);
        }
        if (this.at != 0 && !(blockPos1 = this.dK()).equals(blockPos)) {
            this.az.a(b, (byte)0);
            this.aF = true;
            if (this.ao().B_() && !this.cq() && !blockPos1.equals(this.cH)) {
                this.cH = blockPos;
                this.cI = 6;
                this.ao = this.dP();
                this.ap = this.dR();
                this.aq = this.dV();
            }
        }
    }

    protected @Nullable EnumDirection h(BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            if (!this.a(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection facing) {
        if (this.i(pos)) {
            return false;
        }
        EnumDirection opposite = facing.g();
        if (!this.ao().a(pos.a(facing), this, opposite)) {
            return false;
        }
        AxisAlignedBB aabb = EntityShulker.a(this.eF(), opposite, 1.0f, pos.c()).h(1.0E-6);
        return this.ao().a((Entity)this, aabb);
    }

    private boolean i(BlockPosition pos) {
        IBlockData blockState = this.ao().a_(pos);
        if (blockState.l()) {
            return false;
        }
        boolean flag = blockState.a(Blocks.ca) && pos.equals(this.dK());
        return !flag;
    }

    protected boolean p() {
        if (!this.gG() && this.cb()) {
            BlockPosition blockPos = this.dK();
            for (int i2 = 0; i2 < 5; ++i2) {
                BlockPosition blockPos1 = blockPos.b(MathHelper.b(this.as, -8, 8), MathHelper.b(this.as, -8, 8), MathHelper.b(this.as, -8, 8));
                if (blockPos1.v() <= this.ao().K_() || !this.ao().A(blockPos1) || !this.ao().w().a(blockPos1) || !this.ao().a((Entity)this, new AxisAlignedBB(blockPos1).h(1.0E-6))) continue;
                EnumDirection direction = this.h(blockPos1);
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockPos1.u(), blockPos1.v(), blockPos1.w());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockPos1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                if (direction == null) continue;
                this.aw();
                this.a(direction);
                this.a(SoundEffects.Ad, 1.0f, 1.0f);
                this.a_((double)blockPos1.u() + 0.5, blockPos1.v(), (double)blockPos1.w() + 0.5);
                this.ao().a(GameEvent.R, blockPos, GameEvent.a.a(this));
                this.az.a(b, (byte)0);
                this.g((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InterpolationHandler l_() {
        return null;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.gV() && (directEntity = damageSource.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        if ((double)this.eZ() < (double)this.fq() * 0.5 && this.as.a(4) == 0) {
            this.p();
        } else if (damageSource.a(DamageTypeTags.j) && (directEntity = damageSource.c()) != null && directEntity.ay() == EntityTypes.bl) {
            this.gW();
        }
        return true;
    }

    private boolean gV() {
        return this.gX() == 0;
    }

    private void gW() {
        Vec3D vec3 = this.dI();
        AxisAlignedBB boundingBox = this.dj();
        if (!this.gV() && this.p()) {
            EntityShulker shulker;
            int size = this.ao().a(EntityTypes.bk, boundingBox.g(8.0), Entity::cb).size();
            float f2 = (float)(size - 1) / 5.0f;
            if (!(this.ao().y.i() < f2) && (shulker = EntityTypes.bk.a(this.ao(), EntitySpawnReason.e)) != null) {
                shulker.a(this.gQ());
                shulker.f(vec3);
                if (!new ShulkerDuplicateEvent((Shulker)shulker.getBukkitEntity(), (Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.ao().addFreshEntity(shulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return this.cb();
    }

    public EnumDirection gP() {
        return this.az.a(a);
    }

    public void a(EnumDirection attachFace) {
        this.az.a(a, attachFace);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key)) {
            this.a(this.aG());
        }
        super.a(key);
    }

    public int gX() {
        return this.az.a(b).byteValue();
    }

    public void a(int peekAmount) {
        if (!this.ao().B_()) {
            this.h(GenericAttributes.b).c(d);
            if (peekAmount == 0) {
                this.h(GenericAttributes.b).d(e);
                this.a(SoundEffects.zX, 1.0f, 1.0f);
                this.c(GameEvent.j);
            } else {
                this.a(SoundEffects.Ab, 1.0f, 1.0f);
                this.c(GameEvent.k);
            }
        }
        this.az.a(b, (byte)peekAmount);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cF, this.cG);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.bC = 0.0f;
        this.bD = 0.0f;
    }

    @Override
    public int ac() {
        return 180;
    }

    @Override
    public int ae() {
        return 180;
    }

    @Override
    public void h(Entity entity) {
    }

    public @Nullable Vec3D M(float partialTick) {
        if (this.cH != null && this.cI > 0) {
            double d2 = (double)((float)this.cI - partialTick) / 6.0;
            d2 *= d2;
            BlockPosition blockPos = this.dK();
            double d1 = (double)(blockPos.u() - this.cH.u()) * (d2 *= (double)this.eF());
            double d22 = (double)(blockPos.v() - this.cH.v()) * d2;
            double d3 = (double)(blockPos.w() - this.cH.w()) * d2;
            return new Vec3D(-d1, -d22, -d3);
        }
        return null;
    }

    @Override
    protected float c(float scale) {
        return Math.min(scale, 3.0f);
    }

    private void a(Optional<EnumColor> variant) {
        this.az.a(c, variant.map(color -> (byte)color.a()).orElse((byte)16));
    }

    public Optional<EnumColor> gQ() {
        return Optional.ofNullable(this.gR());
    }

    public @Nullable EnumColor gR() {
        byte b2 = this.az.a(c);
        return b2 != 16 && b2 <= 15 ? EnumColor.a(b2) : null;
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.ba ? EntityShulker.c(component, this.gR()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.ba);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.ba) {
            this.a(Optional.of(EntityShulker.c(DataComponents.ba, value)));
            return true;
        }
        return super.b(component, value);
    }

    class d
    extends ControllerLook {
        public d(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection opposite = EntityShulker.this.gP().g();
            Vector3f vector3f = opposite.b().transform(new Vector3f((Vector3fc)cD));
            BaseBlockPosition unitVec3i = opposite.q();
            Vector3f vector3f1 = new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d2 = this.e - this.a.dP();
            double d1 = this.f - this.a.dT();
            double d22 = this.g - this.a.dV();
            Vector3f vector3f2 = new Vector3f((float)d2, (float)d1, (float)d22);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return !(Math.abs(f2) > 1.0E-5f) && !(Math.abs(f1) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 180.0 / 3.1415927410125732)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityShulker.this.ag_();
            return target != null && target.cb() && EntityShulker.this.ao().av() != EnumDifficulty.a;
        }

        @Override
        public void d() {
            this.b = 20;
            EntityShulker.this.a(100);
        }

        @Override
        public void e() {
            EntityShulker.this.a(0);
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityShulker.this.ao().av() != EnumDifficulty.a) {
                --this.b;
                EntityLiving target = EntityShulker.this.ag_();
                if (target != null) {
                    EntityShulker.this.J().a(target, 180.0f, 180.0f);
                    double d2 = EntityShulker.this.g((Entity)target);
                    if (d2 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.as.a(10) * 20 / 2;
                            EntityShulker.this.ao().b(new EntityShulkerBullet(EntityShulker.this.ao(), EntityShulker.this, target, EntityShulker.this.gP().o()));
                            EntityShulker.this.a(SoundEffects.Ac, 2.0f, (EntityShulker.this.as.i() - EntityShulker.this.as.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean b() {
            return EntityShulker.this.ag_() == null && EntityShulker.this.as.a(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dK(), EntityShulker.this.gP());
        }

        @Override
        public boolean c() {
            return EntityShulker.this.ag_() == null && this.b > 0;
        }

        @Override
        public void d() {
            this.b = this.a(20 * (1 + EntityShulker.this.as.a(3)));
            EntityShulker.this.a(30);
        }

        @Override
        public void e() {
            if (EntityShulker.this.ag_() == null) {
                EntityShulker.this.a(0);
            }
        }

        @Override
        public void a() {
            --this.b;
        }
    }

    class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker shulker) {
            super((EntityInsentient)shulker, EntityHuman.class, true);
        }

        @Override
        public boolean b() {
            return EntityShulker.this.ao().av() != EnumDifficulty.a && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).gP();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.dj().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.dj().c(targetDistance, targetDistance, 4.0) : this.e.dj().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, (entity, level) -> entity instanceof IMonster);
        }

        @Override
        public boolean b() {
            return this.e.cI() != null && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).gP();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.dj().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.dj().c(targetDistance, targetDistance, 4.0) : this.e.dj().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
        }
    }
}

