/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntitySilverfish
extends EntityMonster {
    private @Nullable PathfinderGoalSilverfishWakeOthers a;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
    }

    @Override
    protected void D() {
        this.a = new PathfinderGoalSilverfishWakeOthers(this);
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.ao()));
        this.cs.a(3, this.a);
        this.cs.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cs.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 8.0).a(GenericAttributes.x, 0.25).a(GenericAttributes.d, 1.0);
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.c;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.Ae;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.Ag;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Af;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.Ah, 0.15f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if ((damageSource.d() != null || damageSource.a(DamageTypeTags.x)) && this.a != null) {
            this.a.h();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public void g() {
        this.bC = this.ec();
        super.g();
    }

    @Override
    public void s(float offset) {
        this.v(offset);
        super.s(offset);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return BlockMonsterEggs.p(level.a_(pos.e())) ? 10.0f : super.a(pos, level);
    }

    public static boolean b(EntityTypes<EntitySilverfish> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (!EntitySilverfish.c(entityType, level, spawnReason, pos, random)) {
            return false;
        }
        if (EntitySpawnReason.a(spawnReason)) {
            return true;
        }
        EntityHuman nearestPlayer = level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
        return (nearestPlayer == null || nearestPlayer.affectsSpawning) && nearestPlayer == null;
    }

    static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish silverfish) {
            this.a = silverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean b() {
            return this.b > 0;
        }

        @Override
        public void a() {
            --this.b;
            if (this.b <= 0) {
                World level = this.a.ao();
                RandomSource random = this.a.ep();
                BlockPosition blockPos = this.a.dK();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int i1 = 0;
                    while (i1 <= 10 && i1 >= -10) {
                        int i22 = 0;
                        while (i22 <= 10 && i22 >= -10) {
                            BlockPosition blockPos1 = blockPos.b(i1, i2, i22);
                            IBlockData blockState = level.a_(blockPos1);
                            Block block = blockState.b();
                            if (block instanceof BlockMonsterEggs) {
                                IBlockData afterState;
                                IBlockData iBlockData = afterState = PathfinderGoalSilverfishWakeOthers.a(level).U().a(GameRules.F) != false ? blockState.y().g() : ((BlockMonsterEggs)block).r(level.a_(blockPos1));
                                if (CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos1, afterState)) {
                                    if (PathfinderGoalSilverfishWakeOthers.a(level).U().a(GameRules.F).booleanValue()) {
                                        level.a(blockPos1, true, this.a);
                                    } else {
                                        level.a(blockPos1, ((BlockMonsterEggs)block).r(level.a_(blockPos1)), 3);
                                    }
                                    if (random.h()) {
                                        return;
                                    }
                                }
                            }
                            i22 = (i22 <= 0 ? 1 : 0) - i22;
                        }
                        i1 = (i1 <= 0 ? 1 : 0) - i1;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        private @Nullable EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish silverfish) {
            super(silverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.b.ag_() != null) {
                return false;
            }
            if (!this.b.N().l()) {
                return false;
            }
            RandomSource random = this.b.ep();
            if (PathfinderGoalSilverfishHideInBlock.a(this.b).U().a(GameRules.F).booleanValue() && random.a(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.b(random);
                BlockPosition blockPos = BlockPosition.a(this.b.dP(), this.b.dR() + 0.5, this.b.dV()).a(this.i);
                IBlockData blockState = this.b.ao().a_(blockPos);
                if (BlockMonsterEggs.p(blockState)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.b();
        }

        @Override
        public boolean c() {
            return !this.j && super.c();
        }

        @Override
        public void d() {
            if (!this.j) {
                super.d();
            } else {
                BlockPosition blockPos;
                World levelAccessor = this.b.ao();
                IBlockData blockState = levelAccessor.a_(blockPos = BlockPosition.a(this.b.dP(), this.b.dR() + 0.5, this.b.dV()).a(this.i));
                if (BlockMonsterEggs.p(blockState)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(this.b, blockPos, BlockMonsterEggs.q(blockState))) {
                        return;
                    }
                    levelAccessor.a(blockPos, BlockMonsterEggs.q(blockState), 3);
                    this.b.U();
                    this.b.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
                }
            }
        }
    }
}

