/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.jspecify.annotations.Nullable;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> cu = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean cv = false;
    public float d;
    public float e;
    public float f;
    private boolean cw = false;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)type, level);
        this.df();
        this.cp = new ControllerMoveSlime(this);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.cs.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.cs.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.cs.a(5, new PathfinderGoalSlimeIdle(this));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> Math.abs(entity.dR() - this.dR()) <= 4.0));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cu, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean resetHealth) {
        int i2 = MathHelper.a(size, 1, 127);
        this.az.a(cu, i2);
        this.aH();
        this.j_();
        this.h(GenericAttributes.u).a(i2 * i2);
        this.h(GenericAttributes.x).a(0.2f + 0.1f * (float)i2);
        this.h(GenericAttributes.d).a(i2);
        if (resetHealth) {
            this.x(this.fq());
        }
        this.cn = i2;
    }

    public int gR() {
        return this.az.a(cu);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Size", this.gR() - 1);
        output.a("wasOnGround", this.cw);
        output.a("Paper.canWander", this.canWander);
    }

    @Override
    protected void a(ValueInput input) {
        this.a(input.a("Size", 0) + 1, false);
        super.a(input);
        this.cw = input.a("wasOnGround", false);
        this.canWander = input.a("Paper.canWander", true);
    }

    public boolean gS() {
        return this.gR() <= 1;
    }

    protected ParticleParam p() {
        return Particles.Y;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aV() && !this.cw) {
            float f2 = this.a(this.aF()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.as.i() * ((float)Math.PI * 2);
                float f3 = this.as.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a((double)f22) * f1 * f3;
                float f5 = MathHelper.b((double)f22) * f1 * f3;
                this.ao().a(this.p(), this.dP() + (double)f4, this.dR(), this.dV() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gP(), this.fC(), ((this.as.i() - this.as.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aV() && this.cw) {
            this.d = 1.0f;
        }
        this.cw = this.aV();
        this.gM();
    }

    protected void gM() {
        this.d *= 0.6f;
    }

    protected int gL() {
        return this.as.a(20) + 10;
    }

    @Override
    public void j_() {
        double x2 = this.dP();
        double y2 = this.dR();
        double z2 = this.dV();
        super.j_();
        this.a_(x2, y2, z2);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cu.equals(key)) {
            this.j_();
            this.v(this.bE);
            this.bC = this.bE;
            if (this.by() && this.as.a(20) == 0) {
                this.bI();
            }
        }
        super.a(key);
    }

    public EntityTypes<? extends EntitySlime> ay() {
        return super.ay();
    }

    @Override
    public void remove(Entity.RemovalReason reason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause eventCause) {
        int size = this.gR();
        if (!this.ao().B_() && size > 1 && this.fa()) {
            float width = this.a(this.aF()).a();
            float f2 = width / 2.0f;
            int i2 = size / 2;
            int i1 = 2 + this.as.a(3);
            ScoreboardTeam team = this.cI();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), i1);
            if (!event.callEvent() || event.getCount() <= 0) {
                super.remove(reason, eventCause);
                return;
            }
            i1 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(i1);
            for (int i22 = 0; i22 < i1; ++i22) {
                float f1 = ((float)(i22 % 2) - 0.5f) * f2;
                float f22 = ((float)(i22 / 2) - 0.5f) * f2;
                EntitySlime converted = this.convertTo(this.ay(), new ConversionParams(ConversionType.b, false, false, team), EntitySpawnReason.k, (T mob) -> {
                    mob.a(i2, true);
                    mob.b(this.dP() + (double)f1, this.dR() + 0.5, this.dV() + (double)f22, this.as.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (!slimes.isEmpty() && CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(reason, eventCause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.ao().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(reason, eventCause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gN()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        if (this.gN()) {
            this.i(entity);
        }
    }

    protected void i(EntityLiving livingEntity) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            DamageSource damageSource;
            WorldServer serverLevel = (WorldServer)world;
            if (this.cb() && this.h(livingEntity) && this.G(livingEntity) && livingEntity.a(serverLevel, damageSource = this.en().b(this), this.gO())) {
                this.a(SoundEffects.Aw, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(serverLevel, (Entity)livingEntity, damageSource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return new Vec3D(0.0, (double)dimensions.b() - 0.015625 * (double)this.gR() * (double)partialTick, 0.0);
    }

    protected boolean gN() {
        return !this.gS() && this.dy();
    }

    protected float gO() {
        return (float)this.i(GenericAttributes.d);
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.gS() ? SoundEffects.By : SoundEffects.Ay;
    }

    @Override
    public SoundEffect fd() {
        return this.gS() ? SoundEffects.Bx : SoundEffects.Ax;
    }

    protected SoundEffect gP() {
        return this.gS() ? SoundEffects.BA : SoundEffects.AA;
    }

    public static boolean c(EntityTypes<EntitySlime> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (level.av() != EnumDifficulty.a) {
            if (EntitySpawnReason.a(spawnReason)) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
            double maxHeightSwamp = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (level.z(pos).a(BiomeTags.an) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp) {
                float value = level.ad().a(EnvironmentAttributes.M, pos).floatValue();
                if (random.i() < value && level.G(pos) <= random.a(8)) {
                    return EntitySlime.a(entityType, level, spawnReason, pos, random);
                }
            }
            if (!(level instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
            boolean flag = level.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkPos.h, chunkPos.i, ((GeneratorAccessSeed)level).J(), level.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float fC() {
        return 0.4f * (float)this.gR();
    }

    @Override
    public int ac() {
        return 0;
    }

    protected boolean gT() {
        return this.gR() > 0;
    }

    @Override
    public void u() {
        Vec3D deltaMovement = this.dN();
        this.m(deltaMovement.g, this.fF(), deltaMovement.i);
        this.aF = true;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        int randomInt = random.a(3);
        if (randomInt < 2 && random.i() < 0.5f * difficulty.d()) {
            ++randomInt;
        }
        int i2 = 1 << randomInt;
        this.a(i2, true);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    float k() {
        float f2 = this.gS() ? 1.4f : 0.8f;
        return ((this.as.i() - this.as.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gQ() {
        return this.gS() ? SoundEffects.Bz : SoundEffects.Az;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return super.b(pose).a(this.gR());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime mob) {
            super(mob);
            this.n = mob;
            this.l = 180.0f * mob.ec() / (float)Math.PI;
        }

        public void a(float yRot, boolean aggressive) {
            this.l = yRot;
            this.o = aggressive;
        }

        public void a(double speedModifier) {
            this.h = speedModifier;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.v(this.b(this.d.ec(), this.l, 90.0f));
            this.d.bE = this.d.ec();
            this.d.bC = this.d.ec();
            if (this.k != ControllerMove.Operation.b) {
                this.d.I(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aV()) {
                    this.d.C((float)(this.h * this.d.i(GenericAttributes.x)));
                    if (this.m-- <= 0) {
                        this.m = this.n.gL();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.L().a();
                        if (this.n.gT()) {
                            this.n.a(this.n.gQ(), this.n.fC(), this.n.k());
                        }
                    } else {
                        this.n.bN = 0.0f;
                        this.n.bP = 0.0f;
                        this.d.C(0.0f);
                    }
                } else {
                    this.d.C((float)(this.h * this.d.i(GenericAttributes.x)));
                }
            }
        }
    }

    static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.N().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.by() || this.a.bN()) && this.a.K() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            if (this.a.ep().i() < 0.8f) {
                this.a.L().a();
            }
            if ((controllerMove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(1.2);
            }
        }
    }

    static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.ag_();
            if (target == null || !target.cb()) {
                return false;
            }
            if (!this.a.c(target)) {
                return false;
            }
            return this.a.K() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)target.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving target = this.a.ag_();
            if (target == null || !target.cb()) {
                return false;
            }
            if (!this.a.c(target)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)target.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            EntityLiving target = this.a.ag_();
            if (target != null) {
                this.a.a((Entity)target, 10.0f, 10.0f);
            }
            if ((controllerMove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(this.a.ec(), this.a.gN());
            }
        }

        @Override
        public void e() {
            this.b = 0;
            this.a.g((EntityLiving)null);
        }
    }

    static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.ag_() == null && this.a.canWander && (this.a.aV() || this.a.by() || this.a.bN() || this.a.d(MobEffects.y)) && this.a.K() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ep().a(60));
                this.b = this.a.ep().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllerMove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(this.b, false);
            }
        }
    }

    static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.cq() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void a() {
            ControllerMove controllerMove = this.a.K();
            if (controllerMove instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(1.0);
            }
        }
    }
}

