/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey cv = MinecraftKey.b("suffocating");
    private static final AttributeModifier cw = new AttributeModifier(cv, -0.34f, AttributeModifier.Operation.b);
    private static final float cx = 0.35f;
    private static final float cz = 0.55f;
    private static final DataWatcherObject<Integer> cA = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cC;
    private @Nullable PathfinderGoalTempt cD;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cC = new SaddleStorage(this.az, cA);
        this.W = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        do {
            mutableBlockPos.c(EnumDirection.b);
        } while (level.b_(mutableBlockPos).a(TagsFluid.b));
        return level.a_(mutableBlockPos).l();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cA.equals(key) && this.ao().B_()) {
            this.cC.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cA, 0);
        builder.a(cB, false);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.cb() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.Bw : super.a(slot, stack, equippable);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalPanic(this, 1.65));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cD = new PathfinderGoalTempt(this, 1.4, itemStack -> itemStack.a(TagsItem.bd), false);
        this.cs.a(3, this.cD);
        this.cs.a(4, new a(this, 1.0));
        this.cs.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.cs.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.cs.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void x(boolean suffocating) {
        this.az.a(cB, suffocating);
        AttributeModifiable attribute = this.h(GenericAttributes.x);
        if (attribute != null) {
            if (suffocating) {
                attribute.a(cw);
            } else {
                attribute.c(cv);
            }
        }
    }

    public boolean p() {
        return this.az.a(cB);
    }

    @Override
    public boolean a(Fluid fluidState) {
        return fluidState.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        if (!this.ao().B_()) {
            return super.a(entity, dimensions, partialTick);
        }
        float min = Math.min(0.25f, this.bB.b());
        float f2 = this.bB.c();
        float f1 = 0.12f * MathHelper.b((double)(f2 * 1.5f)) * 2.0f * min;
        return super.a(entity, dimensions, partialTick).b(0.0, f1 * partialTick, 0.0);
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityHuman player;
        Entity entity;
        return this.al() && (entity = this.do()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.po) ? player : super.dl();
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D[] vec3s = new Vec3D[]{EntityStrider.a(this.dF(), (double)livingEntity.dF(), livingEntity.ec()), EntityStrider.a(this.dF(), (double)livingEntity.dF(), livingEntity.ec() - 22.5f), EntityStrider.a(this.dF(), (double)livingEntity.dF(), livingEntity.ec() + 22.5f), EntityStrider.a(this.dF(), (double)livingEntity.dF(), livingEntity.ec() - 45.0f), EntityStrider.a(this.dF(), (double)livingEntity.dF(), livingEntity.ec() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d2 = this.dj().e;
        double d1 = this.dj().b - 0.5;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (Vec3D vec3 : vec3s) {
            mutableBlockPos.b(this.dP() + vec3.g, d2, this.dV() + vec3.i);
            for (double d22 = d2; d22 > d1; d22 -= 1.0) {
                set.add(mutableBlockPos.j());
                mutableBlockPos.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockPos : set) {
            double blockFloorHeight;
            if (this.ao().b_(blockPos).a(TagsFluid.b) || !DismountUtil.a(blockFloorHeight = this.ao().m(blockPos))) continue;
            Vec3D vec31 = Vec3D.a(blockPos, blockFloorHeight);
            for (EntityPose pose : livingEntity.go()) {
                AxisAlignedBB localBoundsForPose = livingEntity.f(pose);
                if (!DismountUtil.a(this.ao(), livingEntity, localBoundsForPose.c(vec31))) continue;
                livingEntity.c(pose);
                return vec31;
            }
        }
        return new Vec3D(this.dP(), this.dj().e, this.dV());
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        this.a(player.ec(), player.ee() * 0.5f);
        this.bC = this.bE = this.ec();
        this.ab = this.bE;
        this.cC.b();
        super.a(player, travelVector);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman player) {
        return (float)(this.i(GenericAttributes.x) * (double)(this.p() ? 0.35f : 0.55f) * (double)this.cC.c());
    }

    @Override
    protected float bj() {
        return this.al + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.bN() ? SoundEffects.Bu : SoundEffects.Bt, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cC.a(this.ep());
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.bN()) {
            this.l();
        } else {
            super.a(y2, onGround, state, pos);
        }
    }

    @Override
    public void g() {
        if (this.gQ() && this.as.a(140) == 0) {
            this.b(SoundEffects.Bp);
        } else if (this.gM() && this.as.a(60) == 0) {
            this.b(SoundEffects.Bq);
        }
        if (!this.gG()) {
            boolean suffocating;
            EntityStrider strider;
            IBlockData blockState = this.ao().a_(this.dK());
            IBlockData blockStateOnLegacy = this.bJ();
            boolean flag = blockState.a(TagsBlock.bg) || blockStateOnLegacy.a(TagsBlock.bg) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.dz();
            boolean flag1 = entity instanceof EntityStrider && (strider = (EntityStrider)entity).p();
            boolean bl = suffocating = !flag || flag1;
            if (suffocating ^ this.p() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.x(suffocating);
            }
        }
        super.g();
        this.gR();
    }

    private boolean gQ() {
        return this.cD != null && this.cD.k();
    }

    @Override
    protected boolean F() {
        return true;
    }

    private void gR() {
        if (this.bN()) {
            VoxelShapeCollision collisionContext = VoxelShapeCollision.a(this);
            if (collisionContext.a(BlockFluids.d, this.dK(), true) && !this.ao().b_(this.dK().d()).a(TagsFluid.b)) {
                this.e(true);
            } else {
                this.k(this.dN().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder gP() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.175f);
    }

    @Override
    public @Nullable SoundEffect W() {
        return !this.gM() && !this.gQ() ? SoundEffects.Bo : null;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.Bs;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Br;
    }

    @Override
    protected boolean s(Entity passenger) {
        return !this.cr() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fR() {
        return true;
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new b(this, level);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (level.a_(pos).y().a(TagsFluid.b)) {
            return 10.0f;
        }
        return this.bN() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    public @Nullable EntityStrider b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bB.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.bc);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.j(player.b(hand));
        if (!isFood && this.al() && !this.cr() && !player.gA()) {
            if (!this.ao().B_()) {
                player.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return this.a(itemInHand, EnumItemSlot.h) ? itemInHand.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        if (isFood && !this.bq()) {
            this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.Bv, this.dB(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        return interactionResult;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (this.e_()) {
            return super.a(level, difficulty, spawnReason, spawnGroupData);
        }
        RandomSource random = level.G_();
        if (random.a(30) == 0) {
            EntityInsentient mob = EntityTypes.ca.a(level.a(), EntitySpawnReason.g);
            if (mob != null) {
                spawnGroupData = this.a(level, difficulty, mob, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(random), false));
                mob.a(EnumItemSlot.a, new ItemStack(Items.po));
                this.a(EnumItemSlot.h, new ItemStack(Items.oR));
                this.g(EnumItemSlot.h);
            }
        } else if (random.a(10) == 0) {
            EntityAgeable ageableMob = EntityTypes.bB.a(level.a(), EntitySpawnReason.g);
            if (ageableMob != null) {
                ageableMob.d_(-24000);
                spawnGroupData = this.a(level, difficulty, ageableMob, null);
            }
        } else {
            spawnGroupData = new EntityAgeable.a(0.5f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntityInsentient jockey, @Nullable GroupDataEntity spawnData) {
        jockey.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
        jockey.a(level, difficulty, EntitySpawnReason.g, spawnData);
        jockey.a((Entity)this, true, false);
        return new EntityAgeable.a(0.0f);
    }

    static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speedModifier) {
            super(strider, speedModifier, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bN() && this.a(this.g.ao(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bN() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.K) && level.a_(pos.d()).a(PathMode.a);
        }
    }

    static class b
    extends Navigation {
        b(EntityStrider strider, World level) {
            super(strider, level);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, maxVisitedNodes);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType == PathType.i || pathType == PathType.o || pathType == PathType.n || super.a(pathType);
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.K) || super.a(pos);
        }
    }
}

