/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityVex
extends EntityMonster
implements TraceableEntity {
    public static final float a = 45.836624f;
    public static final int b = MathHelper.d(3.9269907f);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityVex.class, DataWatcherRegistry.a);
    private static final int d = 1;
    public @Nullable EntityReference<EntityInsentient> e;
    private @Nullable BlockPosition f;
    public boolean cv;
    public int cw;

    public EntityVex(EntityTypes<? extends EntityVex> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cp = new c(this);
        this.cn = 3;
    }

    @Override
    public boolean bp() {
        return this.at % b == 0;
    }

    @Override
    public boolean ba() {
        return !this.eh();
    }

    @Override
    public void g() {
        this.ar = true;
        super.g();
        this.ar = false;
        this.g(true);
        if (this.cv && --this.cw <= 0) {
            this.cw = 20;
            this.a(this.en().j(), 1.0f);
        }
    }

    @Override
    protected void D() {
        super.D();
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(4, new a());
        this.cs.a(8, new d());
        this.cs.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.ct.a(2, new b(this));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 14.0).a(GenericAttributes.d, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.f = input.a("bound_pos", BlockPosition.a).orElse(null);
        input.e("life_ticks").ifPresentOrElse(this::a, () -> {
            this.cv = false;
        });
        this.e = EntityReference.a(input, "owner");
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof EntityVex) {
            EntityVex vex = (EntityVex)entity;
            this.e = vex.e;
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.b("bound_pos", BlockPosition.a, this.f);
        if (this.cv) {
            output.a("life_ticks", this.cw);
        }
        EntityReference.a(this.e, output, "owner");
    }

    public @Nullable EntityInsentient gP() {
        return EntityReference.a(this.e, this.ao(), EntityInsentient.class);
    }

    public @Nullable BlockPosition gQ() {
        return this.f;
    }

    public void h(@Nullable BlockPosition boundOrigin) {
        this.f = boundOrigin;
    }

    private boolean b(int mask) {
        byte i2 = this.az.a(c);
        return (i2 & mask) != 0;
    }

    private void a(int mask, boolean value) {
        int i2 = this.az.a(c).byteValue();
        i2 = value ? (i2 |= mask) : (i2 &= ~mask);
        this.az.a(c, (byte)(i2 & 0xFF));
    }

    public boolean gR() {
        return this.b(1);
    }

    public void x(boolean charging) {
        this.a(1, charging);
    }

    public void a(EntityInsentient owner) {
        this.e = EntityReference.a(owner);
    }

    public void a(int limitedLifeTicks) {
        this.cv = true;
        this.cw = limitedLifeTicks;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.Eg;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Ei;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.Ej;
    }

    @Override
    public float bO() {
        return 1.0f;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.qH));
        this.a(EnumItemSlot.a, 0.0f);
    }

    class c
    extends ControllerMove {
        public c(EntityVex mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b) {
                Vec3D vec3 = new Vec3D(this.e - EntityVex.this.dP(), this.f - EntityVex.this.dR(), this.g - EntityVex.this.dV());
                double len = vec3.g();
                if (len < EntityVex.this.dj().a()) {
                    this.k = ControllerMove.Operation.a;
                    EntityVex.this.k(EntityVex.this.dN().c(0.5));
                } else {
                    EntityVex.this.k(EntityVex.this.dN().e(vec3.c(this.h * 0.05 / len)));
                    if (EntityVex.this.ag_() == null) {
                        Vec3D deltaMovement = EntityVex.this.dN();
                        EntityVex.this.v(-((float)MathHelper.d(deltaMovement.g, deltaMovement.i)) * 57.295776f);
                        EntityVex.this.bC = EntityVex.this.ec();
                    } else {
                        double d2 = EntityVex.this.ag_().dP() - EntityVex.this.dP();
                        double d1 = EntityVex.this.ag_().dV() - EntityVex.this.dV();
                        EntityVex.this.v(-((float)MathHelper.d(d2, d1)) * 57.295776f);
                        EntityVex.this.bC = EntityVex.this.ec();
                    }
                }
            }
        }
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityVex.this.ag_();
            return target != null && target.cb() && !EntityVex.this.K().b() && EntityVex.this.as.a(net.minecraft.world.entity.monster.EntityVex$a.b(7)) == 0 && EntityVex.this.g((Entity)target) > 4.0;
        }

        @Override
        public boolean c() {
            return EntityVex.this.K().b() && EntityVex.this.gR() && EntityVex.this.ag_() != null && EntityVex.this.ag_().cb();
        }

        @Override
        public void d() {
            EntityLiving target = EntityVex.this.ag_();
            if (target != null) {
                Vec3D eyePosition = target.bV();
                EntityVex.this.cp.a(eyePosition.g, eyePosition.h, eyePosition.i, 1.0);
            }
            EntityVex.this.x(true);
            EntityVex.this.a(SoundEffects.Eh, 1.0f, 1.0f);
        }

        @Override
        public void e() {
            EntityVex.this.x(false);
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = EntityVex.this.ag_();
            if (target != null) {
                if (EntityVex.this.dj().c(target.dj())) {
                    EntityVex.this.c(net.minecraft.world.entity.monster.EntityVex$a.a(EntityVex.this.ao()), (Entity)target);
                    EntityVex.this.x(false);
                } else {
                    double d2 = EntityVex.this.g((Entity)target);
                    if (d2 < 9.0) {
                        Vec3D eyePosition = target.bV();
                        EntityVex.this.cp.a(eyePosition.g, eyePosition.h, eyePosition.i, 1.0);
                    }
                }
            }
        }
    }

    class d
    extends PathfinderGoal {
        public d() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !EntityVex.this.K().b() && EntityVex.this.as.a(net.minecraft.world.entity.monster.EntityVex$d.b(7)) == 0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void a() {
            BlockPosition boundOrigin = EntityVex.this.gQ();
            if (boundOrigin == null) {
                boundOrigin = EntityVex.this.dK();
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = boundOrigin.b(EntityVex.this.as.a(15) - 7, EntityVex.this.as.a(11) - 5, EntityVex.this.as.a(15) - 7);
                IBlockData blockState = EntityVex.this.ao().getBlockStateIfLoaded(blockPos);
                if (blockState == null || !blockState.l()) continue;
                EntityVex.this.cp.a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, 0.25);
                if (EntityVex.this.ag_() != null) break;
                EntityVex.this.J().a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class b
    extends PathfinderGoalTarget {
        private final PathfinderTargetCondition b;

        public b(EntityCreature mob) {
            super(mob, false);
            this.b = PathfinderTargetCondition.b().d().e();
        }

        @Override
        public boolean b() {
            EntityInsentient owner = EntityVex.this.gP();
            return owner != null && owner.ag_() != null && this.a(owner.ag_(), this.b);
        }

        @Override
        public void d() {
            EntityInsentient owner = EntityVex.this.gP();
            EntityVex.this.setTarget(owner != null ? owner.ag_() : null, EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET);
            super.d();
        }
    }
}

