/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownSplashPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final MinecraftKey a = MinecraftKey.b("drinking");
    private static final AttributeModifier b = new AttributeModifier(a, -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int f;
    private PathfinderGoalNearestHealableRaider<EntityRaider> cv;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> cw;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World level) {
        super((EntityTypes<? extends EntityRaider>)type, level);
    }

    @Override
    protected void D() {
        super.D();
        this.cv = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, (entity, level) -> this.hh() && entity.ay() != EntityTypes.bQ);
        this.cw = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, null);
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.cs.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(3, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.ct.a(2, this.cv);
        this.ct.a(3, this.cw);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, false);
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.FL;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.FP;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.FN;
    }

    public void z(boolean usingItem) {
        this.aD().a(e, usingItem);
    }

    public boolean gP() {
        return this.aD().a(e);
    }

    public static AttributeProvider.Builder gY() {
        return EntityMonster.gW().a(GenericAttributes.u, 26.0).a(GenericAttributes.x, 0.25);
    }

    @Override
    public void d_() {
        if (!this.ao().B_() && this.cb()) {
            this.cv.k();
            if (this.cv.i() <= 0) {
                this.cw.a(true);
            } else {
                this.cw.a(false);
            }
            if (this.gP()) {
                if (this.f-- <= 0) {
                    this.z(false);
                    net.minecraft.world.item.ItemStack mainHandItem = this.fx();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.l);
                    PotionContents potionContents = mainHandItem.a(DataComponents.Y);
                    if (mainHandItem.a(Items.up)) {
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(mainHandItem));
                        PotionContents potionContents2 = potionContents = event.callEvent() ? CraftItemStack.unwrap(event.getPotion()).a(DataComponents.Y) : null;
                    }
                    if (mainHandItem.a(Items.up) && potionContents != null) {
                        potionContents.a((MobEffect effect) -> this.addEffect((MobEffect)effect, EntityPotionEffectEvent.Cause.ATTACK), mainHandItem.a(DataComponents.Z, Float.valueOf(1.0f)).floatValue());
                    }
                    this.c(GameEvent.l);
                    this.h(GenericAttributes.x).c(b.a());
                }
            } else {
                Holder<PotionRegistry> holder = null;
                if (this.as.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.d(MobEffects.m)) {
                    holder = Potions.w;
                } else if (this.as.i() < 0.15f && (this.cp() || this.fb() != null && this.fb().a(DamageTypeTags.i)) && !this.d(MobEffects.l)) {
                    holder = Potions.l;
                } else if (this.as.i() < 0.05f && this.eZ() < this.fq()) {
                    holder = Potions.y;
                } else if (this.as.i() < 0.5f && this.ag_() != null && !this.d(MobEffects.a) && this.ag_().g(this) > 121.0) {
                    holder = Potions.n;
                }
                if (holder != null) {
                    this.setDrinkingPotion(PotionContents.a(Items.up, holder));
                }
            }
            if (this.as.i() < 7.5E-4f) {
                this.ao().a((Entity)this, (byte)15);
            }
        }
        super.d_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        potion = CraftEventFactory.handleWitchReadyPotionEvent(this, potion);
        this.a(EnumItemSlot.a, potion);
        this.f = this.fx().a(this);
        this.z(true);
        if (!this.bq()) {
            this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.FO, this.dB(), 1.0f, 0.8f + this.as.i() * 0.4f);
        }
        AttributeModifiable attribute = this.h(GenericAttributes.x);
        attribute.c(a);
        attribute.b(b);
    }

    @Override
    public SoundEffect gX() {
        return SoundEffects.FM;
    }

    @Override
    public void b(byte id) {
        if (id == 15) {
            for (int i2 = 0; i2 < this.as.a(35) + 10; ++i2) {
                this.ao().a(Particles.ar, this.dP() + this.as.k() * (double)0.13f, this.dj().e + 0.5 + this.as.k() * (double)0.13f, this.dV() + this.as.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(id);
        }
    }

    @Override
    protected float f(DamageSource damageSource, float damageAmount) {
        damageAmount = super.f(damageSource, damageAmount);
        if (damageSource.d() == this) {
            damageAmount = 0.0f;
        }
        if (damageSource.a(DamageTypeTags.k)) {
            damageAmount *= 0.15f;
        }
        return damageAmount;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        if (!this.gP()) {
            Vec3D deltaMovement = target.dN();
            double d2 = target.dP() + deltaMovement.g - this.dP();
            double d1 = target.dT() - (double)1.1f - this.dR();
            double d22 = target.dV() + deltaMovement.i - this.dV();
            double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
            Holder<PotionRegistry> holder = Potions.A;
            if (target instanceof EntityRaider) {
                holder = target.eZ() <= 4.0f ? Potions.y : Potions.F;
                this.g((EntityLiving)null);
            } else if (squareRoot >= 8.0 && !target.d(MobEffects.b)) {
                holder = Potions.q;
            } else if (target.eZ() >= 8.0f && !target.d(MobEffects.s)) {
                holder = Potions.C;
            } else if (squareRoot <= 3.0 && !target.d(MobEffects.r) && this.as.i() < 0.25f) {
                holder = Potions.L;
            }
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                net.minecraft.world.item.ItemStack itemStack = PotionContents.a(Items.xD, holder);
                WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemStack));
                if (!event.callEvent()) {
                    return;
                }
                itemStack = CraftItemStack.asNMSCopy(event.getPotion());
                IProjectile.a(ThrownSplashPotion::new, serverLevel, itemStack, this, d2, d1 + squareRoot * 0.2, d22, 0.75f, 8.0f);
            }
            if (!this.bq()) {
                this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.FQ, this.dB(), 1.0f, 0.8f + this.as.i() * 0.4f);
            }
        }
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
    }

    @Override
    public boolean k() {
        return false;
    }
}

