/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.BreezeUtil;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class LongJump
extends Behavior<Breeze> {
    private static final int c = 4;
    private static final int d = 10;
    private static final int e = 2;
    private static final int f = Math.round(10.0f);
    private static final float g = 24.0f;
    private static final float h = 1.4f;
    private static final float i = 0.058333334f;
    private static final ObjectArrayList<Integer> j = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.p, MemoryStatus.a, MemoryModuleType.bf, MemoryStatus.b, MemoryModuleType.bk, MemoryStatus.c, MemoryModuleType.bl, MemoryStatus.c, MemoryModuleType.bg, MemoryStatus.b, MemoryModuleType.n, MemoryStatus.b, MemoryModuleType.bm, MemoryStatus.c), 200);
    }

    public static boolean a(WorldServer level, Breeze breeze) {
        if (!breeze.aV() && !breeze.by()) {
            return false;
        }
        if (BehaviorSwim.a(breeze)) {
            return false;
        }
        if (breeze.ev().a(MemoryModuleType.bl, MemoryStatus.a)) {
            return true;
        }
        EntityLiving livingEntity = breeze.ev().c(MemoryModuleType.p).orElse(null);
        if (livingEntity == null) {
            return false;
        }
        if (LongJump.a(breeze, livingEntity)) {
            breeze.ev().b(MemoryModuleType.p);
            return false;
        }
        if (LongJump.b(breeze, livingEntity)) {
            return false;
        }
        if (!LongJump.c(level, breeze)) {
            return false;
        }
        BlockPosition blockPos = LongJump.a((EntityLiving)breeze, BreezeUtil.a(livingEntity, breeze.ep()));
        if (blockPos == null) {
            return false;
        }
        IBlockData blockState = level.a_(blockPos.e());
        if (breeze.ay().a(blockState)) {
            return false;
        }
        if (!BreezeUtil.a(breeze, blockPos.b()) && !BreezeUtil.a(breeze, blockPos.b(4).b())) {
            return false;
        }
        breeze.ev().a(MemoryModuleType.bl, blockPos);
        return true;
    }

    protected boolean b(WorldServer level, Breeze owner) {
        return LongJump.a(level, owner);
    }

    @Override
    protected boolean a(WorldServer level, Breeze entity, long gameTime) {
        return entity.aF() != EntityPose.a && !entity.ev().a(MemoryModuleType.bf);
    }

    @Override
    protected void b(WorldServer level, Breeze entity, long gameTime) {
        if (entity.ev().a(MemoryModuleType.bk, MemoryStatus.b)) {
            entity.ev().a(MemoryModuleType.bk, Unit.a, f);
        }
        entity.c(EntityPose.r);
        level.a(null, entity, SoundEffects.cQ, SoundCategory.f, 1.0f, 1.0f);
        entity.ev().c(MemoryModuleType.bl).ifPresent(blockPos -> entity.a(ArgumentAnchor.Anchor.b, blockPos.b()));
    }

    @Override
    protected void c(WorldServer level, Breeze owner, long gameTime) {
        boolean isInWater = owner.by();
        if (!isInWater && owner.ev().a(MemoryModuleType.bm, MemoryStatus.a)) {
            owner.ev().b(MemoryModuleType.bm);
        }
        if (LongJump.a(owner)) {
            Vec3D vec3 = owner.ev().c(MemoryModuleType.bl).flatMap(blockPos -> LongJump.a(owner, owner.ep(), Vec3D.c(blockPos))).orElse(null);
            if (vec3 == null) {
                owner.c(EntityPose.a);
                return;
            }
            if (isInWater) {
                owner.ev().a(MemoryModuleType.bm, Unit.a);
            }
            owner.a(SoundEffects.cW, 1.0f, 1.0f);
            owner.c(EntityPose.g);
            owner.v(owner.bC);
            owner.r(true);
            owner.k(vec3);
        } else if (LongJump.b(owner)) {
            owner.a(SoundEffects.cX, 1.0f, 1.0f);
            owner.c(EntityPose.a);
            owner.r(false);
            boolean hasMemoryValue = owner.ev().a(MemoryModuleType.y);
            owner.ev().a(MemoryModuleType.bf, Unit.a, hasMemoryValue ? 2L : 10L);
            owner.ev().a(MemoryModuleType.bg, Unit.a, 100L);
        }
    }

    @Override
    protected void d(WorldServer level, Breeze entity, long gameTime) {
        if (entity.aF() == EntityPose.g || entity.aF() == EntityPose.r) {
            entity.c(EntityPose.a);
        }
        entity.ev().b(MemoryModuleType.bl);
        entity.ev().b(MemoryModuleType.bk);
        entity.ev().b(MemoryModuleType.bm);
    }

    private static boolean a(Breeze breeze) {
        return breeze.ev().c(MemoryModuleType.bk).isEmpty() && breeze.aF() == EntityPose.r;
    }

    private static boolean b(Breeze breeze) {
        boolean flag = breeze.aF() == EntityPose.g;
        boolean onGround = breeze.aV();
        boolean flag1 = breeze.by() && breeze.ev().a(MemoryModuleType.bm, MemoryStatus.b);
        return flag && (onGround || flag1);
    }

    private static @Nullable BlockPosition a(EntityLiving owner, Vec3D targetPos) {
        RayTrace clipContext = new RayTrace(targetPos, targetPos.a(EnumDirection.a, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, owner);
        MovingObjectPositionBlock hitResult = owner.ao().a(clipContext);
        if (((MovingObjectPosition)hitResult).d() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult.g()).d();
        }
        RayTrace clipContext1 = new RayTrace(targetPos, targetPos.a(EnumDirection.b, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, owner);
        MovingObjectPositionBlock hitResult1 = owner.ao().a(clipContext1);
        return ((MovingObjectPosition)hitResult1).d() == MovingObjectPosition.EnumMovingObjectType.b ? BlockPosition.a(hitResult1.g()).d() : null;
    }

    private static boolean a(Breeze breeze, EntityLiving target) {
        return !target.a((Entity)breeze, breeze.i(GenericAttributes.o));
    }

    private static boolean b(Breeze breeze, EntityLiving target) {
        return target.f((Entity)breeze) - 4.0f <= 0.0f;
    }

    private static boolean c(WorldServer level, Breeze breeze) {
        BlockPosition blockPos = breeze.dK();
        if (level.a_(blockPos).a(Blocks.qg)) {
            return false;
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            BlockPosition blockPos1 = blockPos.a(EnumDirection.b, i2);
            if (level.a_(blockPos1).l() || level.b_(blockPos1).a(TagsFluid.a)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3D> a(Breeze breeze, RandomSource random, Vec3D target) {
        for (int i2 : SystemUtils.a(j, random)) {
            float f2 = 0.058333334f * (float)breeze.i(GenericAttributes.o);
            Optional<Vec3D> optional = LongJumpUtil.a(breeze, target, f2, i2, false);
            if (!optional.isPresent()) continue;
            if (breeze.d(MobEffects.h)) {
                double d2 = optional.get().d().h * (double)breeze.fG();
                return optional.map(vec3 -> vec3.b(0.0, d2, 0.0));
            }
            return optional;
        }
        return Optional.empty();
    }
}

