/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class Creaking
extends EntityMonster {
    private static final DataWatcherObject<Boolean> cy = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cA = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Optional<BlockPosition>> cB = DataWatcher.a(Creaking.class, DataWatcherRegistry.p);
    private static final int cC = 15;
    private static final int cD = 1;
    private static final float cE = 3.0f;
    private static final float cF = 32.0f;
    private static final float cG = 144.0f;
    public static final int a = 40;
    private static final float cH = 0.4f;
    public static final float b = 0.3f;
    public static final int c = 16545810;
    public static final int d = 0x5F5F5F;
    public static final int e = 8;
    public static final int f = 45;
    private static final int cI = 4;
    private int cJ;
    public final AnimationState cv = new AnimationState();
    public final AnimationState cw = new AnimationState();
    public final AnimationState cx = new AnimationState();
    private int cK;
    private boolean cL;
    private int cM;
    private int cN;

    public Creaking(EntityTypes<? extends Creaking> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.co = new c(this);
        this.cp = new d(this);
        this.cq = new b(this);
        Navigation groundPathNavigation = (Navigation)this.N();
        groundPathNavigation.a(true);
        this.cn = 0;
    }

    public void h(BlockPosition homePos) {
        this.i(homePos);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    public boolean k() {
        return this.gS() != null;
    }

    @Override
    protected EntityAIBodyControl I() {
        return new a(this);
    }

    protected BehaviorController.b<Creaking> ew() {
        return CreakingAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CreakingAi.b(this, this.ew().a(dynamic));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cy, true);
        builder.a(cz, false);
        builder.a(cA, false);
        builder.a(cB, Optional.empty());
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gW().a(GenericAttributes.u, 1.0).a(GenericAttributes.x, 0.4f).a(GenericAttributes.d, 3.0).a(GenericAttributes.o, 32.0).a(GenericAttributes.D, 1.0625);
    }

    public boolean gP() {
        return this.az.a(cy);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (!(target instanceof EntityLiving)) {
            return false;
        }
        this.cJ = 15;
        this.ao().a((Entity)this, (byte)4);
        return super.c(level, target);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        BlockPosition homePos = this.gS();
        if (homePos == null || damageSource.a(DamageTypeTags.d)) {
            return super.a(level, damageSource, amount);
        }
        if (!this.a(level, damageSource) && this.cK <= 0 && !this.fa()) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            EntityHuman player = this.i(damageSource);
            Entity directEntity = damageSource.c();
            if (!(directEntity instanceof EntityLiving) && !(directEntity instanceof IProjectile) && player == null) {
                return false;
            }
            this.cK = 8;
            this.ao().a((Entity)this, (byte)66);
            this.c(GameEvent.u);
            TileEntity tileEntity = this.ao().c_(homePos);
            if (tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this)) {
                if (player != null) {
                    creakingHeartBlockEntity.c();
                }
                this.g(damageSource);
            }
            return true;
        }
        return false;
    }

    public EntityHuman i(DamageSource damageSource) {
        this.e(damageSource);
        return this.f(damageSource);
    }

    @Override
    public boolean bY() {
        return super.bY() && this.gP();
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (this.gP()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    public BehaviorController<Creaking> ev() {
        return super.ev();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("creakingBrain");
        this.ev().a((WorldServer)this.ao(), this);
        profilerFiller.c();
        CreakingAi.a(this);
    }

    @Override
    public void d_() {
        if (this.cK > 0) {
            --this.cK;
        }
        if (this.cJ > 0) {
            --this.cJ;
        }
        if (!this.ao().B_()) {
            boolean flag = this.az.a(cy);
            boolean flag1 = this.gZ();
            if (flag1 != flag) {
                this.c(GameEvent.u);
                if (flag1) {
                    this.b(SoundEffects.hu);
                } else {
                    this.X();
                    this.b(SoundEffects.ht);
                }
            }
            this.az.a(cy, flag1);
        }
        super.d_();
    }

    @Override
    public void g() {
        BlockPosition homePos;
        if (!this.ao().B_() && (homePos = this.gS()) != null) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            boolean flag;
            TileEntity tileEntity = this.ao().c_(homePos);
            boolean bl = flag = tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this);
            if (!flag) {
                this.x(0.0f);
            }
        }
        super.g();
        if (this.ao().B_()) {
            this.hc();
            this.gY();
        }
    }

    @Override
    protected void eH() {
        if (this.k() && this.gU()) {
            ++this.bw;
            if (!this.ao().B_() && this.bw > 45 && !this.eh()) {
                this.gQ();
            }
        } else {
            super.eH();
        }
    }

    @Override
    protected void B(float partialTick) {
        float min = Math.min(partialTick * 25.0f, 3.0f);
        this.bB.a(min, 0.4f, 1.0f);
    }

    private void hc() {
        this.cv.a(this.cJ > 0, this.at);
        this.cw.a(this.cK > 0, this.at);
        this.cx.a(this.gU(), this.at);
    }

    public void gQ() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            AxisAlignedBB boundingBox = this.dj();
            Vec3D center = boundingBox.f();
            double d2 = boundingBox.b() * 0.3;
            double d1 = boundingBox.c() * 0.3;
            double d22 = boundingBox.d() * 0.3;
            serverLevel.a(new ParticleParamBlock(Particles.bj, Blocks.u.m()), center.g, center.h, center.i, 100, d2, d1, d22, 0.0);
            serverLevel.a(new ParticleParamBlock(Particles.bj, (IBlockData)Blocks.cQ.m().b(CreakingHeartBlock.c, CreakingHeartState.c)), center.g, center.h, center.i, 10, d2, d1, d22, 0.0);
        }
        this.b(this.fd());
        this.remove(Entity.RemovalReason.b, null);
    }

    public void j(DamageSource damageSource) {
        this.i(damageSource);
        this.a(damageSource);
        this.b(SoundEffects.hx);
    }

    @Override
    public void b(byte id) {
        if (id == 66) {
            this.cK = 8;
            this.g(this.en().p());
        } else if (id == 4) {
            this.cJ = 15;
            this.fN();
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean bx() {
        return this.k() || super.bx();
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return !this.k() && super.o(allowPassengers);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new e(this, level);
    }

    public boolean gR() {
        List list = this.ca.c(MemoryModuleType.j).orElse(List.of());
        if (list.isEmpty()) {
            this.cN = 0;
            return false;
        }
        AxisAlignedBB boundingBox = this.dj();
        for (EntityHuman player : list) {
            if (!boundingBox.d(player.bV())) continue;
            ++this.cN;
            return this.cN > 4;
        }
        this.cN = 0;
        return false;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        input.a("home_pos", BlockPosition.a).ifPresent(this::h);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.b("home_pos", BlockPosition.a, this.gS());
    }

    public void i(BlockPosition homePos) {
        this.az.a(cB, Optional.of(homePos));
    }

    public @Nullable BlockPosition gS() {
        return this.az.a(cB).orElse(null);
    }

    public void gT() {
        this.az.a(cA, true);
    }

    public boolean gU() {
        return this.az.a(cA);
    }

    public boolean gX() {
        return this.cL;
    }

    public void gY() {
        if (this.bw > this.cM) {
            this.cM = this.bw + this.ep().a(this.cL ? 2 : this.bw / 4, this.cL ? 8 : this.bw / 2);
            this.cL = !this.cL;
        }
    }

    @Override
    public void fN() {
        this.b(SoundEffects.hq);
    }

    @Override
    public SoundEffect W() {
        return this.hb() ? null : SoundEffects.hn;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.k() ? SoundEffects.hw : super.h(damageSource);
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.hr;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.hs, 0.15f, 1.0f);
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }

    @Override
    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause cause) {
        if (this.gP()) {
            super.knockback(strength, x2, z2, attacker, cause);
        }
    }

    public boolean gZ() {
        List list = this.ca.c(MemoryModuleType.j).orElse(List.of());
        boolean isActive = this.hb();
        if (list.isEmpty()) {
            if (isActive) {
                this.ha();
            }
            return true;
        }
        boolean flag = false;
        for (EntityHuman player : list) {
            if (!this.c((EntityLiving)player) || this.t(player)) continue;
            flag = true;
            if (isActive && !EntityLiving.bo.test(player) || !this.a(player, 0.5, false, true, this.dT(), this.dR() + 0.5 * (double)this.eF(), (this.dT() + this.dR()) / 2.0)) continue;
            if (isActive) {
                return false;
            }
            if (!(player.g(this) < 144.0)) continue;
            this.g(player);
            return false;
        }
        if (!flag && isActive) {
            this.ha();
        }
        return true;
    }

    public void g(EntityHuman player) {
        this.ev().a(MemoryModuleType.p, player);
        this.c(GameEvent.u);
        this.b(SoundEffects.ho);
        this.x(true);
    }

    public void ha() {
        this.ev().b(MemoryModuleType.p);
        this.c(GameEvent.u);
        this.b(SoundEffects.hp);
        this.x(false);
    }

    public void x(boolean isActive) {
        this.az.a(cz, isActive);
    }

    public boolean hb() {
        return this.az.a(cz);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    class c
    extends ControllerLook {
        public c(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.gP()) {
                super.a();
            }
        }
    }

    class d
    extends ControllerMove {
        public d(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.gP()) {
                super.a();
            }
        }
    }

    class b
    extends ControllerJump {
        public b(Creaking mob) {
            super(mob);
        }

        @Override
        public void b() {
            if (Creaking.this.gP()) {
                super.b();
            } else {
                Creaking.this.t(false);
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.gP()) {
                super.a();
            }
        }
    }

    class e
    extends Navigation {
        e(Creaking mob, World level) {
            super(mob, level);
        }

        @Override
        public void d() {
            if (Creaking.this.gP()) {
                super.d();
            }
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new f();
            this.o.a(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    class f
    extends PathfinderNormal {
        private static final int m = 1024;

        f() {
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            BlockPosition homePos = Creaking.this.gS();
            if (homePos == null) {
                return super.a(context, x2, y2, z2);
            }
            double d2 = homePos.j(new BaseBlockPosition(x2, y2, z2));
            return d2 > 1024.0 && d2 >= homePos.j(context.b()) ? PathType.a : super.a(context, x2, y2, z2);
        }
    }
}

