/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int cA = 40;
    private static final float cB = 0.3f;
    private static final int cC = 1;
    private static final float cD = 0.6f;
    private static final int cE = 6;
    private static final float cF = 0.5f;
    private static final boolean cG = false;
    private static final int cH = 0;
    private static final boolean cI = false;
    public static final int cv = 300;
    private int cJ;
    public int cK = 0;
    public boolean cL = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> cw = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.aB, (Object[])new MemoryModuleType[]{MemoryModuleType.A, MemoryModuleType.aD, MemoryModuleType.aE, MemoryModuleType.aA, MemoryModuleType.L, MemoryModuleType.aH, MemoryModuleType.aI, MemoryModuleType.aa});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cn = 5;
    }

    @VisibleForTesting
    public void s(int timeInOverworld) {
        this.cK = timeInOverworld;
    }

    @Override
    public boolean aj_() {
        return true;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gW().a(GenericAttributes.u, 40.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.r, 0.6f).a(GenericAttributes.e, 1.0).a(GenericAttributes.d, 6.0);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            this.cJ = 10;
            this.ao().a((Entity)this, (byte)4);
            this.b(SoundEffects.oo);
            HoglinAI.a(this, livingEntity);
            return IOglin.a(level, this, livingEntity);
        }
        return false;
    }

    @Override
    protected void d(EntityLiving entity) {
        if (this.gP()) {
            IOglin.a(this, entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            HoglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> ew() {
        return BehaviorController.a(cx, cw);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.ew().a(dynamic));
    }

    public BehaviorController<EntityHoglin> ev() {
        return super.ev();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("hoglinBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        HoglinAI.a(this);
        if (this.gR()) {
            ++this.cK;
            if (this.cK > 300) {
                this.b(SoundEffects.op);
                this.gT();
            }
        } else {
            this.cK = 0;
        }
    }

    @Override
    public void d_() {
        if (this.cJ > 0) {
            --this.cJ;
        }
        super.d_();
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.cn = 3;
            this.h(GenericAttributes.d).a(0.5);
        } else {
            this.cn = 5;
            this.h(GenericAttributes.d).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !level.a_(pos.e()).a(Blocks.lG);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (level.G_().i() < 0.2f) {
            this.a_(true);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return level.a_(pos.e()).a(Blocks.pu) ? 10.0f : 0.0f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.gz();
        }
        return interactionResult;
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cJ = 10;
            this.b(SoundEffects.oo);
        } else {
            super.b(id);
        }
    }

    @Override
    public int gQ() {
        return this.cJ;
    }

    @Override
    public boolean eI() {
        return true;
    }

    @Override
    protected int f(WorldServer level) {
        return this.cn;
    }

    private void gT() {
        EntityZoglin converted = this.convertTo(EntityTypes.bV, ConversionParams.a(this, true, false), (T mob) -> mob.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
        if (converted == null) {
            this.cK = 0;
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aU);
    }

    public boolean gP() {
        return !this.e_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cz, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsImmuneToZombification", this.gU());
        output.a("TimeInOverworld", this.cK);
        output.a("CannotBeHunted", this.cL);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("IsImmuneToZombification", false));
        this.cK = input.a("TimeInOverworld", 0);
        this.y(input.a("CannotBeHunted", false));
    }

    public void x(boolean immuneToZombification) {
        this.aD().a(cz, immuneToZombification);
    }

    public boolean gU() {
        return this.aD().a(cz);
    }

    public boolean gR() {
        return !this.gU() && !this.gG() && this.ao().c().a(EnvironmentAttributes.J, this.dI()) != false;
    }

    private void y(boolean cannotBeHunted) {
        this.cL = cannotBeHunted;
    }

    public boolean gS() {
        return this.gP() && !this.cL;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        EntityHoglin hoglin = EntityTypes.ao.a(level, EntitySpawnReason.e);
        if (hoglin != null) {
            hoglin.gz();
        }
        return hoglin;
    }

    @Override
    public boolean gY() {
        return !HoglinAI.c(this) && super.gY();
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect W() {
        return this.ao().B_() ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.or;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.oq;
    }

    @Override
    public SoundEffect bk() {
        return SoundEffects.oX;
    }

    @Override
    public SoundEffect bl() {
        return SoundEffects.oW;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.ot, 0.15f, 1.0f);
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }
}

