/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.illager;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.illager.EntityIllagerWizard;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class EntityEvoker
extends EntityIllagerWizard {
    private @Nullable EntitySheep a;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> type, World level) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, level);
        this.cn = 10;
    }

    @Override
    protected void D() {
        super.D();
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new b());
        this.cs.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.cs.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 0.6, 1.0));
        this.cs.a(4, new c());
        this.cs.a(5, new a());
        this.cs.a(6, new d());
        this.cs.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.cs.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder gP() {
        return EntityMonster.gW().a(GenericAttributes.x, 0.5).a(GenericAttributes.o, 12.0).a(GenericAttributes.u, 24.0);
    }

    @Override
    public SoundEffect gX() {
        return SoundEffects.kh;
    }

    @Override
    protected boolean u(Entity entity) {
        EntityVex vex;
        return entity == this || super.u(entity) || entity instanceof EntityVex && (vex = (EntityVex)entity).gP() != null && this.u(vex.gP());
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.kf;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.ki;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.kk;
    }

    public void a(@Nullable EntitySheep wololoTarget) {
        this.a = wololoTarget;
    }

    public @Nullable EntitySheep hl() {
        return this.a;
    }

    @Override
    protected SoundEffect gZ() {
        return SoundEffects.kg;
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
    }

    class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void a() {
            if (EntityEvoker.this.ag_() != null) {
                EntityEvoker.this.J().a(EntityEvoker.this.ag_(), (float)EntityEvoker.this.ae(), (float)EntityEvoker.this.ac());
            } else if (EntityEvoker.this.hl() != null) {
                EntityEvoker.this.J().a(EntityEvoker.this.hl(), (float)EntityEvoker.this.ae(), (float)EntityEvoker.this.ac());
            }
        }
    }

    class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean b() {
            if (!super.b()) {
                return false;
            }
            int size = net.minecraft.world.entity.monster.illager.EntityEvoker$c.a(EntityEvoker.this.ao()).a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.dj().g(16.0)).size();
            return EntityEvoker.this.as.a(8) + 1 > size;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer serverLevel = (WorldServer)EntityEvoker.this.ao();
            ScoreboardTeam team = EntityEvoker.this.cI();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = EntityEvoker.this.dK().b(-2 + EntityEvoker.this.as.a(5), 1, -2 + EntityEvoker.this.as.a(5));
                EntityVex vex = EntityTypes.bK.a(EntityEvoker.this.ao(), EntitySpawnReason.f);
                if (vex == null) continue;
                vex.a(blockPos, 0.0f, 0.0f);
                vex.a((WorldAccess)serverLevel, serverLevel.c(blockPos), EntitySpawnReason.f, null);
                vex.a(EntityEvoker.this);
                vex.h(blockPos);
                vex.a(20 * (30 + EntityEvoker.this.as.a(90)));
                if (team != null) {
                    serverLevel.i().a(vex.da(), team);
                }
                serverLevel.addFreshEntityWithPassengers(vex, CreatureSpawnEvent.SpawnReason.SPELL);
                serverLevel.a(GameEvent.t, blockPos, GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.km;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving target = EntityEvoker.this.ag_();
            double min = Math.min(target.dR(), EntityEvoker.this.dR());
            double d2 = Math.max(target.dR(), EntityEvoker.this.dR()) + 1.0;
            float f2 = (float)MathHelper.d(target.dV() - EntityEvoker.this.dV(), target.dP() - EntityEvoker.this.dP());
            if (EntityEvoker.this.g((Entity)target) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dP() + (double)MathHelper.b((double)f1) * 1.5, EntityEvoker.this.dV() + (double)MathHelper.a((double)f1) * 1.5, min, d2, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dP() + (double)MathHelper.b((double)f1) * 2.5, EntityEvoker.this.dV() + (double)MathHelper.a((double)f1) * 2.5, min, d2, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d1 = 1.25 * (double)(i3 + 1);
                    int i1 = 1 * i3;
                    this.a(EntityEvoker.this.dP() + (double)MathHelper.b((double)f2) * d1, EntityEvoker.this.dV() + (double)MathHelper.a((double)f2) * d1, min, d2, f2, i1);
                }
            }
        }

        private void a(double x2, double z2, double minY, double maxY, float yRot, int warmupDelay) {
            BlockPosition blockPos = BlockPosition.a(x2, maxY, z2);
            boolean flag = false;
            double d2 = 0.0;
            do {
                IBlockData blockState1;
                VoxelShape collisionShape;
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = EntityEvoker.this.ao().a_(blockPos1);
                if (!blockState.c((IBlockAccess)EntityEvoker.this.ao(), blockPos1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.ao().A(blockPos) && !(collisionShape = (blockState1 = EntityEvoker.this.ao().a_(blockPos)).g(EntityEvoker.this.ao(), blockPos)).c()) {
                    d2 = collisionShape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockPos = blockPos.e()).v() >= MathHelper.c(minY) - 1);
            if (flag) {
                EntityEvoker.this.ao().b(new EntityEvokerFangs(EntityEvoker.this.ao(), x2, (double)blockPos.v() + d2, z2, yRot, warmupDelay, EntityEvoker.this));
                EntityEvoker.this.ao().a(GameEvent.t, new Vec3D(x2, (double)blockPos.v() + d2, z2), GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.kl;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entity, WorldServer level) -> ((EntitySheep)entity).gP() == EnumColor.l);
        }

        @Override
        public boolean b() {
            if (EntityEvoker.this.ag_() != null) {
                return false;
            }
            if (EntityEvoker.this.ha()) {
                return false;
            }
            if (EntityEvoker.this.at < this.c) {
                return false;
            }
            WorldServer serverLevel = net.minecraft.world.entity.monster.illager.EntityEvoker$d.a(EntityEvoker.this.ao());
            if (!serverLevel.U().a(GameRules.F).booleanValue()) {
                return false;
            }
            List<EntitySheep> nearbyEntities = serverLevel.a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.dj().c(16.0, 4.0, 16.0));
            if (nearbyEntities.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(nearbyEntities.get(EntityEvoker.this.as.a(nearbyEntities.size())));
            return true;
        }

        @Override
        public boolean c() {
            return EntityEvoker.this.hl() != null && this.b > 0;
        }

        @Override
        public void e() {
            super.e();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep wololoTarget = EntityEvoker.this.hl();
            if (wololoTarget != null && wololoTarget.cb()) {
                wololoTarget.a(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.kn;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

