/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.illager;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.illager.EntityIllagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.k);
    private static final int b = 5;
    private static final int e = 300;
    public final InventorySubcontainer cv = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> type, World level) {
        super((EntityTypes<? extends EntityIllagerAbstract>)type, level);
    }

    @Override
    protected void D() {
        super.D();
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.cs.a(2, new EntityRaider.a(this, 10.0f));
        this.cs.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.cs.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder gZ() {
        return EntityMonster.gW().a(GenericAttributes.x, 0.35f).a(GenericAttributes.u, 24.0).a(GenericAttributes.d, 5.0).a(GenericAttributes.o, 32.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    @Override
    public boolean g(ItemStack stack) {
        return stack.h() == Items.yz;
    }

    public boolean ha() {
        return this.az.a(a);
    }

    @Override
    public void b(boolean isCharging) {
        this.az.a(a, isCharging);
    }

    @Override
    public void a() {
        this.bK = 0;
    }

    @Override
    public TagKey<Item> aa() {
        return TagsItem.cq;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        this.a_(output);
    }

    @Override
    public EntityIllagerAbstract.a gY() {
        if (this.ha()) {
            return EntityIllagerAbstract.a.f;
        }
        if (this.b(Items.yz)) {
            return EntityIllagerAbstract.a.e;
        }
        return this.gI() ? EntityIllagerAbstract.a.b : EntityIllagerAbstract.a.h;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a_(input);
        this.b_(true);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public int aj() {
        return 1;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.yz));
    }

    @Override
    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        ItemStack mainHandItem;
        super.b(level, random, difficulty);
        if (random.a(300) == 0 && (mainHandItem = this.fx()).a(Items.yz)) {
            EnchantmentManager.a(mainHandItem, level.J_(), VanillaEnchantmentProviders.b, difficulty, random);
        }
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.wH;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.wJ;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.wK;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public InventorySubcontainer gP() {
        return this.cv;
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        if (item.h() instanceof ItemBanner) {
            super.a(level, entity);
        } else if (this.j(item)) {
            this.a(entity);
            ItemStack itemStack = this.cv.b(item);
            if (itemStack.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                item.e(itemStack.N());
            }
        }
    }

    private boolean j(ItemStack item) {
        return this.hh() && item.a(Items.xe);
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        int i2 = slot - 300;
        return i2 >= 0 && i2 < this.cv.b() ? this.cv.a_(i2) : super.a_(slot);
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
        boolean flag1;
        Raid currentRaid = this.he();
        boolean bl = flag1 = this.as.i() <= currentRaid.s();
        if (flag1) {
            ItemStack itemStack = new ItemStack(Items.yz);
            ResourceKey<EnchantmentProvider> resourceKey = wave > currentRaid.a(EnumDifficulty.c) ? VanillaEnchantmentProviders.d : (wave > currentRaid.a(EnumDifficulty.b) ? VanillaEnchantmentProviders.c : null);
            if (resourceKey != null) {
                EnchantmentManager.a(itemStack, level.J_(), resourceKey, level.c(this.dK()), this.ep());
                this.a(EnumItemSlot.a, itemStack);
            }
        }
    }

    @Override
    public SoundEffect gX() {
        return SoundEffects.wI;
    }
}

