/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cw = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cy = MinecraftKey.b("baby");
    private static final AttributeModifier cz = new AttributeModifier(cy, 0.2f, AttributeModifier.Operation.b);
    private static final int cA = 16;
    private static final float cB = 0.35f;
    private static final int cC = 5;
    private static final float cD = 0.1f;
    private static final int cE = 3;
    private static final float cF = 0.2f;
    private static final EntitySize cG = EntityTypes.aZ.n().a(0.5f).b(0.97f);
    private static final double cH = 0.5;
    private static final boolean cI = false;
    private static final boolean cJ = false;
    public final InventorySubcontainer cK = new InventorySubcontainer(8);
    public boolean cL = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.az, MemoryModuleType.ay, MemoryModuleType.M, MemoryModuleType.ba, MemoryModuleType.y, MemoryModuleType.z, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.am, MemoryModuleType.an, MemoryModuleType.A, MemoryModuleType.ao, MemoryModuleType.ap, MemoryModuleType.ar, MemoryModuleType.aq, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.as, MemoryModuleType.aw, MemoryModuleType.N, MemoryModuleType.aC, MemoryModuleType.t, MemoryModuleType.aD, MemoryModuleType.aE, MemoryModuleType.av, MemoryModuleType.ax, MemoryModuleType.aF, MemoryModuleType.aG, MemoryModuleType.aH, MemoryModuleType.ah, MemoryModuleType.ai, MemoryModuleType.aj, MemoryModuleType.ak, MemoryModuleType.al});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();
    private static final Codec<Set<Item>> ITEM_SET_CODEC = BuiltInRegistries.h.q().listOf().xmap(HashSet::new, List::copyOf);

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World level) {
        super(type, level);
        this.cn = 5;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsBaby", this.e_());
        output.a("CannotHunt", this.cL);
        this.a_(output);
        output.a("Bukkit.BarterList", ITEM_SET_CODEC, this.allowedBarterItems);
        output.a("Bukkit.InterestList", ITEM_SET_CODEC, this.interestItems);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a_(input.a("IsBaby", false));
        this.z(input.a("CannotHunt", false));
        this.a_(input);
        this.allowedBarterItems = input.a("Bukkit.BarterList", ITEM_SET_CODEC).orElseGet(HashSet::new);
        this.interestItems = input.a("Bukkit.InterestList", ITEM_SET_CODEC).orElseGet(HashSet::new);
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer gP() {
        return this.cK;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        this.cK.g().forEach(itemStack -> this.a(level, (ItemStack)itemStack));
    }

    protected ItemStack j(ItemStack stack) {
        return this.cK.b(stack);
    }

    protected boolean k(ItemStack stack) {
        return this.cK.c(stack);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, false);
        builder.a(cw, false);
        builder.a(cx, false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (cv.equals(key)) {
            this.j_();
        }
    }

    public static AttributeProvider.Builder gX() {
        return EntityMonster.gW().a(GenericAttributes.u, 16.0).a(GenericAttributes.x, 0.35f).a(GenericAttributes.d, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !level.a_(pos.e()).a(Blocks.lG);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        if (spawnReason != EntitySpawnReason.d) {
            if (random.i() < 0.2f) {
                this.a_(true);
            } else if (this.gR()) {
                this.a(EnumItemSlot.a, this.gZ());
            }
        }
        PiglinAI.a(this, level.G_());
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.gA();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (this.gR()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.ry), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.rz), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.rA), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.rB), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> ew() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.ew().a(dynamic));
    }

    public BehaviorController<EntityPiglin> ev() {
        return super.ev();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            return PiglinAI.a(serverLevel, this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gS() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cG : super.b(pose);
    }

    @Override
    public void a_(boolean childZombie) {
        this.aD().a(cv, childZombie);
        if (!this.ao().B_()) {
            AttributeModifiable attribute = this.h(GenericAttributes.x);
            attribute.c(cz.a());
            if (childZombie) {
                attribute.b(cz);
            }
        }
    }

    @Override
    public boolean e_() {
        return this.aD().a(cv);
    }

    private void z(boolean cannotHunt) {
        this.cL = cannotHunt;
    }

    @Override
    protected boolean k() {
        return !this.cL;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("piglinBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        PiglinAI.a(this);
        super.a(level);
    }

    @Override
    protected int f(WorldServer level) {
        return this.cn;
    }

    @Override
    protected void h(WorldServer level) {
        PiglinAI.a(level, this);
        this.forceDrops = true;
        this.cK.g().forEach(itemStack -> this.a(level, (ItemStack)itemStack));
        this.forceDrops = false;
        super.h(level);
    }

    private ItemStack gZ() {
        return (double)this.as.i() < 0.5 ? new ItemStack(Items.yz) : new ItemStack(this.as.a(10) == 0 ? Items.xM : Items.qC);
    }

    @Override
    public @Nullable TagKey<Item> aa() {
        return this.e_() ? null : TagsItem.cp;
    }

    public boolean ha() {
        return this.az.a(cw);
    }

    @Override
    public void b(boolean isCharging) {
        this.az.a(cw, isCharging);
    }

    @Override
    public void a() {
        this.bK = 0;
    }

    @Override
    public EntityPiglinArmPose gS() {
        if (this.gY()) {
            return EntityPiglinArmPose.e;
        }
        if (PiglinAI.a(this.fy())) {
            return EntityPiglinArmPose.d;
        }
        if (this.gI() && this.gT()) {
            return EntityPiglinArmPose.a;
        }
        if (this.ha()) {
            return EntityPiglinArmPose.c;
        }
        return this.b(Items.yz) && ItemCrossbow.g(this.eq()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f;
    }

    public boolean gY() {
        return this.az.a(cx);
    }

    public void y(boolean dancing) {
        this.az.a(cx, dancing);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            PiglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean g(ItemStack stack) {
        return stack.h() == Items.yz || stack.c(DataComponents.O);
    }

    protected void l(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void m(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.h())) {
            this.a(EnumItemSlot.b, stack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return level.U().a(GameRules.F) != false && this.gn() && PiglinAI.a(this, stack);
    }

    protected boolean n(ItemStack candidate) {
        EnumItemSlot equipmentSlotForItem = this.f(candidate);
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        return this.a(candidate, itemBySlot, equipmentSlotForItem);
    }

    @Override
    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.F)) {
            return false;
        }
        TagKey<Item> preferredWeaponType = this.aa();
        boolean flag = PiglinAI.isLovedItem(newItem, this) || preferredWeaponType != null && newItem.a(preferredWeaponType);
        boolean flag1 = PiglinAI.isLovedItem(currentItem, this) || preferredWeaponType != null && currentItem.a(preferredWeaponType);
        return flag && !flag1 || (flag || !flag1) && super.a(newItem, currentItem, slot);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        PiglinAI.a(level, this, entity);
    }

    @Override
    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        if (this.e_() && entity.ay() == EntityTypes.ao) {
            entity = this.c(entity, 3);
        }
        return super.a(entity, force, triggerEvents);
    }

    private Entity c(Entity vehicle, int maxPosition) {
        List<Entity> passengers = vehicle.dn();
        return maxPosition != 1 && !passengers.isEmpty() ? this.c(passengers.getFirst(), maxPosition - 1) : vehicle;
    }

    @Override
    public @Nullable SoundEffect W() {
        return this.ao().B_() ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.wx;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.wv;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.wz, 0.15f, 1.0f);
    }

    @Override
    protected void gU() {
        this.b(SoundEffects.wA);
    }
}

