/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinBruteAI;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import org.jspecify.annotations.Nullable;

public class EntityPiglinBrute
extends EntityPiglinAbstract {
    private static final int f = 50;
    private static final float cv = 0.35f;
    private static final int cw = 7;
    private static final double cx = 12.0;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglinBrute>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.m);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.az, MemoryModuleType.ay, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.n, MemoryModuleType.F, (Object[])new MemoryModuleType[]{MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.am, MemoryModuleType.N, MemoryModuleType.b});

    public EntityPiglinBrute(EntityTypes<? extends EntityPiglinBrute> type, World level) {
        super((EntityTypes<? extends EntityPiglinAbstract>)type, level);
        this.cn = 20;
    }

    public static AttributeProvider.Builder gP() {
        return EntityMonster.gW().a(GenericAttributes.u, 50.0).a(GenericAttributes.x, 0.35f).a(GenericAttributes.d, 7.0).a(GenericAttributes.o, 12.0);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        PiglinBruteAI.a(this);
        this.a(level.G_(), difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.qF));
    }

    protected BehaviorController.b<EntityPiglinBrute> ew() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinBruteAI.a(this, this.ew().a(dynamic));
    }

    public BehaviorController<EntityPiglinBrute> ev() {
        return super.ev();
    }

    @Override
    public boolean k() {
        return false;
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return stack.a(Items.qF) && super.c(level, stack);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("piglinBruteBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        PiglinBruteAI.b(this);
        PiglinBruteAI.c(this);
        super.a(level);
    }

    @Override
    public EntityPiglinArmPose gS() {
        return this.gI() && this.gT() ? EntityPiglinArmPose.a : EntityPiglinArmPose.f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            PiglinBruteAI.a(level, this, livingEntity);
        }
        return flag;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.wB;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.wE;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.wD;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.wF, 0.15f, 1.0f);
    }

    protected void gX() {
        this.b(SoundEffects.wC);
    }

    @Override
    protected void gU() {
        this.b(SoundEffects.wG);
    }
}

