/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.skeleton;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.arrow.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.jspecify.annotations.Nullable;

public class Bogged
extends EntitySkeletonAbstract
implements IShearable {
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(Bogged.class, DataWatcherRegistry.k);
    private static final String d = "sheared";
    private static final boolean e = false;

    public static AttributeProvider.Builder gT() {
        return EntitySkeletonAbstract.k().a(GenericAttributes.u, 16.0);
    }

    public Bogged(EntityTypes<? extends Bogged> type, World level) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)type, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(d, this.gU());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a(d, false));
    }

    public boolean gU() {
        return this.az.a(c);
    }

    public void x(boolean sheared) {
        this.az.a(c, sheared);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.tZ) && this.a()) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, hand.a());
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.cz;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.cB;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.cA;
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.cD;
    }

    @Override
    protected EntityArrow a(ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        EntityArrow abstractArrow = super.a(arrow, velocity, weapon);
        if (abstractArrow instanceof EntityTippedArrow) {
            EntityTippedArrow arrow1 = (EntityTippedArrow)abstractArrow;
            arrow1.a(new MobEffect(MobEffects.s, 100));
        }
        return abstractArrow;
    }

    @Override
    protected int gQ() {
        return 50;
    }

    @Override
    protected int gR() {
        return 70;
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(level, LootTables.aW, shears, (arg_0, arg_1) -> Bogged.lambda$generateDefaultDrops$0((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.cC, source, 1.0f, 1.0f);
        this.spawnShearedMushrooms(level, shears, drops);
        this.x(true);
    }

    private void spawnShearedMushrooms(WorldServer level, ItemStack stack, List<ItemStack> drops) {
        this.forceDrops = true;
        drops.forEach(drop -> this.a(level, (ItemStack)drop, this.dG()));
        this.forceDrops = false;
    }

    @Override
    public boolean a() {
        return !this.gU() && this.cb();
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$0(List drops, WorldServer ignored, ItemStack stack) {
        drops.add(stack);
    }
}

