/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.skeleton;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpecialDates;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int c = 20;
    private static final int d = 40;
    protected static final int a = 50;
    protected static final int b = 70;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> e = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack f = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };
    private boolean shouldBurnInDay = true;

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.gP();
    }

    @Override
    protected void D() {
        this.cs.a(2, new PathfinderGoalRestrictSun(this));
        this.cs.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.cs.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(6, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cv));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.x, 0.25);
    }

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean gL() {
        return this.shouldBurnInDay && super.gL();
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.p(), 0.15f, 1.0f);
    }

    abstract SoundEffect p();

    @Override
    public void t() {
        super.t();
        Entity entity = this.dA();
        if (entity instanceof EntityCreature) {
            EntityCreature pathfinderMob = (EntityCreature)entity;
            this.bC = pathfinderMob.bC;
        }
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        this.a(EnumItemSlot.a, new ItemStack(Items.pW));
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        RandomSource random = level.G_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        this.gP();
        this.b_(level.a().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.skeletons || random.i() < 0.55f * difficulty.d());
        if (this.a(EnumItemSlot.f).f() && SpecialDates.b() && random.i() < 0.25f) {
            this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.eK : Blocks.eJ));
            this.a(EnumItemSlot.f, 0.0f);
        }
        return spawnGroupData;
    }

    public void gP() {
        if (this.ao() != null && !this.ao().B_()) {
            this.cs.a(this.f);
            this.cs.a(this.e);
            ItemStack itemInHand = this.b(ProjectileHelper.a(this, Items.pW));
            if (itemInHand.a(Items.pW)) {
                int hardAttackInterval = this.gQ();
                if (this.ao().av() != EnumDifficulty.d) {
                    hardAttackInterval = this.gR();
                }
                this.e.c(hardAttackInterval);
                this.cs.a(4, this.e);
            } else {
                this.cs.a(4, this.f);
            }
        }
    }

    protected int gQ() {
        return 20;
    }

    protected int gR() {
        return 40;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        EnumHand hand = ProjectileHelper.a(this, Items.pW);
        ItemStack itemInHand = this.b(hand);
        ItemStack projectile = this.d(itemInHand);
        EntityArrow arrow = this.a(projectile, distanceFactor, itemInHand);
        double d2 = target.dP() - this.dP();
        double d1 = target.f(0.3333333333333333) - arrow.dR();
        double d22 = target.dV() - this.dV();
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.Delayed<EntityArrow> delayedEntity = IProjectile.spawnProjectileUsingShootDelayed(arrow, serverLevel, projectile, d2, d1 + squareRoot * (double)0.2f, d22, 1.6f, 14 - serverLevel.av().a() * 4);
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, itemInHand, arrow.s(), arrow, hand, distanceFactor, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == arrow.getBukkitEntity()) {
                delayedEntity.spawn();
            }
        }
        this.a(SoundEffects.Au, 1.0f, 1.0f / (this.ep().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        return ProjectileHelper.a(this, arrow, velocity, weapon);
    }

    @Override
    public boolean g(ItemStack stack) {
        return stack.h() == Items.pW;
    }

    @Override
    public TagKey<Item> aa() {
        return TagsItem.cn;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.gP();
        this.shouldBurnInDay = input.a("Paper.ShouldBurnInDay", true);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void onEquipItem(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        super.onEquipItem(slot, oldItem, newItem, silent);
        if (!this.ao().B_()) {
            this.gP();
        }
    }

    public boolean gS() {
        return this.cO();
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return !stack.a(TagsItem.cf) && super.c(level, stack);
    }
}

