/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.player.EntityHuman;
import org.jspecify.annotations.Nullable;

public class AngerManagement {
    @VisibleForTesting
    protected static final int a = 2;
    @VisibleForTesting
    protected static final int b = 150;
    private static final int f = 1;
    private int g = MathHelper.b(RandomSource.a(), 0, 2);
    int h;
    private static final Codec<Pair<UUID, Integer>> i = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("uuid").forGetter(Pair::getFirst), (App)ExtraCodecs.q.fieldOf("anger").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    private final Predicate<Entity> j;
    @VisibleForTesting
    protected final ArrayList<Entity> c;
    private final a k;
    @VisibleForTesting
    protected final Object2IntMap<Entity> d;
    @VisibleForTesting
    protected final Object2IntMap<UUID> e;

    public static Codec<AngerManagement> a(Predicate<Entity> filter) {
        return RecordCodecBuilder.create(instance -> instance.group((App)i.listOf().fieldOf("suspects").orElse(Collections.emptyList()).forGetter(AngerManagement::b)).apply((Applicative)instance, list -> new AngerManagement(filter, (List<Pair<UUID, Integer>>)list)));
    }

    public AngerManagement(Predicate<Entity> filter, List<Pair<UUID, Integer>> angerByUuid) {
        this.j = filter;
        this.c = new ArrayList();
        this.k = new a(this);
        this.d = new Object2IntOpenHashMap();
        this.e = new Object2IntOpenHashMap(angerByUuid.size());
        angerByUuid.forEach(pair -> this.e.put((Object)((UUID)pair.getFirst()), (Integer)pair.getSecond()));
    }

    private List<Pair<UUID, Integer>> b() {
        return Streams.concat((Stream[])new Stream[]{this.c.stream().map(entity -> Pair.of((Object)entity.cY(), (Object)this.d.getInt(entity))), this.e.object2IntEntrySet().stream().map(entry -> Pair.of((Object)((UUID)entry.getKey()), (Object)entry.getIntValue()))}).collect(Collectors.toList());
    }

    public void a(WorldServer level, Predicate<Entity> predicate) {
        --this.g;
        if (this.g <= 0) {
            this.a(level);
            this.g = 2;
        }
        ObjectIterator objectIterator = this.e.object2IntEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
            int intValue = entry.getIntValue();
            if (intValue <= 1) {
                objectIterator.remove();
                continue;
            }
            entry.setValue(intValue - 1);
        }
        ObjectIterator objectIterator1 = this.d.object2IntEntrySet().iterator();
        while (objectIterator1.hasNext()) {
            Object2IntMap.Entry entry1 = (Object2IntMap.Entry)objectIterator1.next();
            int intValue1 = entry1.getIntValue();
            Entity entity = (Entity)entry1.getKey();
            Entity.RemovalReason removalReason = entity.ei();
            if (intValue1 > 1 && predicate.test(entity) && removalReason == null) {
                entry1.setValue(intValue1 - 1);
                continue;
            }
            this.c.remove(entity);
            objectIterator1.remove();
            if (intValue1 <= 1 || removalReason == null) continue;
            switch (removalReason) {
                case e: 
                case c: 
                case d: {
                    this.e.put((Object)entity.cY(), intValue1 - 1);
                }
            }
        }
        this.c();
    }

    private void c() {
        this.h = 0;
        this.c.sort(this.k);
        if (this.c.size() == 1) {
            this.h = this.d.getInt((Object)this.c.get(0));
        }
    }

    private void a(WorldServer level) {
        ObjectIterator objectIterator = this.e.object2IntEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
            int intValue = entry.getIntValue();
            Entity entity = level.d((UUID)entry.getKey());
            if (entity == null) continue;
            this.d.put((Object)entity, intValue);
            this.c.add(entity);
            objectIterator.remove();
        }
    }

    public int a(Entity entity, int offset) {
        boolean flag = !this.d.containsKey((Object)entity);
        int i2 = this.d.computeInt((Object)entity, (entity1, integer) -> Math.min(150, (integer == null ? 0 : integer) + offset));
        if (flag) {
            int i1 = this.e.removeInt((Object)entity.cY());
            this.d.put((Object)entity, i2 += i1);
            this.c.add(entity);
        }
        this.c();
        return i2;
    }

    public void a(Entity entity) {
        this.d.removeInt((Object)entity);
        this.c.remove(entity);
        this.c();
    }

    private @Nullable Entity d() {
        return this.c.stream().filter(this.j).findFirst().orElse(null);
    }

    public int b(@Nullable Entity entity) {
        return entity == null ? this.h : this.d.getInt((Object)entity);
    }

    public Optional<EntityLiving> a() {
        return Optional.ofNullable(this.d()).filter(entity -> entity instanceof EntityLiving).map(entity -> (EntityLiving)entity);
    }

    @VisibleForTesting
    protected record a(AngerManagement a) implements Comparator<Entity>
    {
        public int a(Entity first, Entity second) {
            boolean isAngry1;
            if (first.equals(second)) {
                return 0;
            }
            int orDefault = this.a.d.getOrDefault((Object)first, 0);
            int orDefault1 = this.a.d.getOrDefault((Object)second, 0);
            this.a.h = Math.max(this.a.h, Math.max(orDefault, orDefault1));
            boolean isAngry = AngerLevel.a(orDefault).d();
            if (isAngry != (isAngry1 = AngerLevel.a(orDefault1).d())) {
                return isAngry ? -1 : 1;
            }
            boolean flag = first instanceof EntityHuman;
            boolean flag1 = second instanceof EntityHuman;
            if (flag != flag1) {
                return flag ? -1 : 1;
            }
            return Integer.compare(orDefault1, orDefault);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "angerManagement", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "angerManagement", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "angerManagement", "a"}, this, o2);
        }
    }
}

