/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int cv = 40;
    private static final int cw = 200;
    private static final int cx = 500;
    private static final float cy = 0.3f;
    private static final float cz = 1.0f;
    private static final float cA = 1.5f;
    private static final int cB = 30;
    private static final int cC = 24;
    private static final DataWatcherObject<Integer> cD = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int cE = 200;
    private static final int cF = 260;
    private static final int cG = 20;
    private static final int cH = 120;
    private static final int cI = 20;
    private static final int cJ = 35;
    private static final int cK = 10;
    private static final int cL = 20;
    private static final int cM = 100;
    private static final int cN = 20;
    private static final int cO = 30;
    private static final float cP = 4.5f;
    private static final float cQ = 0.7f;
    private static final int cR = 30;
    private int cU;
    private int cV;
    private int cW;
    private int cX;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cY;
    private final VibrationSystem.d cZ;
    private VibrationSystem.a da;
    AngerManagement db = new AngerManagement(this::H, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> type, World level) {
        super(type, level);
        this.cZ = new a();
        this.da = new VibrationSystem.a();
        this.cY = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.cn = 5;
        this.N().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, this.d(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.n() == 1) {
            this.c(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader level) {
        return super.a(level) && level.a((Entity)this, this.ay().n().a(this.dI()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.gU() && !damageSource.a(DamageTypeTags.d) || super.a(level, damageSource);
    }

    boolean gU() {
        return this.d(EntityPose.o) || this.d(EntityPose.n);
    }

    @Override
    protected boolean p(Entity vehicle) {
        return false;
    }

    @Override
    public float gu() {
        return 5.0f;
    }

    @Override
    protected float bj() {
        return this.al + 0.55f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 500.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.r, 1.0).a(GenericAttributes.e, 1.5).a(GenericAttributes.d, 30.0).a(GenericAttributes.o, 24.0);
    }

    @Override
    public boolean bw() {
        return true;
    }

    @Override
    public float fC() {
        return 4.0f;
    }

    @Override
    public @Nullable SoundEffect W() {
        return !this.d(EntityPose.l) && !this.gU() ? this.gP().b() : null;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.Fg;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Fc;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Fq, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.Fb, 10.0f, this.fD());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(level, target);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cD, 0);
    }

    public int p() {
        return this.az.a(cD);
    }

    private void gX() {
        this.az.a(cD, this.ha());
    }

    @Override
    public void g() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            VibrationSystem.c.a((World)serverLevel, this.da, this.cZ);
            if (this.gA() || this.ab()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.ao().B_()) {
            if (this.at % this.gY() == 0) {
                this.cW = 10;
                if (!this.bq()) {
                    this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.Ff, this.dB(), 5.0f, this.fD(), false);
                }
            }
            this.cV = this.cU;
            if (this.cU > 0) {
                --this.cU;
            }
            this.cX = this.cW;
            if (this.cW > 0) {
                --this.cW;
            }
            switch (this.aF()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("wardenBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        super.a(level);
        if ((this.at + this.aA()) % 120 == 0) {
            Warden.a(level, this.dI(), this, 20);
        }
        if (this.at % 20 == 0) {
            this.db.a(level, this::H);
            this.gX();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.a.a();
            this.e.a(this.at);
        } else if (id == 61) {
            this.cU = 10;
        } else if (id == 62) {
            this.f.a(this.at);
        } else {
            super.b(id);
        }
    }

    private int gY() {
        float f2 = (float)this.p() / (float)AngerLevel.c.a();
        return 40 - MathHelper.b(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cV, this.cU) / 10.0f;
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.cX, this.cW) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.a((float)this.at) < 4500.0f) {
            RandomSource random = this.ep();
            IBlockData blockStateOn = this.bK();
            if (blockStateOn.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d2 = this.dP() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    double y2 = this.dR();
                    double d1 = this.dV() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    this.ao().a(new ParticleParamBlock(Particles.b, blockStateOn), d2, y2, d1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aE.equals(key)) {
            switch (this.aF()) {
                case n: {
                    this.c.a(this.at);
                    break;
                }
                case o: {
                    this.d.a(this.at);
                    break;
                }
                case l: {
                    this.a.a(this.at);
                    break;
                }
                case m: {
                    this.b.a(this.at);
                }
            }
        }
        super.a(key);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gU();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> ev() {
        return super.ev();
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            listenerConsumer.accept(this.cY, serverLevel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean H(@Nullable Entity entity) {
        if (!(entity instanceof EntityLiving)) return false;
        EntityLiving livingEntity = (EntityLiving)entity;
        if (this.ao() != entity.ao()) return false;
        if (!IEntitySelector.e.test(entity)) return false;
        if (this.t(entity)) return false;
        if (livingEntity.ay() == EntityTypes.h) return false;
        if (livingEntity.ay() == EntityTypes.bO) return false;
        if (livingEntity.cU()) return false;
        if (livingEntity.fa()) return false;
        if (!this.ao().w().a(livingEntity.dj())) return false;
        return true;
    }

    public static void a(WorldServer level, Vec3D pos, @Nullable Entity source, int radius) {
        MobEffect mobEffectInstance = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(level, source, pos, radius, mobEffectInstance, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("anger", AngerManagement.a(this::H), this.db);
        output.a("listener", VibrationSystem.a.a, this.da);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.db = input.a("anger", AngerManagement.a(this::H)).orElseGet(() -> new AngerManagement(this::H, Collections.emptyList()));
        this.gX();
        this.da = input.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
    }

    private void gZ() {
        if (!this.d(EntityPose.l)) {
            this.a(this.gP().c(), 10.0f, this.fD());
        }
    }

    public AngerLevel gP() {
        return AngerLevel.a(this.ha());
    }

    private int ha() {
        return this.db.b(this.ag_());
    }

    public void I(Entity entity) {
        this.db.a(entity);
    }

    public void J(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int offset, boolean playListeningSound) {
        if (!this.gG() && this.H(entity)) {
            int activeAnger = this.db.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + offset));
            this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            offset = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag = !(this.ag_() instanceof EntityHuman);
            int i2 = this.db.a(entity, offset);
            if (entity instanceof EntityHuman && flag && AngerLevel.a(i2).d()) {
                this.ev().b(MemoryModuleType.p);
            }
            if (playListeningSound) {
                this.gZ();
            }
        }
    }

    public Optional<EntityLiving> gQ() {
        return this.gP().d() ? this.db.a() : Optional.empty();
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.ev().a(MemoryModuleType.aP, Unit.a, 1200L);
        if (spawnReason == EntitySpawnReason.k) {
            this.c(EntityPose.n);
            this.ev().a(MemoryModuleType.aN, Unit.a, WardenAi.a);
            this.a(SoundEffects.EY, 5.0f, 1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (!this.gG() && !this.gU()) {
            Entity entity = damageSource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.ca.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                if (damageSource.b() || this.a((Entity)livingEntity, 5.0)) {
                    this.i(livingEntity);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving attackTarget) {
        this.ev().b(MemoryModuleType.aJ);
        this.ev().a(MemoryModuleType.p, attackTarget);
        this.ev().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        EntitySize entityDimensions = super.b(pose);
        return this.gU() ? EntitySize.c(entityDimensions.a(), 1.0f) : entityDimensions;
    }

    @Override
    public boolean bY() {
        return !this.gU() && super.bY();
    }

    @Override
    protected void F(Entity entity) {
        if (!this.gG() && !this.ev().a(MemoryModuleType.aS)) {
            this.ev().a(MemoryModuleType.aS, Unit.a, 20L);
            this.J(entity);
            WardenAi.a(this, entity.dK());
        }
        super.F(entity);
    }

    @VisibleForTesting
    public AngerManagement gR() {
        return this.db;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new Navigation(this, this, level){

            @Override
            protected Pathfinder a(int maxVisitedNodes) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, maxVisitedNodes){

                    @Override
                    protected float a(PathPoint first, PathPoint second) {
                        return first.b(second);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gS() {
        return this.da;
    }

    @Override
    public VibrationSystem.d gT() {
        return this.cZ;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.dk());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            EntityLiving livingEntity;
            Entity entity;
            return !Warden.this.gG() && !Warden.this.fa() && !Warden.this.ev().a(MemoryModuleType.aT) && !Warden.this.gU() && level.w().a(pos) && (!((entity = context.a()) instanceof EntityLiving) || Warden.this.H(livingEntity = (EntityLiving)entity));
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (!Warden.this.fa()) {
                Warden.this.ca.a(MemoryModuleType.aT, Unit.a, 40L);
                level.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Fr, 5.0f, Warden.this.fD());
                BlockPosition blockPos = pos;
                if (playerEntity != null) {
                    if (Warden.this.a(playerEntity, 30.0)) {
                        if (Warden.this.ev().a(MemoryModuleType.aL)) {
                            if (Warden.this.H(playerEntity)) {
                                blockPos = playerEntity.dK();
                            }
                            Warden.this.J(playerEntity);
                        } else {
                            Warden.this.a(playerEntity, 10, true);
                        }
                    }
                    Warden.this.ev().a(MemoryModuleType.aL, Unit.a, 100L);
                } else {
                    Warden.this.J(entity);
                }
                if (!Warden.this.gP().d()) {
                    Optional<EntityLiving> activeEntity = Warden.this.db.a();
                    if (playerEntity != null || activeEntity.isEmpty() || activeEntity.get() == entity) {
                        WardenAi.a(Warden.this, blockPos);
                    }
                }
            }
        }
    }
}

