/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilus;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityDrowned
extends EntityZombie
implements IRangedEntity {
    public static final float a = 0.03f;
    private static final float f = 0.5f;
    boolean cv;

    public EntityDrowned(EntityTypes<? extends EntityDrowned> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
        this.cp = new d(this);
        this.a(PathType.j, 0.0f);
    }

    public static AttributeProvider.Builder k() {
        return EntityZombie.gT().a(GenericAttributes.D, 1.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new AmphibiousPathNavigation(this, level);
    }

    @Override
    protected void p() {
        this.cs.a(1, new c(this, 1.0));
        this.cs.a(2, new f(this, 1.0, 40, 10.0f));
        this.cs.a(2, new a(this, 1.0, false));
        this.cs.a(5, new b(this, 1.0));
        this.cs.a(6, new e(this, 1.0, this.ao().V()));
        this.cs.a(7, new PathfinderGoalRandomStroll(this, 1.0));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, EntityDrowned.class).a(EntityPigZombie.class));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> this.i(entity)));
        if (this.ao().spigotConfig.zombieAggressiveTowardsVillager) {
            this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<Axolotl>((EntityInsentient)this, Axolotl.class, true, false));
        this.ct.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cv));
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        ZombieNautilus zombieNautilus;
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        if (this.a(EnumItemSlot.b).f() && level.G_().i() < 0.03f) {
            this.a(EnumItemSlot.b, new ItemStack(Items.ys));
            this.g(EnumItemSlot.b);
        }
        if ((spawnReason == EntitySpawnReason.a || spawnReason == EntitySpawnReason.d) && this.fx().a(Items.yr) && level.G_().i() < 0.5f && !this.e_() && !level.z(this.dK()).a(BiomeTags.am) && (zombieNautilus = EntityTypes.bY.a(this.ao(), EntitySpawnReason.g)) != null) {
            if (spawnReason == EntitySpawnReason.d) {
                zombieNautilus.gz();
            }
            zombieNautilus.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
            zombieNautilus.a(level, difficulty, spawnReason, null);
            this.a((Entity)zombieNautilus, false, false);
            level.b(zombieNautilus);
        }
        return spawnGroupData;
    }

    public static boolean c(EntityTypes<EntityDrowned> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag;
        if (!level.b_(pos.e()).a(TagsFluid.a) && !EntitySpawnReason.a(spawnReason)) {
            return false;
        }
        Holder<BiomeBase> biome = level.z(pos);
        boolean bl = flag = !(level.av() == EnumDifficulty.a || !EntitySpawnReason.b(spawnReason) && !EntityDrowned.a(level, pos, random) || !EntitySpawnReason.a(spawnReason) && !level.b_(pos).a(TagsFluid.a));
        if (!flag || !EntitySpawnReason.a(spawnReason) && spawnReason != EntitySpawnReason.j) {
            return biome.a(BiomeTags.am) ? random.a(15) == 0 && flag : random.a(40) == 0 && EntityDrowned.a(level, pos) && flag;
        }
        return true;
    }

    private static boolean a(GeneratorAccess level, BlockPosition pos) {
        return pos.v() < level.V() - 5;
    }

    @Override
    public SoundEffect W() {
        return this.by() ? SoundEffects.jm : SoundEffects.jl;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.by() ? SoundEffects.jq : SoundEffects.jp;
    }

    @Override
    public SoundEffect fd() {
        return this.by() ? SoundEffects.jo : SoundEffects.jn;
    }

    @Override
    protected SoundEffect gP() {
        return SoundEffects.js;
    }

    @Override
    public SoundEffect bk() {
        return SoundEffects.jt;
    }

    @Override
    protected boolean gQ() {
        return true;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if ((double)random.i() > 0.9) {
            int randomInt = random.a(16);
            if (randomInt < 10) {
                this.a(EnumItemSlot.a, new ItemStack(Items.yr));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.sZ));
            }
        }
    }

    @Override
    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        return !currentItem.a(Items.ys) && super.a(newItem, currentItem, slot);
    }

    @Override
    protected boolean gR() {
        return false;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    public boolean i(@Nullable EntityLiving target) {
        return target != null && (!this.ao().ag() || target.by());
    }

    @Override
    public boolean db() {
        return !this.cB();
    }

    boolean gZ() {
        if (this.cv) {
            return true;
        }
        EntityLiving target = this.ag_();
        return target != null && target.by();
    }

    @Override
    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        if (this.bC() && this.gZ()) {
            this.a(0.01f, travelVector);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c(0.9));
        } else {
            super.a(travelVector, gravity, isFalling, previousY);
        }
    }

    @Override
    public void bF() {
        if (!this.ao().B_()) {
            this.j(this.dy() && this.bC() && this.gZ());
        }
    }

    @Override
    public boolean cC() {
        return this.cB() && !this.cq();
    }

    protected boolean gS() {
        double d2;
        BlockPosition target;
        PathEntity path = this.N().j();
        return path != null && (target = path.l()) != null && (d2 = this.h(target.u(), target.v(), target.w())) < 4.0;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        ItemStack mainHandItem = this.fx();
        ItemStack itemStack = mainHandItem.a(Items.yr) ? mainHandItem : new ItemStack(Items.yr);
        EntityThrownTrident thrownTrident = new EntityThrownTrident(this.ao(), this, itemStack);
        double d2 = target.dP() - this.dP();
        double d1 = target.f(0.3333333333333333) - thrownTrident.dR();
        double d22 = target.dV() - this.dV();
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.a(thrownTrident, serverLevel, itemStack, d2, d1 + squareRoot * (double)0.2f, d22, 1.6f, 14 - this.ao().av().a() * 4);
        }
        this.a(SoundEffects.jr, 1.0f, 1.0f / (this.ep().i() * 0.4f + 0.8f));
    }

    @Override
    public TagKey<Item> aa() {
        return TagsItem.co;
    }

    public void x(boolean searchingForLand) {
        this.cv = searchingForLand;
    }

    @Override
    public void t() {
        super.t();
        Entity entity = this.dA();
        if (entity instanceof EntityCreature) {
            EntityCreature pathfinderMob = (EntityCreature)entity;
            this.bC = pathfinderMob.bC;
        }
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return !stack.a(TagsItem.cf) && super.c(level, stack);
    }

    static class d
    extends ControllerMove {
        private final EntityDrowned l;

        public d(EntityDrowned mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            EntityLiving target = this.l.ag_();
            if (this.l.gZ() && this.l.by()) {
                if (target != null && target.dR() > this.l.dR() || this.l.cv) {
                    this.l.k(this.l.dN().b(0.0, 0.002, 0.0));
                }
                if (this.k != ControllerMove.Operation.b || this.l.N().l()) {
                    this.l.C(0.0f);
                    return;
                }
                double d2 = this.e - this.l.dP();
                double d1 = this.f - this.l.dR();
                double d22 = this.g - this.l.dV();
                double squareRoot = Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22);
                d1 /= squareRoot;
                float f2 = (float)(MathHelper.d(d22, d2) * 180.0 / 3.1415927410125732) - 90.0f;
                this.l.v(this.b(this.l.ec(), f2, 90.0f));
                this.l.bC = this.l.ec();
                float f1 = (float)(this.h * this.l.i(GenericAttributes.x));
                float f22 = MathHelper.h(0.125f, this.l.fM(), f1);
                this.l.C(f22);
                this.l.k(this.l.dN().b((double)f22 * d2 * 0.005, (double)f22 * d1 * 0.1, (double)f22 * d22 * 0.005));
            } else {
                if (!this.l.aV()) {
                    this.l.k(this.l.dN().b(0.0, -0.008, 0.0));
                }
                super.a();
            }
        }
    }

    static class c
    extends PathfinderGoal {
        private final EntityCreature a;
        private double b;
        private double c;
        private double d;
        private final double e;
        private final World f;

        public c(EntityCreature mob, double speedModifier) {
            this.a = mob;
            this.e = speedModifier;
            this.f = mob.ao();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!this.f.ag()) {
                return false;
            }
            if (this.a.by()) {
                return false;
            }
            Vec3D waterPos = this.h();
            if (waterPos == null) {
                return false;
            }
            this.b = waterPos.g;
            this.c = waterPos.h;
            this.d = waterPos.i;
            return true;
        }

        @Override
        public boolean c() {
            return !this.a.N().l();
        }

        @Override
        public void d() {
            this.a.N().a(this.b, this.c, this.d, this.e);
        }

        private @Nullable Vec3D h() {
            RandomSource random = this.a.ep();
            BlockPosition blockPos = this.a.dK();
            for (int i2 = 0; i2 < 10; ++i2) {
                BlockPosition blockPos1 = blockPos.b(random.a(20) - 10, 2 - random.a(8), random.a(20) - 10);
                if (!this.f.a_(blockPos1).a(Blocks.J)) continue;
                return Vec3D.c(blockPos1);
            }
            return null;
        }
    }

    static class f
    extends PathfinderGoalArrowAttack {
        private final EntityDrowned a;

        public f(IRangedEntity rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
            this.a = (EntityDrowned)rangedAttackMob;
        }

        @Override
        public boolean b() {
            return super.b() && this.a.fx().a(Items.yr);
        }

        @Override
        public void d() {
            super.d();
            this.a.w(true);
            this.a.c(EnumHand.a);
        }

        @Override
        public void e() {
            super.e();
            this.a.gf();
            this.a.w(false);
        }
    }

    static class a
    extends PathfinderGoalZombieAttack {
        private final EntityDrowned b;

        public a(EntityDrowned drowned, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(drowned, speedModifier, followingTargetEvenIfNotSeen);
            this.b = drowned;
        }

        @Override
        public boolean b() {
            return super.b() && this.b.i(this.b.ag_());
        }

        @Override
        public boolean c() {
            return super.c() && this.b.i(this.b.ag_());
        }
    }

    static class b
    extends PathfinderGoalGotoTarget {
        private final EntityDrowned g;

        public b(EntityDrowned drowned, double speedModifier) {
            super(drowned, speedModifier, 8, 2);
            this.g = drowned;
        }

        @Override
        public boolean b() {
            return super.b() && !this.g.ao().ag() && this.g.by() && this.g.dR() >= (double)(this.g.ao().V() - 3);
        }

        @Override
        public boolean c() {
            return super.c();
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            BlockPosition blockPos = pos.d();
            return level.A(blockPos) && level.A(blockPos.d()) && level.a_(pos).b((IBlockAccess)level, pos, this.g);
        }

        @Override
        public void d() {
            this.g.x(false);
            super.d();
        }

        @Override
        public void e() {
            super.e();
        }
    }

    static class e
    extends PathfinderGoal {
        private final EntityDrowned a;
        private final double b;
        private final int c;
        private boolean d;

        public e(EntityDrowned drowned, double speedModifier, int seaLevel) {
            this.a = drowned;
            this.b = speedModifier;
            this.c = seaLevel;
        }

        @Override
        public boolean b() {
            return !this.a.ao().ag() && this.a.by() && this.a.dR() < (double)(this.c - 2);
        }

        @Override
        public boolean c() {
            return this.b() && !this.d;
        }

        @Override
        public void a() {
            if (this.a.dR() < (double)(this.c - 1) && (this.a.N().l() || this.a.gS())) {
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 4, 8, new Vec3D(this.a.dP(), this.c - 1, this.a.dV()), 1.5707963705062866);
                if (posTowards == null) {
                    this.d = true;
                    return;
                }
                this.a.N().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }

        @Override
        public void d() {
            this.a.x(true);
            this.d = false;
        }

        @Override
        public void e() {
            this.a.x(false);
        }
    }
}

