/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpecialDates;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.SpearUseGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombieVillager;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private final AttributeModifier babyModifier;
    private static final MinecraftKey cv = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cw = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cx = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey cy = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cA = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float b = 0.05f;
    public static final int c = 50;
    public static final int d = 40;
    public static final int e = 7;
    private static final int cC = -1;
    private static final EntitySize cD = EntityTypes.bW.n().a(0.5f).b(0.93f);
    private static final float cE = 0.1f;
    public static final Predicate<EnumDifficulty> cF = difficulty -> difficulty == EnumDifficulty.d;
    private static final boolean cG = false;
    private static final boolean cH = false;
    private static final int cI = 0;
    private final PathfinderGoalBreakDoor cJ;
    private boolean cK;
    private int cL;
    public int cM;
    private boolean shouldBurnInDay;

    public EntityZombie(EntityTypes<? extends EntityZombie> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.babyModifier = new AttributeModifier(a, this.ao().paperConfig().entities.behavior.babyZombieMovementModifier, AttributeModifier.Operation.b);
        this.cK = false;
        this.cL = 0;
        this.shouldBurnInDay = true;
        this.cJ = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)level.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(type, level.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bW))));
    }

    public EntityZombie(World level) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bW, level);
    }

    @Override
    protected void D() {
        if (this.ao().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.cs.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.p();
    }

    protected void p() {
        this.cs.a(2, new SpearUseGoal<EntityZombie>(this, 1.0, 1.0, 10.0f, 2.0f));
        this.cs.a(3, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.cs.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gX));
        this.cs.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.ao().spigotConfig.zombieAggressiveTowardsVillager) {
            this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ct.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cv));
    }

    public static AttributeProvider.Builder gT() {
        return EntityMonster.gW().a(GenericAttributes.o, 35.0).a(GenericAttributes.x, 0.23f).a(GenericAttributes.d, 3.0).a(GenericAttributes.b, 2.0).a(GenericAttributes.C);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cz, false);
        builder.a(cA, 0);
        builder.a(cB, false);
    }

    public boolean gU() {
        return this.aD().a(cB);
    }

    public boolean gX() {
        return this.cK;
    }

    public void y(boolean canBreakDoors) {
        if (this.cr.c()) {
            if (this.cK != canBreakDoors) {
                this.cK = canBreakDoors;
                this.cr.e(canBreakDoors);
                if (canBreakDoors) {
                    this.cs.a(1, this.cJ);
                } else {
                    this.cs.a(this.cJ);
                }
            }
        } else if (this.cK) {
            this.cs.a(this.cJ);
            this.cK = false;
        }
    }

    @Override
    public boolean e_() {
        return this.aD().a(cz);
    }

    @Override
    protected int f(WorldServer level) {
        int previousReward = this.cn;
        if (this.e_()) {
            this.cn = (int)((double)this.cn * 2.5);
        }
        int reward = super.f(level);
        this.cn = previousReward;
        return reward;
    }

    @Override
    public void a_(boolean childZombie) {
        this.aD().a(cz, childZombie);
        if (this.ao() != null && !this.ao().B_()) {
            AttributeModifiable attribute = this.h(GenericAttributes.x);
            attribute.c(this.babyModifier.a());
            if (childZombie) {
                attribute.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cz.equals(key)) {
            this.j_();
        }
        super.a(key);
    }

    protected boolean gR() {
        return true;
    }

    @Override
    public void g() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.cb() && !this.gG()) {
                if (this.gU()) {
                    --this.cM;
                    if (this.cM < 0) {
                        this.h(serverLevel);
                    }
                } else if (this.gR()) {
                    if (((Entity)this).a(TagsFluid.a)) {
                        ++this.cL;
                        if (this.cL >= 600) {
                            this.d(300);
                        }
                    } else {
                        this.cL = -1;
                    }
                }
            }
        }
        super.g();
    }

    public void stopDrowning() {
        this.cM = -1;
        this.aD().a(cB, false);
    }

    public void d(int conversionTime) {
        this.cM = conversionTime;
        this.aD().a(cB, true);
    }

    protected void h(WorldServer level) {
        this.a(level, EntityTypes.O);
        if (!this.bq()) {
            level.a(null, 1040, this.dK(), 0);
        }
    }

    protected void a(WorldServer level, EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie converted = this.convertTo(entityType, ConversionParams.a(this, true, true), (T zombie) -> zombie.L(level.c(zombie.dK()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer level, EntityVillager villager) {
        return EntityZombie.convertVillagerToZombieVillager(level, villager, this.dK(), this.bq(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static @Nullable EntityZombieVillager convertVillagerToZombieVillager(WorldServer level, EntityVillager villager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        EntityZombieVillager zombieVillager = villager.convertTo(EntityTypes.bZ, ConversionParams.a(villager, true, true), (T mob) -> {
            mob.a((WorldAccess)level, level.c(mob.dK()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            mob.a(villager.gZ());
            mob.a(villager.he().d());
            mob.a(villager.b().a());
            mob.r(villager.d());
            if (!silent) {
                level.a(null, 1026, blockPosition, 0);
            }
        }, transformReason, creatureSpawnReason);
        return zombieVillager;
    }

    public boolean af_() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        EntityLiving target = this.ag_();
        if (target == null && damageSource.d() instanceof EntityLiving) {
            target = (EntityLiving)damageSource.d();
        }
        if (target != null && level.av() == EnumDifficulty.d && (double)this.as.i() < this.i(GenericAttributes.C) && level.O()) {
            int floor = MathHelper.c(this.dP());
            int floor1 = MathHelper.c(this.dR());
            int floor2 = MathHelper.c(this.dV());
            EntityTypes<? extends EntityZombie> type = this.ay();
            EntityZombie zombie = type.a(level, EntitySpawnReason.j);
            if (zombie == null) {
                return true;
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                int i3;
                int i22;
                int i1 = floor + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1);
                BlockPosition blockPos = new BlockPosition(i1, i22 = floor1 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1), i3 = floor2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1));
                if (!EntityPositionTypes.a(type, level, blockPos) || !EntityPositionTypes.a(type, level, EntitySpawnReason.j, blockPos, level.y)) continue;
                zombie.a_(i1, i22, i3);
                if (level.hasNearbyAlivePlayerThatAffectsSpawning(i1, i22, i3, 7.0) || !level.f(zombie) || !level.g(zombie) || !zombie.gQ() && level.d(zombie.dj())) continue;
                zombie.setTarget(target, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET);
                zombie.a((WorldAccess)level, level.c(zombie.dK()), EntitySpawnReason.j, null);
                level.addFreshEntityWithPassengers(zombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attribute = this.h(GenericAttributes.C);
                AttributeModifier modifier = attribute.a(cv);
                double d2 = modifier != null ? modifier.b() : 0.0;
                attribute.c(cv);
                attribute.d(new AttributeModifier(cv, d2 - 0.05, AttributeModifier.Operation.a));
                zombie.h(GenericAttributes.C).d(cw);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        boolean flag = super.c(level, target);
        if (flag) {
            EntityCombustByEntityEvent event;
            float effectiveDifficulty = level.c(this.dK()).b();
            if (this.fx().f() && this.cp() && this.as.i() < effectiveDifficulty * 0.3f && (event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), (float)(2 * (int)effectiveDifficulty))).callEvent()) {
                target.igniteForSeconds(event.getDuration(), false);
            }
        }
        return flag;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.GG;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.GS;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.GL;
    }

    protected SoundEffect gP() {
        return SoundEffects.Hk;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.gP(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> ay() {
        return super.ay();
    }

    protected boolean gQ() {
        return false;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        float f2 = random.i();
        float f3 = this.ao().av() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int randomInt = random.a(6);
            if (randomInt == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.qH));
            } else if (randomInt == 1) {
                this.a(EnumItemSlot.a, new ItemStack(Items.xL));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.qI));
            }
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsBaby", this.e_());
        output.a("CanBreakDoors", this.gX());
        output.a("InWaterTime", this.by() ? this.cL : -1);
        output.a("DrownedConversionTime", this.gU() ? this.cM : -1);
        output.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a_(input.a("IsBaby", false));
        this.y(input.a("CanBreakDoors", false));
        this.cL = input.a("InWaterTime", 0);
        int intOr = input.a("DrownedConversionTime", -1);
        if (intOr != -1) {
            this.d(intOr);
        } else {
            this.aD().a(cB, false);
        }
        this.shouldBurnInDay = input.a("Paper.ShouldBurnInDay", true);
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        EntityVillager villager;
        double fallbackChance;
        boolean flag = super.a(level, entity, damageSource);
        double d2 = level.av() == EnumDifficulty.d ? 100.0 : (fallbackChance = level.av() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.as.j() * 100.0 < level.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && entity instanceof EntityVillager && this.a(level, villager = (EntityVillager)entity)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cD : super.b(pose);
    }

    @Override
    public boolean h(ItemStack stack) {
        return (!stack.a(TagsItem.az) || !this.e_() || !this.cq()) && super.h(stack);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return !stack.a(Items.tk) && super.c(level, stack);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        float specialMultiplier = difficulty.d();
        if (spawnReason != EntitySpawnReason.i) {
            this.b_(this.ao().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || random.i() < 0.55f * specialMultiplier);
        }
        if (spawnGroupData == null) {
            spawnGroupData = new GroupDataZombie(EntityZombie.a(random), true);
        }
        if (spawnGroupData instanceof GroupDataZombie) {
            GroupDataZombie zombieGroupData = (GroupDataZombie)spawnGroupData;
            if (zombieGroupData.b) {
                this.a_(true);
                if (zombieGroupData.c) {
                    EntityChicken chicken1;
                    if ((double)random.i() < 0.05) {
                        List<Entity> entitiesOfClass = level.a(EntityChicken.class, this.dj().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!entitiesOfClass.isEmpty()) {
                            EntityChicken chicken = (EntityChicken)entitiesOfClass.get(0);
                            chicken.x(true);
                            this.a((Entity)chicken, false, false);
                        }
                    } else if ((double)random.i() < 0.05 && (chicken1 = EntityTypes.C.a(this.ao(), EntitySpawnReason.g)) != null) {
                        chicken1.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
                        chicken1.a(level, difficulty, EntitySpawnReason.g, null);
                        chicken1.x(true);
                        this.a((Entity)chicken1, false, false);
                        level.addFreshEntity(chicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(random.i() < specialMultiplier * 0.1f);
            if (spawnReason != EntitySpawnReason.i) {
                this.a(random, difficulty);
                this.a(level, random, difficulty);
            }
        }
        if (this.a(EnumItemSlot.f).f() && SpecialDates.b() && random.i() < 0.25f) {
            this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.eK : Blocks.eJ));
            this.a(EnumItemSlot.f, 0.0f);
        }
        this.L(specialMultiplier);
        return spawnGroupData;
    }

    @VisibleForTesting
    public void a(int inWaterTime) {
        this.cL = inWaterTime;
    }

    @VisibleForTesting
    public void b(int conversionTime) {
        this.cM = conversionTime;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void L(float difficulty) {
        this.gY();
        this.h(GenericAttributes.r).c(new AttributeModifier(EntityInsentient.ch, this.as.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d2 = this.as.j() * 1.5 * (double)difficulty;
        if (d2 > 1.0) {
            this.h(GenericAttributes.o).c(new AttributeModifier(cy, d2, AttributeModifier.Operation.c));
        }
        if (this.as.i() < difficulty * 0.05f) {
            this.h(GenericAttributes.C).c(new AttributeModifier(cx, this.as.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.h(GenericAttributes.u).c(new AttributeModifier(cx, this.as.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gY() {
        this.h(GenericAttributes.C).a(this.as.j() * (double)0.1f);
    }

    class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speedModifier, int verticalSearchRange) {
            super(Blocks.nb, mob, speedModifier, verticalSearchRange);
        }

        @Override
        public void a(GeneratorAccess level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.GM, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.as.i() * 0.2f);
        }

        @Override
        public void a(World level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.DA, SoundCategory.e, 0.7f, 0.9f + level.y.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean b;
        public final boolean c;

        public GroupDataZombie(boolean isBaby, boolean canSpawnJockey) {
            this.b = isBaby;
            this.c = canSpawnJockey;
        }
    }
}

