/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class EntityZombieHusk
extends EntityZombie {
    public EntityZombieHusk(EntityTypes<? extends EntityZombieHusk> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
    }

    @Override
    public boolean af_() {
        return false;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.oY;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.pb;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.pa;
    }

    @Override
    protected SoundEffect gP() {
        return SoundEffects.pc;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        boolean flag = super.c(level, target);
        if (flag && this.fx().f() && target instanceof EntityLiving) {
            float effectiveDifficulty = level.c(this.dK()).b();
            ((EntityLiving)target).addEffect(new MobEffect(MobEffects.q, 140 * (int)effectiveDifficulty), this, EntityPotionEffectEvent.Cause.ATTACK);
        }
        return flag;
    }

    @Override
    protected boolean gR() {
        return true;
    }

    @Override
    protected void h(WorldServer level) {
        this.a(level, EntityTypes.bW);
        if (!this.bq()) {
            level.a(null, 1041, this.dK(), 0);
        }
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        float specialMultiplier = difficulty.d();
        if (spawnReason != EntitySpawnReason.i) {
            this.b_(random.i() < 0.55f * specialMultiplier);
        }
        if (spawnGroupData != null) {
            spawnGroupData = new a((EntityZombie.GroupDataZombie)spawnGroupData);
            boolean bl = ((a)spawnGroupData).a = spawnReason != EntitySpawnReason.a;
        }
        if (spawnGroupData instanceof a) {
            BlockPosition blockPos;
            a huskGroupData = (a)spawnGroupData;
            if (!huskGroupData.a && level.b(EntityTypes.w.a((double)(blockPos = this.dK()).u() + 0.5, blockPos.v(), (double)blockPos.w() + 0.5))) {
                huskGroupData.a = true;
                if (random.i() < 0.1f) {
                    this.a(EnumItemSlot.a, new ItemStack(Items.xL));
                    CamelHusk camelHusk = EntityTypes.w.a(this.ao(), EntitySpawnReason.a);
                    if (camelHusk != null) {
                        camelHusk.a_(this.dP(), this.dR(), this.dV());
                        camelHusk.a(level, difficulty, spawnReason, null);
                        this.a((Entity)camelHusk, true, true);
                        level.b(camelHusk);
                        Parched parched = EntityTypes.aV.a(this.ao(), EntitySpawnReason.a);
                        if (parched != null) {
                            parched.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
                            parched.a(level, difficulty, spawnReason, null);
                            parched.a((Entity)camelHusk, false, false);
                            level.a_(parched);
                        }
                    }
                }
            }
        }
        return spawnGroupData;
    }

    public static class a
    extends EntityZombie.GroupDataZombie {
        public boolean a = false;

        public a(EntityZombie.GroupDataZombie zombieGroupData) {
            super(zombieGroupData.b, zombieGroupData.c);
        }
    }
}

