/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.npc.villager.VillagerDataHolder;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> f = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int cv = 3600;
    private static final int cw = 6000;
    private static final int cx = 14;
    private static final int cy = 4;
    private static final int cz = -1;
    private static final int cA = 0;
    private static final Set<EntitySpawnReason> cB = EnumSet.of(EntitySpawnReason.r, new EntitySpawnReason[]{EntitySpawnReason.s, EntitySpawnReason.i, EntitySpawnReason.m, EntitySpawnReason.c, EntitySpawnReason.q});
    public int cC;
    public @Nullable UUID cD;
    private @Nullable Reputation cE;
    private @Nullable MerchantRecipeList cF;
    private int cG = 0;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(f, this.hb());
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("VillagerData", VillagerData.c, this.gZ());
        output.b("Offers", MerchantRecipeList.a, this.cF);
        output.b("Gossips", Reputation.a, this.cE);
        output.a("ConversionTime", this.gS() ? this.cC : -1);
        output.b("ConversionPlayer", UUIDUtil.a, this.cD);
        output.a("Xp", this.cG);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(f, input.a("VillagerData", VillagerData.c).orElseGet(this::hb));
        this.cF = input.a("Offers", MerchantRecipeList.a).orElse(null);
        this.cE = input.a("Gossips", Reputation.a).orElse(null);
        int intOr = input.a("ConversionTime", -1);
        if (intOr != -1) {
            UUID uuid = input.a("ConversionPlayer", UUIDUtil.a).orElse(null);
            this.b(uuid, intOr);
        } else {
            this.aD().a(a, false);
            this.cC = -1;
        }
        this.cG = input.a("Xp", 0);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (!cB.contains((Object)spawnReason)) {
            this.a(this.gZ().a(level.J_(), VillagerType.a(level.z(this.dK()))));
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private VillagerData hb() {
        Optional random = BuiltInRegistries.y.a(this.as);
        VillagerData villagerData = EntityVillager.gX();
        if (random.isPresent()) {
            villagerData = villagerData.b(random.get());
        }
        return villagerData;
    }

    @Override
    public void g() {
        if (!this.ao().B_() && this.cb() && this.gS()) {
            int conversionProgress = this.hc();
            this.cC -= conversionProgress;
            if (this.cC <= 0) {
                this.i((WorldServer)this.ao());
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.rK)) {
            if (this.d(MobEffects.r)) {
                itemInHand.a(1, (EntityLiving)player);
                if (!this.ao().B_()) {
                    this.b(player.cY(), this.as.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean gR() {
        return false;
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.gS() && this.cG == 0;
    }

    public boolean gS() {
        return this.aD().a(a);
    }

    public void b(@Nullable UUID conversionStarter, int villagerConversionTime) {
        this.startConverting(conversionStarter, villagerConversionTime, true);
    }

    public void startConverting(@Nullable UUID conversionStarter, int villagerConversionTime, boolean broadcastEntityEvent) {
        this.cD = conversionStarter;
        this.cC = villagerConversionTime;
        this.aD().a(a, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, villagerConversionTime, Math.min(this.ao().av().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.ao().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 16) {
            if (!this.bq()) {
                this.ao().a(this.dP(), this.dT(), this.dV(), SoundEffects.Hn, this.dB(), 1.0f + this.as.i(), this.as.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(id);
        }
    }

    private void i(WorldServer level) {
        EntityVillager converted = this.convertTo(EntityTypes.bL, ConversionParams.a(this, false, false), (T mob) -> {
            EntityHuman playerByUuid;
            for (EnumItemSlot equipmentSlot : this.a(level, (ItemStack itemStack) -> !EnchantmentManager.a(itemStack, EnchantmentEffectComponents.F))) {
                SlotAccess slot = mob.a_(equipmentSlot.b() + 300);
                if (slot == null) continue;
                slot.a(this.a(equipmentSlot));
            }
            mob.a(this.gZ());
            if (this.cE != null) {
                mob.a(this.cE);
            }
            if (this.cF != null) {
                mob.b(this.cF.a());
            }
            mob.s(this.cG);
            mob.a((WorldAccess)level, level.c(mob.dK()), EntitySpawnReason.i, null);
            mob.i(level);
            if (this.cD != null && (playerByUuid = level.getGlobalPlayerByUUID(this.cD)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)playerByUuid, this, (EntityVillager)mob);
                level.a(ReputationEvent.a, (Entity)playerByUuid, (ReputationHandler)((Object)mob));
            }
            mob.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.bq()) {
                level.a(null, 1027, this.dK(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void d(int villagerConversionTime) {
        this.cC = villagerConversionTime;
    }

    private int hc() {
        int i2 = 1;
        if (this.as.i() < 0.01f) {
            int i1 = 0;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i22 = (int)this.dP() - 4; i22 < (int)this.dP() + 4 && i1 < 14; ++i22) {
                for (int i3 = (int)this.dR() - 4; i3 < (int)this.dR() + 4 && i1 < 14; ++i3) {
                    for (int i4 = (int)this.dV() - 4; i4 < (int)this.dV() + 4 && i1 < 14; ++i4) {
                        IBlockData blockState = this.ao().a_(mutableBlockPos.d(i22, i3, i4));
                        if (!blockState.a(Blocks.fC) && !(blockState.b() instanceof BlockBed)) continue;
                        if (this.as.i() < 0.3f) {
                            ++i2;
                        }
                        ++i1;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fD() {
        return this.e_() ? (this.as.i() - this.as.i()) * 0.2f + 2.0f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.Hl;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.Hp;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Ho;
    }

    @Override
    public SoundEffect gP() {
        return SoundEffects.Hq;
    }

    public void a(MerchantRecipeList tradeOffers) {
        this.cF = tradeOffers;
    }

    public void a(Reputation gossips) {
        this.cE = gossips;
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gZ();
        if (!villagerData.b().equals(data.b())) {
            this.cF = null;
        }
        this.az.a(f, data);
    }

    @Override
    public VillagerData gZ() {
        return this.az.a(f);
    }

    public int ha() {
        return this.cG;
    }

    public void r(int villagerXp) {
        this.cG = villagerXp;
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aC ? EntityZombieVillager.c(component, this.gZ().a()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aC);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aC) {
            Holder<VillagerType> holder = EntityZombieVillager.c(DataComponents.aC, value);
            this.a(this.gZ().a(holder));
            return true;
        }
        return super.b(component, value);
    }
}

