/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.villager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.npc.villager.VillagerDataHolder;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger cB = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cC = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int cx = 12;
    public static final Map<Item, Integer> cy = ImmutableMap.of((Object)Items.rd, (Object)4, (Object)Items.ws, (Object)1, (Object)Items.wr, (Object)1, (Object)Items.xz, (Object)1);
    private static final int cD = 2;
    private static final int cE = 10;
    private static final int cF = 1200;
    private static final int cG = 24000;
    private static final int cH = 10;
    private static final int cI = 5;
    private static final long cJ = 24000L;
    @VisibleForTesting
    public static final float cz = 0.5f;
    private static final int cK = 0;
    private static final byte cL = 0;
    private static final int cM = 0;
    private static final int cN = 0;
    private static final int cO = 0;
    private static final boolean cP = false;
    private int cQ;
    private boolean cR;
    private @Nullable EntityHuman cU;
    private boolean cV;
    private int cW = 0;
    private final Reputation cX = new Reputation();
    private long cY;
    private long cZ = 0L;
    private int da = 0;
    private long db = 0L;
    public int dc = 0;
    private long dd;
    private boolean de = false;
    private static final ImmutableList<MemoryModuleType<?>> df = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.ba, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> dg = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> cA = ImmutableMap.of(MemoryModuleType.b, (villager, poiType) -> poiType.a(PoiTypes.n), MemoryModuleType.c, (villager, poiType) -> villager.gZ().b().a().b().test((Holder<VillagePlaceType>)poiType), MemoryModuleType.d, (villager, poiType) -> VillagerProfession.a.test((Holder<VillagePlaceType>)poiType), MemoryModuleType.e, (villager, poiType) -> poiType.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> type, World level) {
        this(type, level, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> type, World level, ResourceKey<VillagerType> villagerType) {
        this(type, level, level.J_().d(villagerType));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> type, World level, Holder<VillagerType> villagerType) {
        super((EntityTypes<? extends EntityVillagerAbstract>)type, level);
        this.N().e(true);
        this.N().a(true);
        this.N().a(48.0f);
        this.b_(true);
        this.a(this.gZ().a(villagerType).b(level.J_(), VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> ev() {
        return super.ev();
    }

    protected BehaviorController.b<EntityVillager> ew() {
        return BehaviorController.a(df, dg);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> brain = this.ew().a(dynamic);
        this.a(brain);
        return brain;
    }

    public void i(WorldServer level) {
        BehaviorController<EntityVillager> brain = this.ev();
        brain.b(level, this);
        this.ca = brain.h();
        this.a(this.ev());
    }

    private void a(BehaviorController<EntityVillager> villagerBrain) {
        Holder<VillagerProfession> holder = this.gZ().b();
        if (this.e_()) {
            villagerBrain.a(EnvironmentAttributes.S);
            villagerBrain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            villagerBrain.a(EnvironmentAttributes.R);
            villagerBrain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        villagerBrain.a(Activity.a, Behaviors.a(holder, 0.5f));
        villagerBrain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        villagerBrain.a(Activity.e, Behaviors.c(holder, 0.5f));
        villagerBrain.a(Activity.b, Behaviors.e(holder, 0.5f));
        villagerBrain.a(Activity.g, Behaviors.f(holder, 0.5f));
        villagerBrain.a(Activity.i, Behaviors.g(holder, 0.5f));
        villagerBrain.a(Activity.h, Behaviors.h(holder, 0.5f));
        villagerBrain.a(Activity.j, Behaviors.i(holder, 0.5f));
        villagerBrain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        villagerBrain.b(Activity.b);
        villagerBrain.a(Activity.b);
        villagerBrain.a(this.ao().c(), this.ao().au(), this.dI());
    }

    @Override
    protected void h() {
        super.h();
        if (this.ao() instanceof WorldServer) {
            this.i((WorldServer)this.ao());
        }
    }

    public static AttributeProvider.Builder gT() {
        return EntityInsentient.E().a(GenericAttributes.x, 0.5);
    }

    public boolean gU() {
        return this.de;
    }

    @Override
    public void inactiveTick() {
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        if (this.dy()) {
            if (this.ao().spigotConfig.tickInactiveVillagers) {
                this.a(this.ao().getMinecraftWorld());
            } else {
                this.customServerAiStep(this.ao().getMinecraftWorld(), true);
            }
        }
        this.hr();
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer level) {
        this.customServerAiStep(level, false);
    }

    protected void customServerAiStep(WorldServer level, boolean inactive) {
        Raid raidAt;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("villagerBrain");
        if (!inactive) {
            this.ev().a(level, this);
        }
        profilerFiller.c();
        if (this.de) {
            this.de = false;
        }
        if (!this.gQ() && this.cQ > 0) {
            --this.cQ;
            if (this.cQ <= 0) {
                if (this.cR) {
                    this.k(level);
                    this.cR = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cU != null) {
            level.a(ReputationEvent.e, (Entity)this.cU, this);
            level.a((Entity)this, (byte)14);
            this.cU = null;
        }
        if (!inactive && !this.gG() && this.as.a(100) == 0 && (raidAt = level.f(this.dK())) != null && raidAt.r() && !raidAt.a()) {
            level.a((Entity)this, (byte)42);
        }
        if (this.gZ().b().a(VillagerProfession.b) && this.gQ()) {
            this.gS();
        }
        if (inactive) {
            return;
        }
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        this.hr();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.vm) || !this.cb() || this.gQ() || this.gr()) {
            return super.b(player, hand);
        }
        if (this.e_()) {
            this.hf();
            return EnumInteractionResult.a;
        }
        if (!this.ao().B_()) {
            boolean isEmpty = this.b().isEmpty();
            if (hand == EnumHand.a) {
                if (isEmpty) {
                    this.hf();
                }
                player.a(StatisticList.U);
            }
            if (isEmpty) {
                return EnumInteractionResult.c;
            }
            this.h(player);
        }
        return EnumInteractionResult.a;
    }

    public void hf() {
        this.r(40);
        if (!this.ao().B_()) {
            this.b(SoundEffects.Eo);
        }
    }

    private void h(EntityHuman player) {
        this.i(player);
        this.a(player);
        this.a(player, this.R_(), this.gZ().c());
    }

    @Override
    public void a(@Nullable EntityHuman player) {
        boolean flag = this.a() != null && player == null;
        super.a(player);
        if (flag) {
            this.gS();
        }
    }

    @Override
    protected void gS() {
        super.gS();
        this.hg();
    }

    private void hg() {
        if (!this.ao().B_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.b()) {
                merchantOffer.n();
            }
        }
    }

    @Override
    public boolean gV() {
        return true;
    }

    public void gW() {
        this.hl();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.b()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
            if (!event.callEvent()) continue;
            merchantOffer.j();
        }
        this.hh();
        this.db = this.ao().au();
        ++this.dc;
    }

    private void hh() {
        MerchantRecipeList offers = this.b();
        EntityHuman tradingPlayer = this.a();
        if (tradingPlayer != null && !offers.isEmpty()) {
            tradingPlayer.a(tradingPlayer.cn.l, offers, this.gZ().c(), this.d(), this.e(), this.gV());
        }
    }

    private boolean hi() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.b()) {
            if (!merchantOffer.t()) continue;
            return true;
        }
        return false;
    }

    private boolean hj() {
        return this.dc == 0 || this.dc < 2 && this.ao().au() > this.db + 2400L;
    }

    public boolean j(WorldServer level) {
        long l2 = this.db + 12000L;
        long gameTime = this.ao().au();
        boolean flag = gameTime > l2;
        long dayCount = level.e();
        boolean bl = this.dd > 0L && dayCount > this.dd;
        this.dd = dayCount;
        if (flag |= bl) {
            this.db = gameTime;
            this.hs();
        }
        return this.hj() && this.hi();
    }

    private void hk() {
        int i2 = 2 - this.dc;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.b()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
                if (!event.callEvent()) continue;
                merchantOffer.j();
            }
        }
        for (int i1 = 0; i1 < i2; ++i1) {
            this.hl();
        }
        this.hh();
    }

    public void hl() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.b()) {
            merchantOffer.g();
        }
    }

    private void i(EntityHuman player) {
        int playerReputation = this.g(player);
        if (playerReputation != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.b()) {
                if (merchantOffer.ignoreDiscounts) continue;
                merchantOffer.a(-MathHelper.b((float)playerReputation * merchantOffer.p()));
            }
        }
        if (player.d(MobEffects.F)) {
            MobEffect effect = player.e(MobEffects.F);
            int amplifier = effect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer1 : this.b()) {
                if (merchantOffer1.ignoreDiscounts) continue;
                double d2 = 0.3 + 0.0625 * (double)amplifier;
                int i2 = (int)Math.floor(d2 * (double)merchantOffer1.a().N());
                merchantOffer1.a(-Math.max(i2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cC, EntityVillager.gX());
    }

    public static VillagerData gX() {
        return new VillagerData(BuiltInRegistries.x.b(VillagerType.c), BuiltInRegistries.y.b(VillagerProfession.b), 1);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("VillagerData", VillagerData.c, this.gZ());
        output.a("FoodLevel", (byte)this.cW);
        output.a("Gossips", Reputation.a, this.cX);
        output.a("Xp", this.da);
        output.a("LastRestock", this.db);
        output.a("LastGossipDecay", this.cZ);
        output.a("RestocksToday", this.dc);
        if (this.de) {
            output.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(cC, input.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gX));
        this.cW = input.a("FoodLevel", (byte)0);
        this.cX.c();
        input.a("Gossips", Reputation.a).ifPresent(this.cX::a);
        this.da = input.a("Xp", 0);
        this.db = input.a("LastRestock", 0L);
        this.cZ = input.a("LastGossipDecay", 0L);
        if (this.ao() instanceof WorldServer) {
            this.i((WorldServer)this.ao());
        }
        this.dc = input.a("RestocksToday", 0);
        this.de = input.a("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public @Nullable SoundEffect W() {
        if (this.gr()) {
            return null;
        }
        return this.gQ() ? SoundEffects.Ep : SoundEffects.Ek;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.En;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Em;
    }

    public void gY() {
        this.b(this.gZ().b().a().f());
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gZ();
        if (!villagerData.b().equals(data.b())) {
            this.cw = null;
        }
        this.az.a(cC, data);
    }

    @Override
    public VillagerData gZ() {
        return this.az.a(cC);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.as.a(4);
        this.da += offer.q();
        this.cU = this.a();
        if (this.hp()) {
            this.cQ = 40;
            this.cR = true;
            i2 += 5;
        }
        if (offer.u()) {
            this.ao().b(new EntityExperienceOrb(this.ao(), this.dP(), this.dR() + 0.5, this.dV(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.a(), this));
        }
    }

    @Override
    public void a(@Nullable EntityLiving livingEntity) {
        if (livingEntity != null && this.ao() instanceof WorldServer) {
            ((WorldServer)this.ao()).a(ReputationEvent.c, (Entity)livingEntity, this);
            if (this.cb() && livingEntity instanceof EntityHuman) {
                this.ao().a((Entity)this, (byte)13);
            }
        }
        super.a(livingEntity);
    }

    @Override
    public void a(DamageSource damageSource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            cB.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.a(this).getString());
        }
        if ((entity = damageSource.d()) != null) {
            this.H(entity);
        }
        this.hm();
        super.a(damageSource);
    }

    public void hm() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void H(Entity murderer) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> memory = this.ca.c(MemoryModuleType.h);
            if (!memory.isEmpty()) {
                memory.get().b(ReputationHandler.class::isInstance).forEach(entity -> serverLevel.a(ReputationEvent.d, murderer, (ReputationHandler)((Object)entity)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> moduleType) {
        if (this.ao() instanceof WorldServer) {
            MinecraftServer server = ((WorldServer)this.ao()).s();
            this.ca.c(moduleType).ifPresent(pos -> {
                WorldServer level = server.a(pos.a());
                if (level != null) {
                    VillagePlace poiManager = level.F();
                    Optional<Holder<VillagePlaceType>> type = poiManager.c(pos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> biPredicate = cA.get(moduleType);
                    if (type.isPresent() && biPredicate.test(this, type.get())) {
                        poiManager.b(pos.b());
                        level.W().b(pos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Y_() {
        return this.cW + this.hq() >= 12 && !this.gr() && this.Z_() == 0;
    }

    private boolean hn() {
        return this.cW < 12;
    }

    private void ho() {
        if (this.hn() && this.hq() != 0) {
            for (int i2 = 0; i2 < this.gP().b(); ++i2) {
                int count;
                Integer integer;
                ItemStack item = this.gP().a(i2);
                if (item.f() || (integer = cy.get(item.h())) == null) continue;
                for (int i1 = count = item.N(); i1 > 0; --i1) {
                    this.cW += integer.intValue();
                    this.gP().a(i2, 1);
                    if (this.hn()) continue;
                    return;
                }
            }
        }
    }

    public int g(EntityHuman player) {
        return this.cX.a(player.cY(), (ReputationType type) -> true);
    }

    private void t(int level) {
        this.cW -= level;
    }

    public void ha() {
        this.ho();
        this.t(12);
    }

    public void b(MerchantRecipeList offers) {
        this.cw = offers;
    }

    private boolean hp() {
        int level = this.gZ().c();
        return VillagerData.d(level) && this.da >= VillagerData.c(level);
    }

    public void k(WorldServer level) {
        this.a(this.gZ().a(this.gZ().c() + 1));
        this.h(level);
    }

    @Override
    protected IChatBaseComponent cR() {
        return this.gZ().b().a().a();
    }

    @Override
    public void b(byte id) {
        if (id == 12) {
            this.a(Particles.T);
        } else if (id == 13) {
            this.a(Particles.a);
        } else if (id == 14) {
            this.a(Particles.R);
        } else if (id == 42) {
            this.a(Particles.aq);
        } else {
            super.b(id);
        }
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnReason == EntitySpawnReason.e) {
            this.a(this.gZ().b(level.J_(), VillagerProfession.b));
        }
        if (spawnReason == EntitySpawnReason.n || spawnReason == EntitySpawnReason.m || EntitySpawnReason.a(spawnReason) || spawnReason == EntitySpawnReason.o) {
            this.a(this.gZ().a(level.J_(), VillagerType.a(level.z(this.dK()))));
        }
        if (spawnReason == EntitySpawnReason.d) {
            this.de = true;
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public @Nullable EntityVillager b(WorldServer level, EntityAgeable partner) {
        double randomDouble = this.as.j();
        Holder<VillagerType> orThrow = randomDouble < 0.5 ? level.J_().d(VillagerType.a(level.z(this.dK()))) : (randomDouble < 0.75 ? this.gZ().a() : ((EntityVillager)partner).gZ().a());
        EntityVillager villager = new EntityVillager(EntityTypes.bL, (World)level, orThrow);
        villager.a((WorldAccess)level, level.c(villager.dK()), EntitySpawnReason.e, null);
        return villager;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.av() != EnumDifficulty.a) {
            EntityWitch witch = this.convertTo(EntityTypes.bQ, ConversionParams.a(this, false, false), (T witch1) -> {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, witch1).isCancelled()) {
                    return false;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    cB.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                witch1.a((WorldAccess)level, level.c(witch1.dK()), EntitySpawnReason.i, null);
                witch1.gz();
                this.hm();
                return true;
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (witch == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        InventoryCarrier.a(level, this, this, entity);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        Item item = stack.h();
        return (stack.a(TagsItem.ci) || this.gZ().b().a().d().contains((Object)item)) && this.gP().c(stack);
    }

    public boolean hb() {
        return this.hq() >= 24;
    }

    public boolean hc() {
        return this.hq() < 12;
    }

    private int hq() {
        InventorySubcontainer inventory = this.gP();
        return cy.entrySet().stream().mapToInt(entry -> inventory.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean hd() {
        return this.gP().a_((ItemStack stack) -> stack.a(TagsItem.ch));
    }

    @Override
    protected void h(WorldServer level) {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] itemListings;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map1;
        VillagerData villagerData = this.gZ();
        ResourceKey resourceKey = villagerData.b().e().orElse(null);
        if (resourceKey != null && (map1 = this.ao().Q().b(FeatureFlags.b) ? ((map = VillagerTrades.c.get(resourceKey)) != null ? map : VillagerTrades.a.get(resourceKey)) : VillagerTrades.a.get(resourceKey)) != null && !map1.isEmpty() && (itemListings = (VillagerTrades.IMerchantRecipeOption[])map1.get(villagerData.c())) != null) {
            MerchantRecipeList offers = this.b();
            this.a((WorldServer)this.ao(), offers, itemListings, amount);
            if (SharedConstants.af && villagerData.c() < map1.size()) {
                this.k((WorldServer)this.ao());
            }
            return true;
        }
        return false;
    }

    public void a(WorldServer level, EntityVillager target, long gameTime) {
        if (!(gameTime >= this.cY && gameTime < this.cY + 1200L || gameTime >= target.cY && gameTime < target.cY + 1200L)) {
            this.cX.a(target.cX, this.as, 10);
            this.cY = gameTime;
            target.cY = gameTime;
            this.a(level, gameTime, 5);
        }
    }

    private void hr() {
        long gameTime = this.ao().au();
        if (this.cZ == 0L) {
            this.cZ = gameTime;
        } else if (gameTime >= this.cZ + 24000L) {
            this.cX.b();
            this.cZ = gameTime;
        }
    }

    public void a(WorldServer level, long gameTime, int minVillagerAmount) {
        AxisAlignedBB aabb;
        List<EntityVillager> entitiesOfClass;
        List<EntityVillager> list;
        if (this.a(gameTime) && (list = (entitiesOfClass = level.a(EntityVillager.class, aabb = this.dj().c(10.0, 10.0, 10.0))).stream().filter(villager -> villager.a(gameTime)).limit(5L).toList()).size() >= minVillagerAmount && SpawnUtil.trySpawnMob(EntityTypes.au, EntitySpawnReason.f, level, this.dK(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            entitiesOfClass.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long gameTime) {
        return this.b(this.ao().au()) && !this.ca.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent type, Entity target) {
        if (type == ReputationEvent.a) {
            this.cX.a(target.cY(), ReputationType.d, 20);
            this.cX.a(target.cY(), ReputationType.c, 25);
        } else if (type == ReputationEvent.e) {
            this.cX.a(target.cY(), ReputationType.e, 2);
        } else if (type == ReputationEvent.c) {
            this.cX.a(target.cY(), ReputationType.b, 25);
        } else if (type == ReputationEvent.d) {
            this.cX.a(target.cY(), ReputationType.a, 25);
        }
    }

    @Override
    public int d() {
        return this.da;
    }

    public void s(int villagerXp) {
        this.da = villagerXp;
    }

    private void hs() {
        this.hk();
        this.dc = 0;
    }

    public Reputation he() {
        return this.cX;
    }

    public void a(Reputation gossips) {
        this.cX.a(gossips);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.ca.a(MemoryModuleType.I, this.ao().au());
        this.ca.b(MemoryModuleType.n);
        this.ca.b(MemoryModuleType.F);
    }

    @Override
    public void gs() {
        super.gs();
        this.ca.a(MemoryModuleType.J, this.ao().au());
    }

    private boolean b(long gameTime) {
        Optional<Long> memory = this.ca.c(MemoryModuleType.I);
        return memory.filter(lastSlept -> gameTime - lastSlept < 24000L).isPresent();
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aC ? EntityVillager.c(component, this.gZ().a()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aC);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aC) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.aC, value);
            this.a(this.gZ().a(holder));
            return true;
        }
        return super.b(component, value);
    }
}

