/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.villager;

import com.google.common.collect.Lists;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.ArrayList;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> cx = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int cv = 300;
    private static final int cy = 8;
    private @Nullable EntityHuman cz;
    protected @Nullable MerchantRecipeList cw;
    private final InventorySubcontainer cA = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World level) {
        super((EntityTypes<? extends EntityAgeable>)type, level);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public int p() {
        return this.az.a(cx);
    }

    public void r(int unhappyCounter) {
        this.az.a(cx, unhappyCounter);
    }

    @Override
    public int d() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cx, 0);
    }

    @Override
    public void a(@Nullable EntityHuman player) {
        this.cz = player;
    }

    @Override
    public @Nullable EntityHuman a() {
        return this.cz;
    }

    public boolean gQ() {
        return this.cz != null;
    }

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public void resetOffers() {
        this.cw = new MerchantRecipeList();
        this.h((WorldServer)this.ao());
    }

    @Override
    public MerchantRecipeList b() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.cw == null) {
                this.cw = new MerchantRecipeList();
                this.h(serverLevel);
            }
            return this.cw;
        }
        throw new IllegalStateException("Cannot load Villager offers on the client");
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void a(int xp) {
    }

    @Override
    public void processTrade(MerchantRecipe offer, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            offer.l();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(offer);
        }
        this.a(offer);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.cm = -this.S();
        if (this.cz instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.cz, this, offer.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean e() {
        return true;
    }

    @Override
    public void a(ItemStack stack) {
        if (!this.ao().B_() && this.cm > -this.S() + 20) {
            this.cm = -this.S();
            this.b(this.x(!stack.f()));
        }
    }

    @Override
    public SoundEffect f() {
        return SoundEffects.Eq;
    }

    protected SoundEffect x(boolean isYesSound) {
        return isYesSound ? SoundEffects.Eq : SoundEffects.Eo;
    }

    public void gR() {
        this.b(SoundEffects.El);
    }

    @Override
    protected void a(ValueOutput output) {
        MerchantRecipeList offers;
        super.a(output);
        if (!this.ao().B_() && !(offers = this.b()).isEmpty()) {
            output.a("Offers", MerchantRecipeList.a, offers);
        }
        this.a_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cw = input.a("Offers", MerchantRecipeList.a).orElse(null);
        this.a_(input);
    }

    @Override
    public @Nullable Entity b(TeleportTransition teleportTransition) {
        this.gS();
        return super.b(teleportTransition);
    }

    protected void gS() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.gS();
    }

    protected void a(ParticleParam options) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            this.ao().a(options, this.e(1.0), this.dS() + 1.0, this.h(1.0), d2, d1, d22);
        }
    }

    @Override
    public boolean aj_() {
        return false;
    }

    @Override
    public InventorySubcontainer gP() {
        return this.cA;
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        int i2 = slot - 300;
        return i2 >= 0 && i2 < this.cA.b() ? this.cA.a_(i2) : super.a_(slot);
    }

    protected abstract void h(WorldServer var1);

    protected void a(WorldServer level, MerchantRecipeList givenMerchantOffers, VillagerTrades.IMerchantRecipeOption[] newTrades, int maxNumbers) {
        ArrayList list = Lists.newArrayList((Object[])newTrades);
        int i2 = 0;
        while (i2 < maxNumbers && !list.isEmpty()) {
            MerchantRecipe offer = ((VillagerTrades.IMerchantRecipeOption)list.remove(this.as.a(list.size()))).a(level, this, this.as);
            if (offer == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)offer.asBukkit());
            if (this.valid) {
                event.callEvent();
            }
            if (!event.isCancelled()) {
                CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
                if (craftMerchantRecipe.getIngredients().isEmpty()) {
                    return;
                }
                givenMerchantOffers.add(craftMerchantRecipe.toMinecraft());
            }
            ++i2;
        }
    }

    @Override
    public Vec3D u(float partialTick) {
        float f2 = MathHelper.h(partialTick, this.bD, this.bC) * ((float)Math.PI / 180);
        Vec3D vec3 = new Vec3D(0.0, this.dj().c() - 1.0, 0.2);
        return this.p(partialTick).e(vec3.b(-f2));
    }

    @Override
    public boolean c() {
        return this.ao().B_();
    }

    @Override
    public boolean b(EntityHuman player) {
        return this.a() == player && this.cb() && player.b((Entity)this, 4.0);
    }
}

