/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.wanderingtrader;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTradeWithPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalUseItem;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.illager.EntityEvoker;
import net.minecraft.world.entity.monster.illager.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.illager.EntityPillager;
import net.minecraft.world.entity.monster.illager.EntityVindicator;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityVillagerTrader
extends EntityVillagerAbstract
implements Consumable.b {
    private static final int cx = 0;
    private @Nullable BlockPosition cy;
    private int cz = 0;
    public boolean canDrinkPotion = true;
    public boolean canDrinkMilk = true;

    public EntityVillagerTrader(EntityTypes<? extends EntityVillagerTrader> type, World level) {
        super((EntityTypes<? extends EntityVillagerAbstract>)type, level);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, PotionContents.a(Items.up, Potions.g), SoundEffects.EQ, wanderingTrader -> this.canDrinkPotion && this.ao().ah() && !wanderingTrader.cG()));
        this.cs.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, new ItemStack(Items.sq), SoundEffects.EV, wanderingTrader -> this.canDrinkMilk && this.ao().ag() && wanderingTrader.cG()));
        this.cs.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityZombie>(this, EntityZombie.class, 8.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityVex>(this, EntityVex.class, 8.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityPillager>(this, EntityPillager.class, 15.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityIllagerIllusioner>(this, EntityIllagerIllusioner.class, 12.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalAvoidTarget<EntityZoglin>(this, EntityZoglin.class, 10.0f, 0.5, 0.5));
        this.cs.a(1, new PathfinderGoalPanic(this, 0.5));
        this.cs.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.cs.a(2, new a(this, 2.0, 0.35));
        this.cs.a(4, new PathfinderGoalMoveTowardsRestriction(this, 0.35));
        this.cs.a(8, new PathfinderGoalRandomStrollLand(this, 0.35));
        this.cs.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return null;
    }

    @Override
    public boolean e() {
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.a(Items.vm) && this.cb() && !this.gQ() && !this.e_()) {
            if (hand == EnumHand.a) {
                player.a(StatisticList.U);
            }
            if (!this.ao().B_()) {
                if (this.b().isEmpty()) {
                    return EnumInteractionResult.c;
                }
                this.a(player);
                this.a(player, this.R_(), 1);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    protected void h(WorldServer level) {
        MerchantRecipeList offers = this.b();
        for (Pair<VillagerTrades.IMerchantRecipeOption[], Integer> pair : VillagerTrades.b) {
            VillagerTrades.IMerchantRecipeOption[] itemListings = (VillagerTrades.IMerchantRecipeOption[])pair.getLeft();
            this.a(level, offers, itemListings, (Integer)pair.getRight());
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("DespawnDelay", this.cz);
        output.b("wander_target", BlockPosition.a, this.cy);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cz = input.a("DespawnDelay", 0);
        this.cy = input.a("wander_target", BlockPosition.a).orElse(null);
        this.d_(Math.max(0, this.Z_()));
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void b(MerchantRecipe offer) {
        if (offer.u()) {
            int i2 = 3 + this.as.a(4);
            this.ao().b(new EntityExperienceOrb(this.ao(), this.dP(), this.dR() + 0.5, this.dV(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.a(), this));
        }
    }

    @Override
    public SoundEffect W() {
        return this.gQ() ? SoundEffects.EW : SoundEffects.EO;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.ET;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.EP;
    }

    @Override
    public SoundEffect j(ItemStack stack) {
        return stack.a(Items.sq) ? SoundEffects.ER : SoundEffects.ES;
    }

    @Override
    protected SoundEffect x(boolean getYesSound) {
        return getYesSound ? SoundEffects.EX : SoundEffects.EU;
    }

    @Override
    public SoundEffect f() {
        return SoundEffects.EX;
    }

    public void s(int despawnDelay) {
        this.cz = despawnDelay;
    }

    public int gT() {
        return this.cz;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.ao().B_()) {
            this.gU();
        }
    }

    private void gU() {
        if (this.cz > 0 && !this.gQ() && --this.cz == 0) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    public void h(@Nullable BlockPosition wanderTarget) {
        this.cy = wanderTarget;
    }

    public @Nullable BlockPosition gW() {
        return this.cy;
    }

    class a
    extends PathfinderGoal {
        final EntityVillagerTrader a;
        final double b;
        final double c;

        a(EntityVillagerTrader trader, double stopDistance, double speedModifier) {
            this.a = trader;
            this.b = stopDistance;
            this.c = speedModifier;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public void e() {
            this.a.h((BlockPosition)null);
            EntityVillagerTrader.this.cr.n();
        }

        @Override
        public boolean b() {
            BlockPosition wanderTarget = this.a.gW();
            return wanderTarget != null && this.a(wanderTarget, this.b);
        }

        @Override
        public void a() {
            BlockPosition wanderTarget = this.a.gW();
            if (wanderTarget != null && EntityVillagerTrader.this.cr.l()) {
                if (this.a(wanderTarget, 10.0)) {
                    Vec3D vec3 = new Vec3D((double)wanderTarget.u() - this.a.dP(), (double)wanderTarget.v() - this.a.dR(), (double)wanderTarget.w() - this.a.dV()).d();
                    Vec3D vec31 = vec3.c(10.0).b(this.a.dP(), this.a.dR(), this.a.dV());
                    EntityVillagerTrader.this.cr.a(vec31.g, vec31.h, vec31.i, this.c);
                } else {
                    EntityVillagerTrader.this.cr.a((double)wanderTarget.u(), (double)wanderTarget.v(), (double)wanderTarget.w(), this.c);
                }
            }
        }

        private boolean a(BlockPosition pos, double distance) {
            return !pos.a(this.a.dI(), distance);
        }
    }
}

