/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class AutoRecipeStackManager<T> {
    public final Object2IntOpenHashMap<T> amounts = new Object2IntOpenHashMap();

    boolean b(T item, int amount) {
        return this.amounts.getInt(item) >= amount;
    }

    void c(T item, int amount) {
        int i2 = this.amounts.addTo(item, -amount);
        if (i2 < amount) {
            throw new IllegalStateException("Took " + amount + " items, but only had " + i2);
        }
    }

    void d(T item, int amount) {
        this.amounts.addTo(item, amount);
    }

    public boolean a(List<? extends a<T>> ingredients, int amount, @Nullable b<T> output) {
        return new c(ingredients).a(amount, output);
    }

    public int b(List<? extends a<T>> ingredients, int amount, @Nullable b<T> output) {
        return new c(ingredients).b(amount, output);
    }

    public void a() {
        this.amounts.clear();
    }

    public void a(T item, int amount) {
        this.d(item, amount);
    }

    List<T> a(Iterable<? extends a<T>> ingredients) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.amounts)) {
            if (entry.getIntValue() <= 0 || !AutoRecipeStackManager.a(ingredients, entry.getKey())) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    private static <T> boolean a(Iterable<? extends a<T>> ingredients, T item) {
        for (a<T> ingredientInfo : ingredients) {
            if (!ingredientInfo.acceptsItem(item)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public int a(List<? extends a<T>> ingredients) {
        int i2 = Integer.MAX_VALUE;
        ObjectIterable objectIterable = Object2IntMaps.fastIterable(this.amounts);
        block0: for (a<Object> a2 : ingredients) {
            int i1 = 0;
            for (Object2IntMap.Entry entry : objectIterable) {
                int intValue = entry.getIntValue();
                if (intValue <= i1) continue;
                if (a2.acceptsItem(entry.getKey())) {
                    i1 = intValue;
                }
                if (i1 < i2) continue;
                continue block0;
            }
            i2 = i1;
            if (i1 != 0) continue;
            break;
        }
        return i2;
    }

    class c {
        private final List<? extends a<T>> c;
        private final int d;
        private final List<T> e;
        private final int f;
        private final BitSet g;
        private final IntList h = new IntArrayList();

        public c(List<? extends a<T>> ingredients) {
            this.c = ingredients;
            this.d = ingredients.size();
            this.e = AutoRecipeStackManager.this.a(ingredients);
            this.f = this.e.size();
            this.g = new BitSet(this.c() + this.e() + this.g() + this.i() + this.k());
            this.a();
        }

        private void a() {
            for (int i2 = 0; i2 < this.d; ++i2) {
                a ingredientInfo = this.c.get(i2);
                for (int i1 = 0; i1 < this.f; ++i1) {
                    if (!ingredientInfo.acceptsItem(this.e.get(i1))) continue;
                    this.a(i1, i2);
                }
            }
        }

        public boolean a(int amount, @Nullable b<T> output) {
            if (amount <= 0) {
                return true;
            }
            int i2 = 0;
            block0: while (true) {
                IntList list;
                if ((list = this.b(amount)) == null) {
                    boolean flag = i2 == this.d;
                    boolean flag1 = flag && output != null;
                    this.m();
                    this.l();
                    block1: for (int i1 = 0; i1 < this.d; ++i1) {
                        for (int i22 = 0; i22 < this.f; ++i22) {
                            if (!this.d(i22, i1)) continue;
                            this.f(i22, i1);
                            AutoRecipeStackManager.this.d(this.e.get(i22), amount);
                            if (!flag1) continue block1;
                            output.accept(this.e.get(i22));
                            continue block1;
                        }
                    }
                    assert (this.g.get(this.j(), this.j() + this.k()).isEmpty());
                    return flag;
                }
                int _int = list.getInt(0);
                AutoRecipeStackManager.this.c(this.e.get(_int), amount);
                int i1 = list.size() - 1;
                this.e(list.getInt(i1));
                ++i2;
                int i2x = 0;
                while (true) {
                    if (i2x >= list.size() - 1) continue block0;
                    if (net.minecraft.world.entity.player.AutoRecipeStackManager$c.a(i2x)) {
                        _int1 = list.getInt(i2x);
                        _int2 = list.getInt(i2x + 1);
                        this.e(_int1, _int2);
                    } else {
                        _int1 = list.getInt(i2x + 1);
                        _int2 = list.getInt(i2x);
                        this.f(_int1, _int2);
                    }
                    ++i2x;
                }
                break;
            }
        }

        private static boolean a(int index) {
            return (index & 1) == 0;
        }

        private @Nullable IntList b(int amount) {
            this.m();
            for (int i2 = 0; i2 < this.f; ++i2) {
                IntList list;
                if (!AutoRecipeStackManager.this.b(this.e.get(i2), amount) || (list = this.c(i2)) == null) continue;
                return list;
            }
            return null;
        }

        private @Nullable IntList c(int amount) {
            this.h.clear();
            this.j(amount);
            this.h.add(amount);
            while (!this.h.isEmpty()) {
                int _int;
                int size = this.h.size();
                if (net.minecraft.world.entity.player.AutoRecipeStackManager$c.a(size - 1)) {
                    _int = this.h.getInt(size - 1);
                    for (int i2 = 0; i2 < this.d; ++i2) {
                        if (this.h(i2) || !this.b(_int, i2) || this.d(_int, i2)) continue;
                        this.g(i2);
                        this.h.add(i2);
                        break;
                    }
                } else {
                    _int = this.h.getInt(size - 1);
                    if (!this.d(_int)) {
                        return this.h;
                    }
                    for (int ix = 0; ix < this.f; ++ix) {
                        if (this.k(ix) || !this.d(ix, _int)) continue;
                        assert (this.b(ix, _int));
                        this.j(ix);
                        this.h.add(ix);
                        break;
                    }
                }
                if ((_int = this.h.size()) != size) continue;
                this.h.removeInt(_int - 1);
            }
            return null;
        }

        private int b() {
            return 0;
        }

        private int c() {
            return this.d;
        }

        private int d() {
            return this.b() + this.c();
        }

        private int e() {
            return this.f;
        }

        private int f() {
            return this.d() + this.e();
        }

        private int g() {
            return this.d;
        }

        private int h() {
            return this.f() + this.g();
        }

        private int i() {
            return this.d * this.f;
        }

        private int j() {
            return this.h() + this.i();
        }

        private int k() {
            return this.d * this.f;
        }

        private boolean d(int stackingIndex) {
            return this.g.get(this.f(stackingIndex));
        }

        private void e(int stackingIndex) {
            this.g.set(this.f(stackingIndex));
        }

        private int f(int stackingIndex) {
            assert (stackingIndex >= 0 && stackingIndex < this.d);
            return this.f() + stackingIndex;
        }

        private void l() {
            this.h(this.f(), this.g());
        }

        private void a(int itemIndex, int ingredientIndex) {
            this.g.set(this.c(itemIndex, ingredientIndex));
        }

        private boolean b(int itemIndex, int ingredientIndex) {
            return this.g.get(this.c(itemIndex, ingredientIndex));
        }

        private int c(int itemIndex, int ingredientIndex) {
            assert (itemIndex >= 0 && itemIndex < this.f);
            assert (ingredientIndex >= 0 && ingredientIndex < this.d);
            return this.h() + itemIndex * this.d + ingredientIndex;
        }

        private boolean d(int itemIndex, int ingredientIndex) {
            return this.g.get(this.g(itemIndex, ingredientIndex));
        }

        private void e(int itemIndex, int ingredientIndex) {
            int residualIndex = this.g(itemIndex, ingredientIndex);
            assert (!this.g.get(residualIndex));
            this.g.set(residualIndex);
        }

        private void f(int itemIndex, int ingredientIndex) {
            int residualIndex = this.g(itemIndex, ingredientIndex);
            assert (this.g.get(residualIndex));
            this.g.clear(residualIndex);
        }

        private int g(int itemIndex, int ingredientIndex) {
            assert (itemIndex >= 0 && itemIndex < this.f);
            assert (ingredientIndex >= 0 && ingredientIndex < this.d);
            return this.j() + itemIndex * this.d + ingredientIndex;
        }

        private void g(int ingredientIndex) {
            this.g.set(this.i(ingredientIndex));
        }

        private boolean h(int ingredientIndex) {
            return this.g.get(this.i(ingredientIndex));
        }

        private int i(int ingredientIndex) {
            assert (ingredientIndex >= 0 && ingredientIndex < this.d);
            return this.b() + ingredientIndex;
        }

        private void j(int itemIndex) {
            this.g.set(this.l(itemIndex));
        }

        private boolean k(int itemIndex) {
            return this.g.get(this.l(itemIndex));
        }

        private int l(int itemIndex) {
            assert (itemIndex >= 0 && itemIndex < this.f);
            return this.d() + itemIndex;
        }

        private void m() {
            this.h(this.b(), this.c());
            this.h(this.d(), this.e());
        }

        private void h(int offset, int count) {
            this.g.clear(offset, offset + count);
        }

        public int b(int amount, @Nullable b<T> output) {
            int i2 = 0;
            int i1 = Math.min(amount, AutoRecipeStackManager.this.a(this.c)) + 1;
            while (true) {
                int i22;
                if (this.a(i22 = (i2 + i1) / 2, null)) {
                    if (i1 - i2 <= 1) {
                        if (i22 > 0) {
                            this.a(i22, output);
                        }
                        return i22;
                    }
                    i2 = i22;
                    continue;
                }
                i1 = i22;
            }
        }
    }

    @FunctionalInterface
    public static interface b<T> {
        public void accept(T var1);
    }

    @FunctionalInterface
    public static interface a<T> {
        public boolean acceptsItem(T var1);
    }
}

