/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartCommandBlock;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;

public abstract class EntityHuman
extends Avatar
implements ContainerUser {
    public static final int cc = 20;
    public static final int cd = 100;
    public static final int ce = 10;
    public static final int cf = 200;
    public static final int cg = 499;
    public static final int ch = 500;
    public static final float ci = 4.5f;
    public static final float cj = 3.0f;
    private static final int a = 40;
    private static final DataWatcherObject<Float> b = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<OptionalInt> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    private static final DataWatcherObject<OptionalInt> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    private static final short f = 0;
    private static final float g = 0.0f;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final int cB = 0;
    private static final boolean cC = false;
    private static final int cD = 0;
    public static final float ck = 2.0f;
    final PlayerInventory cE;
    protected InventoryEnderChest cl = new InventoryEnderChest(this);
    public final ContainerPlayer cm;
    public Container cn;
    protected FoodMetaData co = new FoodMetaData();
    protected int cp;
    public int cq;
    public int cF = 0;
    protected boolean cr;
    private final PlayerAbilities cG = new PlayerAbilities();
    public int cs = 0;
    public int ct = 0;
    public float cu = 0.0f;
    public int cv = 0;
    protected final float cw = 0.02f;
    private int cH;
    public GameProfile cI;
    private boolean cJ;
    private net.minecraft.world.item.ItemStack cK = net.minecraft.world.item.ItemStack.l;
    private final ItemCooldown cL = this.f();
    private Optional<GlobalPos> cM = Optional.empty();
    public @Nullable EntityFishingHook cx;
    public float cy;
    public @Nullable Vec3D cz;
    public @Nullable Entity cA;
    private boolean cN = false;
    private int cO = 0;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World level, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.cb, level);
        this.a(gameProfile.id());
        this.cI = gameProfile;
        this.cE = new PlayerInventory(this, this.cb);
        this.cm = new ContainerPlayer(this.cE, !level.B_(), this);
        this.cn = this.cm;
    }

    @Override
    protected EntityEquipment eu() {
        return new PlayerEquipment(this);
    }

    public boolean a(World level, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gY()) {
            return false;
        }
        net.minecraft.world.item.ItemStack mainHandItem = this.fx();
        return mainHandItem.f() || !mainHandItem.b(new ShapeDetectorBlock(level, pos, false));
    }

    public static AttributeProvider.Builder gz() {
        return EntityLiving.ex().a(GenericAttributes.d, 1.0).a(GenericAttributes.x, 0.1f).a(GenericAttributes.f).a(GenericAttributes.s).a(GenericAttributes.h, 4.5).a(GenericAttributes.l, 3.0).a(GenericAttributes.g).a(GenericAttributes.E).a(GenericAttributes.B).a(GenericAttributes.v).a(GenericAttributes.F).a(GenericAttributes.I, 6.0E7).a(GenericAttributes.J, 6.0E7);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(b, Float.valueOf(0.0f));
        builder.a(c, 0);
        builder.a(d, OptionalInt.empty());
        builder.a(e, OptionalInt.empty());
    }

    @Override
    public void g() {
        this.ar = this.au();
        if (this.au() || this.cq()) {
            this.e(false);
        }
        if (this.cq > 0) {
            --this.cq;
        }
        if (this.gr()) {
            ++this.cF;
            if (this.cF == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cF = Integer.MIN_VALUE;
            }
            if (this.cF > 100) {
                this.cF = 100;
            }
            if (!this.ao().B_() && !this.ao().c().a(EnvironmentAttributes.C, this.dI()).a(this.ao())) {
                this.a(false, true);
            }
        } else if (this.cF > 0) {
            ++this.cF;
            if (this.cF >= 110) {
                this.cF = 0;
            }
        }
        this.gD();
        super.g();
        int i2 = 29999999;
        double d2 = MathHelper.a(this.dP(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dV(), -2.9999999E7, 2.9999999E7);
        if (d2 != this.dP() || d1 != this.dV()) {
            this.a_(d2, this.dR(), d1);
        }
        ++this.bz;
        ++this.bA;
        net.minecraft.world.item.ItemStack mainHandItem = this.fx();
        if (!net.minecraft.world.item.ItemStack.a(this.cK, mainHandItem)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cK, mainHandItem)) {
                this.hf();
            }
            this.cK = mainHandItem.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pP)) {
            this.m();
        }
        this.cL.a();
        this.gE();
        if (this.cO > 0) {
            --this.cO;
        }
    }

    @Override
    protected float fP() {
        return this.gg() ? 15.0f : super.fP();
    }

    public boolean gA() {
        return this.cu();
    }

    protected boolean gB() {
        return this.cu();
    }

    protected boolean gC() {
        return this.cu();
    }

    protected boolean gD() {
        this.cr = ((Entity)this).a(TagsFluid.a);
        return this.cr;
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (!this.gL().b) {
            super.a(downwards, pos);
        }
    }

    @Override
    public void m(boolean downwards) {
        if (!this.gL().b) {
            super.m(downwards);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            net.minecraft.world.item.ItemStack itemBySlot = this.a(equipmentSlot);
            Equippable equippable = itemBySlot.a(DataComponents.H);
            if (!itemBySlot.a(item) || equippable == null || equippable.b() != equipmentSlot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    protected void gE() {
        if (this.h(EntityPose.d)) {
            EntityPose desiredPose = this.n();
            EntityPose pose = this.au() || this.cq() || this.h(desiredPose) ? desiredPose : (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d);
            this.c(pose);
        }
    }

    private EntityPose n() {
        if (this.gr()) {
            return EntityPose.c;
        }
        if (this.cB()) {
            return EntityPose.d;
        }
        if (this.gj()) {
            return EntityPose.b;
        }
        if (this.fW()) {
            return EntityPose.e;
        }
        return this.cu() && !this.cG.b ? EntityPose.f : EntityPose.a;
    }

    protected boolean h(EntityPose pose) {
        return this.ao().a((Entity)this, this.a(pose).a(this.dI()).h(1.0E-7));
    }

    @Override
    public SoundEffect bk() {
        return SoundEffects.xg;
    }

    @Override
    public SoundEffect bl() {
        return SoundEffects.xe;
    }

    @Override
    public SoundEffect bm() {
        return SoundEffects.xf;
    }

    @Override
    public int co() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.ao().a((Entity)this, this.dP(), this.dR(), this.dV(), sound, this.dB(), volume, pitch);
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.h;
    }

    @Override
    public int dC() {
        return 20;
    }

    @Override
    public void b(byte id) {
        if (id == 9) {
            this.Q_();
        } else if (id == 23) {
            this.v(false);
        } else if (id == 22) {
            this.v(true);
        } else {
            super.b(id);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.r();
        this.cn = this.cm;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.cn = this.cm;
    }

    public void r() {
        this.cn = this.cm;
    }

    protected void s() {
    }

    @Override
    public void t() {
        if (!this.ao().B_() && this.gB() && this.cq()) {
            this.cf();
            if (!this.cq()) {
                this.h(false);
                return;
            }
        }
        super.t();
    }

    @Override
    public void d_() {
        if (this.cp > 0) {
            --this.cp;
        }
        this.i();
        this.cE.m();
        if (this.cG.b && !this.cq()) {
            this.l();
        }
        super.d_();
        this.fv();
        this.bE = this.ec();
        this.C((float)this.i(GenericAttributes.x));
        if (this.eZ() > 0.0f && !this.au()) {
            AxisAlignedBB aabb = this.cq() && !this.dz().eh() ? this.dj().b(this.dz().dj()).c(1.0, 0.0, 1.0) : this.dj().c(1.0, 0.5, 1.0);
            List<Entity> entities = this.ao().a_(this, aabb);
            ArrayList list = Lists.newArrayList();
            for (Entity entity : entities) {
                if (entity.ay() == EntityTypes.Z) {
                    list.add(entity);
                    continue;
                }
                if (entity.eh()) continue;
                this.d(entity);
            }
            if (!list.isEmpty()) {
                this.d((Entity)SystemUtils.a(list, this.as));
            }
        }
        this.j();
    }

    protected void i() {
    }

    public void j() {
    }

    public void k() {
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gF() {
        return this.az.a(c);
    }

    public void q(int score) {
        this.az.a(c, score);
    }

    public void r(int score) {
        int score1 = this.gF();
        this.az.a(c, score1 + score);
    }

    public void a(int ticks, float damageAmount, net.minecraft.world.item.ItemStack stack) {
        this.bW = ticks;
        this.bX = damageAmount;
        this.bY = stack;
        if (!this.ao().B_()) {
            this.k();
            this.c(4, true);
        }
    }

    @Override
    public net.minecraft.world.item.ItemStack eq() {
        return this.fW() && this.bY != null ? this.bY : super.eq();
    }

    @Override
    public void a(DamageSource damageSource) {
        World world;
        super.a(damageSource);
        this.aH();
        if (!this.au() && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.dropAllDeathLoot(serverLevel, damageSource);
        }
        if (damageSource != null) {
            this.m(-MathHelper.b((double)((this.fg() + this.ec()) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -MathHelper.a((double)((this.fg() + this.ec()) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.m(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.P);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aT();
        this.d(false);
        this.d(Optional.of(GlobalPos.a(this.ao().aq(), this.dK())));
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        if (!level.U().a(GameRules.s).booleanValue()) {
            this.gG();
            this.cE.n();
        }
    }

    protected void gG() {
        for (int i2 = 0; i2 < this.cE.b(); ++i2) {
            net.minecraft.world.item.ItemStack item = this.cE.a(i2);
            if (item.f() || !EnchantmentManager.a(item, EnchantmentEffectComponents.E)) continue;
            this.cE.b(i2);
        }
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return damageSource.k().d().a();
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.wW;
    }

    public void g(net.minecraft.world.item.ItemStack stack) {
    }

    public @Nullable EntityItem a(net.minecraft.world.item.ItemStack stack, boolean includeThrowerName) {
        return this.a(stack, false, includeThrowerName);
    }

    public float c(IBlockData state) {
        float destroySpeed = this.cE.h().a(state);
        if (destroySpeed > 1.0f) {
            destroySpeed += (float)this.i(GenericAttributes.v);
        }
        if (MobEffectUtil.a(this)) {
            destroySpeed *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.d(MobEffects.d)) {
            float f2 = switch (this.e(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= f2;
        }
        destroySpeed *= (float)this.i(GenericAttributes.g);
        if (((Entity)this).a(TagsFluid.a)) {
            destroySpeed *= (float)this.h(GenericAttributes.E).g();
        }
        if (!this.aV()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    public boolean d(IBlockData state) {
        return !state.C() || this.cE.h().b(state);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(this.cI.id());
        this.cE.a(input.c("Inventory", ItemStackWithSlot.a));
        this.cE.d(input.a("SelectedItemSlot", 0));
        this.cF = input.a("SleepTimer", (short)0);
        this.cu = input.a("XpP", 0.0f);
        this.cs = input.a("XpLevel", 0);
        this.ct = input.a("XpTotal", 0);
        this.cv = input.a("XpSeed", 0);
        if (this.cv == 0) {
            this.cv = this.as.f();
        }
        this.q(input.a("Score", 0));
        this.co.a(input);
        input.a("abilities", PlayerAbilities.a.a).ifPresent(this.cG::a);
        this.h(GenericAttributes.x).a(this.cG.b());
        this.cl.b(input.c("EnderItems", ItemStackWithSlot.a));
        this.d(input.a("LastDeathLocation", GlobalPos.b));
        this.cz = input.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.cN = input.a("ignore_fall_damage_from_current_explosion", false);
        this.cO = input.a("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        GameProfileSerializer.a(output);
        this.cE.a(output.a("Inventory", ItemStackWithSlot.a));
        output.a("SelectedItemSlot", this.cE.g());
        output.a("SleepTimer", (short)this.cF);
        output.a("XpP", this.cu);
        output.a("XpLevel", this.cs);
        output.a("XpTotal", this.ct);
        output.a("XpSeed", this.cv);
        output.a("Score", this.gF());
        this.co.a(output);
        output.a("abilities", PlayerAbilities.a.a, this.cG.c());
        this.cl.b(output.a("EnderItems", ItemStackWithSlot.a));
        this.cM.ifPresent(globalPos -> output.a("LastDeathLocation", GlobalPos.b, globalPos));
        output.b("current_explosion_impact_pos", Vec3D.a, this.cz);
        output.a("ignore_fall_damage_from_current_explosion", this.cN);
        output.a("current_impulse_context_reset_grace_time", this.cO);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        if (super.a(level, damageSource)) {
            return true;
        }
        if (damageSource.a(DamageTypeTags.n)) {
            return level.U().a(GameRules.h) == false;
        }
        if (damageSource.a(DamageTypeTags.m)) {
            return level.U().a(GameRules.l) == false;
        }
        return damageSource.a(DamageTypeTags.i) ? !level.U().a(GameRules.m).booleanValue() : damageSource.a(DamageTypeTags.o) && level.U().a(GameRules.p) == false;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean damaged;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.cG.a && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bK = 0;
        if (this.fa()) {
            return false;
        }
        if (damageSource.g()) {
            if (level.av() == EnumDifficulty.a) {
                return false;
            }
            if (level.av() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (level.av() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(level, damageSource, amount)) {
            this.k();
        }
        return damaged;
    }

    @Override
    protected void a(WorldServer level, EntityLiving entity) {
        super.a(level, entity);
        net.minecraft.world.item.ItemStack itemBlockingWith = this.gh();
        BlocksAttacks blocksAttacks = itemBlockingWith != null ? itemBlockingWith.a(DataComponents.M) : null;
        float secondsToDisableBlocking = entity.gu();
        if (secondsToDisableBlocking > 0.0f && blocksAttacks != null) {
            blocksAttacks.disable(level, this, secondsToDisableBlocking, itemBlockingWith, entity);
        }
    }

    @Override
    public boolean eS() {
        return !this.gL().a && super.eS();
    }

    public boolean a(EntityHuman other) {
        Team team;
        if (other instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)other;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = other.ao().getCraftServer().getOfflinePlayer(other.da());
            team = other.ao().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.ao().getCraftServer().getOfflinePlayer(this.da()));
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        return super.actuallyHurt(level, damageSource, amount, event);
    }

    public boolean Z() {
        return false;
    }

    public void a(TileEntitySign signEntity, boolean isFrontText) {
    }

    public void a(EntityMinecartCommandBlock minecart) {
    }

    public void a(TileEntityCommand commandBlockEntity) {
    }

    public void a(TileEntityStructure structureEntity) {
    }

    public void a(TestBlockEntity testBlockEntity) {
    }

    public void a(TestInstanceBlockEntity testInstanceBlockEntity) {
    }

    public void a(TileEntityJigsaw jigsawBlockEntity) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public void a(AbstractNautilus nautilus, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory menu) {
        return OptionalInt.empty();
    }

    public void b(Holder<Dialog> dialog) {
    }

    public void a(int containerId, MerchantRecipeList offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
    }

    public void a(net.minecraft.world.item.ItemStack stack, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entityToInteractOn, EnumHand hand) {
        if (this.au()) {
            if (entityToInteractOn instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entityToInteractOn));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemInHand = this.b(hand);
        net.minecraft.world.item.ItemStack itemStack = itemInHand.v();
        EnumInteractionResult interactionResult = entityToInteractOn.a(this, hand);
        if (interactionResult.a()) {
            if (this.gv() && itemInHand == this.b(hand) && itemInHand.N() < itemStack.N()) {
                itemInHand.e(itemStack.N());
            }
            return interactionResult;
        }
        if (!itemInHand.f() && entityToInteractOn instanceof EntityLiving) {
            EnumInteractionResult interactionResult1;
            if (this.gv()) {
                itemInHand = itemStack;
            }
            if ((interactionResult1 = itemInHand.a(this, (EntityLiving)entityToInteractOn, hand)).a()) {
                this.ao().a(GameEvent.r, entityToInteractOn.dI(), GameEvent.a.a(this));
                if (itemInHand.f() && !this.gv()) {
                    this.a(hand, net.minecraft.world.item.ItemStack.l);
                }
                return interactionResult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.X = 0;
    }

    @Override
    protected boolean fE() {
        return super.fE() || this.gr() || this.eh() || !this.valid;
    }

    @Override
    public boolean eG() {
        return !this.cG.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        float f2 = this.eg();
        if (!this.cG.b && !(movement.h > 0.0) && (type == EnumMoveType.a || type == EnumMoveType.b) && this.gC() && this.K(f2)) {
            double d2;
            double d1 = movement.i;
            double d22 = 0.05;
            double d3 = Math.signum(d2) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d2 = movement.g; d2 != 0.0 && this.p(d2, 0.0, f2); d2 -= d3) {
                if (!(Math.abs(d2) <= 0.05)) continue;
                d2 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.p(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d2 != 0.0 && d1 != 0.0 && this.p(d2, d1, f2)) {
                d2 = Math.abs(d2) <= 0.05 ? 0.0 : (d2 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d2, movement.h, d1);
        }
        return movement;
    }

    private boolean K(float maxUpStep) {
        return this.aV() || this.an < (double)maxUpStep && !this.p(0.0, 0.0, (double)maxUpStep - this.an);
    }

    private boolean p(double x2, double z2, double distance) {
        AxisAlignedBB boundingBox = this.dj();
        return this.ao().a((Entity)this, new AxisAlignedBB(boundingBox.a + 1.0E-7 + x2, boundingBox.b - distance - 1.0E-7, boundingBox.c + 1.0E-7 + z2, boundingBox.d - 1.0E-7 + x2, boundingBox.b, boundingBox.f - 1.0E-7 + z2));
    }

    public void e(Entity target) {
        boolean willAttack = !this.H(target);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            DamageSource damageSource;
            float f2 = this.fW() ? this.bX : (float)this.i(GenericAttributes.d);
            net.minecraft.world.item.ItemStack weaponItem = this.eq();
            DamageSource dmgSourceFinal = damageSource = this.i(weaponItem);
            float attackStrengthScale = this.I(0.5f);
            float f1 = attackStrengthScale * (this.a(target, f2, damageSource) - f2);
            f2 *= this.p();
            this.fO();
            float dmgFinal = f1;
            if (!this.deflectProjectile(target, () -> !CraftEventFactory.handleNonLivingEntityDamageEvent(target, dmgSourceFinal, dmgFinal, false))) {
                if (f2 > 0.0f || f1 > 0.0f) {
                    boolean flag1;
                    boolean flag;
                    boolean bl = flag = attackStrengthScale > 0.9f;
                    if (this.cA() && flag) {
                        this.c(SoundEffects.wO);
                        flag1 = true;
                    } else {
                        flag1 = false;
                    }
                    f2 += weaponItem.h().a(target, f2, damageSource);
                    boolean flag2 = flag && this.J(target);
                    boolean bl2 = flag2 = flag2 && !this.ao().paperConfig().entities.behavior.disablePlayerCrits;
                    if (flag2) {
                        damageSource = damageSource.critical();
                        f2 *= 1.5f;
                    }
                    float f22 = f2 + f1;
                    boolean isSweepAttack = this.a(flag, flag2, flag1);
                    float f3 = 0.0f;
                    if (target instanceof EntityLiving) {
                        EntityLiving livingEntity = (EntityLiving)target;
                        f3 = livingEntity.eZ();
                    }
                    Vec3D deltaMovement = target.dN();
                    boolean flag3 = target.b(damageSource, f22);
                    if (flag3) {
                        this.a(target, this.b(target, damageSource) + (flag1 ? 0.5f : 0.0f), deltaMovement);
                        if (isSweepAttack) {
                            this.a(target, f2, damageSource, attackStrengthScale);
                        }
                        this.a(target, flag2, isSweepAttack, flag, false, f1);
                        this.C(target);
                        this.a(target, weaponItem, damageSource, true);
                        this.a(target, f3);
                        this.causeFoodExhaustion(this.ao().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                    } else {
                        this.c(SoundEffects.wP);
                    }
                }
                this.fi();
            }
        }
    }

    private void c(SoundEffect sound) {
        EntityHuman.sendSoundEffect(this, this.dP(), this.dR(), this.dV(), sound, this.dB(), 1.0f, 1.0f);
    }

    private DamageSource i(net.minecraft.world.item.ItemStack stack) {
        return stack.a((EntityLiving)this, () -> this.en().a(this));
    }

    private boolean H(Entity target) {
        return !target.cT() || target.w(this);
    }

    private boolean deflectProjectile(Entity target, BooleanSupplier callEvent) {
        if (target.ay().a(TagsEntity.I) && target instanceof IProjectile) {
            IProjectile projectile = (IProjectile)target;
            if (callEvent.getAsBoolean() && projectile.a(ProjectileDeflection.c, this, EntityReference.a(this), true)) {
                this.b(SoundEffects.wP);
                return true;
            }
        }
        return false;
    }

    private boolean J(Entity target) {
        return this.an > 0.0 && !this.aV() && !this.fl() && !this.by() && !this.hl() && !this.cq() && target instanceof EntityLiving && !this.cA();
    }

    private boolean a(boolean isStrong, boolean isCritical, boolean extraKnockback) {
        double d1;
        double d2;
        if (isStrong && !isCritical && !extraKnockback && this.aV() && (d2 = this.ag().j()) < MathHelper.n(d1 = (double)this.fM() * 2.5)) {
            return this.b(EnumHand.a).a(TagsItem.ca);
        }
        return false;
    }

    private void a(Entity target, boolean isCritical, boolean isSweep, boolean isStrong, boolean isStab, float damageAmount) {
        if (isCritical) {
            this.c(SoundEffects.wN);
            this.b(target);
        }
        if (!(isCritical || isSweep || isStab)) {
            this.c(isStrong ? SoundEffects.wQ : SoundEffects.wS);
        }
        if (damageAmount > 0.0f) {
            this.c(target);
        }
    }

    private void a(Entity target, float previousHealth) {
        if (target instanceof EntityLiving) {
            float f2 = previousHealth - ((EntityLiving)target).eZ();
            this.a(StatisticList.I, Math.round(f2 * 10.0f));
            if (this.ao() instanceof WorldServer && f2 > 2.0f) {
                int i2 = (int)((double)f2 * 0.5);
                ((WorldServer)this.ao()).a(Particles.h, target.dP(), target.f(0.5), target.dV(), i2, 0.1, 0.0, 0.1, 0.2);
            }
        }
    }

    private void a(Entity target, net.minecraft.world.item.ItemStack stack, DamageSource damageSource, boolean postAttackEffects) {
        Entity entity = target;
        if (target instanceof EntityComplexPart) {
            entity = ((EntityComplexPart)target).a;
        }
        boolean flag = false;
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                flag = stack.a(livingEntity, (EntityLiving)this);
            }
            if (postAttackEffects) {
                EnchantmentManager.a(serverLevel, target, damageSource, stack);
            }
        }
        if (!this.ao().B_() && !stack.f() && entity instanceof EntityLiving) {
            if (flag) {
                stack.b((EntityLiving)entity, (EntityLiving)this);
            }
            if (stack.f()) {
                if (stack == this.fx()) {
                    this.a(EnumHand.a, net.minecraft.world.item.ItemStack.l);
                } else {
                    this.a(EnumHand.b, net.minecraft.world.item.ItemStack.l);
                }
            }
        }
    }

    @Override
    public void a(Entity target, float strength, Vec3D currentMovement) {
        if (strength > 0.0f) {
            if (target instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)target;
                livingEntity.knockback(strength, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
            } else {
                target.push(-MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))) * strength, 0.1, MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))) * strength, this);
            }
            this.k(this.dN().d(0.6, 1.0, 0.6));
            if (!this.ao().paperConfig().misc.disableSprintInterruptionOnAttack) {
                this.i(false);
            }
        }
        if (target instanceof EntityPlayer && target.ah) {
            boolean cancelled = false;
            Player player = (Player)target.getBukkitEntity();
            Vector velocity = CraftVector.toBukkit(currentMovement);
            PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
            this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                cancelled = true;
            } else if (!velocity.equals((Object)event.getVelocity())) {
                player.setVelocity(event.getVelocity());
            }
            if (!cancelled) {
                ((EntityPlayer)target).g.b(new PacketPlayOutEntityVelocity(target));
                target.ah = false;
                target.k(currentMovement);
            }
        }
    }

    @Override
    public float fD() {
        return 1.0f;
    }

    private void a(Entity entity, float damageAmount, DamageSource damageSource, float strengthScale) {
        this.c(SoundEffects.wR);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            float var12 = 1.0f + (float)this.i(GenericAttributes.F) * damageAmount;
            for (EntityLiving livingEntity : this.ao().a(EntityLiving.class, entity.dj().c(1.0, 0.25, 1.0))) {
                EntityArmorStand armorStand;
                if (livingEntity == this || livingEntity == entity || this.t(livingEntity) || livingEntity instanceof EntityArmorStand && (armorStand = (EntityArmorStand)livingEntity).r() || !(this.g(livingEntity) < 9.0)) continue;
                float f1 = this.a((Entity)livingEntity, var12, damageSource) * strengthScale;
                livingEntity.lastDamageCancelled = false;
                if (!livingEntity.a(serverLevel, damageSource.knownCause(EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK), f1) || livingEntity.lastDamageCancelled) continue;
                livingEntity.knockback(0.4f, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                EnchantmentManager.a(serverLevel, (Entity)livingEntity, damageSource);
            }
            double d2 = -MathHelper.a((double)(this.ec() * ((float)Math.PI / 180)));
            double d1 = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)));
            serverLevel.a(Particles.an, this.dP() + d2, this.f(0.5), this.dV() + d1, 0, d2, 0.0, d1, 0.0);
        }
    }

    protected float a(Entity entity, float damage, DamageSource damageSource) {
        return damage;
    }

    @Override
    protected void f(EntityLiving target) {
        this.e((Entity)target);
    }

    public void b(Entity target) {
    }

    private float p() {
        float attackStrengthScale = this.I(0.5f);
        return 0.2f + attackStrengthScale * attackStrengthScale * 0.8f;
    }

    @Override
    public boolean a(EnumItemSlot slot, Entity target, float damageAmount, boolean damage, boolean knockback, boolean dismount) {
        boolean flag;
        boolean cannotAttack = this.H(target);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), !cannotAttack);
        if (!playerAttackEntityEvent.callEvent() || cannotAttack) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemBySlot = this.a(slot);
        DamageSource damageSource = this.i(itemBySlot);
        float f2 = this.a(target, damageAmount, damageSource) - damageAmount;
        if (!this.fZ() || this.ga().a() != slot) {
            f2 *= this.I(0.5f);
            damageAmount *= this.p();
        }
        float dmgFinal = f2;
        if (knockback && this.deflectProjectile(target, () -> !CraftEventFactory.handleNonLivingEntityDamageEvent(target, damageSource, dmgFinal, false))) {
            return true;
        }
        float f1 = damage ? damageAmount + f2 : 0.0f;
        float f22 = 0.0f;
        if (target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            f22 = livingEntity.eZ();
        }
        Vec3D deltaMovement = target.dN();
        boolean bl = flag = damage && target.b(damageSource, f1);
        if (knockback) {
            this.a(target, 0.4f + this.b(target, damageSource), deltaMovement);
        }
        boolean flag1 = false;
        if (dismount && target.cq()) {
            flag1 = true;
            target.cf();
        }
        if (!(flag || knockback || flag1)) {
            return false;
        }
        this.a(target, false, false, damage, true, f2);
        this.C(target);
        this.a(target, itemBySlot, damageSource, flag);
        this.a(target, f22);
        this.causeFoodExhaustion(this.ao().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
        return true;
    }

    public void c(Entity target) {
    }

    @Override
    public void remove(Entity.RemovalReason reason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause eventCause) {
        super.remove(reason, eventCause);
        this.cm.a(this);
        if (this.gN()) {
            this.s();
        }
    }

    @Override
    public boolean aa_() {
        return true;
    }

    @Override
    protected boolean dw() {
        return this.gH();
    }

    public boolean gH() {
        return false;
    }

    @Override
    public boolean dx() {
        return !this.ao().B_() || this.gH();
    }

    @Override
    public boolean dy() {
        return !this.ao().B_() || this.gH();
    }

    public GameProfile gI() {
        return this.cI;
    }

    public NameAndId gJ() {
        return new NameAndId(this.cI);
    }

    public PlayerInventory gK() {
        return this.cE;
    }

    public PlayerAbilities gL() {
        return this.cG;
    }

    @Override
    public boolean gv() {
        return this.cG.d;
    }

    public boolean gM() {
        return this.cG.d;
    }

    public void a(net.minecraft.world.item.ItemStack carried, net.minecraft.world.item.ItemStack clicked, ClickAction action) {
    }

    public boolean gN() {
        return this.cn != this.cm;
    }

    public boolean gO() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition bedPos) {
        return this.startSleepInBed(bedPos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition bedPos, boolean force) {
        this.b(bedPos);
        this.cF = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        super.gs();
        if (this.ao() instanceof WorldServer && updateLevelForSleepingPlayers) {
            ((WorldServer)this.ao()).h();
        }
        this.cF = wakeImmediately ? 0 : 100;
    }

    @Override
    public void gs() {
        this.a(true, true);
    }

    public boolean gP() {
        return this.gr() && this.cF >= 100;
    }

    public int gQ() {
        return this.cF;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey statKey) {
        this.b(StatisticList.i.b(statKey));
    }

    public void a(MinecraftKey stat, int increment) {
        this.a(StatisticList.i.b(stat), increment);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int increment) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.cq()) {
            super.m(travelVector);
        } else {
            double d2;
            if (this.cB()) {
                double d1;
                d2 = this.cj().h;
                double d3 = d1 = d2 < -0.2 ? 0.085 : 0.06;
                if (d2 <= 0.0 || this.bM || !this.ao().b_(BlockPosition.a(this.dP(), this.dR() + 1.0 - 0.1, this.dV())).c()) {
                    Vec3D deltaMovement = this.dN();
                    this.k(deltaMovement.b(0.0, (d2 - deltaMovement.h) * d1, 0.0));
                }
            }
            if (this.gL().b) {
                d2 = this.dN().h;
                super.m(travelVector);
                this.k(this.dN().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.m(travelVector);
            }
        }
    }

    @Override
    protected boolean fU() {
        return !this.cG.b && super.fU();
    }

    @Override
    public void bF() {
        if (this.cG.b) {
            this.j(false);
        } else {
            super.bF();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.ao().a_(pos).j(this.ao(), pos);
    }

    @Override
    public float fM() {
        return (float)this.i(GenericAttributes.x);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        double min;
        boolean flag;
        if (this.cG.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(fallDistance * 100.0));
        }
        boolean bl = flag = this.cz != null && this.cN;
        if (flag) {
            boolean flag1;
            min = Math.min(fallDistance, this.cz.h - this.dR());
            boolean bl2 = flag1 = min <= 0.0;
            if (flag1) {
                this.hr();
            } else {
                this.hp();
            }
        } else {
            min = fallDistance;
        }
        if (min > 0.0 && super.a(min, damageMultiplier, damageSource)) {
            this.hr();
            return true;
        }
        this.b(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    public boolean gR() {
        if (!this.gj() && this.fU() && !this.by()) {
            this.gS();
            return true;
        }
        return false;
    }

    public void gS() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bI() {
        if (!this.au()) {
            super.bI();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.by()) {
            this.bn();
            this.b(state);
        } else {
            BlockPosition primaryStepSoundBlockPos = this.e(pos);
            if (!pos.equals(primaryStepSoundBlockPos)) {
                IBlockData blockState = this.ao().a_(primaryStepSoundBlockPos);
                if (blockState.a(TagsBlock.bB)) {
                    this.a(blockState, state);
                } else {
                    super.b(primaryStepSoundBlockPos, blockState);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a fj() {
        return new EntityLiving.a(SoundEffects.xd, SoundEffects.wT);
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        this.b(StatisticList.g.b(entity.ay()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
        if (!this.cG.b) {
            super.a(state, motionMultiplier);
        }
        this.hp();
    }

    public void d(int xpPoints) {
        this.r(xpPoints);
        this.cu += (float)xpPoints / (float)this.gU();
        this.ct = MathHelper.a(this.ct + xpPoints, 0, Integer.MAX_VALUE);
        while (this.cu < 0.0f) {
            float f2 = this.cu * (float)this.gU();
            if (this.cs > 0) {
                this.c(-1);
                this.cu = 1.0f + f2 / (float)this.gU();
                continue;
            }
            this.c(-1);
            this.cu = 0.0f;
        }
        while (this.cu >= 1.0f) {
            this.cu = (this.cu - 1.0f) * (float)this.gU();
            this.c(1);
            this.cu /= (float)this.gU();
        }
    }

    public int gT() {
        return this.cv;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int levelCost) {
        this.cs -= levelCost;
        if (this.cs < 0) {
            this.cs = 0;
            this.cu = 0.0f;
            this.ct = 0;
        }
        this.cv = this.as.f();
    }

    public void c(int levels) {
        this.cs = IntMath.saturatedAdd((int)this.cs, (int)levels);
        if (this.cs < 0) {
            this.cs = 0;
            this.cu = 0.0f;
            this.ct = 0;
        }
        if (levels > 0 && this.cs % 5 == 0 && (float)this.cH < (float)this.at - 100.0f) {
            float f2 = this.cs > 30 ? 1.0f : (float)this.cs / 30.0f;
            EntityHuman.sendSoundEffect(this, this.dP(), this.dR(), this.dV(), SoundEffects.xc, this.dB(), f2 * 0.75f, 1.0f);
            this.cH = this.at;
        }
    }

    public int gU() {
        if (this.cs >= 30) {
            return 112 + (this.cs - 30) * 9;
        }
        return this.cs >= 15 ? 37 + (this.cs - 15) * 5 : 7 + this.cs * 2;
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.ao().a((Entity)fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)fromEntity;
            serverPlayer.g.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.as.g()));
        }
    }

    public void a(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float exhaustion, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cG.a || this.ao().B_() || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, exhaustion)).isCancelled())) {
            this.co.a(event.getExhaustion());
        }
    }

    @Override
    public void fi() {
        if (this.gV()) {
            super.fi();
        }
    }

    protected boolean gV() {
        return this.gW().b() || this.gL().c;
    }

    public Optional<WardenSpawnTracker> ab() {
        return Optional.empty();
    }

    public FoodMetaData gW() {
        return this.co;
    }

    public boolean u(boolean canAlwaysEat) {
        return this.cG.a || canAlwaysEat || this.co.c();
    }

    public boolean gX() {
        return this.eZ() > 0.0f && this.eZ() < this.fq();
    }

    public boolean gY() {
        return this.cG.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cG.e) {
            return true;
        }
        BlockPosition blockPos = pos.a(facing.g());
        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(this.ao(), blockPos, false);
        return stack.a(blockInWorld);
    }

    @Override
    protected int f(WorldServer level) {
        return level.U().a(GameRules.s) == false && !this.au() ? Math.min(this.cs * 7, 100) : 0;
    }

    @Override
    protected boolean eJ() {
        return true;
    }

    @Override
    public boolean de() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bv() {
        return this.cG.b || this.aV() && this.cx() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void z() {
    }

    @Override
    public IChatBaseComponent ap() {
        return IChatBaseComponent.b(this.cI.name());
    }

    @Override
    public String aq() {
        return this.cI.name();
    }

    public InventoryEnderChest gZ() {
        return this.cl;
    }

    @Override
    protected boolean b(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(net.minecraft.world.item.ItemStack stack) {
        return this.cE.g(stack);
    }

    public abstract @Nullable EnumGamemode a();

    @Override
    public boolean au() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bW() {
        return !this.au() && super.bW();
    }

    @Override
    public boolean cB() {
        return !this.cG.b && !this.au() && super.cB();
    }

    public boolean ha() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean db() {
        return !this.cG.b;
    }

    @Override
    public IChatBaseComponent R_() {
        IChatMutableComponent mutableComponent = ScoreboardTeam.a(this.cI(), this.ap());
        return this.a(mutableComponent);
    }

    private IChatMutableComponent a(IChatMutableComponent displayName) {
        String string = this.gI().name();
        return displayName.a(style -> style.a(new ChatClickable.SuggestCommand("/tell " + string + " ")).a(this.di()).a(string));
    }

    @Override
    public String da() {
        return this.gI().name();
    }

    @Override
    protected void G(float absorptionAmount) {
        this.aD().a(b, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fX() {
        return this.aD().a(b).floatValue();
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        if (slot == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cn.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.cn.a(carried);
                    return true;
                }
            };
        }
        final int i2 = slot - 500;
        if (i2 >= 0 && i2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cm.r().a(i2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.cm.r().a(i2, carried);
                    EntityHuman.this.cm.a(EntityHuman.this.cE);
                    return true;
                }
            };
        }
        if (slot >= 0 && slot < this.cE.j().size()) {
            return this.cE.a_(slot);
        }
        int i1 = slot - 200;
        return i1 >= 0 && i1 < this.cl.b() ? this.cl.a_(i1) : super.a_(slot);
    }

    public boolean hb() {
        return this.cJ;
    }

    public void v(boolean reducedDebugInfo) {
        this.cJ = reducedDebugInfo;
    }

    @Override
    public void h(int ticks) {
        super.h(this.cG.a ? Math.min(ticks, 1) : ticks);
    }

    protected static Optional<EntityParrot.Variant> d(NBTTagCompound tag) {
        EntityTypes entityType;
        if (!tag.j() && (entityType = (EntityTypes)tag.a("id", EntityTypes.a).orElse(null)) == EntityTypes.aW) {
            return tag.a("Variant", EntityParrot.Variant.h);
        }
        return Optional.empty();
    }

    protected static OptionalInt a(Optional<EntityParrot.Variant> variant) {
        return variant.map(variant1 -> OptionalInt.of(variant1.a())).orElse(OptionalInt.empty());
    }

    private static Optional<EntityParrot.Variant> a(OptionalInt variantId) {
        return variantId.isPresent() ? Optional.of(EntityParrot.Variant.a(variantId.getAsInt())) : Optional.empty();
    }

    public void b(Optional<EntityParrot.Variant> variant) {
        this.az.a(d, EntityHuman.a(variant));
    }

    public Optional<EntityParrot.Variant> hc() {
        return EntityHuman.a(this.az.a(d));
    }

    public void c(Optional<EntityParrot.Variant> variant) {
        this.az.a(e, EntityHuman.a(variant));
    }

    public Optional<EntityParrot.Variant> hd() {
        return EntityHuman.a(this.az.a(e));
    }

    public float he() {
        return (float)(1.0 / this.i(GenericAttributes.f) * 20.0);
    }

    public boolean c(net.minecraft.world.item.ItemStack stack, int adjustTicks) {
        float orDefault = stack.a(DataComponents.i, Float.valueOf(0.0f)).floatValue();
        float f2 = (float)(this.bz + adjustTicks) / this.he();
        return orDefault > 0.0f && f2 < orDefault;
    }

    public float I(float adjustTicks) {
        return MathHelper.a(((float)this.bz + adjustTicks) / this.he(), 0.0f, 1.0f);
    }

    public float J(float adjustTicks) {
        return MathHelper.a(((float)this.bA + adjustTicks) / this.he(), 0.0f, 1.0f);
    }

    public void hf() {
        this.bz = 0;
        this.bA = 0;
    }

    @Override
    public void fO() {
        super.fO();
    }

    public void hg() {
        this.bz = 0;
    }

    public ItemCooldown hh() {
        return this.cL;
    }

    @Override
    protected float bi() {
        return !this.cG.b && !this.gj() ? super.bi() : 1.0f;
    }

    @Override
    public float eB() {
        return (float)this.i(GenericAttributes.s);
    }

    public boolean hi() {
        return this.cG.d && this.I().hasPermission(Permissions.b);
    }

    public PermissionSet I() {
        return PermissionSet.g;
    }

    @Override
    public ImmutableList<EntityPose> go() {
        return ImmutableList.of((Object)EntityPose.a, (Object)EntityPose.f, (Object)EntityPose.d);
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack, MutableBoolean cancelled) {
        EntityHuman entityHuman = this;
        if (!(entityHuman instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
        boolean notCancelled = new PlayerReadyArrowEvent((Player)serverPlayer.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        if (!notCancelled) {
            cancelled.setValue(true);
        }
        return notCancelled;
    }

    @Override
    public net.minecraft.world.item.ItemStack d(net.minecraft.world.item.ItemStack shootable) {
        EntityHuman entityHuman;
        if (!(shootable.h() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.l;
        }
        MutableBoolean anyEventCancelled = new MutableBoolean();
        Predicate<net.minecraft.world.item.ItemStack> supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).c().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        net.minecraft.world.item.ItemStack heldProjectile = ItemProjectileWeapon.a(this, supportedHeldProjectiles);
        if (!heldProjectile.f()) {
            return heldProjectile;
        }
        supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).a().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        for (int i2 = 0; i2 < this.cE.b(); ++i2) {
            net.minecraft.world.item.ItemStack item2 = this.cE.a(i2);
            if (!supportedHeldProjectiles.test(item2)) continue;
            return item2;
        }
        if (anyEventCancelled.booleanValue() && !this.cG.d && (entityHuman = this) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityHuman;
            this.resyncUsingItem(player);
        }
        return this.gv() ? new net.minecraft.world.item.ItemStack(Items.pX) : net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public Vec3D u(float partialTick) {
        double d2 = 0.22 * (this.at() == EnumMainHand.b ? -1.0 : 1.0);
        float f2 = MathHelper.h(partialTick * 0.5f, this.ee(), this.ac) * ((float)Math.PI / 180);
        float f1 = MathHelper.h(partialTick, this.bD, this.bC) * ((float)Math.PI / 180);
        if (this.gj() || this.fW()) {
            float f22;
            Vec3D viewVector = this.h(partialTick);
            Vec3D deltaMovement = this.dN();
            double d1 = deltaMovement.j();
            double d22 = viewVector.j();
            if (d1 > 0.0 && d22 > 0.0) {
                double d3 = (deltaMovement.g * viewVector.g + deltaMovement.i * viewVector.i) / Math.sqrt(d1 * d22);
                double d4 = deltaMovement.g * viewVector.i - deltaMovement.i * viewVector.g;
                f22 = (float)(Math.signum(d4) * Math.acos(d3));
            } else {
                f22 = 0.0f;
            }
            return this.p(partialTick).e(new Vec3D(d2, -0.11, 0.85).c(-f22).a(-f2).b(-f1));
        }
        if (this.cC()) {
            return this.p(partialTick).e(new Vec3D(d2, 0.2, -0.15).a(-f2).b(-f1));
        }
        double d5 = this.dj().c() - 1.0;
        double d1 = this.cz() ? -0.2 : 0.07;
        return this.p(partialTick).e(new Vec3D(d2, d5, d1).b(-f1));
    }

    @Override
    public boolean el() {
        return true;
    }

    public boolean hj() {
        return this.fZ() && this.gb().a(Items.tb);
    }

    @Override
    public boolean ek() {
        return false;
    }

    public Optional<GlobalPos> hk() {
        return this.cM;
    }

    public void d(Optional<GlobalPos> lastDeathLocation) {
        this.cM = lastDeathLocation;
    }

    @Override
    public float fg() {
        return this.cy;
    }

    @Override
    public void q(float yaw) {
        super.q(yaw);
        this.cy = yaw;
    }

    public boolean hl() {
        return this.d(MobEffects.o);
    }

    @Override
    public boolean ef() {
        return true;
    }

    @Override
    protected float fL() {
        if (this.cG.b && !this.cq()) {
            return this.cA() ? this.cG.a() * 2.0f : this.cG.a();
        }
        return this.cA() ? 0.025999999f : 0.02f;
    }

    @Override
    public boolean a(ContainerOpenersCounter openersCounter, BlockPosition pos) {
        return openersCounter.a(this);
    }

    @Override
    public double ar() {
        return this.hm();
    }

    public double hm() {
        return this.i(GenericAttributes.h);
    }

    public double hn() {
        return this.i(GenericAttributes.l);
    }

    public boolean b(Entity entity, double buffer) {
        return !entity.eh() && this.a(entity.dj(), buffer);
    }

    public boolean a(AxisAlignedBB aabb, double buffer) {
        double d2 = this.hn() + buffer;
        double d1 = aabb.e(this.bV());
        return d1 < d2 * d2;
    }

    public boolean b(AxisAlignedBB aabb, double buffer) {
        return this.fz().a((EntityLiving)this, aabb, buffer);
    }

    public boolean a(BlockPosition pos, double buffer) {
        double d2 = this.hm() + buffer;
        return new AxisAlignedBB(pos).e(this.bV()) < d2 * d2;
    }

    public void w(boolean ignoreFallDamageFromCurrentImpulse) {
        this.cN = ignoreFallDamageFromCurrentImpulse;
        if (ignoreFallDamageFromCurrentImpulse) {
            this.s(40);
        } else {
            this.cO = 0;
        }
    }

    public void s(int ticks) {
        this.cO = Math.max(this.cO, ticks);
    }

    public boolean ho() {
        return this.cN;
    }

    public void hp() {
        if (this.cO == 0) {
            this.hr();
        }
    }

    public boolean hq() {
        return this.cO > 0;
    }

    public void hr() {
        this.cO = 0;
        this.cA = null;
        this.cz = null;
        this.cN = false;
    }

    public boolean hs() {
        return false;
    }

    @Override
    public boolean fl() {
        return !this.cG.b && super.fl();
    }

    public String ht() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.aq()).add("id", this.aA()).add("pos", (Object)this.dI()).add("mode", (Object)this.a()).add("permission", (Object)this.I()).toString();
    }

    public static final class EnumBedResult
    extends Record {
        private final @Nullable IChatBaseComponent e;
        public static final EnumBedResult a = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.too_far_away"));
        public static final EnumBedResult b = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.obstructed"));
        public static final EnumBedResult c = new EnumBedResult(null);
        public static final EnumBedResult d = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.not_safe"));
        public static final EnumBedResult EXPLOSION = new EnumBedResult(null);

        public EnumBedResult(@Nullable IChatBaseComponent message) {
            this.e = message;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnumBedResult.class, "message", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnumBedResult.class, "message", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnumBedResult.class, "message", "e"}, this, o2);
        }

        public @Nullable IChatBaseComponent a() {
            return this.e;
        }
    }
}

