/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int b = 5;
    public static final int c = 36;
    public static final int d = 9;
    public static final int e = 40;
    public static final int f = 41;
    public static final int g = 42;
    public static final int h = -1;
    public static final Int2ObjectMap<EnumItemSlot> i = new Int2ObjectArrayMap(Map.of(EnumItemSlot.c.a(36), EnumItemSlot.c, EnumItemSlot.d.a(36), EnumItemSlot.d, EnumItemSlot.e.a(36), EnumItemSlot.e, EnumItemSlot.f.a(36), EnumItemSlot.f, 40, EnumItemSlot.b, 41, EnumItemSlot.g, 42, EnumItemSlot.h));
    private static final IChatBaseComponent k = IChatBaseComponent.c("container.inventory");
    private final NonNullList<ItemStack> l = NonNullList.a(36, ItemStack.l);
    private int m;
    public final EntityHuman j;
    public final EntityEquipment n;
    private int o;
    public static final EnumItemSlot[] EQUIPMENT_SLOTS_SORTED_BY_INDEX = (EnumItemSlot[])i.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue).toArray(EnumItemSlot[]::new);
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.l.size() + i.size());
        combined.addAll(this.l);
        for (EnumItemSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            ItemStack itemStack = this.n.a(equipmentSlot);
            combined.add(itemStack);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(4);
        for (EnumItemSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            items.add(this.n.a(equipmentSlot));
        }
        return items;
    }

    public List<ItemStack> getExtraContent() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EnumItemSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            if (equipmentSlot.a() == EnumItemSlot.Function.b) continue;
            items.add(this.n.a(equipmentSlot));
        }
        return items;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.j.getBukkitEntity();
    }

    @Override
    public int ap_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.j.getBukkitEntity().getLocation();
    }

    public PlayerInventory(EntityHuman player, EntityEquipment equipment) {
        this.j = player;
        this.n = equipment;
    }

    public int g() {
        return this.m;
    }

    public void d(int slot) {
        if (!PlayerInventory.f(slot)) {
            throw new IllegalArgumentException("Invalid selected slot");
        }
        this.m = slot;
    }

    public ItemStack h() {
        return this.l.get(this.m);
    }

    public ItemStack b(ItemStack stack) {
        return this.l.set(this.m, stack);
    }

    public static int i() {
        return 9;
    }

    public NonNullList<ItemStack> j() {
        return this.l;
    }

    private boolean a(ItemStack destination, ItemStack origin) {
        return !destination.f() && destination.l() && destination.N() < this.f_(destination) && ItemStack.c(destination, origin);
    }

    public int canHold(ItemStack itemStack) {
        int remains = itemStack.N();
        for (int slot = 0; slot < this.l.size(); ++slot) {
            ItemStack itemInSlot = this.a(slot);
            if (itemInSlot.f()) {
                return itemStack.N();
            }
            if (this.a(itemInSlot, itemStack)) {
                remains -= (itemInSlot.k() < this.ap_() ? itemInSlot.k() : this.ap_()) - itemInSlot.N();
            }
            if (remains > 0) continue;
            return itemStack.N();
        }
        ItemStack itemInOffhand = this.n.a(EnumItemSlot.b);
        if (this.a(itemInOffhand, itemStack)) {
            remains -= (itemInOffhand.k() < this.ap_() ? itemInOffhand.k() : this.ap_()) - itemInOffhand.N();
        }
        if (remains <= 0) {
            return itemStack.N();
        }
        return itemStack.N() - remains;
    }

    public int k() {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            if (!this.l.get(i2).f()) continue;
            return i2;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack stack, int targetSlot) {
        int freeSlot;
        this.d(targetSlot);
        if (!this.l.get(this.m).f() && (freeSlot = this.k()) != -1) {
            this.l.set(freeSlot, this.l.get(this.m));
        }
        this.l.set(this.m, stack);
    }

    public void pickSlot(int index, int targetSlot) {
        this.d(targetSlot);
        ItemStack itemStack = this.l.get(this.m);
        this.l.set(this.m, this.l.get(index));
        this.l.set(index, itemStack);
    }

    public static boolean f(int index) {
        return index >= 0 && index < 9;
    }

    public int d(ItemStack stack) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            if (this.l.get(i2).f() || !ItemStack.c(stack, this.l.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static boolean e(ItemStack stack) {
        return !stack.n() && !stack.F() && !stack.c(DataComponents.h);
    }

    public int findSlotMatchingCraftingIngredient(ItemOrExact item, ItemStack stack) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            ItemStack itemStack = this.l.get(i2);
            if (itemStack.f() || !item.matches(itemStack) || item instanceof ItemOrExact.Item && !PlayerInventory.e(itemStack) || !stack.f() && !ItemStack.c(stack, itemStack)) continue;
            return i2;
        }
        return -1;
    }

    public int l() {
        int i1;
        for (int i2 = 0; i2 < 9; ++i2) {
            i1 = (this.m + i2) % 9;
            if (!this.l.get(i1).f()) continue;
            return i1;
        }
        for (int ix = 0; ix < 9; ++ix) {
            i1 = (this.m + ix) % 9;
            if (this.l.get(i1).F()) continue;
            return i1;
        }
        return this.m;
    }

    public int a(Predicate<ItemStack> stackPredicate, int maxCount, IInventory inventory) {
        int i2 = 0;
        boolean flag = maxCount == 0;
        i2 += ContainerUtil.a(this, stackPredicate, maxCount - i2, flag);
        i2 += ContainerUtil.a(inventory, stackPredicate, maxCount - i2, flag);
        ItemStack carried = this.j.cn.g();
        i2 += ContainerUtil.a(carried, stackPredicate, maxCount - i2, flag);
        if (carried.f()) {
            this.j.cn.a(ItemStack.l);
        }
        return i2;
    }

    private int k(ItemStack stack) {
        int slotWithRemainingSpace = this.f(stack);
        if (slotWithRemainingSpace == -1) {
            slotWithRemainingSpace = this.k();
        }
        return slotWithRemainingSpace == -1 ? stack.N() : this.d(slotWithRemainingSpace, stack);
    }

    private int d(int slot, ItemStack stack) {
        int i2;
        int min;
        int count = stack.N();
        ItemStack item = this.a(slot);
        if (item.f()) {
            item = stack.c(0);
            this.a(slot, item);
        }
        if ((min = Math.min(count, i2 = this.f_(item) - item.N())) == 0) {
            return count;
        }
        item.g(min);
        item.d(5);
        return count -= min;
    }

    public int f(ItemStack stack) {
        if (this.a(this.a(this.m), stack)) {
            return this.m;
        }
        if (this.a(this.a(40), stack)) {
            return 40;
        }
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            if (!this.a(this.l.get(i2), stack)) continue;
            return i2;
        }
        return -1;
    }

    public void m() {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            ItemStack item = this.a(i2);
            if (item.f()) continue;
            item.a(this.j.ao(), (Entity)this.j, i2 == this.m ? EnumItemSlot.a : null);
        }
    }

    public boolean g(ItemStack stack) {
        return this.c(-1, stack);
    }

    public boolean c(int slot, ItemStack stack) {
        if (stack.f()) {
            return false;
        }
        try {
            int count;
            if (stack.n()) {
                if (slot == -1) {
                    slot = this.k();
                }
                if (slot >= 0) {
                    this.l.set(slot, stack.g());
                    this.l.get(slot).d(5);
                    return true;
                }
                if (this.j.gv()) {
                    stack.e(0);
                    return true;
                }
                return false;
            }
            do {
                count = stack.N();
                if (slot == -1) {
                    stack.e(this.k(stack));
                    continue;
                }
                stack.e(this.d(slot, stack));
            } while (!stack.f() && stack.N() < count);
            if (stack.N() == count && this.j.gv()) {
                stack.e(0);
                return true;
            }
            return stack.N() < count;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.a(var6, "Adding item to inventory");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Item being added");
            crashReportCategory.a("Item ID", Item.a(stack.h()));
            crashReportCategory.a("Item data", stack.o());
            crashReportCategory.a("Item name", () -> stack.y().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void h(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean sendPacket) {
        while (!stack.f()) {
            EntityHuman entityHuman;
            int slotWithRemainingSpace = this.f(stack);
            if (slotWithRemainingSpace == -1) {
                slotWithRemainingSpace = this.k();
            }
            if (slotWithRemainingSpace == -1) {
                this.j.a(stack, false);
                break;
            }
            int i2 = stack.k() - this.a(slotWithRemainingSpace).N();
            if (!this.c(slotWithRemainingSpace, stack.a(i2)) || !sendPacket || !((entityHuman = this.j) instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
            serverPlayer.g.b(this.g(slotWithRemainingSpace));
        }
    }

    public ClientboundSetPlayerInventoryPacket g(int slot) {
        return new ClientboundSetPlayerInventoryPacket(slot, this.a(slot).v());
    }

    @Override
    public ItemStack a(int index, int count) {
        ItemStack itemStack;
        if (index < this.l.size()) {
            return ContainerUtil.a(this.l, index, count);
        }
        EnumItemSlot equipmentSlot = (EnumItemSlot)i.get(index);
        if (equipmentSlot != null && !(itemStack = this.n.a(equipmentSlot)).f()) {
            return itemStack.a(count);
        }
        return ItemStack.l;
    }

    public void i(ItemStack stack) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            if (this.l.get(i2) != stack) continue;
            this.l.set(i2, ItemStack.l);
            return;
        }
        for (EnumItemSlot equipmentSlot : i.values()) {
            ItemStack itemStack = this.n.a(equipmentSlot);
            if (itemStack != stack) continue;
            this.n.a(equipmentSlot, ItemStack.l);
            return;
        }
    }

    @Override
    public ItemStack b(int index) {
        if (index < this.l.size()) {
            ItemStack itemStack = this.l.get(index);
            this.l.set(index, ItemStack.l);
            return itemStack;
        }
        EnumItemSlot equipmentSlot = (EnumItemSlot)i.get(index);
        return equipmentSlot != null ? this.n.a(equipmentSlot, ItemStack.l) : ItemStack.l;
    }

    @Override
    public void a(int index, ItemStack stack) {
        EnumItemSlot equipmentSlot;
        if (index < this.l.size()) {
            this.l.set(index, stack);
        }
        if ((equipmentSlot = (EnumItemSlot)i.get(index)) != null) {
            this.n.a(equipmentSlot, stack);
        }
    }

    public void a(ValueOutput.a<ItemStackWithSlot> output) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            ItemStack itemStack = this.l.get(i2);
            if (itemStack.f()) continue;
            output.a(new ItemStackWithSlot(i2, itemStack));
        }
    }

    public void a(ValueInput.a<ItemStackWithSlot> input) {
        this.l.clear();
        for (ItemStackWithSlot itemStackWithSlot : input) {
            if (!itemStackWithSlot.a(this.l.size())) continue;
            this.a(itemStackWithSlot.a(), itemStackWithSlot.b());
        }
    }

    @Override
    public int b() {
        return this.l.size() + i.size();
    }

    @Override
    public boolean c() {
        for (ItemStack itemStack : this.l) {
            if (itemStack.f()) continue;
            return false;
        }
        for (EnumItemSlot equipmentSlot : i.values()) {
            if (this.n.a(equipmentSlot).f()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack a(int index) {
        if (index < this.l.size()) {
            return this.l.get(index);
        }
        EnumItemSlot equipmentSlot = (EnumItemSlot)i.get(index);
        return equipmentSlot != null ? this.n.a(equipmentSlot) : ItemStack.l;
    }

    @Override
    public IChatBaseComponent ap() {
        return k;
    }

    public void n() {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            ItemStack itemStack = this.l.get(i2);
            if (itemStack.f()) continue;
            this.j.a(itemStack, true, false);
            this.l.set(i2, ItemStack.l);
        }
        this.n.a(this.j);
    }

    @Override
    public void e() {
        ++this.o;
    }

    public int o() {
        return this.o;
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    public boolean j(ItemStack stack) {
        for (ItemStack itemStack : this) {
            if (itemStack.f() || !ItemStack.c(itemStack, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean a(TagKey<Item> tag) {
        for (ItemStack itemStack : this) {
            if (itemStack.f() || !itemStack.a(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean b(Predicate<ItemStack> predicate) {
        for (ItemStack itemStack : this) {
            if (!predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void a(PlayerInventory playerInventory) {
        for (int i2 = 0; i2 < this.b(); ++i2) {
            this.a(i2, playerInventory.a(i2));
        }
        this.d(playerInventory.g());
    }

    @Override
    public void a() {
        this.l.clear();
        this.n.b();
    }

    public void a(StackedItemContents contents) {
        for (ItemStack itemStack : this.l) {
            contents.a(itemStack);
        }
    }

    public ItemStack a(boolean removeStack) {
        ItemStack selectedItem = this.h();
        return selectedItem.f() ? ItemStack.l : this.a(this.m, removeStack ? selectedItem.N() : 1);
    }
}

