/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityLlamaSpit
extends IProjectile {
    public EntityLlamaSpit(EntityTypes<? extends EntityLlamaSpit> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
    }

    public EntityLlamaSpit(World level, EntityLlama spitter) {
        this((EntityTypes<? extends EntityLlamaSpit>)EntityTypes.aD, level);
        this.d(spitter);
        this.a_(spitter.dP() - (double)(spitter.dF() + 1.0f) * 0.5 * (double)MathHelper.a((double)(spitter.bC * ((float)Math.PI / 180))), spitter.dT() - (double)0.1f, spitter.dV() + (double)(spitter.dF() + 1.0f) * 0.5 * (double)MathHelper.b((double)(spitter.bC * ((float)Math.PI / 180))));
    }

    @Override
    protected double bs() {
        return 0.06;
    }

    @Override
    public void g() {
        super.g();
        Vec3D deltaMovement = this.dN();
        MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
        double d2 = this.dP() + deltaMovement.g;
        double d1 = this.dR() + deltaMovement.h;
        double d22 = this.dV() + deltaMovement.i;
        this.q();
        float f2 = 0.99f;
        if (this.ao().a(this.dj()).noneMatch(BlockBase.BlockData::l)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.by()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.k(deltaMovement.c((double)0.99f));
            this.bu();
            this.a_(d2, d1, d22);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        Entity entity = this.p();
        if (entity instanceof EntityLiving) {
            WorldServer serverLevel;
            EntityLiving livingEntity = (EntityLiving)entity;
            Entity entity2 = result.a();
            DamageSource damageSource = this.en().b((Entity)this, livingEntity);
            World world = this.ao();
            if (world instanceof WorldServer && entity2.a(serverLevel = (WorldServer)world, damageSource, 1.0f)) {
                EnchantmentManager.a(serverLevel, entity2, damageSource);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        if (!this.ao().B_()) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Vec3D movement = packet.j();
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = 0.4 + 0.1 * (double)i2;
            this.ao().a(Particles.al, this.dP(), this.dR(), this.dV(), movement.g * d2, movement.h, movement.i * d2);
        }
        this.k(movement);
    }
}

